/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal;

import com.ibm.team.filesystem.client.IRelativeLocation;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;

public final class RelativeLocation
implements IRelativeLocation {
    public static final RelativeLocation EMPTY_LOCATION = new RelativeLocation(new String[0]);
    private static final long serialVersionUID = -6525561138009171483L;
    private final String[] nameParts;

    public RelativeLocation(String name) {
        this.nameParts = new Path(name).segments();
        if (this.nameParts.length > 1) {
            throw new IllegalArgumentException();
        }
        RelativeLocation.validateNameParts(this.nameParts);
    }

    public RelativeLocation(String[] locationParts) {
        this(locationParts, true);
    }

    private RelativeLocation(String[] locationParts, boolean verify) {
        this.nameParts = new String[locationParts.length];
        System.arraycopy(locationParts, 0, this.nameParts, 0, locationParts.length);
        if (verify) {
            RelativeLocation.validateNameParts(this.nameParts);
        }
    }

    private RelativeLocation(String[] locationParts, String[] moreLocationParts) {
        this.nameParts = new String[locationParts.length + moreLocationParts.length];
        System.arraycopy(locationParts, 0, this.nameParts, 0, locationParts.length);
        System.arraycopy(moreLocationParts, 0, this.nameParts, locationParts.length, moreLocationParts.length);
    }

    public RelativeLocation(List<String> relativePath) {
        this.nameParts = relativePath.toArray(new String[relativePath.size()]);
        RelativeLocation.validateNameParts(this.nameParts);
    }

    private static void validateNameParts(String[] segments) {
        String[] stringArray = segments;
        int n = segments.length;
        int n2 = 0;
        while (n2 < n) {
            String name = stringArray[n2];
            if (name.equals(".") || name.equals("..")) {
                throw new IllegalArgumentException("Invalid relative path: " + Arrays.toString(segments));
            }
            if (name.indexOf(47) != -1) {
                throw new IllegalArgumentException("Invalid segment \"" + name + "\" in " + Arrays.toString(segments));
            }
            if (name.indexOf(92) != -1) {
                throw new IllegalArgumentException("Invalid segment \"" + name + "\" in " + Arrays.toString(segments));
            }
            ++n2;
        }
    }

    @Override
    public IRelativeLocation append(String name) {
        String[] newParts = new Path(name).segments();
        if (newParts.length > 1) {
            throw new IllegalArgumentException();
        }
        RelativeLocation.validateNameParts(newParts);
        return new RelativeLocation(this.nameParts, newParts);
    }

    @Override
    public IRelativeLocation append(IRelativeLocation location) {
        if (location.isEmpty()) {
            return this;
        }
        if (this.isEmpty()) {
            return location;
        }
        if (location instanceof RelativeLocation) {
            RelativeLocation relativeLocation = (RelativeLocation)location;
            return new RelativeLocation(this.nameParts, relativeLocation.nameParts);
        }
        IRelativeLocation l = location;
        LinkedList<String> names = new LinkedList<String>();
        while (!l.isEmpty()) {
            names.addFirst(l.getName());
            l = l.getParent();
        }
        String[] newParts = names.toArray(new String[names.size()]);
        RelativeLocation.validateNameParts(newParts);
        return new RelativeLocation(this.nameParts, newParts);
    }

    @Override
    public String getName() {
        if (this.isEmpty()) {
            return null;
        }
        return this.nameParts[this.nameParts.length - 1];
    }

    @Override
    public IRelativeLocation getParent() {
        if (this.isEmpty()) {
            return null;
        }
        String[] parentParts = new String[this.nameParts.length - 1];
        int i = 0;
        while (i < this.nameParts.length - 1) {
            parentParts[i] = this.nameParts[i];
            ++i;
        }
        return new RelativeLocation(parentParts, false);
    }

    @Override
    public boolean isEmpty() {
        return this.nameParts.length == 0;
    }

    @Override
    public boolean isPrefixOf(IRelativeLocation anotherLocation) {
        return this.isPrefixOf(anotherLocation, true);
    }

    @Override
    public boolean isPrefixOf(IRelativeLocation anotherLocation, boolean isCaseSensitive) {
        if (anotherLocation instanceof RelativeLocation) {
            RelativeLocation relativeLocation = (RelativeLocation)anotherLocation;
            int len = this.nameParts.length;
            if (len > relativeLocation.nameParts.length) {
                return false;
            }
            int i = 0;
            while (i < len) {
                if (isCaseSensitive ? !this.nameParts[i].equals(relativeLocation.nameParts[i]) : !this.nameParts[i].equalsIgnoreCase(relativeLocation.nameParts[i])) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        IRelativeLocation l = anotherLocation;
        LinkedList<String> names = new LinkedList<String>();
        while (!l.isEmpty()) {
            names.addFirst(l.getName());
            l = l.getParent();
        }
        int len = this.nameParts.length;
        if (len > names.size()) {
            return false;
        }
        int i = 0;
        while (i < len) {
            if (isCaseSensitive ? !this.nameParts[i].equals(names.get(i)) : !this.nameParts[i].equalsIgnoreCase((String)names.get(i))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    @Override
    public String[] segments() {
        String[] segmentCopy = new String[this.nameParts.length];
        System.arraycopy(this.nameParts, 0, segmentCopy, 0, this.nameParts.length);
        return segmentCopy;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof RelativeLocation)) {
            return false;
        }
        target = (RelativeLocation)obj;
        i = this.nameParts.length;
        targetSegments = target.nameParts;
        if (i == targetSegments.length) ** GOTO lbl12
        return false;
lbl-1000:
        // 1 sources

        {
            if (this.nameParts[i].equals(targetSegments[i])) continue;
            return false;
lbl12:
            // 2 sources

            ** while (--i >= 0)
        }
lbl13:
        // 1 sources

        return true;
    }

    @Override
    public int hashCode() {
        int hash = 17;
        int segmentCount = this.nameParts.length;
        int i = 0;
        while (i < segmentCount) {
            hash = hash * 37 + this.nameParts[i].hashCode();
            ++i;
        }
        return hash;
    }

    @Override
    public IRelativeLocation getCanonicalForm(boolean isCaseSensitive, boolean convertCase) {
        if (isCaseSensitive || !convertCase || this.isEmpty()) {
            return this;
        }
        String[] parts = new String[this.nameParts.length];
        int i = 0;
        while (i < this.nameParts.length) {
            parts[i] = this.nameParts[i].toUpperCase().toLowerCase();
            ++i;
        }
        return new RelativeLocation(parts);
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public boolean sameLocation(IRelativeLocation anotherLocation, boolean caseSensitive) {
        if (caseSensitive) {
            return this.equals(anotherLocation);
        }
        if (!(anotherLocation instanceof RelativeLocation)) {
            return false;
        }
        otherSegments = ((RelativeLocation)anotherLocation).nameParts;
        if (this.nameParts == null) {
            return otherSegments == null;
        }
        if (otherSegments == null) {
            return false;
        }
        i = this.nameParts.length;
        if (i == otherSegments.length) ** GOTO lbl15
        return false;
lbl-1000:
        // 1 sources

        {
            if (this.nameParts[i].equalsIgnoreCase(otherSegments[i])) continue;
            return false;
lbl15:
            // 2 sources

            ** while (--i >= 0)
        }
lbl16:
        // 1 sources

        return true;
    }

    @Override
    public IPath toPath() {
        StringBuffer buffer = new StringBuffer();
        String[] stringArray = this.nameParts;
        int n = this.nameParts.length;
        int n2 = 0;
        while (n2 < n) {
            String part = stringArray[n2];
            buffer.append('/').append(part);
            ++n2;
        }
        Path path = new Path(buffer.toString());
        return path.removeTrailingSeparator().setDevice(null).makeUNC(false).makeAbsolute();
    }

    @Override
    public String segment(int index) {
        if (index >= this.nameParts.length) {
            return null;
        }
        return this.nameParts[index];
    }

    @Override
    public int segmentCount() {
        return this.nameParts.length;
    }

    @Override
    public IRelativeLocation removeFirstSegments(int count) {
        if (count == 0) {
            return this;
        }
        if (count >= this.nameParts.length) {
            return new RelativeLocation(new String[0], false);
        }
        Assert.isLegal((count > 0 ? 1 : 0) != 0);
        int newSize = this.nameParts.length - count;
        String[] newParts = new String[newSize];
        System.arraycopy(this.nameParts, count, newParts, 0, newSize);
        return new RelativeLocation(newParts, false);
    }

    @Override
    public IRelativeLocation removeLastSegments(int count) {
        if (count == 0) {
            return this;
        }
        if (count >= this.nameParts.length) {
            return new RelativeLocation(new String[0], false);
        }
        Assert.isLegal((count > 0 ? 1 : 0) != 0);
        int newSize = this.nameParts.length - count;
        String[] newParts = new String[newSize];
        System.arraycopy(this.nameParts, 0, newParts, 0, newSize);
        return new RelativeLocation(newParts, false);
    }

    @Override
    public IRelativeLocation uptoSegment(int count) {
        if (count == 0) {
            return new RelativeLocation(new String[0], false);
        }
        if (count >= this.nameParts.length) {
            return this;
        }
        Assert.isTrue((count > 0 ? 1 : 0) != 0, (String)"Invalid parameter to Path.uptoSegment");
        String[] newParts = new String[count];
        System.arraycopy(this.nameParts, 0, newParts, 0, count);
        return new RelativeLocation(newParts, false);
    }

    @Override
    public String toString() {
        if (this.nameParts.length > 0) {
            StringBuffer buffer = new StringBuffer();
            int i = 0;
            while (i < this.nameParts.length) {
                buffer.append('/');
                buffer.append(this.nameParts[i]);
                ++i;
            }
            return buffer.toString();
        }
        return "/";
    }
}

