/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal.copyfileareas;

import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.filesystem.client.ILocation;
import com.ibm.team.filesystem.client.IRelativeLocation;
import com.ibm.team.filesystem.client.IShare;
import com.ibm.team.filesystem.client.ISharingDescriptor;
import com.ibm.team.filesystem.client.internal.FileSystemStatusUtil;
import com.ibm.team.filesystem.client.internal.LoggingHelper;
import com.ibm.team.filesystem.client.internal.copyfileareas.AbstractLock;
import com.ibm.team.filesystem.client.internal.copyfileareas.BatchingLock;
import com.ibm.team.filesystem.client.internal.copyfileareas.CFAReadLock;
import com.ibm.team.filesystem.client.internal.copyfileareas.CFARemoveLock;
import com.ibm.team.filesystem.client.internal.copyfileareas.ComponentLock;
import com.ibm.team.filesystem.client.internal.copyfileareas.CopyFileArea;
import com.ibm.team.filesystem.client.internal.copyfileareas.CopyFileAreaManager;
import com.ibm.team.filesystem.client.internal.copyfileareas.CopyFileAreaStore;
import com.ibm.team.filesystem.client.internal.copyfileareas.GlobalCFALock;
import com.ibm.team.filesystem.client.internal.copyfileareas.ICopyFileArea;
import com.ibm.team.filesystem.client.internal.copyfileareas.MultiLock;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IContextHandle;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.osgi.util.NLS;

public final class CFALockUtil {
    public static final int LOCK_OBTAINED = 0;
    public static final int PATH_NOT_MANAGED = 1;
    public static final int LOCK_HELD_BY_ANOTHER_THREAD = 2;
    public static final int LOCK_REQUEST_CANCELED = 3;
    public static final int LOCK_REQUEST_FAILED = 4;

    private CFALockUtil() {
    }

    public static boolean isLocked(AbstractLock lock) {
        return CopyFileAreaManager.instance.isLocked(lock);
    }

    public static boolean isLockedForUpdate(ILocation cfaRoot, IComponentHandle component, IContextHandle connection) {
        CopyFileArea cfa = CopyFileAreaManager.instance.getExistingCopyFileArea(cfaRoot);
        if (cfa == null) {
            return false;
        }
        return CFALockUtil.isLocked(new ComponentLock(cfa.getRoot(), connection, component));
    }

    public static AbstractLock lockExistingForUpdate(ILocation cfaRoot, IRelativeLocation rootRelativePath, IProgressMonitor monitor) throws FileSystemException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        AbstractLock lock = CFALockUtil.lockExistingForRead(cfaRoot, (IProgressMonitor)progress.newChild(20));
        if (lock == null) {
            progress.done();
            return null;
        }
        boolean success = false;
        try {
            CopyFileArea cfa = CopyFileAreaManager.instance.getExistingCopyFileArea(cfaRoot);
            ISharingDescriptor desc = cfa.findSharingDescriptor(rootRelativePath);
            CFALockUtil.endBatching(lock, (IProgressMonitor)progress.newChild(1));
            success = true;
            if (desc == null) {
                progress.done();
                return null;
            }
            ILocation rootPath = cfa.getRoot();
            while (true) {
                lock = CFALockUtil.beginBatching(new ComponentLock(rootPath, desc.getConnectionHandle(), desc.getComponent()), true, (IProgressMonitor)progress.newChild(30));
                success = false;
                cfa = CopyFileAreaManager.instance.getExistingCopyFileArea(cfaRoot);
                if (cfa == null) {
                    CFALockUtil.endBatching(lock, (IProgressMonitor)progress.newChild(1));
                    progress.done();
                    success = true;
                    return null;
                }
                ILocation newRoot = cfa.getRoot();
                if (!newRoot.equals(rootPath)) {
                    rootPath = newRoot;
                } else {
                    ISharingDescriptor newDesc = cfa.findSharingDescriptor(rootRelativePath);
                    if (newDesc == null) {
                        CFALockUtil.endBatching(lock, (IProgressMonitor)progress.newChild(1));
                        progress.done();
                        success = true;
                        return null;
                    }
                    if (newDesc.getComponent().sameItemId((IItemHandle)desc.getComponent()) && newDesc.getConnectionHandle().sameItemId((IItemHandle)desc.getConnectionHandle())) {
                        progress.done();
                        success = true;
                        AbstractLock abstractLock = lock;
                        return abstractLock;
                    }
                    desc = newDesc;
                }
                CFALockUtil.endBatching(lock, (IProgressMonitor)progress.newChild(1));
                success = true;
                progress.setWorkRemaining(79);
            }
        }
        finally {
            if (!success) {
                CFALockUtil.endBatching(lock, (IProgressMonitor)progress.newChild(1));
            }
        }
    }

    public static AbstractLock lockExistingForRead(ILocation cfaRoot, IProgressMonitor monitor) throws FileSystemException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        CopyFileArea cfa = CopyFileAreaManager.instance.getExistingCopyFileArea(cfaRoot);
        if (cfa == null) {
            progress.done();
            return null;
        }
        ILocation rootPath = cfa.getRoot();
        while (true) {
            AbstractLock lock = CFALockUtil.beginBatching(new CFAReadLock(rootPath), true, (IProgressMonitor)progress.newChild(50));
            boolean success = false;
            try {
                cfa = CopyFileAreaManager.instance.getExistingCopyFileArea(cfaRoot);
                if (cfa == null) {
                    return null;
                }
                ILocation newRootPath = cfa.getRoot();
                if (newRootPath.equals(rootPath)) {
                    progress.done();
                    success = true;
                    AbstractLock abstractLock = lock;
                    return abstractLock;
                }
                rootPath = newRootPath;
            }
            finally {
                if (!success) {
                    CopyFileAreaStore.endBatching(lock, (IProgressMonitor)progress.newChild(1));
                }
            }
            progress.setWorkRemaining(100);
        }
    }

    public static AbstractLock lockExistingForGlobalUpdate(ILocation cfaRoot, IProgressMonitor monitor) throws FileSystemException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        CopyFileArea cfa = CopyFileAreaManager.instance.getExistingCopyFileArea(cfaRoot);
        if (cfa == null) {
            progress.done();
            return null;
        }
        ILocation rootPath = cfa.getRoot();
        while (true) {
            AbstractLock lock = CFALockUtil.beginBatching(new GlobalCFALock(rootPath), true, (IProgressMonitor)progress.newChild(50));
            boolean success = false;
            try {
                cfa = CopyFileAreaManager.instance.getExistingCopyFileArea(cfaRoot);
                if (cfa == null) {
                    return null;
                }
                ILocation newRootPath = cfa.getRoot();
                if (newRootPath.equals(rootPath)) {
                    progress.done();
                    success = true;
                    AbstractLock abstractLock = lock;
                    return abstractLock;
                }
                rootPath = newRootPath;
            }
            finally {
                if (!success) {
                    CopyFileAreaStore.endBatching(lock, (IProgressMonitor)progress.newChild(1));
                }
            }
            progress.setWorkRemaining(100);
        }
    }

    public static AbstractLock lockExistingForUpdate(ILocation cfaRoot, IContextHandle connection, IComponentHandle component, IProgressMonitor monitor) throws FileSystemException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        CopyFileArea cfa = CopyFileAreaManager.instance.getExistingCopyFileArea(cfaRoot);
        if (cfa == null) {
            progress.done();
            return null;
        }
        ILocation rootPath = cfa.getRoot();
        while (true) {
            AbstractLock lock = CFALockUtil.beginBatching(new ComponentLock(rootPath, connection, component), true, (IProgressMonitor)progress.newChild(50));
            boolean success = false;
            try {
                cfa = CopyFileAreaManager.instance.getExistingCopyFileArea(cfaRoot);
                if (cfa == null) {
                    return null;
                }
                ILocation newRootPath = cfa.getRoot();
                if (newRootPath.equals(rootPath)) {
                    progress.done();
                    success = true;
                    AbstractLock abstractLock = lock;
                    return abstractLock;
                }
                rootPath = newRootPath;
            }
            finally {
                if (!success) {
                    CopyFileAreaStore.endBatching(lock, (IProgressMonitor)progress.newChild(1));
                }
            }
            progress.setWorkRemaining(100);
        }
    }

    public static AbstractLock lockExistingForReadForLocation(ILocation location, IProgressMonitor monitor) throws FileSystemException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        ICopyFileArea cfa = CopyFileAreaManager.instance.getCopyFileAreaForPath(location);
        if (cfa == null) {
            progress.done();
            return null;
        }
        ILocation rootPath = cfa.getRoot();
        while (true) {
            AbstractLock lock = CFALockUtil.beginBatching(new CFAReadLock(rootPath), true, (IProgressMonitor)progress.newChild(50));
            boolean success = false;
            try {
                cfa = CopyFileAreaManager.instance.getExistingCopyFileArea(rootPath);
                if (cfa != null) {
                    ILocation newRootPath = cfa.getRoot();
                    if (newRootPath.equals(rootPath)) {
                        progress.done();
                        success = true;
                        AbstractLock abstractLock = lock;
                        return abstractLock;
                    }
                    rootPath = newRootPath;
                } else {
                    CopyFileAreaStore.endBatching(lock, (IProgressMonitor)progress.newChild(1));
                    success = true;
                    cfa = CopyFileAreaManager.instance.getCopyFileAreaForPath(location);
                    if (cfa == null) {
                        progress.done();
                        return null;
                    }
                    rootPath = cfa.getRoot();
                }
            }
            finally {
                if (!success) {
                    CopyFileAreaStore.endBatching(lock, (IProgressMonitor)progress.newChild(1));
                }
            }
            progress.setWorkRemaining(100);
        }
    }

    public static AbstractLock beginBatching(AbstractLock resourceRule, boolean waitForLock, IProgressMonitor monitor) {
        CopyFileAreaManager instance = CopyFileAreaManager.instance;
        return instance.batchingLock.acquire(resourceRule, instance, BatchingLock.NULL_LOCK_PARTICIPANT, waitForLock, monitor);
    }

    public static void endBatching(AbstractLock rule, IProgressMonitor monitor) throws FileSystemException {
        CopyFileAreaManager.instance.batchingLock.release(rule, monitor);
    }

    public static AbstractLock createAndLockSuperExclusive(ILocation cfaRoot, IProgressMonitor monitor) throws FileSystemException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        CopyFileArea cfa = CopyFileAreaManager.instance.getExistingCopyFileArea(cfaRoot);
        if (cfa == null) {
            cfa = CopyFileAreaManager.instance.createCopyFileArea(cfaRoot, (IProgressMonitor)progress.newChild(30));
        }
        ILocation rootPath = cfa.getRoot();
        while (true) {
            AbstractLock lock = CFALockUtil.beginBatching(new CFARemoveLock(rootPath), true, (IProgressMonitor)progress.newChild(20));
            boolean success = false;
            try {
                cfa = CopyFileAreaManager.instance.getExistingCopyFileArea(rootPath);
                if (cfa != null) {
                    ILocation newRootPath = cfa.getRoot();
                    if (newRootPath.equals(rootPath)) {
                        progress.done();
                        success = true;
                        AbstractLock abstractLock = lock;
                        return abstractLock;
                    }
                    rootPath = newRootPath;
                } else {
                    CFALockUtil.endBatching(lock, (IProgressMonitor)progress.newChild(1));
                    success = true;
                    cfa = CopyFileAreaManager.instance.createCopyFileArea(cfaRoot, (IProgressMonitor)progress.newChild(1));
                    rootPath = cfa.getRoot();
                }
            }
            finally {
                if (!success) {
                    CFALockUtil.endBatching(lock, (IProgressMonitor)progress.newChild(1));
                }
            }
            progress.setWorkRemaining(70);
        }
    }

    public static AbstractLock createAndLockForReading(ILocation cfaRoot, boolean waitForLock, IProgressMonitor monitor) throws FileSystemException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        CopyFileArea cfa = CopyFileAreaManager.instance.getExistingCopyFileArea(cfaRoot);
        if (cfa == null) {
            cfa = CopyFileAreaManager.instance.createCopyFileArea(cfaRoot, (IProgressMonitor)progress.newChild(30));
        }
        ILocation rootPath = cfa.getRoot();
        AbstractLock lock;
        while ((lock = CFALockUtil.beginBatching(new CFAReadLock(rootPath), waitForLock, (IProgressMonitor)progress.newChild(20))) != null) {
            boolean success = false;
            try {
                cfa = CopyFileAreaManager.instance.getExistingCopyFileArea(rootPath);
                if (cfa != null) {
                    ILocation newRootPath = cfa.getRoot();
                    if (newRootPath.equals(rootPath)) {
                        progress.done();
                        success = true;
                        AbstractLock abstractLock = lock;
                        return abstractLock;
                    }
                    rootPath = newRootPath;
                } else {
                    CFALockUtil.endBatching(lock, (IProgressMonitor)progress.newChild(1));
                    success = true;
                    cfa = CopyFileAreaManager.instance.createCopyFileArea(cfaRoot, (IProgressMonitor)progress.newChild(1));
                    rootPath = cfa.getRoot();
                }
            }
            finally {
                if (!success) {
                    CFALockUtil.endBatching(lock, (IProgressMonitor)progress.newChild(1));
                }
            }
            progress.setWorkRemaining(70);
        }
        return null;
    }

    public static AbstractLock createAndLockForUpdate(ILocation cfaRoot, IRelativeLocation rootRelativePath, boolean waitForLock, IProgressMonitor monitor) throws FileSystemException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        AbstractLock lock = CFALockUtil.createAndLockForReading(cfaRoot, waitForLock, (IProgressMonitor)progress.newChild(20));
        if (lock == null) {
            return null;
        }
        boolean success = false;
        try {
            CopyFileArea cfa = CopyFileAreaManager.instance.getExistingCopyFileArea(cfaRoot);
            ISharingDescriptor desc = cfa.findSharingDescriptor(rootRelativePath);
            CFALockUtil.endBatching(lock, (IProgressMonitor)progress.newChild(1));
            success = true;
            if (desc == null) {
                progress.done();
                return null;
            }
            ILocation rootPath = cfa.getRoot();
            while (true) {
                if ((lock = CFALockUtil.beginBatching(new ComponentLock(rootPath, desc.getConnectionHandle(), desc.getComponent()), waitForLock, (IProgressMonitor)progress.newChild(30))) == null) {
                    return null;
                }
                success = false;
                cfa = CopyFileAreaManager.instance.getExistingCopyFileArea(cfaRoot);
                if (cfa == null) {
                    CFALockUtil.endBatching(lock, (IProgressMonitor)progress.newChild(1));
                    success = true;
                    cfa = CopyFileAreaManager.instance.createCopyFileArea(cfaRoot, (IProgressMonitor)progress.newChild(1));
                    rootPath = cfa.getRoot();
                } else {
                    ILocation newRoot = cfa.getRoot();
                    if (!newRoot.equals(rootPath)) {
                        rootPath = newRoot;
                    } else {
                        ISharingDescriptor newDesc = cfa.findSharingDescriptor(rootRelativePath);
                        if (newDesc == null) {
                            CFALockUtil.endBatching(lock, (IProgressMonitor)progress.newChild(1));
                            progress.done();
                            success = true;
                            return null;
                        }
                        if (newDesc.getComponent().sameItemId((IItemHandle)desc.getComponent()) && newDesc.getConnectionHandle().sameItemId((IItemHandle)desc.getConnectionHandle())) {
                            progress.done();
                            success = true;
                            AbstractLock abstractLock = lock;
                            return abstractLock;
                        }
                        desc = newDesc;
                    }
                    CFALockUtil.endBatching(lock, (IProgressMonitor)progress.newChild(1));
                    success = true;
                }
                progress.setWorkRemaining(79);
            }
        }
        finally {
            if (!success) {
                CFALockUtil.endBatching(lock, (IProgressMonitor)progress.newChild(1));
            }
        }
    }

    public static AbstractLock createAndLockForUpdate(ILocation cfaRoot, IContextHandle connection, IComponentHandle component, IProgressMonitor monitor) throws FileSystemException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        CopyFileArea cfa = CopyFileAreaManager.instance.getExistingCopyFileArea(cfaRoot);
        if (cfa == null) {
            cfa = CopyFileAreaManager.instance.createCopyFileArea(cfaRoot, (IProgressMonitor)progress.newChild(30));
        }
        ILocation rootPath = cfa.getRoot();
        while (true) {
            AbstractLock lock = CFALockUtil.beginBatching(new ComponentLock(rootPath, connection, component), true, (IProgressMonitor)progress.newChild(20));
            boolean success = false;
            try {
                cfa = CopyFileAreaManager.instance.getExistingCopyFileArea(rootPath);
                if (cfa != null) {
                    ILocation newRootPath = cfa.getRoot();
                    if (newRootPath.equals(rootPath)) {
                        progress.done();
                        success = true;
                        AbstractLock abstractLock = lock;
                        return abstractLock;
                    }
                    rootPath = newRootPath;
                } else {
                    CFALockUtil.endBatching(lock, (IProgressMonitor)progress.newChild(1));
                    success = true;
                    cfa = CopyFileAreaManager.instance.createCopyFileArea(cfaRoot, (IProgressMonitor)progress.newChild(1));
                    rootPath = cfa.getRoot();
                }
            }
            finally {
                if (!success) {
                    CFALockUtil.endBatching(lock, (IProgressMonitor)progress.newChild(1));
                }
            }
            progress.setWorkRemaining(70);
        }
    }

    public static boolean isLockedForUpdateOfChildren(ILocation cfaRoot, IRelativeLocation rootRelativePath, IProgressMonitor monitor) throws FileSystemException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        CopyFileArea cfa = CopyFileAreaManager.instance.getExistingCopyFileArea(cfaRoot);
        if (cfa == null) {
            progress.done();
            return false;
        }
        ILocation rootPath = cfa.getRoot();
        if (!CFALockUtil.isLocked(new CFAReadLock(rootPath))) {
            return false;
        }
        IRelativeLocation[] sharePaths = cfa.allSharePaths();
        IRelativeLocation convertedPath = rootRelativePath.getCanonicalForm(cfa.isCaseSensitive(), true);
        IShare containingShare = null;
        boolean parentOfShare = false;
        IRelativeLocation[] iRelativeLocationArray = sharePaths;
        int n = sharePaths.length;
        int n2 = 0;
        while (n2 < n) {
            IRelativeLocation sharePath = iRelativeLocationArray[n2];
            IRelativeLocation shareRootPath = sharePath.getCanonicalForm(cfa.isCaseSensitive(), true);
            if (shareRootPath.isPrefixOf(convertedPath)) {
                containingShare = cfa.getShare(sharePath);
                if (containingShare != null) break;
                return false;
            }
            if (convertedPath.isPrefixOf(shareRootPath)) {
                parentOfShare = true;
                break;
            }
            ++n2;
        }
        ISharingDescriptor desc = null;
        if (containingShare != null) {
            desc = containingShare.getSharingDescriptor();
        } else if (!parentOfShare) {
            return false;
        }
        AbstractLock lock = desc == null ? new GlobalCFALock(rootPath) : new ComponentLock(rootPath, desc.getConnectionHandle(), desc.getComponent());
        return CFALockUtil.isLocked(lock);
    }

    public static LockResult createAndLockForUpdateOfChildren(ILocation cfaRoot, IRelativeLocation rootRelativePath, boolean waitForLock, IProgressMonitor monitor) throws FileSystemException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        AbstractLock lock = CFALockUtil.createAndLockForReading(cfaRoot, waitForLock, (IProgressMonitor)progress.newChild(20));
        if (lock == null) {
            return new LockResult(waitForLock, progress);
        }
        boolean success = false;
        try {
            CopyFileArea cfa = CopyFileAreaManager.instance.getExistingCopyFileArea(cfaRoot);
            ILocation rootPath = cfa.getRoot();
            IRelativeLocation[] sharePaths = cfa.allSharePaths();
            IRelativeLocation convertedPath = rootRelativePath.getCanonicalForm(cfa.isCaseSensitive(), true);
            IShare containingShare = null;
            boolean parentOfShare = false;
            IRelativeLocation[] iRelativeLocationArray = sharePaths;
            int n = sharePaths.length;
            int n2 = 0;
            while (n2 < n) {
                IRelativeLocation sharePath = iRelativeLocationArray[n2];
                IRelativeLocation shareRootPath = sharePath.getCanonicalForm(cfa.isCaseSensitive(), true);
                if (shareRootPath.isPrefixOf(convertedPath)) {
                    containingShare = cfa.getShare(sharePath);
                    break;
                }
                if (convertedPath.isPrefixOf(shareRootPath)) {
                    parentOfShare = true;
                    break;
                }
                ++n2;
            }
            ISharingDescriptor desc = null;
            if (containingShare != null) {
                desc = containingShare.getSharingDescriptor();
            } else if (!parentOfShare) {
                CFALockUtil.endBatching(lock, (IProgressMonitor)progress.newChild(1));
                success = true;
                progress.done();
                LockResult lockResult = new LockResult(1);
                return lockResult;
            }
            CFALockUtil.endBatching(lock, (IProgressMonitor)progress.newChild(1));
            success = true;
            while (true) {
                lock = desc == null ? new GlobalCFALock(rootPath) : new ComponentLock(rootPath, desc.getConnectionHandle(), desc.getComponent());
                if ((lock = CFALockUtil.beginBatching(lock, waitForLock, (IProgressMonitor)progress.newChild(30))) == null) {
                    LockResult lockResult = new LockResult(waitForLock, progress);
                    return lockResult;
                }
                success = false;
                cfa = CopyFileAreaManager.instance.getExistingCopyFileArea(cfaRoot);
                if (cfa == null) {
                    CFALockUtil.endBatching(lock, (IProgressMonitor)progress.newChild(1));
                    success = true;
                    cfa = CopyFileAreaManager.instance.createCopyFileArea(cfaRoot, (IProgressMonitor)progress.newChild(1));
                    rootPath = cfa.getRoot();
                } else {
                    ILocation newRoot = cfa.getRoot();
                    if (!newRoot.equals(rootPath)) {
                        rootPath = newRoot;
                    } else {
                        sharePaths = cfa.allSharePaths();
                        convertedPath = rootRelativePath.getCanonicalForm(cfa.isCaseSensitive(), true);
                        containingShare = null;
                        parentOfShare = false;
                        IRelativeLocation[] iRelativeLocationArray2 = sharePaths;
                        int n3 = sharePaths.length;
                        int n4 = 0;
                        while (n4 < n3) {
                            IRelativeLocation sharePath = iRelativeLocationArray2[n4];
                            IRelativeLocation shareRootPath = sharePath.getCanonicalForm(cfa.isCaseSensitive(), true);
                            if (shareRootPath.isPrefixOf(convertedPath)) {
                                containingShare = cfa.getShare(sharePath);
                                break;
                            }
                            if (convertedPath.isPrefixOf(shareRootPath)) {
                                parentOfShare = true;
                                break;
                            }
                            ++n4;
                        }
                        ISharingDescriptor newDesc = null;
                        if (containingShare != null) {
                            newDesc = containingShare.getSharingDescriptor();
                        } else if (!parentOfShare) {
                            CFALockUtil.endBatching(lock, (IProgressMonitor)progress.newChild(1));
                            success = true;
                            progress.done();
                            LockResult lockResult = new LockResult(1);
                            return lockResult;
                        }
                        if (desc == null) {
                            if (newDesc == null) {
                                progress.done();
                                LockResult result = new LockResult(lock);
                                success = true;
                                LockResult lockResult = result;
                                return lockResult;
                            }
                        } else if (newDesc != null && newDesc.getComponent().sameItemId((IItemHandle)desc.getComponent()) && newDesc.getConnectionHandle().sameItemId((IItemHandle)desc.getConnectionHandle())) {
                            progress.done();
                            LockResult result = new LockResult(lock);
                            success = true;
                            LockResult lockResult = result;
                            return lockResult;
                        }
                        desc = newDesc;
                    }
                    CFALockUtil.endBatching(lock, (IProgressMonitor)progress.newChild(1));
                    success = true;
                }
                progress.setWorkRemaining(79);
            }
        }
        finally {
            if (!success) {
                CFALockUtil.endBatching(lock, (IProgressMonitor)progress.newChild(1));
            }
        }
    }

    public static AbstractLock createAndLockForReading(List<? extends ILocation> cfaRoots, boolean waitForLocks, IProgressMonitor monitor) throws FileSystemException {
        int size = cfaRoots.size();
        Assert.isTrue((size != 0 ? 1 : 0) != 0);
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        ILocation[] cfas = new ILocation[size];
        SubMonitor createMonitor = progress.newChild(30);
        createMonitor.setWorkRemaining(size);
        int i = 0;
        AbstractLock[] readLocks = new AbstractLock[size];
        for (ILocation iLocation : cfaRoots) {
            ILocation iLocation2;
            CopyFileArea cfa = CopyFileAreaManager.instance.getExistingCopyFileArea(iLocation);
            if (cfa == null) {
                cfa = CopyFileAreaManager.instance.createCopyFileArea(iLocation, (IProgressMonitor)createMonitor.newChild(1));
            }
            cfas[i] = iLocation2 = cfa.getRoot();
            readLocks[i] = new CFAReadLock(iLocation2);
            ++i;
        }
        AbstractLock abstractLock;
        while ((abstractLock = CFALockUtil.beginBatching(MultiLock.combine(readLocks), waitForLocks, (IProgressMonitor)progress.newChild(20))) != null) {
            boolean unlocked = false;
            try {
                i = 0;
                SubMonitor checkProgress = progress.newChild(1);
                checkProgress.setWorkRemaining(size + 1);
                for (ILocation iLocation : cfaRoots) {
                    ILocation newRootPath;
                    CopyFileArea cfa = CopyFileAreaManager.instance.getExistingCopyFileArea(iLocation);
                    if (cfa != null) {
                        newRootPath = cfa.getRoot();
                        if (!newRootPath.equals(cfas[i])) {
                            if (!unlocked) {
                                CFALockUtil.endBatching(abstractLock, (IProgressMonitor)checkProgress.newChild(1));
                                unlocked = true;
                            }
                            cfas[i] = newRootPath;
                            readLocks[i] = new CFAReadLock(newRootPath);
                        }
                    } else {
                        if (!unlocked) {
                            CFALockUtil.endBatching(abstractLock, (IProgressMonitor)checkProgress.newChild(1));
                            unlocked = true;
                        }
                        cfa = CopyFileAreaManager.instance.createCopyFileArea(iLocation, (IProgressMonitor)checkProgress.newChild(1));
                        cfas[i] = newRootPath = cfa.getRoot();
                        readLocks[i] = new CFAReadLock(newRootPath);
                    }
                    ++i;
                }
                checkProgress.done();
                if (!unlocked) {
                    progress.done();
                    unlocked = true;
                    AbstractLock abstractLock2 = abstractLock;
                    return abstractLock2;
                }
            }
            finally {
                if (!unlocked) {
                    CFALockUtil.endBatching(abstractLock, (IProgressMonitor)progress.newChild(1));
                }
            }
            progress.setWorkRemaining(70);
        }
        return null;
    }

    public static LockResult createAndLockForUpdateOfChildren(List<? extends ILocation> cfaRoots, List<? extends IRelativeLocation> rootRelativePaths, boolean waitForLock, IProgressMonitor monitor) throws FileSystemException {
        int size = cfaRoots.size();
        Assert.isTrue((size == rootRelativePaths.size() ? 1 : 0) != 0);
        Assert.isTrue((size != 0 ? 1 : 0) != 0);
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        AbstractLock lock = CFALockUtil.createAndLockForReading(cfaRoots, waitForLock, (IProgressMonitor)progress.newChild(20));
        if (lock == null) {
            return new LockResult(waitForLock, progress);
        }
        boolean success = false;
        try {
            IRelativeLocation shareRootPath;
            ISharingDescriptor[] descriptors = new ISharingDescriptor[size];
            AbstractLock[] locks = new AbstractLock[size];
            ILocation[] paths = new ILocation[size];
            Iterator<? extends ILocation> cfaIt = cfaRoots.iterator();
            Iterator<? extends IRelativeLocation> pathIt = rootRelativePaths.iterator();
            int i = 0;
            while (i != size) {
                ILocation cfaRoot = cfaIt.next();
                IRelativeLocation rootRelativePath = pathIt.next();
                CopyFileArea cfa = CopyFileAreaManager.instance.getExistingCopyFileArea(cfaRoot);
                ILocation rootPath = cfa.getRoot();
                IRelativeLocation[] sharePaths = cfa.allSharePaths();
                cfa.internalGetMetadata();
                IRelativeLocation convertedPath = rootRelativePath.getCanonicalForm(cfa.isCaseSensitive(), true);
                IShare containingShare = null;
                IRelativeLocation[] iRelativeLocationArray = sharePaths;
                int n = sharePaths.length;
                int n2 = 0;
                while (n2 < n) {
                    IRelativeLocation sharePath = iRelativeLocationArray[n2];
                    shareRootPath = sharePath.getCanonicalForm(cfa.isCaseSensitive(), true);
                    if (shareRootPath.isPrefixOf(convertedPath)) {
                        containingShare = cfa.getShare(sharePath);
                        if (containingShare != null) break;
                        LoggingHelper.log(FileSystemStatusUtil.getStatusFor(0, NLS.bind((String)"Expected share could not be found at ''{0}''", (Object)sharePath.toString())));
                    }
                    if (convertedPath.isPrefixOf(shareRootPath)) break;
                    ++n2;
                }
                paths[i] = rootPath;
                if (containingShare != null) {
                    descriptors[i] = containingShare.getSharingDescriptor();
                    locks[i] = new ComponentLock(rootPath, descriptors[i].getConnectionHandle(), descriptors[i].getComponent());
                } else {
                    descriptors[i] = null;
                    locks[i] = new GlobalCFALock(rootPath);
                }
                ++i;
            }
            CFALockUtil.endBatching(lock, (IProgressMonitor)progress.newChild(1));
            success = true;
            while (true) {
                if ((lock = CFALockUtil.beginBatching(MultiLock.combine(locks), waitForLock, (IProgressMonitor)progress.newChild(30))) == null) {
                    LockResult lockResult = new LockResult(waitForLock, progress);
                    return lockResult;
                }
                success = false;
                cfaIt = cfaRoots.iterator();
                pathIt = rootRelativePaths.iterator();
                boolean goAgain = false;
                boolean noneContainShares = true;
                int i2 = 0;
                while (i2 != size) {
                    ILocation cfaRoot = cfaIt.next();
                    IRelativeLocation rootRelativePath = pathIt.next();
                    CopyFileArea cfa = CopyFileAreaManager.instance.getExistingCopyFileArea(cfaRoot);
                    if (cfa == null) {
                        if (!success) {
                            CFALockUtil.endBatching(lock, (IProgressMonitor)progress.newChild(1));
                            success = true;
                        }
                        cfa = CopyFileAreaManager.instance.createCopyFileArea(cfaRoot, (IProgressMonitor)progress.newChild(1));
                        ILocation rootPath = cfa.getRoot();
                        descriptors[i2] = null;
                        locks[i2] = new GlobalCFALock(rootPath);
                        paths[i2] = rootPath;
                        goAgain = true;
                    } else {
                        ILocation newRoot = cfa.getRoot();
                        if (!newRoot.equals(paths[i2])) {
                            paths[i2] = newRoot;
                            goAgain = true;
                        } else if (!success) {
                            Collection<IShare> shares = cfa.allShares();
                            cfa.internalGetMetadata();
                            IRelativeLocation convertedPath = rootRelativePath.getCanonicalForm(cfa.isCaseSensitive(), true);
                            IShare containingShare = null;
                            for (IShare share : shares) {
                                shareRootPath = share.getPath().getCanonicalForm(cfa.isCaseSensitive(), true);
                                if (shareRootPath.isPrefixOf(convertedPath)) {
                                    containingShare = share;
                                    break;
                                }
                                if (!convertedPath.isPrefixOf(shareRootPath)) continue;
                                noneContainShares = false;
                                break;
                            }
                            if (containingShare != null) {
                                ISharingDescriptor newDesc = containingShare.getSharingDescriptor();
                                noneContainShares = false;
                                ISharingDescriptor desc = descriptors[i2];
                                if (desc == null || !newDesc.getComponent().sameItemId((IItemHandle)desc.getComponent()) || !newDesc.getConnectionHandle().sameItemId((IItemHandle)desc.getConnectionHandle())) {
                                    descriptors[i2] = newDesc;
                                    locks[i2] = new ComponentLock(newRoot, newDesc.getConnectionHandle(), newDesc.getComponent());
                                    goAgain = true;
                                }
                            } else if (descriptors[i2] != null) {
                                descriptors[i2] = null;
                                locks[i2] = new GlobalCFALock(newRoot);
                                goAgain = true;
                            }
                        }
                    }
                    ++i2;
                }
                if (!goAgain) {
                    if (noneContainShares) {
                        CFALockUtil.endBatching(lock, (IProgressMonitor)progress.newChild(1));
                        success = true;
                        progress.done();
                        LockResult lockResult = new LockResult(1);
                        return lockResult;
                    }
                    progress.done();
                    LockResult result = new LockResult(lock);
                    success = true;
                    LockResult lockResult = result;
                    return lockResult;
                }
                CFALockUtil.endBatching(lock, (IProgressMonitor)progress.newChild(1));
                success = true;
                progress.setWorkRemaining(79);
            }
        }
        finally {
            if (!success) {
                CFALockUtil.endBatching(lock, (IProgressMonitor)progress.newChild(1));
            }
        }
    }

    public static void endBatching(LockResult lock, SubMonitor monitor) throws FileSystemException {
        if (lock.code == 0) {
            CFALockUtil.endBatching(lock.lock, (IProgressMonitor)monitor);
        }
    }

    public static class LockResult {
        public final AbstractLock lock;
        public final int code;

        public LockResult(AbstractLock lock) {
            this.code = 0;
            this.lock = lock;
        }

        public LockResult(int code) {
            this.code = code;
            this.lock = null;
        }

        public LockResult(boolean waitForLock, SubMonitor progress) {
            this.lock = null;
            this.code = progress.isCanceled() ? 3 : (!waitForLock ? 2 : 4);
        }
    }
}

