/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal.load;

import com.ibm.team.filesystem.client.ILoadFilter;
import com.ibm.team.filesystem.client.ISharingDescriptor;
import com.ibm.team.filesystem.client.internal.Messages;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.osgi.util.NLS;

public class LoadFilter
implements ILoadFilter {
    public static final String CLIENT_DATA_KEY = "com.ibm.team.filesystem.client.LoadFilter";
    private static final int VERSION = 0;
    private final String[] excludePatterns;
    private HashSet<String> filterSet;

    public static ILoadFilter exclude(String[] excludePatterns) {
        return new LoadFilter(excludePatterns);
    }

    public static byte[] toBytes(ILoadFilter filter) throws IOException {
        return ((LoadFilter)filter).toBytes();
    }

    public static LoadFilter fromBytes(byte[] bytes) throws IOException {
        DataInputStream in = new DataInputStream(new ByteArrayInputStream(bytes));
        int version = in.readInt();
        if (version != 0) {
            throw new IOException(NLS.bind((String)Messages.LoadFilter_0, (Object)version));
        }
        int size = in.readInt();
        String[] excludePatterns = new String[size];
        int i = 0;
        while (i < size) {
            excludePatterns[i] = in.readUTF();
            ++i;
        }
        return new LoadFilter(excludePatterns);
    }

    public static LoadFilter getFilter(ISharingDescriptor sharingDescriptor) throws IOException {
        byte[] bytes = sharingDescriptor.getClientData(CLIENT_DATA_KEY);
        if (bytes != null) {
            return LoadFilter.fromBytes(bytes);
        }
        return null;
    }

    public LoadFilter(String[] excludePatterns) {
        this.excludePatterns = excludePatterns;
    }

    @Override
    public boolean include(String name) {
        String[] stringArray = this.excludePatterns;
        int n = this.excludePatterns.length;
        int n2 = 0;
        while (n2 < n) {
            String pattern = stringArray[n2];
            if (pattern.equals(name)) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    private byte[] toBytes() throws IOException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        DataOutputStream out = new DataOutputStream(bos);
        out.writeInt(0);
        out.writeInt(this.excludePatterns.length);
        String[] stringArray = this.excludePatterns;
        int n = this.excludePatterns.length;
        int n2 = 0;
        while (n2 < n) {
            String p = stringArray[n2];
            out.writeUTF(p);
            ++n2;
        }
        return bos.toByteArray();
    }

    @Override
    public boolean sameFilter(ILoadFilter otherFilter) {
        if (!(otherFilter instanceof LoadFilter)) {
            return false;
        }
        Set<String> filters = this.getFilterSet();
        Set<String> otherFilters = ((LoadFilter)otherFilter).getFilterSet();
        if (filters.size() != otherFilters.size()) {
            return false;
        }
        for (String pattern : otherFilters) {
            if (filters.contains(pattern)) continue;
            return false;
        }
        return true;
    }

    private synchronized Set<String> getFilterSet() {
        if (this.filterSet == null) {
            this.filterSet = new HashSet();
            String[] stringArray = this.excludePatterns;
            int n = this.excludePatterns.length;
            int n2 = 0;
            while (n2 < n) {
                String pattern = stringArray[n2];
                this.filterSet.add(pattern);
                ++n2;
            }
        }
        return this.filterSet;
    }

    public Collection<String> getExcludePatterns() {
        return Arrays.asList(this.excludePatterns);
    }
}

