/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal.load;

import com.ibm.team.filesystem.client.FileSystemCore;
import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.filesystem.client.ILoadRule;
import com.ibm.team.filesystem.client.ILoadRuleFactory;
import com.ibm.team.filesystem.client.internal.Messages;
import com.ibm.team.filesystem.client.internal.load.LoadRule;
import com.ibm.team.filesystem.client.internal.load.loadRules.LoadRuleHandler;
import com.ibm.team.filesystem.client.operations.ILoadRule2;
import com.ibm.team.filesystem.common.IFileItem;
import com.ibm.team.filesystem.common.IFileItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.util.NLS;
import com.ibm.team.scm.client.IConnection;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IVersionableHandle;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CodingErrorAction;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.SubMonitor;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;

public class LoadRuleFactory
implements ILoadRuleFactory {
    private static final String SAX_PROPERTIES_SCHEMA_LOCATION = "http://apache.org/xml/properties/schema/external-schemaLocation";
    private static final String SAX_FEATURES_VALIDATION_SCHEMA = "http://apache.org/xml/features/validation/schema";
    private static final String SAX_FEATURES_VALIDATION = "http://xml.org/sax/features/validation";
    private static final String SAX_FEATURES_INCLUDE_XMLNS_ATTRIBUTE = "http://xml.org/sax/features/namespace-prefixes";
    public static final String LOAD_RULE_SCHEMA_LOCATION = "http://com.ibm.team.scm platform:/plugin/com.ibm.team.filesystem.client/schema/LoadRule.xsd";
    private static LoadRuleFactory instance;
    private static final String XML_START = "<?xml";

    private LoadRuleFactory() {
    }

    @Override
    public ILoadRule createLoadRule(IWorkspaceConnection workspaceConnection, IComponentHandle componentHandle) {
        return new LoadRule(workspaceConnection, componentHandle);
    }

    /*
     * Loose catch block
     */
    @Override
    public ILoadRule2 getLoadRule(IWorkspaceConnection connection, IComponentHandle potentialComponentContext, Reader input, IProgressMonitor progress) throws TeamRepositoryException {
        ILoadRule2 rule;
        BufferedReader bufferedInput;
        block11: {
            bufferedInput = new BufferedReader(input);
            if (potentialComponentContext != null && !this.isXMLInput(bufferedInput)) break block11;
            ILoadRule2 iLoadRule2 = this.getLoadRule(connection, bufferedInput, progress);
            try {
                bufferedInput.close();
            }
            catch (IOException iOException) {}
            return iLoadRule2;
        }
        LoadRule oldRule = new LoadRule(connection, potentialComponentContext);
        oldRule.addLoadRules(bufferedInput, progress);
        ILoadRule2 iLoadRule2 = rule = oldRule.convertToNewFormat(potentialComponentContext, progress);
        try {
            bufferedInput.close();
        }
        catch (IOException iOException) {}
        return iLoadRule2;
        catch (IOException e) {
            try {
                throw new FileSystemException(NLS.bind((String)Messages.LoadRuleFactory_0, (Object)e.getMessage(), (Object[])new Object[0]), e);
            }
            catch (Throwable throwable) {
                try {
                    bufferedInput.close();
                }
                catch (IOException iOException) {}
                throw throwable;
            }
        }
    }

    @Override
    public ILoadRule2 getLoadRule(IWorkspaceConnection connection, Reader input, IProgressMonitor progress) throws TeamRepositoryException {
        InputSource inputSource;
        LoadRuleHandler handler;
        XMLReader parser;
        SAXParserFactory nsParserFactory = SAXParserFactory.newInstance();
        nsParserFactory.setNamespaceAware(true);
        nsParserFactory.setValidating(true);
        try {
            parser = nsParserFactory.newSAXParser().getXMLReader();
            handler = new LoadRuleHandler();
            parser.setContentHandler(handler);
            parser.setEntityResolver(handler);
            parser.setErrorHandler(handler);
            parser.setDTDHandler(handler);
            parser.setFeature(SAX_FEATURES_INCLUDE_XMLNS_ATTRIBUTE, true);
            parser.setFeature(SAX_FEATURES_VALIDATION, true);
            parser.setFeature(SAX_FEATURES_VALIDATION_SCHEMA, true);
            parser.setProperty(SAX_PROPERTIES_SCHEMA_LOCATION, LOAD_RULE_SCHEMA_LOCATION);
            inputSource = new InputSource(input);
        }
        catch (SAXNotRecognizedException e) {
            throw new FileSystemException(e);
        }
        catch (ParserConfigurationException e) {
            throw new FileSystemException(e);
        }
        catch (SAXException e) {
            throw new FileSystemException(e);
        }
        try {
            parser.parse(inputSource);
        }
        catch (SAXParseException spe) {
            Exception cause = spe.getException();
            if (cause == null) {
                cause = spe;
            }
            if (spe.getSystemId() != null) {
                throw new FileSystemException(NLS.bind((String)Messages.LoadRuleFactory_2, (Object)spe.getSystemId(), (Object[])new Object[]{spe.getLineNumber()}), cause);
            }
            throw new FileSystemException(NLS.bind((String)Messages.LoadRuleFactory_3, (Object)spe.getLocalizedMessage(), (Object[])new Object[0]), cause);
        }
        catch (IOException e) {
            throw new FileSystemException(Messages.LoadRuleFactory_4, e);
        }
        catch (SAXException e) {
            if (e.getException() instanceof TeamRepositoryException) {
                throw (TeamRepositoryException)((Object)e.getException());
            }
            throw new FileSystemException(NLS.bind((String)Messages.LoadRuleFactory_3, (Object)e.getLocalizedMessage(), (Object[])new Object[0]), e);
        }
        List<IStatus> warnings = handler.getWarnings();
        warnings.isEmpty();
        return handler.getLoadRule((IConnection)connection, progress);
    }

    public static ILoadRuleFactory getInstance() {
        if (instance == null) {
            instance = new LoadRuleFactory();
        }
        return instance;
    }

    /*
     * Loose catch block
     */
    @Override
    public boolean isXMLLoadRule(Reader input) {
        BufferedReader bufferedInput = new BufferedReader(input);
        boolean bl = this.isXMLInput(bufferedInput);
        try {
            bufferedInput.close();
        }
        catch (IOException iOException) {}
        return bl;
        catch (IOException iOException) {
            try {}
            catch (Throwable throwable) {
                try {
                    bufferedInput.close();
                }
                catch (IOException iOException2) {}
                throw throwable;
            }
            try {
                bufferedInput.close();
            }
            catch (IOException iOException3) {}
            return false;
        }
    }

    private boolean isXMLInput(BufferedReader input) throws IOException {
        boolean result = false;
        input.mark(12);
        char[] buffer = new char[10];
        int len = 0;
        int offset = 0;
        int max = buffer.length;
        while (len != -1 && offset < buffer.length) {
            len = input.read(buffer, offset, max);
            if (len == -1) continue;
            offset += len;
            max -= len;
        }
        String start = new String(buffer, 0, offset);
        if (start.contains(XML_START)) {
            result = true;
        }
        input.reset();
        return result;
    }

    @Override
    public ILoadRule2 getLoadRule(IWorkspaceConnection connection, IComponentHandle componentHandle, IFileItemHandle fileVersionable, IProgressMonitor progress) throws TeamRepositoryException {
        InputStreamReader reader;
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress, (int)100);
        IFileItem file = (IFileItem)connection.configuration(componentHandle).fetchCompleteItem((IVersionableHandle)fileVersionable, (IProgressMonitor)monitor.newChild(1));
        InputStream stream = FileSystemCore.getContentManager(connection.teamRepository()).retrieveContentStream((IFileItemHandle)file, file.getContent(), (IProgressMonitor)monitor.newChild(1));
        if (file.getContent().getCharacterEncoding() == null || file.getContent().getCharacterEncoding() == "") {
            CharsetDecoder decoder = Charset.forName("UTF-8").newDecoder().onMalformedInput(CodingErrorAction.REPORT).onUnmappableCharacter(CodingErrorAction.REPORT);
            reader = new InputStreamReader(stream, decoder);
        } else {
            try {
                reader = new InputStreamReader(stream, file.getContent().getCharacterEncoding());
            }
            catch (UnsupportedEncodingException e) {
                throw new FileSystemException(NLS.bind((String)Messages.LoadRuleFactory_1, (Object)file.getName(), (Object[])new Object[]{file.getContent().getCharacterEncoding()}), e);
            }
        }
        return this.getLoadRule(connection, componentHandle, reader, (IProgressMonitor)monitor.newChild(98));
    }
}

