/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal.namespace.impl;

import com.ibm.team.filesystem.client.internal.era.DeliveryInfo;
import com.ibm.team.filesystem.client.internal.era.EraDescriptor;
import com.ibm.team.filesystem.client.internal.namespace.AbstractContext;
import com.ibm.team.filesystem.client.internal.namespace.EraNamespace;
import com.ibm.team.filesystem.client.internal.namespace.IConfigurationWrapper;
import com.ibm.team.filesystem.client.internal.namespace.IContextHistory;
import com.ibm.team.filesystem.client.internal.namespace.impl.EraCache;
import com.ibm.team.filesystem.client.internal.namespace.impl.EraSnapshot;
import com.ibm.team.filesystem.common.changemodel.VersionablePath;
import com.ibm.team.filesystem.common.internal.util.ChangeSetUtil;
import com.ibm.team.repository.common.IItem;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.scm.client.IConnection;
import com.ibm.team.scm.common.IChange;
import com.ibm.team.scm.common.IChangeSet;
import com.ibm.team.scm.common.IComponent;
import com.ibm.team.scm.common.IVersionable;
import com.ibm.team.scm.common.internal.util.ItemId;
import com.ibm.team.scm.common.internal.util.NewCollection;
import com.ibm.team.scm.common.internal.util.StateId;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;

public class EraContext
extends AbstractContext {
    private HashMap<UUID, UUID> cachedStates = NewCollection.hashMap();
    private IConfigurationWrapper snapshot;
    private String name;
    private EraDescriptor era;

    public EraContext(EraDescriptor era, String name) {
        super(EraNamespace.create(era));
        this.snapshot = new EraSnapshot(this, era);
        this.name = name;
        this.era = era;
    }

    @Override
    public ItemId<IComponent> getComponent() {
        return this.era.getComponent();
    }

    @Override
    public IConnection getConnection() {
        return null;
    }

    @Override
    public EraDescriptor getChangeSets(IProgressMonitor monitor) throws TeamRepositoryException {
        return this.era;
    }

    private EraDescriptor getEra() {
        return this.era;
    }

    @Override
    public IConfigurationWrapper getVersionableTree() {
        return this.snapshot;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T extends IItem> Map<ItemId<T>, StateId<T>> getStates(Collection<ItemId<T>> itemIds, boolean shouldRefresh, IProgressMonitor monitor) throws TeamRepositoryException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        EraDescriptor descriptor = this.getEra();
        HashSet neededStates = NewCollection.hashSet();
        HashMap foundStates = NewCollection.hashMap();
        HashMap<UUID, UUID> hashMap = this.cachedStates;
        synchronized (hashMap) {
            for (ItemId<T> next : itemIds) {
                UUID cachedState = this.cachedStates.get(next.getItemUUID());
                if (cachedState == null) {
                    neededStates.add(next);
                    continue;
                }
                foundStates.put(next, new StateId(next, cachedState));
            }
        }
        boolean allCached = neededStates.isEmpty();
        int changeSetCounter = 0;
        while (!neededStates.isEmpty()) {
            progress.setWorkRemaining(5);
            IChangeSet nextChangeSet = EraCache.getDefault().fetchChangeSet(descriptor, changeSetCounter, false, (IProgressMonitor)progress.newChild(1));
            if (nextChangeSet == null) break;
            for (Object next : nextChangeSet.changes()) {
                IChange nextChange = (IChange)next;
                StateId afterState = ChangeSetUtil.getAfterState((IChange)nextChange);
                ItemId nextItem = afterState.getItemId();
                if (!neededStates.contains(nextItem)) continue;
                neededStates.remove(nextItem);
                foundStates.put(nextItem, afterState);
            }
            ++changeSetCounter;
        }
        if (!allCached) {
            HashMap<UUID, UUID> hashMap2 = this.cachedStates;
            synchronized (hashMap2) {
                for (StateId next : foundStates.values()) {
                    this.cachedStates.put(next.getItemUUID(), next.getStateUUID());
                }
            }
        }
        return foundStates;
    }

    @Override
    public void refresh(IProgressMonitor monitor) throws TeamRepositoryException {
        super.refresh(monitor);
    }

    @Override
    public boolean isLive() {
        return false;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public List<DeliveryInfo> findChangeSetsAffecting(ItemId<?> item, boolean searchIntermediates, int maxResults, IProgressMonitor monitor) throws TeamRepositoryException {
        return this.era.findChangeSetsAffecting(item, maxResults, monitor);
    }

    @Override
    public IContextHistory getHistory() {
        return null;
    }

    @Override
    public Collection<ItemId<IChangeSet>> changeSetsInHistory(Collection<ItemId<IChangeSet>> singleton, IProgressMonitor monitor) throws TeamRepositoryException {
        throw new TeamRepositoryException("Unsupported operation. Unable to compute whether change sets are contained in an IChangeHistory.");
    }

    @Override
    public Map<ItemId<IVersionable>, VersionablePath> resolve(Collection<ItemId<IVersionable>> versionables, IProgressMonitor monitor) throws TeamRepositoryException {
        return this.era.resolve(versionables, monitor);
    }
}

