/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal.patches;

import com.ibm.team.filesystem.client.internal.Messages;
import com.ibm.team.filesystem.client.internal.patches.CreatePatchDilemmaHandler;
import com.ibm.team.filesystem.common.FileLineDelimiter;
import com.ibm.team.filesystem.common.IFileItem;
import com.ibm.team.filesystem.common.ISymbolicLink;
import com.ibm.team.filesystem.common.changemodel.ChangeDescription;
import com.ibm.team.filesystem.common.changemodel.ConfigurationChange;
import com.ibm.team.filesystem.common.changemodel.FileChange;
import com.ibm.team.filesystem.common.changemodel.FileState;
import com.ibm.team.filesystem.common.changemodel.IPathResolver;
import com.ibm.team.filesystem.common.changemodel.ResolvedConfigurationChangePaths;
import com.ibm.team.filesystem.common.internal.patch.ByteArrayLines;
import com.ibm.team.filesystem.common.internal.patch.ChangeClassifier;
import com.ibm.team.filesystem.common.internal.patch.CreateDiffUtil;
import com.ibm.team.filesystem.common.internal.patch.DiffParticipant;
import com.ibm.team.filesystem.common.internal.patch.HunkRange;
import com.ibm.team.filesystem.common.internal.patch.RangeDifference;
import com.ibm.team.internal.repository.rcp.streams.InputStreamUtil;
import com.ibm.team.repository.common.IItemType;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.common.utils.IInputStreamProvider;
import com.ibm.team.repository.rcp.common.collection.CollectionUtil;
import com.ibm.team.scm.common.IFolder;
import com.ibm.team.scm.common.IVersionable;
import com.ibm.team.scm.common.internal.util.ItemId;
import com.ibm.team.scm.common.internal.util.NewCollection;
import com.ibm.team.scm.common.internal.util.SiloedItemId;
import com.ibm.team.scm.common.internal.util.StateId;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.CharBuffer;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubMonitor;

public class CreatePatchUtil {
    public static final String PATCH_HEADER_PREFIX = "### Jazz Patch";
    public static final String PATCH_HEADER_VERSION = "1.0";
    static final String PATCH_HEADER = "### Jazz Patch 1.0\n";
    static final String UTF8 = "UTF-8";
    public static final String TOKEN_DATE = "#date:";
    public static final String TOKEN_COMPONENT = "#component:";
    public static final String TOKEN_WORK_ITEM = "#work_item:";
    public static final String TOKEN_MOVE = "#move:";
    public static final String TOKEN_COMMENT = "#comment:";
    public static final String TOKEN_ITEM_ID = "#itemid:";
    public static final String TOKEN_ITEM_TYPE = "#item_type:";
    public static final String TOKEN_CHANGESET = "#changeset:";
    public static final String TOKEN_CREATE_EMPTYFILE = "#createemptyfile:";
    public static final String TOKEN_EMPTYFILE = "#emptyfile:";
    public static final String TOKEN_DELETE_FOLDER = "#delete_folder:";
    public static final String TOKEN_CREATE_FOLDER = "#create_folder:";
    public static final String TOKEN_BEFORE_STATE_ID = "#before_state:";
    public static final String TOKEN_AFTER_STATE_ID = "#after_state:";
    public static final String TOKEN_DELETE_LINK = "#delete_link:";
    public static final String TOKEN_CREATE_LINK = "#create_link:";
    public static final String TOKEN_CHANGE_LINK = "#change_link:";
    public static final String TOKEN_ADD_PROPERTY = "#add_property:";
    public static final String TOKEN_CHANGE_PROPERTY = "#change_property:";
    public static final String TOKEN_DELETE_PROPERTY = "#delete_property:";
    public static final String TOKEN_LINK_IS_DIRECTORY = "is_directory";

    public static void createPatch(CreatePatchDilemmaHandler handler, final OutputStream out, ConfigurationChange delta, ChangeDescription description, IPathResolver pathResolver, IProgressMonitor monitor) throws TeamRepositoryException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        ResolvedConfigurationChangePaths paths = ResolvedConfigurationChangePaths.resolve((IPathResolver)pathResolver, (ConfigurationChange)delta, (boolean)true, (boolean)true, (IProgressMonitor)progress.newChild(50));
        try {
            List changes = FileChange.filterNops((Collection)delta.getChanges());
            ChangeClassifier classifier = new ChangeClassifier(delta.getChanges());
            ArrayList textChanges = NewCollection.arrayList();
            textChanges.addAll(classifier.getTextChanges());
            if (!classifier.getNonText().isEmpty()) {
                Collection<FileChange> userResponse = handler.nonTextChangesDetected(classifier.getNonText());
                textChanges.addAll(userResponse);
            }
            HashSet<SiloedItemId<IVersionable>> itemIdsToWrite = new HashSet<SiloedItemId<IVersionable>>();
            HashMap changesById = NewCollection.hashMap();
            for (FileChange nextChange : changes) {
                ItemId parentId;
                itemIdsToWrite.add(nextChange.getSiloedItemId());
                ItemId parentComponent = nextChange.getSiloedItemId().getComponent();
                if (!nextChange.getInitial().isDeleted()) {
                    parentId = nextChange.getInitial().getPath().getParent();
                    itemIdsToWrite.add(SiloedItemId.create((ItemId)parentId, (ItemId)parentComponent));
                }
                if (!nextChange.getFinal().isDeleted()) {
                    parentId = nextChange.getFinal().getPath().getParent();
                    itemIdsToWrite.add(SiloedItemId.create((ItemId)parentId, (ItemId)parentComponent));
                }
                CollectionUtil.addToMapOfLists((Map)changesById, (Object)nextChange.getSiloedItemId(), (Object)nextChange);
            }
            ArrayList uniqueChanges = NewCollection.arrayList();
            HashMap<SiloedItemId, List<FileChange>> conflictsAndGaps = new HashMap<SiloedItemId, List<FileChange>>();
            for (Map.Entry next : changesById.entrySet()) {
                if (((List)next.getValue()).size() == 1) {
                    uniqueChanges.add((FileChange)((List)next.getValue()).iterator().next());
                    continue;
                }
                if (((List)next.getValue()).size() <= 1) continue;
                conflictsAndGaps.put((SiloedItemId)next.getKey(), (List)next.getValue());
            }
            if (!conflictsAndGaps.isEmpty()) {
                int result = handler.handleConflictsAndGaps(conflictsAndGaps);
                if (result == 2) {
                    throw new TeamRepositoryException(Messages.CreatePatchUtil_0);
                }
                if (result != 0) {
                    throw new OperationCanceledException();
                }
            }
            SubMonitor writeProgress = progress.newChild(50);
            writeProgress.setWorkRemaining(textChanges.size() + changes.size());
            out.write(PATCH_HEADER.getBytes(UTF8));
            CreatePatchUtil.writeChangeDescription(out, description);
            CreatePatchUtil.writeItemIds(out, paths, itemIdsToWrite);
            CreatePatchUtil.writeStateChanges(out, paths, uniqueChanges);
            HashSet emptyAfterStates = NewCollection.hashSet();
            for (FileChange change : classifier.getFolderChanges()) {
                if (change.getFinal().isDeleted()) {
                    CreatePatchUtil.writeFolderDelete(out, paths.computePath(change.getSiloedItemId(), true, null).toPath());
                    continue;
                }
                if (change.getInitial().isDeleted()) {
                    CreatePatchUtil.writeFolderCreate(out, paths.computePath(change.getSiloedItemId(), false, null).toPath());
                    continue;
                }
                if (change.getInitial().getPath().equals((Object)change.getFinal().getPath())) continue;
                CreatePatchUtil.writeMove(out, paths.computePath(change.getSiloedItemId(), true, null).toPath(), paths.computePath(change.getSiloedItemId(), false, null).toPath());
            }
            for (FileChange change : classifier.getLinkChanges()) {
                if (change.getFinal().isDeleted()) {
                    CreatePatchUtil.writeLinkDelete(out, paths.computePath(change.getSiloedItemId(), true, null).toPath());
                    continue;
                }
                if (change.getInitial().isDeleted()) {
                    CreatePatchUtil.writeLinkCreate(out, paths.computePath(change.getSiloedItemId(), false, null).toPath(), change.getFinal().getTarget(), change.getFinal().isDirectoryLink());
                    continue;
                }
                if (!change.getInitial().getPath().equals((Object)change.getFinal().getPath())) {
                    CreatePatchUtil.writeMove(out, paths.computePath(change.getSiloedItemId(), true, null).toPath(), paths.computePath(change.getSiloedItemId(), false, null).toPath());
                }
                if ((!change.isModify() || change.getFinal().getTarget().equals(change.getInitial().getTarget())) && change.getInitial().isDirectoryLink() == change.getFinal().isDirectoryLink()) continue;
                CreatePatchUtil.writeLinkChange(out, paths.computePath(change.getSiloedItemId(), false, null).toPath(), change.getFinal().getTarget(), change.getFinal().isDirectoryLink());
            }
            Collection propertyChanges = classifier.getPropertyChanges();
            for (FileChange change : propertyChanges) {
                CreatePatchUtil.writePropertyChange(out, change);
            }
            for (FileChange change : textChanges) {
                if (!(change.getInitial().getPath().equals((Object)change.getFinal().getPath()) || change.getInitial().isDeleted() || change.getFinal().isDeleted())) {
                    CreatePatchUtil.writeMove(out, paths.computePath(change.getSiloedItemId(), true, null).toPath(), paths.computePath(change.getSiloedItemId(), false, null).toPath());
                }
                IInputStreamProvider afterContents = change.getFinal().getContents();
                change.getInitial().getContents();
                boolean emptyAfterState = false;
                if (InputStreamUtil.isEmpty((IInputStreamProvider)afterContents, (IProgressMonitor)writeProgress.newChild(1))) {
                    emptyAfterState = true;
                    emptyAfterStates.add(change);
                }
                if (!change.getInitial().isDeleted() || !emptyAfterState) continue;
                CreatePatchUtil.writeCreateEmptyFile(out, paths.computePath(change.getSiloedItemId(), false, null).toPath());
            }
            out.write("#\n".getBytes(UTF8));
            DiffParticipant<ByteArrayLines> diffParticipant = new DiffParticipant<ByteArrayLines>(){

                public ByteArrayLines getRange(InputStream in, String optionalCharsetName) throws IOException {
                    return new ByteArrayLines(in);
                }

                public RangeDifference[] getDifferences(ByteArrayLines range1, ByteArrayLines range2) {
                    return range1.lcs(range2).getDifferences();
                }

                public boolean hasTrailingNL(ByteArrayLines range) {
                    return range.hasTrailingNL();
                }

                public int numLines(ByteArrayLines range) {
                    return range.numLines();
                }

                protected void writeHeader(String header) throws IOException {
                    out.write(header.getBytes(CreatePatchUtil.UTF8));
                }

                public void writeHunkRange(HunkRange range) throws IOException {
                    out.write((String.valueOf(range.toString()) + "\n").getBytes(CreatePatchUtil.UTF8));
                }

                public void writeCommonLine(ByteArrayLines range, int lineNum) throws IOException {
                    out.write(32);
                    out.write(range.get(lineNum));
                }

                public void writeAddedLine(ByteArrayLines range, int lineNum) throws IOException {
                    out.write(43);
                    out.write(range.get(lineNum));
                }

                public void writeRemovedLine(ByteArrayLines range, int lineNum) throws IOException {
                    out.write(45);
                    out.write(range.get(lineNum));
                }

                public void writeNoTrailingNL(ByteArrayLines range) throws IOException {
                    out.write(CreateDiffUtil.NO_TRAILING_NL);
                }
            };
            for (FileChange next : textChanges) {
                if (next.getInitial().isDeleted() && emptyAfterStates.contains(next)) continue;
                CreateDiffUtil.writeDiff((DiffParticipant)diffParticipant, (FileChange)next, (ResolvedConfigurationChangePaths)paths, (IProgressMonitor)writeProgress.newChild(1));
            }
        }
        catch (IOException e) {
            throw new TeamRepositoryException((Throwable)e);
        }
    }

    private static void writePropertyChange(OutputStream out, FileChange change) throws IOException {
        FileLineDelimiter finalLineDelimeter;
        FileLineDelimiter initialLineDelimeter;
        String finalContentType;
        String initialContentType;
        boolean finalExecutable;
        UUID uuid = change.getItemId().getItemUUID();
        FileState initialState = change.getInitial();
        Map initialProperties = initialState.getProperties();
        FileState finalState = change.getFinal();
        Map finalProperties = finalState.getProperties();
        HashSet allNames = NewCollection.hashSet();
        allNames.addAll(initialProperties.keySet());
        allNames.addAll(finalProperties.keySet());
        for (String name : allNames) {
            String initialValue = (String)initialProperties.get(name);
            String finalValue = (String)finalProperties.get(name);
            if (initialValue == null) {
                CreatePatchUtil.writePropertyAddition(out, uuid, name, finalValue);
                continue;
            }
            if (finalValue == null) {
                CreatePatchUtil.writePropertyDeletion(out, uuid, name);
                continue;
            }
            if (initialValue.equals(finalValue)) continue;
            CreatePatchUtil.writePropertyChange(out, uuid, name, finalValue);
        }
        boolean initialExecutable = initialState.isExectuable();
        if (initialExecutable != (finalExecutable = finalState.isExectuable())) {
            CreatePatchUtil.writePropertyChange(out, uuid, " executable_bit", Boolean.toString(finalExecutable));
        }
        if (!(initialContentType = initialState.getContentType()).equals(finalContentType = finalState.getContentType())) {
            CreatePatchUtil.writePropertyChange(out, uuid, " content_type", finalContentType);
        }
        if ((initialLineDelimeter = initialState.getLineDelimiter()) != (finalLineDelimeter = finalState.getLineDelimiter())) {
            CreatePatchUtil.writePropertyChange(out, uuid, " line_delimiter", finalLineDelimeter.toString());
        }
    }

    private static void writePropertyAddition(OutputStream out, UUID uuid, String name, String finalValue) throws IOException {
        CreatePatchUtil.writeMetadata(out, TOKEN_ADD_PROPERTY, new String[]{uuid.getUuidValue(), name, finalValue});
    }

    private static void writePropertyDeletion(OutputStream out, UUID uuid, String name) throws IOException {
        CreatePatchUtil.writeMetadata(out, TOKEN_DELETE_PROPERTY, new String[]{uuid.getUuidValue(), name});
    }

    private static void writePropertyChange(OutputStream out, UUID uuid, String name, String finalValue) throws IOException {
        CreatePatchUtil.writeMetadata(out, TOKEN_CHANGE_PROPERTY, new String[]{uuid.getUuidValue(), name, finalValue});
    }

    private static void writeStateChanges(OutputStream out, ResolvedConfigurationChangePaths paths, Collection<FileChange> changes) throws IOException, TeamRepositoryException {
        for (FileChange next : changes) {
            SiloedItemId versionable = next.getSiloedItemId();
            String pathString = paths.computePath(versionable, true, null).toPath().toString();
            if (next.getInitial().isValidStateId()) {
                CreatePatchUtil.writeStateId(out, TOKEN_BEFORE_STATE_ID, pathString, next.getInitial().getStateId());
            }
            if (!next.getFinal().isValidStateId()) continue;
            CreatePatchUtil.writeStateId(out, TOKEN_AFTER_STATE_ID, pathString, next.getFinal().getStateId());
        }
    }

    private static void writeStateId(OutputStream out, String token, String pathString, StateId stateId) throws IOException {
        CreatePatchUtil.writeMetadata(out, token, new String[]{pathString, stateId.getItemUUID().getUuidValue(), stateId.getStateUUID().getUuidValue()});
    }

    private static void writeFolderCreate(OutputStream out, IPath path) throws IOException {
        CreatePatchUtil.writeMetadata(out, TOKEN_CREATE_FOLDER, path.toString());
    }

    private static void writeFolderDelete(OutputStream out, IPath path) throws IOException {
        CreatePatchUtil.writeMetadata(out, TOKEN_DELETE_FOLDER, path.toString());
    }

    private static void writeLinkCreate(OutputStream out, IPath path, String linkTarget, boolean isDirectory) throws IOException {
        if (!isDirectory) {
            CreatePatchUtil.writeMetadata(out, TOKEN_CREATE_LINK, new String[]{path.toString(), linkTarget});
        } else {
            CreatePatchUtil.writeMetadata(out, TOKEN_CREATE_LINK, new String[]{path.toString(), linkTarget, TOKEN_LINK_IS_DIRECTORY});
        }
    }

    private static void writeLinkChange(OutputStream out, IPath path, String linkTarget, boolean isDirectory) throws IOException {
        if (!isDirectory) {
            CreatePatchUtil.writeMetadata(out, TOKEN_CHANGE_LINK, new String[]{path.toString(), linkTarget});
        } else {
            CreatePatchUtil.writeMetadata(out, TOKEN_CHANGE_LINK, new String[]{path.toString(), linkTarget, TOKEN_LINK_IS_DIRECTORY});
        }
    }

    private static void writeLinkDelete(OutputStream out, IPath path) throws IOException {
        CreatePatchUtil.writeMetadata(out, TOKEN_DELETE_LINK, path.toString());
    }

    private static void writeCreateEmptyFile(OutputStream out, IPath path) throws IOException {
        CreatePatchUtil.writeMetadata(out, TOKEN_CREATE_EMPTYFILE, path.toString());
    }

    private static void writeItemIds(OutputStream out, ResolvedConfigurationChangePaths paths, Collection<SiloedItemId<IVersionable>> itemIds) throws IOException, TeamRepositoryException {
        for (SiloedItemId<IVersionable> versionable : itemIds) {
            CreatePatchUtil.writeMetadata(out, TOKEN_ITEM_ID, new String[]{paths.computePath(versionable, true, null).toPath().toString(), versionable.getItemUUID().getUuidValue(), versionable.getComponentUUID().getUuidValue()});
            String itemTypeString = CreatePatchUtil.getItemTypeString(versionable.getItemType());
            if (itemTypeString == null) continue;
            CreatePatchUtil.writeMetadata(out, TOKEN_ITEM_TYPE, new String[]{versionable.getItemUUID().getUuidValue(), itemTypeString});
        }
    }

    private static String getItemTypeString(IItemType itemType) {
        if (itemType.equals(IFileItem.ITEM_TYPE)) {
            return "file";
        }
        if (itemType.equals(IFolder.ITEM_TYPE)) {
            return "folder";
        }
        if (itemType.equals(ISymbolicLink.ITEM_TYPE)) {
            return "link";
        }
        return null;
    }

    public static IItemType getItemType(String string) {
        if (string.equals("file")) {
            return IFileItem.ITEM_TYPE;
        }
        if (string.equals("folder")) {
            return IFolder.ITEM_TYPE;
        }
        if (string.equals("link")) {
            return ISymbolicLink.ITEM_TYPE;
        }
        return null;
    }

    private static void writeChangeDescription(OutputStream out, ChangeDescription delta) throws IOException {
        if (!delta.getComment().equals("")) {
            CreatePatchUtil.writeMetadata(out, TOKEN_COMMENT, delta.getComment());
        }
        for (ItemId next : delta.getChangeSets()) {
            CreatePatchUtil.writeMetadata(out, TOKEN_CHANGESET, next.getItemUUID().getUuidValue());
        }
        SimpleDateFormat diff_date_format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSSSSSSSS Z", Locale.ENGLISH);
        CreatePatchUtil.writeMetadata(out, TOKEN_DATE, diff_date_format.format(delta.getDate()));
        if (!delta.getComponent().isNull()) {
            CreatePatchUtil.writeMetadata(out, TOKEN_COMPONENT, delta.getComponent().getItemUUID().getUuidValue());
        }
        for (ItemId next : delta.getWorkItems()) {
            CreatePatchUtil.writeMetadata(out, TOKEN_WORK_ITEM, new String[]{next.getItemUUID().getUuidValue(), next.getItemType().getName(), next.getItemType().getNamespaceURI()});
        }
    }

    public static String javaEncodeString(String unencoded) {
        boolean changed = false;
        CharBuffer buffer = CharBuffer.allocate(unencoded.length() * 2);
        char[] chars = new char[unencoded.length()];
        unencoded.getChars(0, unencoded.length(), chars, 0);
        int idx = 0;
        while (idx < chars.length) {
            char ch = chars[idx];
            boolean specialChar = true;
            switch (ch) {
                case '\n': {
                    buffer.put("\\n");
                    break;
                }
                case '\t': {
                    buffer.put("\\t");
                    break;
                }
                case '\b': {
                    buffer.put("\\b");
                    break;
                }
                case '\r': {
                    buffer.put("\\r");
                    break;
                }
                case '\"': {
                    buffer.put("\\\"");
                    break;
                }
                case '\'': {
                    buffer.put("\\'");
                    break;
                }
                case '\\': {
                    buffer.put("\\\\");
                    break;
                }
                default: {
                    specialChar = false;
                    buffer.put(ch);
                }
            }
            if (specialChar) {
                changed = true;
            }
            ++idx;
        }
        if (changed) {
            String result = new String(buffer.array(), 0, buffer.position());
            return result;
        }
        return unencoded;
    }

    public static String getFilePatchHeader(IPath beforePath, IPath afterPath, Date beforeDate, Date afterDate) {
        return CreateDiffUtil.getFilePatchHeader((String)(beforePath == null ? null : beforePath.toString()), (String)(afterPath == null ? null : afterPath.toString()), (Date)beforeDate, (Date)afterDate);
    }

    public static void writeMove(OutputStream out, IPath beforePath, IPath afterPath) throws IOException {
        CreatePatchUtil.writeMetadata(out, TOKEN_MOVE, new String[]{beforePath.toString(), afterPath.toString()});
    }

    private static void writeMetadata(OutputStream out, String token, String comment) throws IOException {
        CreatePatchUtil.writeMetadata(out, token, new String[]{comment});
    }

    public static void writeMetadata(OutputStream out, String token, String[] strings) throws IOException {
        out.write(token.getBytes(UTF8));
        int idx = 0;
        while (idx < strings.length) {
            out.write(" \"".getBytes(UTF8));
            out.write(CreatePatchUtil.javaEncodeString(strings[idx]).getBytes(UTF8));
            out.write("\"".getBytes(UTF8));
            ++idx;
        }
        out.write("\n".getBytes(UTF8));
    }
}

