/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal.rest.util;

import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.filesystem.client.IRelativeLocation;
import com.ibm.team.filesystem.client.ISandbox;
import com.ibm.team.filesystem.client.IShare;
import com.ibm.team.filesystem.client.IShareable;
import com.ibm.team.filesystem.client.ISharingDescriptor;
import com.ibm.team.filesystem.client.internal.SharingManager;
import com.ibm.team.filesystem.client.internal.utils.ConfigurationFacade;
import com.ibm.team.filesystem.client.internal.utils.FlowTableUtil;
import com.ibm.team.filesystem.client.internal.utils.RepositoryUtils;
import com.ibm.team.filesystem.common.FileLineDelimiter;
import com.ibm.team.filesystem.common.IFileItem;
import com.ibm.team.filesystem.common.IFileItemHandle;
import com.ibm.team.filesystem.common.ISymbolicLink;
import com.ibm.team.filesystem.common.ISymbolicLinkHandle;
import com.ibm.team.filesystem.common.internal.rest.client.changeset.DeliveryRequiresHistoryReorderingDTO;
import com.ibm.team.filesystem.common.internal.rest.client.changeset.FilesystemRestClientDTOchangesetFactory;
import com.ibm.team.filesystem.common.internal.rest.client.changeset.GapChangeSetsDTO;
import com.ibm.team.filesystem.common.internal.rest.client.changeset.ProblemChangeSetsDTO;
import com.ibm.team.filesystem.common.internal.rest.client.core.BaselineDTO;
import com.ibm.team.filesystem.common.internal.rest.client.core.BaselineSetDTO;
import com.ibm.team.filesystem.common.internal.rest.client.core.ConfigurationDescriptor2DTO;
import com.ibm.team.filesystem.common.internal.rest.client.core.ConfigurationDescriptorDTO;
import com.ibm.team.filesystem.common.internal.rest.client.core.ConnectionDescriptor2DTO;
import com.ibm.team.filesystem.common.internal.rest.client.core.ConnectionDescriptorDTO;
import com.ibm.team.filesystem.common.internal.rest.client.core.ExceptionDTO;
import com.ibm.team.filesystem.common.internal.rest.client.core.FilesystemRestClientDTOcoreFactory;
import com.ibm.team.filesystem.common.internal.rest.client.core.PathDTO;
import com.ibm.team.filesystem.common.internal.rest.client.core.ReadScopeDTO;
import com.ibm.team.filesystem.common.internal.rest.client.core.SandboxDTO;
import com.ibm.team.filesystem.common.internal.rest.client.core.ShareDTO;
import com.ibm.team.filesystem.common.internal.rest.client.core.ShareableDTO;
import com.ibm.team.filesystem.common.internal.rest.client.core.StackTraceElementDTO;
import com.ibm.team.filesystem.common.internal.rest.client.core.StatusDTO;
import com.ibm.team.filesystem.common.internal.rest.client.core.WorkspaceComponentDTO;
import com.ibm.team.filesystem.common.internal.rest.client.core.WorkspaceDetailsDTO;
import com.ibm.team.filesystem.common.internal.rest.client.core.WorkspaceFlowEntryDTO;
import com.ibm.team.filesystem.common.internal.rest.client.locks.ComponentLockReportDTO;
import com.ibm.team.filesystem.common.internal.rest.client.locks.FilesystemRestClientDTOlocksFactory;
import com.ibm.team.filesystem.common.internal.rest.client.locks.StreamLockReportDTO;
import com.ibm.team.filesystem.common.internal.rest.client.locks.VersionableLockDTO;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IAuditable;
import com.ibm.team.repository.common.IAuditableHandle;
import com.ibm.team.repository.common.IContributor;
import com.ibm.team.repository.common.IContributorHandle;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.IItemType;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.scm.client.IBaselineConnection;
import com.ibm.team.scm.client.IConnection;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.client.SCMPlatform;
import com.ibm.team.scm.client.internal.ConfigurationDescriptor;
import com.ibm.team.scm.client.internal.ConnectionDescriptor;
import com.ibm.team.scm.client.internal.FlowUtils;
import com.ibm.team.scm.client.internal.IConfigurationDescriptor;
import com.ibm.team.scm.common.IBaseline;
import com.ibm.team.scm.common.IBaselineHandle;
import com.ibm.team.scm.common.IBaselineSet;
import com.ibm.team.scm.common.IChangeSetHandle;
import com.ibm.team.scm.common.IComponent;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IContextHandle;
import com.ibm.team.scm.common.ICurrentComponentInfo;
import com.ibm.team.scm.common.IFlowEntry;
import com.ibm.team.scm.common.IFlowNodeHandle;
import com.ibm.team.scm.common.IFlowTable;
import com.ibm.team.scm.common.IFolder;
import com.ibm.team.scm.common.IFolderHandle;
import com.ibm.team.scm.common.IVersionableHandle;
import com.ibm.team.scm.common.IWorkspace;
import com.ibm.team.scm.common.IWorkspaceHandle;
import com.ibm.team.scm.common.dto.IAccessGroupScope;
import com.ibm.team.scm.common.dto.IAncestorReport;
import com.ibm.team.scm.common.dto.IComponentLockReport;
import com.ibm.team.scm.common.dto.IContributorDeferringScope;
import com.ibm.team.scm.common.dto.INameItemPair;
import com.ibm.team.scm.common.dto.IPrivateScope;
import com.ibm.team.scm.common.dto.IProcessAreaScope;
import com.ibm.team.scm.common.dto.IPublicScope;
import com.ibm.team.scm.common.dto.IReadScope;
import com.ibm.team.scm.common.dto.IStreamLockReport;
import com.ibm.team.scm.common.dto.ITeamAreaPrivateScope;
import com.ibm.team.scm.common.dto.IUnknownScope;
import com.ibm.team.scm.common.dto.IVersionableLock;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.osgi.util.NLS;

public class CoreUtil {
    public static ShareDTO translateShare(IShare share, IProgressMonitor monitor) {
        ShareDTO translation = FilesystemRestClientDTOcoreFactory.eINSTANCE.createShareDTO();
        ISharingDescriptor sharingDescriptor = share.getSharingDescriptor();
        translation.setComponentItemId(sharingDescriptor.getComponent().getItemId().getUuidValue());
        translation.setComponentName(sharingDescriptor.getComponentName());
        translation.setRootVersionableItemId(sharingDescriptor.getRootVersionable().getItemId().getUuidValue());
        translation.setRootVersionableItemType(CoreUtil.getVersionableItemType(sharingDescriptor.getRootVersionable()));
        translation.setSandboxPath(share.getSandbox().getRoot().toOSString());
        translation.setPath(CoreUtil.translatePath(share.getPath()));
        translation.setContextItemId(sharingDescriptor.getConnectionHandle().getItemId().getUuidValue());
        translation.setIsWorkspaceContext(sharingDescriptor.getConnectionHandle() instanceof IWorkspaceHandle);
        translation.setContextName(sharingDescriptor.getConnectionName());
        translation.setRepositoryId(sharingDescriptor.getRepositoryId().getUuidValue());
        try {
            translation.setIsLoadedWithAnotherName(share.isLoadedWithAnotherName(monitor));
        }
        catch (FileSystemException fileSystemException) {}
        return translation;
    }

    public static String translatePathToString(PathDTO path) {
        StringBuffer buf = new StringBuffer();
        for (String seg : path.getSegments()) {
            buf.append('/');
            buf.append(seg);
        }
        return buf.toString();
    }

    public static PathDTO translatePath(IRelativeLocation path) {
        return CoreUtil.translatePath(path.segments());
    }

    public static PathDTO translatePath(IShareable shareable) {
        return CoreUtil.translatePath(shareable.getLocalPath());
    }

    public static PathDTO translatePath(String path) {
        return CoreUtil.translatePath(new Path(path).segments());
    }

    public static PathDTO translatePath(String[] pathSegments) {
        PathDTO path = FilesystemRestClientDTOcoreFactory.eINSTANCE.createPathDTO();
        path.getSegments().addAll(Arrays.asList(pathSegments));
        return path;
    }

    public static PathDTO translatePath(IAncestorReport report) {
        PathDTO path = FilesystemRestClientDTOcoreFactory.eINSTANCE.createPathDTO();
        Iterator iPairs = report.getNameItemPairs().iterator();
        iPairs.next();
        while (iPairs.hasNext()) {
            path.getSegments().add(((INameItemPair)iPairs.next()).getName());
        }
        return path;
    }

    public static ConfigurationDescriptorDTO translateConfigurationDescriptor(ConfigurationDescriptor descriptor) {
        ConfigurationDescriptorDTO configurationDescriptor = FilesystemRestClientDTOcoreFactory.eINSTANCE.createConfigurationDescriptorDTO();
        ConnectionDescriptorDTO connectionDescriptor = FilesystemRestClientDTOcoreFactory.eINSTANCE.createConnectionDescriptorDTO();
        connectionDescriptor.setRepositoryId(descriptor.id.getUuidValue());
        connectionDescriptor.setRepositoryURL(descriptor.uri);
        connectionDescriptor.setContextItemId(descriptor.connectionHandle.getItemId().getUuidValue());
        connectionDescriptor.setIsWorkspaceContext(descriptor.connectionHandle instanceof IWorkspaceHandle);
        configurationDescriptor.setConnection(connectionDescriptor);
        configurationDescriptor.setComponentItemId(descriptor.componentHandle.getItemId().getUuidValue());
        return configurationDescriptor;
    }

    public static ConfigurationDescriptor2DTO translateConfigurationDescriptor(IConfigurationDescriptor descriptor) {
        ConfigurationDescriptor2DTO configurationDescriptor = FilesystemRestClientDTOcoreFactory.eINSTANCE.createConfigurationDescriptor2DTO();
        ConnectionDescriptor2DTO connectionDescriptor = FilesystemRestClientDTOcoreFactory.eINSTANCE.createConnectionDescriptor2DTO();
        connectionDescriptor.setRepositoryId(descriptor.getRepositoryId().getUuidValue());
        IContextHandle connectionHandle = descriptor.getConnectionHandle();
        connectionDescriptor.setContextItemId(connectionHandle.getItemId().getUuidValue());
        connectionDescriptor.setIsWorkspaceContext(connectionHandle instanceof IWorkspaceHandle);
        configurationDescriptor.setConnection(connectionDescriptor);
        configurationDescriptor.setComponentItemId(descriptor.getComponentHandle().getItemId().getUuidValue());
        return configurationDescriptor;
    }

    public static ConfigurationDescriptorDTO translateConfigurationDescriptor(ConfigurationFacade descriptor) {
        ConfigurationDescriptorDTO configurationDescriptor = FilesystemRestClientDTOcoreFactory.eINSTANCE.createConfigurationDescriptorDTO();
        ConnectionDescriptorDTO connectionDescriptor = FilesystemRestClientDTOcoreFactory.eINSTANCE.createConnectionDescriptorDTO();
        connectionDescriptor.setRepositoryId(descriptor.getRepositoryId().getUuidValue());
        connectionDescriptor.setRepositoryURL(descriptor.getRepositoryURI());
        IContextHandle connectionHandle = descriptor.getConnectionHandle();
        connectionDescriptor.setContextItemId(connectionHandle.getItemId().getUuidValue());
        connectionDescriptor.setIsWorkspaceContext(connectionHandle instanceof IWorkspaceHandle);
        configurationDescriptor.setConnection(connectionDescriptor);
        configurationDescriptor.setComponentItemId(descriptor.getComponentHandle().getItemId().getUuidValue());
        return configurationDescriptor;
    }

    public static ConnectionDescriptorDTO translateConnection(IConnection connection) {
        ConnectionDescriptorDTO connectionDescriptor = FilesystemRestClientDTOcoreFactory.eINSTANCE.createConnectionDescriptorDTO();
        ITeamRepository teamRepository = connection.teamRepository();
        connectionDescriptor.setRepositoryId(CoreUtil.translateRepositoryId(teamRepository));
        connectionDescriptor.setRepositoryURL(teamRepository.getRepositoryURI());
        connectionDescriptor.setContextItemId(connection.getContextHandle().getItemId().getUuidValue());
        connectionDescriptor.setIsWorkspaceContext(connection.getContextHandle() instanceof IWorkspaceHandle);
        return connectionDescriptor;
    }

    public static BaselineDTO translateBaseline(IBaselineConnection baselineConnection, HashMap<UUID, IContributor> contributors) {
        return CoreUtil.translateBaseline(baselineConnection.teamRepository(), baselineConnection.getResolvedBaseline(), contributors);
    }

    public static HashMap<UUID, IContributor> fetchCreatorAndGetModifiedBy(ITeamRepository repo, List<IBaseline> baselines, IProgressMonitor monitor) throws TeamRepositoryException {
        HashMap<UUID, IContributorHandle> contributorHandles = new HashMap<UUID, IContributorHandle>();
        for (IBaseline baseline : baselines) {
            if (baseline == null) continue;
            IContributorHandle contributor = baseline.getCreator();
            contributorHandles.put(contributor.getItemId(), contributor);
            contributor = baseline.getModifiedBy();
            if (contributor == null) continue;
            contributorHandles.put(contributor.getItemId(), contributor);
        }
        List contributors = repo.itemManager().fetchCompleteItems(new ArrayList(contributorHandles.values()), 0, monitor);
        HashMap<UUID, IContributor> result = new HashMap<UUID, IContributor>();
        for (IContributorHandle contributor : contributors) {
            result.put(contributor.getItemId(), (IContributor)contributor);
        }
        return result;
    }

    public static BaselineDTO translateBaseline(ITeamRepository repository, IBaseline baseline, HashMap<UUID, IContributor> contributors) {
        BaselineDTO baselineDTO = FilesystemRestClientDTOcoreFactory.eINSTANCE.createBaselineDTO();
        baselineDTO.setItemId(baseline.getItemId().getUuidValue());
        baselineDTO.setRepositoryId(CoreUtil.translateRepositoryId(repository));
        baselineDTO.setRepositoryURL(repository.getRepositoryURI());
        baselineDTO.setId(baseline.getId());
        baselineDTO.setName(baseline.getName());
        baselineDTO.setComment(baseline.getComment());
        baselineDTO.setComponentItemId(baseline.getComponent().getItemId().getUuidValue());
        baselineDTO.setCreationDate(baseline.getCreationDate().getTime());
        baselineDTO.setCreatorContributorItemId(baseline.getCreator().getItemId().getUuidValue());
        baselineDTO.setModifiedDate(baseline.modified().getTime());
        baselineDTO.setModifierContributorItemId(baseline.getModifiedBy().getItemId().getUuidValue());
        IContributor contributor = contributors.get(baseline.getCreator().getItemId());
        if (contributor != null) {
            baselineDTO.setCreatorContributorName(contributor.getName());
        }
        if ((contributor = contributors.get(baseline.getModifiedBy().getItemId())) != null) {
            baselineDTO.setModifierContributorName(contributor.getName());
        }
        return baselineDTO;
    }

    public static BaselineSetDTO translateBaselineSet(ITeamRepository repository, IBaselineSet baselineSet) {
        BaselineSetDTO baselineSetDTO = FilesystemRestClientDTOcoreFactory.eINSTANCE.createBaselineSetDTO();
        baselineSetDTO.setComment(baselineSet.getComment());
        baselineSetDTO.setCreationDate(baselineSet.getCreationDate().getTime());
        baselineSetDTO.setCreatorContributorItemId(baselineSet.getCreator().getItemId().getUuidValue());
        baselineSetDTO.setItemId(baselineSet.getItemId().getUuidValue());
        baselineSetDTO.setModifiedDate(baselineSet.modified().getTime());
        baselineSetDTO.setModifierContributorItemId(baselineSet.getModifiedBy().getItemId().getUuidValue());
        baselineSetDTO.setName(baselineSet.getName());
        baselineSetDTO.setOwnerWorkspaceItemId(baselineSet.getOwner().getItemId().getUuidValue());
        baselineSetDTO.setRepositoryId(CoreUtil.translateRepositoryId(repository));
        baselineSetDTO.setRepositoryURL(repository.getRepositoryURI());
        for (IBaselineHandle baselineHandle : baselineSet.getBaselines()) {
            baselineSetDTO.getBaselineItemIds().add(baselineHandle.getItemId().getUuidValue());
        }
        return baselineSetDTO;
    }

    public static ProblemChangeSetsDTO translateProblemChangeSetsDTO(IWorkspaceConnection workspace, Collection<? extends IChangeSetHandle> changeSets) {
        ProblemChangeSetsDTO problemChangeSetsDTO = FilesystemRestClientDTOchangesetFactory.eINSTANCE.createProblemChangeSetsDTO();
        ITeamRepository teamRepository = workspace.teamRepository();
        problemChangeSetsDTO.setRepositoryId(CoreUtil.translateRepositoryId(teamRepository));
        problemChangeSetsDTO.setRepositoryURL(teamRepository.getRepositoryURI());
        problemChangeSetsDTO.setWorkspaceItemId(workspace.getContextHandle().getItemId().getUuidValue());
        for (IChangeSetHandle iChangeSetHandle : changeSets) {
            problemChangeSetsDTO.getChangeSetItemIds().add(iChangeSetHandle.getItemId().getUuidValue());
        }
        return problemChangeSetsDTO;
    }

    public static GapChangeSetsDTO translateGapProblemChangeSetsDTO(IWorkspaceConnection workspace, Collection<IChangeSetHandle> changeSets, boolean handlingSuspended) {
        GapChangeSetsDTO gapChangeSetsDTO = FilesystemRestClientDTOchangesetFactory.eINSTANCE.createGapChangeSetsDTO();
        ITeamRepository teamRepository = workspace.teamRepository();
        gapChangeSetsDTO.setRepositoryId(CoreUtil.translateRepositoryId(teamRepository));
        gapChangeSetsDTO.setRepositoryURL(teamRepository.getRepositoryURI());
        gapChangeSetsDTO.setWorkspaceItemId(workspace.getContextHandle().getItemId().getUuidValue());
        for (IChangeSetHandle changeSet : changeSets) {
            gapChangeSetsDTO.getChangeSetItemIds().add(changeSet.getItemId().getUuidValue());
        }
        gapChangeSetsDTO.setHandlingSuspended(handlingSuspended);
        return gapChangeSetsDTO;
    }

    public static WorkspaceDetailsDTO translateWorkspace(IWorkspaceConnection connection, boolean includeComponents, boolean includeFlowTargets, boolean includeComponentOwner, boolean includeComponentReadScope, IProgressMonitor progress) throws TeamRepositoryException {
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress, (int)105);
        WorkspaceDetailsDTO workspace = CoreUtil.translateWorkspace(connection.teamRepository(), connection.getResolvedWorkspace(), monitor.newChild(5));
        if (includeComponents) {
            ArrayList<Object> toRetrieve = new ArrayList<Object>(2 * connection.getComponentsInfo().size());
            for (ICurrentComponentInfo currentComponentInfo : connection.getComponentsInfo()) {
                toRetrieve.add(currentComponentInfo.basis());
                toRetrieve.add(currentComponentInfo.getComponent());
            }
            List items = connection.teamRepository().itemManager().fetchCompleteItems(toRetrieve, 0, (IProgressMonitor)monitor.newChild(20));
            HashMap<UUID, IAuditable> retrieved = new HashMap<UUID, IAuditable>();
            ArrayList<IBaseline> baselines = new ArrayList<IBaseline>();
            for (IAuditable auditable : items) {
                if (auditable == null) continue;
                retrieved.put(auditable.getItemId(), auditable);
                if (!(auditable instanceof IBaseline)) continue;
                baselines.add((IBaseline)auditable);
            }
            HashMap<UUID, IContributor> contributors = CoreUtil.fetchCreatorAndGetModifiedBy(connection.teamRepository(), baselines, (IProgressMonitor)monitor.newChild(20));
            ArrayList<IComponentHandle> toQueryForOwner = new ArrayList<IComponentHandle>();
            for (ICurrentComponentInfo currentComponentInfo : connection.getComponentsInfo()) {
                toQueryForOwner.add(currentComponentInfo.getComponent());
            }
            HashMap<UUID, IAuditableHandle> byOwner = new HashMap<UUID, IAuditableHandle>();
            if (includeComponentOwner) {
                List owners = toQueryForOwner.isEmpty() ? Collections.EMPTY_LIST : SCMPlatform.getWorkspaceManager((ITeamRepository)connection.teamRepository()).findOwnersForComponents(toQueryForOwner, (IProgressMonitor)monitor.newChild(20));
                int i = 0;
                while (i < owners.size()) {
                    IAuditableHandle owner = (IAuditableHandle)owners.get(i);
                    IComponentHandle comp = (IComponentHandle)toQueryForOwner.get(i);
                    byOwner.put(comp.getItemId(), owner);
                    ++i;
                }
            }
            HashMap<UUID, IReadScope> vizByOwner = new HashMap<UUID, IReadScope>();
            if (includeComponentReadScope) {
                List visibilities = toQueryForOwner.isEmpty() ? Collections.EMPTY_LIST : SCMPlatform.getWorkspaceManager((ITeamRepository)connection.teamRepository()).findReadScopeForComponents(toQueryForOwner, (IProgressMonitor)monitor.newChild(20));
                int i = 0;
                while (i < visibilities.size()) {
                    IReadScope viz = (IReadScope)visibilities.get(i);
                    IComponentHandle comp = (IComponentHandle)toQueryForOwner.get(i);
                    vizByOwner.put(comp.getItemId(), viz);
                    ++i;
                }
            }
            for (ICurrentComponentInfo currentComponentInfo : connection.getComponentsInfo()) {
                BaselineDTO baselineDTO;
                WorkspaceComponentDTO component = FilesystemRestClientDTOcoreFactory.eINSTANCE.createWorkspaceComponentDTO();
                workspace.getComponents().add(component);
                IComponentHandle componentHandle = currentComponentInfo.getComponent();
                component.setItemId(componentHandle.getItemId().getUuidValue());
                IAuditable auditable = (IAuditable)retrieved.get(componentHandle.getItemId());
                if (auditable instanceof IComponent) {
                    IComponent fullComponent = (IComponent)auditable;
                    component.setName(fullComponent.getName());
                    component.setRootFolder(fullComponent.getRootFolder().getItemId().getUuidValue());
                    if (includeComponentOwner) {
                        IAuditableHandle owner = (IAuditableHandle)byOwner.get(fullComponent.getItemId());
                        component.setOwner(owner);
                    }
                    if (includeComponentReadScope) {
                        IReadScope scope = (IReadScope)vizByOwner.get(componentHandle.getItemId());
                        component.setReadScope(CoreUtil.translate(scope));
                    }
                }
                if ((auditable = (IAuditable)retrieved.get(currentComponentInfo.basis().getItemId())) instanceof IBaseline) {
                    IBaseline fullBaseline = (IBaseline)auditable;
                    baselineDTO = CoreUtil.translateBaseline(connection.teamRepository(), fullBaseline, contributors);
                } else {
                    baselineDTO = FilesystemRestClientDTOcoreFactory.eINSTANCE.createBaselineDTO();
                    baselineDTO.setItemId(currentComponentInfo.basis().getItemId().getUuidValue());
                }
                component.setBaseline(baselineDTO);
                List changeSetHandles = connection.activeChangeSets(componentHandle);
                for (IChangeSetHandle changeSet : changeSetHandles) {
                    component.getActiveChangeSetIds().add(changeSet.getItemId().getUuidValue());
                }
            }
        }
        if (includeFlowTargets) {
            IFlowNodeHandle flowNode;
            List flowEntries = workspace.getFlowEntries();
            IFlowTable flowTable = connection.getFlowTable();
            ConnectionDescriptor defaultCollaboration = FlowUtils.getDefaultFlowTargetDescriptor((IWorkspaceConnection)connection);
            ConnectionDescriptor currentCollaboration = FlowTableUtil.getCurrentCollaborationDescriptor(connection);
            HashSet<UUID> targetsReported = new HashSet<UUID>();
            for (IFlowEntry entry : flowTable.acceptSources()) {
                flowNode = entry.getFlowNode();
                if (!(flowNode instanceof IWorkspaceHandle) || !targetsReported.add(flowNode.getItemId())) continue;
                flowEntries.add(CoreUtil.translateFlowEntry(entry, (IWorkspaceHandle)(defaultCollaboration == null ? null : defaultCollaboration.connectionHandle), (IWorkspaceHandle)(currentCollaboration == null ? null : currentCollaboration.connectionHandle), connection.teamRepository()));
            }
            for (IFlowEntry entry : flowTable.deliverTargets()) {
                flowNode = entry.getFlowNode();
                if (!(flowNode instanceof IWorkspaceHandle) || !targetsReported.add(flowNode.getItemId())) continue;
                flowEntries.add(CoreUtil.translateFlowEntry(entry, (IWorkspaceHandle)(defaultCollaboration == null ? null : defaultCollaboration.connectionHandle), (IWorkspaceHandle)(currentCollaboration == null ? null : currentCollaboration.connectionHandle), connection.teamRepository()));
            }
        }
        return workspace;
    }

    public static WorkspaceDetailsDTO translateWorkspace(ITeamRepository repo, IWorkspace workspace, SubMonitor newChild) {
        WorkspaceDetailsDTO workspaceDetails = FilesystemRestClientDTOcoreFactory.eINSTANCE.createWorkspaceDetailsDTO();
        workspaceDetails.setRepositoryId(CoreUtil.translateRepositoryId(repo));
        workspaceDetails.setRepositoryURL(repo.getRepositoryURI());
        workspaceDetails.setItemId(workspace.getItemId().getUuidValue());
        workspaceDetails.setOwner(workspace.getOwner());
        workspaceDetails.setName(workspace.getName());
        workspaceDetails.setDescription(workspace.getDescription());
        workspaceDetails.setStream(workspace.isStream());
        workspaceDetails.setReadScope(CoreUtil.translate(workspace.getReadScope()));
        return workspaceDetails;
    }

    private static ReadScopeDTO translate(IReadScope scope) {
        ReadScopeDTO dto = FilesystemRestClientDTOcoreFactory.eINSTANCE.createReadScopeDTO();
        if (scope instanceof IContributorDeferringScope) {
            dto.setReadScope("contributor_deferring_scope");
            dto.setDefersTo(((IContributorDeferringScope)scope).getScope());
        } else if (scope instanceof IPrivateScope) {
            dto.setReadScope("private_scope");
        } else if (scope instanceof IProcessAreaScope) {
            dto.setReadScope("process_area_scope");
        } else if (scope instanceof IPublicScope) {
            dto.setReadScope("public_scope");
        } else if (scope instanceof ITeamAreaPrivateScope) {
            dto.setReadScope("team_area_private_scope");
        } else if (scope instanceof IAccessGroupScope) {
            dto.setReadScope("access_group_scope");
            dto.setDefersTo(((IAccessGroupScope)scope).getAccessGroup());
        } else if (scope instanceof IUnknownScope) {
            dto.setReadScope("unknown_scope");
        } else {
            dto.setReadScope("unknown_scope");
        }
        return dto;
    }

    private static WorkspaceFlowEntryDTO translateFlowEntry(IFlowEntry entry, IWorkspaceHandle defaultCollaborationHandle, IWorkspaceHandle currentCollaborationHandle, ITeamRepository repo) {
        WorkspaceFlowEntryDTO flowEntry = FilesystemRestClientDTOcoreFactory.eINSTANCE.createWorkspaceFlowEntryDTO();
        if (entry.getRemoteRepositoryURI() == null) {
            flowEntry.setRepositoryURL(repo.getRepositoryURI());
            flowEntry.setRepositoryId(CoreUtil.translateRepositoryId(repo));
        } else {
            flowEntry.setRepositoryURL(entry.getRemoteRepositoryURI());
            flowEntry.setRepositoryId(entry.getRemoteRepositoryIdentifier().getUuidValue());
        }
        flowEntry.setWorkspaceItemId(entry.getFlowNode().getItemId().getUuidValue());
        boolean isCurrentFlow = false;
        if (currentCollaborationHandle != null) {
            isCurrentFlow = currentCollaborationHandle.sameItemId((IItemHandle)entry.getFlowNode());
        }
        flowEntry.setCurrentFlow(isCurrentFlow);
        boolean isDefaultFlow = false;
        if (defaultCollaborationHandle != null) {
            isDefaultFlow = defaultCollaborationHandle.sameItemId((IItemHandle)entry.getFlowNode());
        }
        flowEntry.setDefaultFlow(isDefaultFlow);
        List componentScopes = entry.getComponentScopes();
        for (IComponentHandle componentHandle : componentScopes) {
            flowEntry.getScopedComponentItemIds().add(componentHandle.getItemId().getUuidValue());
        }
        return flowEntry;
    }

    public static ShareableDTO translateShareable(IShareable shareable) {
        ShareableDTO shareableDTO = FilesystemRestClientDTOcoreFactory.eINSTANCE.createShareableDTO();
        if (shareable != null) {
            shareableDTO.setSandboxPath(shareable.getSandbox().getRoot().toOSString());
            shareableDTO.setRelativePath(CoreUtil.translatePath(shareable.getLocalPath()));
        }
        return shareableDTO;
    }

    public static SandboxDTO translateSandbox(ISandbox sandbox, boolean computeFully, IProgressMonitor progress) throws FileSystemException {
        SandboxDTO dto = FilesystemRestClientDTOcoreFactory.eINSTANCE.createSandboxDTO();
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress, (int)4);
        dto.setSandboxPath(sandbox.getRoot().toOSString());
        dto.setCaseSensitive(Boolean.valueOf(sandbox.isCaseSensitive()));
        dto.setCorrupted(Boolean.valueOf(sandbox.isCorrupted((IProgressMonitor)monitor.newChild(1))));
        dto.setSandboxListening(Boolean.valueOf(SharingManager.getInstance().hasSandboxListener(sandbox)));
        if (computeFully) {
            List shares = dto.getAllShares();
            IShare[] iShareArray = sandbox.allShares((IProgressMonitor)monitor.newChild(1));
            int n = iShareArray.length;
            int n2 = 0;
            while (n2 < n) {
                IShare share = iShareArray[n2];
                shares.add(CoreUtil.translateShare(share, (IProgressMonitor)monitor.newChild(1)));
                ++n2;
            }
        }
        return dto;
    }

    public static StatusDTO translateStatus(IStatus status) {
        if (status == null) {
            return null;
        }
        StatusDTO statusDTO = FilesystemRestClientDTOcoreFactory.eINSTANCE.createStatusDTO();
        statusDTO.setPluginId(status.getPlugin());
        statusDTO.setSeverity(status.getSeverity());
        statusDTO.setCode(status.getCode());
        statusDTO.setMessage(status.getMessage());
        statusDTO.setException(CoreUtil.convertException(1, status.getException()));
        IStatus[] iStatusArray = status.getChildren();
        int n = iStatusArray.length;
        int n2 = 0;
        while (n2 < n) {
            IStatus child = iStatusArray[n2];
            statusDTO.getChildren().add(CoreUtil.translateStatus(child));
            ++n2;
        }
        return statusDTO;
    }

    private static ExceptionDTO convertException(int paranoia, Throwable exception) {
        StackTraceElement[] stackTrace;
        if (exception == null) {
            return null;
        }
        ExceptionDTO exceptionDTO = FilesystemRestClientDTOcoreFactory.eINSTANCE.createExceptionDTO();
        exceptionDTO.setMessage(exception.getMessage());
        StackTraceElement[] stackTraceElementArray = stackTrace = exception.getStackTrace();
        int n = stackTrace.length;
        int n2 = 0;
        while (n2 < n) {
            StackTraceElement trace = stackTraceElementArray[n2];
            StackTraceElementDTO stackTraceElementDTO = FilesystemRestClientDTOcoreFactory.eINSTANCE.createStackTraceElementDTO();
            stackTraceElementDTO.setFileName(trace.getFileName());
            stackTraceElementDTO.setLineNumber(trace.getLineNumber());
            stackTraceElementDTO.setClassName(trace.getClassName());
            stackTraceElementDTO.setMethodName(trace.getMethodName());
            exceptionDTO.getStackTrace().add(stackTraceElementDTO);
            ++n2;
        }
        if (exception.getCause() != null && paranoia < 20) {
            exceptionDTO.setCause(CoreUtil.convertException(paranoia + 1, exception.getCause()));
        }
        return exceptionDTO;
    }

    public static String getVersionableItemType(IItemType itemType) {
        if (IFileItem.ITEM_TYPE.equals(itemType)) {
            return "file";
        }
        if (IFolder.ITEM_TYPE.equals(itemType)) {
            return "folder";
        }
        if (ISymbolicLink.ITEM_TYPE.equals(itemType)) {
            return "symbolic_link";
        }
        return "";
    }

    public static String getVersionableItemType(IVersionableHandle versionableHandle) {
        if (versionableHandle instanceof IFileItemHandle) {
            return "file";
        }
        if (versionableHandle instanceof IFolderHandle) {
            return "folder";
        }
        if (versionableHandle instanceof ISymbolicLinkHandle) {
            return "symbolic_link";
        }
        return "";
    }

    public static StreamLockReportDTO getStreamLockReportDTO(IWorkspaceConnection wc, IStreamLockReport report) {
        StreamLockReportDTO result = FilesystemRestClientDTOlocksFactory.eINSTANCE.createStreamLockReportDTO();
        result.setStreamItemId(report.getStream().getItemId().getUuidValue());
        if (wc != null) {
            result.setStreamName(wc.getName());
        }
        for (IComponentLockReport clr : report.getComponentLocks()) {
            result.getComponentLockReports().add(CoreUtil.getComponentLockReportDTO(clr));
        }
        return result;
    }

    private static ComponentLockReportDTO getComponentLockReportDTO(IComponentLockReport report) {
        ComponentLockReportDTO result = FilesystemRestClientDTOlocksFactory.eINSTANCE.createComponentLockReportDTO();
        result.setComponentItemId(report.getComponent().getItemId().getUuidValue());
        for (IVersionableLock lock : report.getLocks()) {
            result.getVersionableLocks().add(CoreUtil.getVersionableLockDTO(lock));
        }
        return result;
    }

    private static VersionableLockDTO getVersionableLockDTO(IVersionableLock lock) {
        VersionableLockDTO result = FilesystemRestClientDTOlocksFactory.eINSTANCE.createVersionableLockDTO();
        result.setContributorItemId(lock.getContributor().getItemId().getUuidValue());
        result.setVersionableItemId(lock.getVersionable().getItemId().getUuidValue());
        return result;
    }

    public static DeliveryRequiresHistoryReorderingDTO getDeliveryRequiresHistoryReorderingDTO(IWorkspaceConnection source, IWorkspaceConnection target, IComponent component) {
        DeliveryRequiresHistoryReorderingDTO result = FilesystemRestClientDTOchangesetFactory.eINSTANCE.createDeliveryRequiresHistoryReorderingDTO();
        result.setComponentItemId(component.getItemId().getUuidValue());
        result.setWorkspaceItemId(source.getResolvedWorkspace().getItemId().getUuidValue());
        result.setTargetWorkspaceItemId(target.getResolvedWorkspace().getItemId().getUuidValue());
        return result;
    }

    public static String getLineDelimiter(FileLineDelimiter lineDelimiterSetting) {
        if (lineDelimiterSetting == null) {
            return "";
        }
        switch (lineDelimiterSetting) {
            case LINE_DELIMITER_PLATFORM: {
                return "platform";
            }
            case LINE_DELIMITER_CRLF: {
                return "crlf";
            }
            case LINE_DELIMITER_LF: {
                return "lf";
            }
            case LINE_DELIMITER_CR: {
                return "cr";
            }
            case LINE_DELIMITER_NONE: {
                return "none";
            }
        }
        return "";
    }

    public static FileLineDelimiter getLineDelimiter(String lineDelimiterSetting) {
        if ("lf".equals(lineDelimiterSetting)) {
            return FileLineDelimiter.LINE_DELIMITER_LF;
        }
        if ("cr".equals(lineDelimiterSetting)) {
            return FileLineDelimiter.LINE_DELIMITER_CR;
        }
        if ("crlf".equals(lineDelimiterSetting)) {
            return FileLineDelimiter.LINE_DELIMITER_CRLF;
        }
        if ("platform".equals(lineDelimiterSetting)) {
            return FileLineDelimiter.LINE_DELIMITER_PLATFORM;
        }
        if ("none".equals(lineDelimiterSetting)) {
            return FileLineDelimiter.LINE_DELIMITER_NONE;
        }
        throw new IllegalArgumentException(NLS.bind((String)"{0} has value {1} which is not one of {2}, {3}, {4}, {5}, {6}", (Object[])new Object[]{"lineDelimiter", lineDelimiterSetting, "lf", "cr", "crlf", "platform", "none"}));
    }

    public static int getDilemmaInstruction(String instruction, int defaultInstruction) {
        if (instruction == null) {
            return defaultInstruction;
        }
        if ("cancel".equals(instruction)) {
            return 1;
        }
        if ("continue".equals(instruction)) {
            return 0;
        }
        if ("no".equals(instruction)) {
            return 3;
        }
        if ("load".equals(instruction)) {
            return 100;
        }
        return 2;
    }

    public static String translateRepositoryId(ITeamRepository repository) {
        UUID id = RepositoryUtils.getRepositoryId(repository);
        return id == null ? null : id.getUuidValue();
    }
}

