/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal.snapshot;

import com.ibm.team.filesystem.client.internal.namespace.ItemLocator;
import com.ibm.team.filesystem.client.internal.snapshot.BaselineSnapshot;
import com.ibm.team.filesystem.client.internal.snapshot.ISnapshot;
import com.ibm.team.filesystem.client.internal.snapshot.SnapshotId;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IAuditableHandle;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.scm.client.IConnection;
import com.ibm.team.scm.client.IWorkspaceManager;
import com.ibm.team.scm.client.SCMPlatform;
import com.ibm.team.scm.common.IBaseline;
import com.ibm.team.scm.common.IBaselineHandle;
import org.eclipse.core.runtime.IProgressMonitor;

public class BaselineId
extends SnapshotId {
    private ItemLocator<IBaseline> id;

    private BaselineId(ItemLocator<IBaseline> id) {
        this.id = id;
    }

    public static BaselineId create(ItemLocator<IBaseline> baseline) {
        return new BaselineId(baseline);
    }

    public static BaselineId create(ITeamRepository repository, IBaselineHandle baseline) {
        ItemLocator<IBaseline> locator = ItemLocator.create(repository, (IAuditableHandle)baseline);
        return BaselineId.create(locator);
    }

    public ItemLocator<IBaseline> getId() {
        return this.id;
    }

    @Override
    public IItemHandle getIdentifyingHandle() {
        return this.id.toHandle();
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BaselineId other = (BaselineId)obj;
        return !(this.id == null ? other.id != null : !this.id.equals(other.id));
    }

    @Override
    public ITeamRepository getRepository() {
        return this.id.getRepository();
    }

    @Override
    public IConnection getConnection(IProgressMonitor monitor) throws TeamRepositoryException {
        IWorkspaceManager mgr = SCMPlatform.getWorkspaceManager((ITeamRepository)this.id.getRepository());
        return mgr.getBaselineConnection((IBaselineHandle)this.id.toHandle(), monitor);
    }

    @Override
    public ISnapshot createSnapshot(IProgressMonitor progress) throws TeamRepositoryException {
        return BaselineSnapshot.create(this.id, progress);
    }
}

