/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.foundation.common.internal.text;

import com.ibm.team.foundation.common.internal.text.SingleCharReader;
import java.io.IOException;
import java.io.Reader;

abstract class SubstitutionTextReader
extends SingleCharReader {
    protected static final String LINE_DELIM = System.getProperty("line.separator", "\n");
    private Reader fReader;
    private boolean fReadFromBuffer;
    private StringBuilder fBuffer;
    private int fIndex;

    protected SubstitutionTextReader(Reader reader) {
        this.fReader = reader;
        this.fBuffer = new StringBuilder();
        this.fIndex = 0;
        this.fReadFromBuffer = false;
    }

    protected abstract String computeSubstitution(int var1) throws IOException;

    protected Reader getReader() {
        return this.fReader;
    }

    protected int nextChar() throws IOException {
        boolean bl = this.fReadFromBuffer = this.fBuffer.length() > 0;
        if (this.fReadFromBuffer) {
            char ch = this.fBuffer.charAt(this.fIndex++);
            if (this.fIndex >= this.fBuffer.length()) {
                this.fBuffer.setLength(0);
                this.fIndex = 0;
            }
            return ch;
        }
        return this.fReader.read();
    }

    @Override
    public int read() throws IOException {
        int c = this.nextChar();
        while (!this.fReadFromBuffer) {
            String s = this.computeSubstitution(c);
            if (s == null) break;
            if (s.length() > 0) {
                this.fBuffer.insert(0, s);
            }
            c = this.nextChar();
        }
        return c;
    }

    @Override
    public boolean ready() throws IOException {
        return this.fReader.ready();
    }

    @Override
    public void close() throws IOException {
        this.fReader.close();
    }

    @Override
    public void reset() throws IOException {
        this.fReader.reset();
        this.fBuffer.setLength(0);
        this.fIndex = 0;
    }
}

