/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.foundation.common.util;

import java.text.CollationElementIterator;
import java.text.Collator;
import java.text.RuleBasedCollator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class WildcardMatcher {
    private boolean fIgnoreCase;
    private Pattern fPattern;

    public WildcardMatcher(String pattern) {
        this(pattern, true, false);
    }

    public WildcardMatcher(String pattern, boolean ignoreCase, boolean ignoreWildcards) {
        this.fIgnoreCase = ignoreCase;
        this.fPattern = ignoreWildcards ? Pattern.compile(this.normalize(pattern)) : Pattern.compile(this.normalizePattern(pattern));
    }

    public boolean match(String toMatch) {
        String normalized = this.normalize(toMatch);
        Matcher matcher = this.fPattern.matcher(normalized);
        return matcher.matches();
    }

    private String normalizePattern(String pattern) {
        int idx = 0;
        int starOrQuestionIdx = 0;
        StringBuilder regex = new StringBuilder();
        while (idx < pattern.length()) {
            starOrQuestionIdx = this.getNextStarOrQuestionMarkIndex(pattern, idx);
            String segment = pattern.substring(idx, starOrQuestionIdx);
            segment = this.unescapeWildcards(segment);
            regex.append(this.normalize(segment));
            if (starOrQuestionIdx < pattern.length()) {
                boolean isStar;
                boolean bl = isStar = pattern.charAt(starOrQuestionIdx) == '*';
                if (isStar) {
                    regex.append(".*");
                } else {
                    regex.append(",[^,]*,");
                }
            }
            idx = starOrQuestionIdx + 1;
        }
        return regex.toString();
    }

    private String unescapeWildcards(String str) {
        StringBuilder builder = new StringBuilder();
        int i = 0;
        while (i < str.length()) {
            char c = str.charAt(i);
            if (c != '\\') {
                builder.append(c);
            } else if (i + 1 == str.length()) {
                builder.append(c);
            } else if (str.charAt(i + 1) != '?' && str.charAt(i + 1) != '*') {
                builder.append(c);
            }
            ++i;
        }
        return builder.toString();
    }

    private int getNextStarOrQuestionMarkIndex(String pattern, int currentIdx) {
        int length = pattern.length();
        while (currentIdx < length) {
            int indexOfStar = pattern.indexOf(42, currentIdx);
            int indexOfQuestionMark = pattern.indexOf(63, currentIdx);
            if (indexOfStar == -1) {
                indexOfStar = length;
            }
            if (indexOfQuestionMark == -1) {
                indexOfQuestionMark = length;
            }
            if ((currentIdx = Math.min(indexOfStar, indexOfQuestionMark)) == length) {
                return length;
            }
            if (currentIdx == 0 || currentIdx > 0 && pattern.charAt(currentIdx - 1) != '\\') {
                return currentIdx;
            }
            ++currentIdx;
        }
        return length;
    }

    private String normalize(String toNormalize) {
        int next;
        RuleBasedCollator collator = (RuleBasedCollator)Collator.getInstance();
        CollationElementIterator collationElementIterator = collator.getCollationElementIterator(toNormalize);
        StringBuilder normalized = new StringBuilder();
        while ((next = collationElementIterator.next()) != -1) {
            int order;
            int primary = CollationElementIterator.primaryOrder(next);
            if (primary == 0) continue;
            if (this.fIgnoreCase) {
                order = primary;
            } else {
                short tertiary = CollationElementIterator.tertiaryOrder(next);
                order = primary << 8 | tertiary;
            }
            normalized.append(",").append(order).append(",");
        }
        return normalized.toString();
    }
}

