/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.commons.httpcomponentsutil;

import com.urbancode.commons.httpcomponentsutil.FlexibleSSLSocketFactory;
import com.urbancode.commons.util.ssl.OpenX509TrustManager;
import com.urbancode.commons.util.ssl.SSLContextProtocolDetector;
import java.io.IOException;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpException;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.auth.AuthProtocolState;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.AuthState;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.config.SocketConfig;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.socket.ConnectionSocketFactory;
import org.apache.http.conn.socket.PlainConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.conn.ssl.X509HostnameVerifier;
import org.apache.http.impl.auth.BasicScheme;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.DefaultRedirectStrategy;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.ProxyAuthenticationStrategy;
import org.apache.http.protocol.HttpContext;

public class CloseableHttpClientBuilder {
    private boolean trustAllCerts = false;
    private int timeoutMillis = -1;
    private String username = null;
    private String password = null;
    private String proxyHost = null;
    private int proxyPort = -1;
    private String proxyUsername = null;
    private String proxyPassword = null;
    private boolean preemptiveAuthentication = false;
    private int maxConnsPerRoute = -1;
    private int maxConns = -1;
    HttpClientConnectionManager connectionManager = null;

    public void setUsername(String username) {
        this.username = username;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setTimeoutMillis(int timeoutMillis) {
        this.timeoutMillis = timeoutMillis;
    }

    public void setTrustAllCerts(boolean trustAllCerts) {
        this.trustAllCerts = trustAllCerts;
    }

    public void setProxyHost(String proxyHost) {
        this.proxyHost = proxyHost;
    }

    public void setProxyPort(int proxyPort) {
        this.proxyPort = proxyPort;
    }

    public void setProxyUsername(String proxyUsername) {
        this.proxyUsername = proxyUsername;
    }

    public void setProxyPassword(String proxyPassword) {
        this.proxyPassword = proxyPassword;
    }

    public void setConnectionManager(HttpClientConnectionManager connectionManager) {
        this.connectionManager = connectionManager;
        if (connectionManager != null) {
            this.maxConnsPerRoute = -1;
            this.maxConns = -1;
        }
    }

    public void setMaxConnsPerRoute(int maxConnsPerRoute) {
        this.connectionManager = null;
        this.maxConnsPerRoute = maxConnsPerRoute;
    }

    public void setMaxConns(int maxConns) {
        this.connectionManager = null;
        this.maxConns = maxConns;
    }

    public void setPreemptiveAuthentication(boolean preemptiveAuthentication) {
        this.preemptiveAuthentication = preemptiveAuthentication;
    }

    public HttpClientBuilder buildClientBuilder() {
        HttpClientBuilder clientBuilder = HttpClientBuilder.create();
        if (this.connectionManager == null) {
            int maxConnsPerRoute = this.maxConnsPerRoute;
            int maxConns = this.maxConns;
            if (maxConnsPerRoute < 0) {
                maxConnsPerRoute = 20;
            }
            if (maxConns < 0) {
                maxConns = 100;
            }
            if (maxConns < maxConnsPerRoute) {
                maxConns = maxConnsPerRoute;
            }
            clientBuilder.setMaxConnPerRoute(maxConnsPerRoute);
            clientBuilder.setMaxConnTotal(maxConns);
            clientBuilder.setSSLSocketFactory(this.buildSocketFactory());
        } else {
            clientBuilder.setConnectionManager(this.connectionManager);
        }
        clientBuilder.setRedirectStrategy(new DefaultRedirectStrategy());
        BasicCredentialsProvider credsProvider = new BasicCredentialsProvider();
        if (this.proxyHost != null && this.proxyHost.length() > 0) {
            HttpHost proxy = new HttpHost(this.proxyHost, this.proxyPort);
            clientBuilder.setProxy(proxy);
            if (StringUtils.isNotEmpty(this.proxyUsername)) {
                ProxyAuthenticationStrategy strat = new ProxyAuthenticationStrategy();
                clientBuilder.setProxyAuthenticationStrategy(strat);
                UsernamePasswordCredentials proxyCredentials = new UsernamePasswordCredentials(this.proxyUsername, this.proxyPassword);
                credsProvider.setCredentials(new AuthScope(this.proxyHost, this.proxyPort), proxyCredentials);
            }
        }
        if (this.username != null && this.password != null) {
            UsernamePasswordCredentials clientCredentials = new UsernamePasswordCredentials(this.username, this.password);
            credsProvider.setCredentials(AuthScope.ANY, clientCredentials);
        }
        clientBuilder.setDefaultCredentialsProvider(credsProvider);
        RequestConfig defaultRequestConfig = RequestConfig.custom().setSocketTimeout(this.timeoutMillis).setConnectTimeout(this.timeoutMillis).setConnectionRequestTimeout(this.timeoutMillis).setStaleConnectionCheckEnabled(true).build();
        clientBuilder.setDefaultRequestConfig(defaultRequestConfig);
        SocketConfig.Builder socketConfig = SocketConfig.custom().setSoReuseAddress(true).setTcpNoDelay(true);
        if (this.timeoutMillis > 0) {
            socketConfig.setSoTimeout(this.timeoutMillis);
        }
        clientBuilder.setDefaultSocketConfig(socketConfig.build());
        if (this.preemptiveAuthentication) {
            clientBuilder.addInterceptorFirst(new PreemptiveAuthInterceptor());
        }
        if (this.connectionManager != null) {
            clientBuilder.addInterceptorFirst(new ApplySSLSocketFactory(this.buildSocketFactory()));
        }
        return clientBuilder;
    }

    public CloseableHttpClient buildClient() {
        return this.buildClientBuilder().build();
    }

    private SSLConnectionSocketFactory buildSocketFactory() {
        SSLContext sslContext;
        try {
            sslContext = SSLContext.getInstance(SSLContextProtocolDetector.detectSslContextProtocol());
            if (this.trustAllCerts) {
                sslContext.init(null, new TrustManager[]{new OpenX509TrustManager()}, null);
            } else {
                sslContext.init(null, null, null);
            }
        }
        catch (KeyManagementException e) {
            throw new RuntimeException(e);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
        SSLSocketFactory factory = sslContext.getSocketFactory();
        String[] supportedProtocols = sslContext.createSSLEngine().getSupportedProtocols();
        FlexibleSSLSocketFactory flexibleSSLSocketFactory = new FlexibleSSLSocketFactory(factory, supportedProtocols);
        X509HostnameVerifier hostNameVerifier = null;
        if (this.trustAllCerts) {
            hostNameVerifier = SSLConnectionSocketFactory.ALLOW_ALL_HOSTNAME_VERIFIER;
        }
        return new SSLConnectionSocketFactory(flexibleSSLSocketFactory, hostNameVerifier);
    }

    static class PreemptiveAuthInterceptor
    implements HttpRequestInterceptor {
        public void process(HttpRequest request, HttpContext oldContext) throws HttpException, IOException {
            HttpHost targetHost;
            CredentialsProvider credsProvider;
            Credentials creds;
            HttpClientContext context = HttpClientContext.adapt(oldContext);
            AuthState authState = context.getTargetAuthState();
            if (authState.getAuthScheme() == null && (creds = (credsProvider = context.getCredentialsProvider()).getCredentials(new AuthScope((targetHost = context.getTargetHost()).getHostName(), targetHost.getPort()))) != null) {
                authState.setState(AuthProtocolState.CHALLENGED);
                authState.update(new BasicScheme(), creds);
            }
        }
    }

    static class ApplySSLSocketFactory
    implements HttpRequestInterceptor {
        SSLConnectionSocketFactory sslSocketFactory;
        Registry<ConnectionSocketFactory> registry;

        public ApplySSLSocketFactory(SSLConnectionSocketFactory sslSocketFactory) {
            this.sslSocketFactory = sslSocketFactory;
            this.registry = RegistryBuilder.create().register("http", PlainConnectionSocketFactory.getSocketFactory()).register("https", (PlainConnectionSocketFactory)((Object)sslSocketFactory)).build();
        }

        public void process(HttpRequest request, HttpContext oldContext) throws HttpException, IOException {
            HttpClientContext context = HttpClientContext.adapt(oldContext);
            if (context.getAttribute("http.socket-factory-registry") == null) {
                context.setAttribute("http.socket-factory-registry", this.registry);
            }
        }
    }
}

