/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.release.rest.models.internal;

import com.urbancode.release.rest.framework.ClientIntegrated;
import com.urbancode.release.rest.framework.JsonReadOnly;
import com.urbancode.release.rest.models.Application;
import com.urbancode.release.rest.models.Group;
import com.urbancode.release.rest.models.Role;
import com.urbancode.release.rest.models.internal.EnvironmentTag;
import com.urbancode.release.rest.models.internal.ReleaseEnvironment;
import com.urbancode.release.rest.models.internal.SuggestedTask;
import com.urbancode.release.rest.models.internal.TaskComment;

public abstract class Task<T extends Task>
extends ClientIntegrated<T> {
    public Boolean automated;
    public Boolean updateVersion;
    public Boolean active;
    public Boolean onlyChangedVersions;
    public Application application;
    public Role executorRole;
    public Group executorGroup;
    public String userId;
    public Long duration;
    public ExecutionPattern taskPattern;
    public TagMatch targetMatch;
    public TagMatch tagOption;
    public String[] environments;
    public String[] tags;
    public String[] tagIds;
    @JsonReadOnly
    public Boolean userCanExecute;
    @JsonReadOnly
    public Boolean belongsToCurrentUser;
    @JsonReadOnly
    public String userName;
    @JsonReadOnly
    public String[] completeEnvironments;
    @JsonReadOnly
    public TaskComment[] comments;
    @JsonReadOnly
    public SuggestedTask[] suggestionsReferencingThis;

    public T setAutomated(boolean automated) {
        return this.automated(automated);
    }

    public T automated(boolean automated) {
        this.automated = automated;
        return (T)this;
    }

    public Boolean getAutomated() {
        return this.automated;
    }

    public T active(boolean active) {
        this.active = active;
        return (T)this;
    }

    public Boolean isActive() {
        return this.active;
    }

    public Task setActive(boolean active) {
        return this.active(active);
    }

    public T onlyChangedVersions(boolean onlyChangedVersions) {
        this.onlyChangedVersions = onlyChangedVersions;
        return (T)this;
    }

    public T updateVersion(boolean updateVersion) {
        this.updateVersion = updateVersion;
        return (T)this;
    }

    public T application(Application application) {
        this.handleNull(application, "application");
        this.application = application;
        return (T)this;
    }

    public T setApplication(Application application) {
        return this.application(application);
    }

    public T executorRoleOrGroup(Role executorRole) {
        this.handleNull(executorRole, "executorRole");
        this.executorRole = executorRole;
        this.executorGroup = null;
        return (T)this;
    }

    public T executorRoleOrGroup(Group executorGroup) {
        this.handleNull(executorGroup, "executorGroup");
        this.executorRole = null;
        this.executorGroup = executorGroup;
        return (T)this;
    }

    public T userId(String userId) {
        this.userId = userId;
        return (T)this;
    }

    public T duration(Long duration) {
        this.duration = duration;
        return (T)this;
    }

    public T taskPattern(ExecutionPattern taskPattern) {
        this.taskPattern = taskPattern;
        return (T)this;
    }

    public T targetMatch(TagMatch targetMatch) {
        this.targetMatch = targetMatch;
        this.tagOption = targetMatch;
        return (T)this;
    }

    public T environments(ReleaseEnvironment ... environments) {
        this.handleNull(environments, "environments");
        this.environments = Task.ids(environments);
        return (T)this;
    }

    public T tags(EnvironmentTag ... tags) {
        if (this.handleNull(tags, "tags", "tagIds")) {
            this.tags = Task.ids(tags);
            this.tagIds = Task.ids(tags);
        } else {
            this.tags = null;
            this.tagIds = null;
        }
        return (T)this;
    }

    public static enum TagMatch {
        ALL_TARGETS,
        WITH_ALL_OF_TAGS,
        WITH_ANY_OF_TAGS;

    }

    public static enum ExecutionPattern {
        ALWAYS,
        ONCE_PER_ENVIRONMENT;

    }
}

