/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.air.vc;

import com.urbancode.air.vc.PersistenceData;
import com.urbancode.air.vc.Persistent;
import java.io.Serializable;

public class Handle
implements Serializable {
    private static final long serialVersionUID = -6800337243625427612L;
    private final String path;
    private final Integer version;
    private final Long commit;

    public Handle(String handleString) {
        handleString = handleString.replace("&", "/");
        int lastPeriod = handleString.lastIndexOf(".");
        int lastHash = handleString.lastIndexOf("#");
        if (lastPeriod > -1 && lastPeriod > lastHash) {
            this.path = handleString.substring(0, lastPeriod);
            String versionString = handleString.substring(lastPeriod + 1);
            this.version = Integer.valueOf(versionString);
            this.commit = null;
        } else if (lastHash > -1 && lastHash > lastPeriod) {
            this.path = handleString.substring(0, lastHash);
            String commitString = handleString.substring(lastHash + 1);
            Long incomingCommit = Long.valueOf(commitString);
            if (incomingCommit == 0L) {
                this.version = -1;
                this.commit = null;
            } else {
                this.commit = incomingCommit;
                this.version = null;
            }
        } else {
            throw new IllegalArgumentException("Unexpected handle format: " + handleString);
        }
    }

    public Handle(Persistent persistent) {
        PersistenceData persistenceData = persistent.getPersistenceData();
        this.path = persistenceData.getPath();
        this.version = persistenceData.getRelativeVersion();
        this.commit = null;
    }

    public Handle(String path, Integer version) {
        this(path + "." + version);
        if (version == null) {
            throw new IllegalArgumentException("Version cannot be null.");
        }
    }

    public Handle(String path, Long commit) {
        this(path + "#" + commit);
        if (commit == null) {
            throw new IllegalArgumentException("Commit cannot be null.");
        }
    }

    public String getPath() {
        return this.path;
    }

    public Integer getVersion() {
        return this.version;
    }

    public Long getCommit() {
        return this.commit;
    }

    public String toString() {
        String result = this.path;
        if (this.version != null) {
            result = result + "." + this.version;
        } else if (this.commit != null) {
            result = result + "#" + this.commit;
        }
        return result;
    }

    public boolean equals(Object other) {
        boolean result = false;
        if (other != null && other instanceof Handle) {
            Handle otherHandle = (Handle)other;
            result = this.path.equals(otherHandle.getPath()) && this.version == otherHandle.getVersion() && this.commit == otherHandle.getCommit();
        }
        return result;
    }

    public int hashCode() {
        int hash = 1;
        hash = hash * 31 + this.getVersion();
        if (this.commit != null) {
            hash += this.commit.hashCode();
        }
        hash = hash * 31 + this.getPath().hashCode();
        hash = hash * 31 + this.getClass().hashCode();
        return hash;
    }
}

