/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.repository.transport.client;

import com.ibm.team.repository.common.transport.AbstractTeamServer;
import com.ibm.team.repository.common.transport.ComponentConfiguration;
import com.ibm.team.repository.common.transport.ICertificateValidator;
import com.ibm.team.repository.common.transport.ITeamRestService;
import com.ibm.team.repository.common.transport.ITeamService;
import com.ibm.team.repository.common.transport.TeamServerConfiguration;
import com.ibm.team.repository.common.util.NLS;
import com.ibm.team.repository.transport.auth.Tracer;
import com.ibm.team.repository.transport.auth.TransportAuthUtil;
import com.ibm.team.repository.transport.client.IOAuthHandler;
import com.ibm.team.repository.transport.client.InterruptableSocketFactory;
import com.ibm.team.repository.transport.client.RemoteTeamRestService;
import com.ibm.team.repository.transport.client.RemoteTeamService;
import com.ibm.team.repository.transport.client.RepositoryJobSchedulingRule;
import com.ibm.team.repository.transport.client.SecureInterruptableSocketFactory;
import com.ibm.team.repository.transport.internal.nls.Messages;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.cert.X509Certificate;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.KeyManager;
import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.HostConfiguration;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpConnectionManager;
import org.apache.commons.httpclient.HttpState;
import org.apache.commons.httpclient.MultiThreadedHttpConnectionManager;
import org.apache.commons.httpclient.NTCredentials;
import org.apache.commons.httpclient.UsernamePasswordCredentials;
import org.apache.commons.httpclient.auth.AuthScope;
import org.apache.commons.httpclient.params.HttpConnectionManagerParams;
import org.apache.commons.httpclient.protocol.Protocol;
import org.apache.commons.httpclient.protocol.ProtocolSocketFactory;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;

public class RemoteTeamServer
extends AbstractTeamServer {
    private static final String NLS_REMOTE_TEAM_SERVER_CLOSING_CONNECTIONS = "_NoId.RemoteTeamServer.ClosingConnections";
    private static final String BACK_SLASH_REGEXP = "\\\\";
    private static final String OS_NAME_PROP = "os.name";
    private static final String OS_WINDOWS = "WINDOWS";
    private static final String COMPUTER_NAME_EV = "ComputerName";
    private MultiThreadedHttpConnectionManager connectionManager;
    private HttpClient httpClient;
    private String repoProtocol;
    private String repoHost;
    private int repoPort;
    private String repoPath;
    private AuthScope authScope;
    private final ICertificateValidator certificateValidator;
    private String proxyHost;
    private int proxyPort = -1;
    private String proxyUserName;
    private String proxyPassword;
    private AuthScope proxyAuthScope;
    private SecureInterruptableSocketFactory secureSocketFactory;
    private final Map<HostConfigurationLookup, HostConfiguration> hostConfigurations = new HashMap<HostConfigurationLookup, HostConfiguration>();
    private IOAuthHandler oauthHandler;
    private KeyManager[] keyManagers;
    private static final Logger HTTP_METHOD_DIRECTOR_LOGGER = Logger.getLogger("org.apache.commons.httpclient.HttpMethodDirector");
    private static final Tracer _tracer;

    static {
        HTTP_METHOD_DIRECTOR_LOGGER.setLevel(Level.WARNING);
        _tracer = new Tracer(RemoteTeamServer.class);
    }

    public RemoteTeamServer(String urString) {
        this(urString, null);
    }

    public RemoteTeamServer(String urlString, ICertificateValidator validator) {
        super(urlString);
        _tracer.enter("RemoteTeamServer - url = %s", new Object[]{urlString});
        try {
            this.setRepositoryURL(urlString);
            this.certificateValidator = validator;
        }
        finally {
            _tracer.leave("RemoteTeamServer", new Object[0]);
        }
    }

    public void setRepositoryURL(String urlString) {
        _tracer.enter("setRepositoryURL", new Object[0]);
        try {
            super.setRepositoryURL(urlString);
            URL url = null;
            try {
                url = new URL(urlString);
            }
            catch (MalformedURLException e) {
                _tracer.trace("RemoteTeamServer - throwing IAE: %s", new Object[]{e.getMessage()});
                throw new IllegalArgumentException(e);
            }
            this.repoProtocol = url.getProtocol();
            this.repoHost = url.getHost();
            this.repoPort = url.getPort();
            this.repoPath = url.getPath();
            if (-1 == this.repoPort) {
                this.repoPort = url.getDefaultPort();
            }
            _tracer.debug("repoProtocol: %s", new Object[]{this.repoProtocol});
            _tracer.debug("repoHost: %s", new Object[]{this.repoHost});
            _tracer.debug("repoPort: %d", new Object[]{this.repoPort});
            _tracer.debug("repoPath: %s", new Object[]{this.repoPath});
            if (this.repoProtocol == null) {
                throw new IllegalArgumentException();
            }
            if (this.repoHost == null) {
                throw new IllegalArgumentException();
            }
            if (-1 == this.repoPort) {
                throw new IllegalStateException("No port available or specified in repository URL");
            }
            this.authScope = new AuthScope(this.repoHost, this.repoPort, AuthScope.ANY_REALM);
            _tracer.debug("Credentials scope: %s", new Object[]{this.authScope});
        }
        finally {
            _tracer.leave("setRepositoryURL", new Object[0]);
        }
    }

    public static void saveSessionState() {
    }

    private synchronized void ensureInitialized() {
        _tracer.enter("ensureInitialized", new Object[0]);
        try {
            if (this.httpClient == null) {
                HttpConnectionManagerParams connectionManagerParams = new HttpConnectionManagerParams();
                connectionManagerParams.setDefaultMaxConnectionsPerHost(1000);
                connectionManagerParams.setMaxTotalConnections(1000);
                connectionManagerParams.setTcpNoDelay(true);
                connectionManagerParams.setLinger(-1);
                connectionManagerParams.setStaleCheckingEnabled(true);
                this.connectionManager = new MultiThreadedHttpConnectionManager();
                this.connectionManager.setParams(connectionManagerParams);
                HostConfiguration hostConfiguration = this.buildHostConfiguration(this.repoProtocol, this.repoHost, this.repoPort);
                Protocol protocol = hostConfiguration.getProtocol();
                if (protocol.getSocketFactory() instanceof SecureInterruptableSocketFactory) {
                    this.secureSocketFactory = (SecureInterruptableSocketFactory)protocol.getSocketFactory();
                }
                this.httpClient = new HttpClient((HttpConnectionManager)this.connectionManager);
                this.httpClient.setHostConfiguration(hostConfiguration);
                this.httpClient.getParams().setCookiePolicy("compatibility");
                _tracer.debug("Created new HttpClient", new Object[0]);
                this.setProxy();
            }
        }
        finally {
            _tracer.leave("ensureInitialized", new Object[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    HostConfiguration buildHostConfiguration(String scheme, String hostname, int port) {
        _tracer.enter("buildHostConfiguration - scheme: %s, hostname: %s, port: %d", new Object[]{scheme, hostname, port});
        try {
            HostConfigurationLookup lookup = new HostConfigurationLookup(scheme, hostname, port);
            Map<HostConfigurationLookup, HostConfiguration> map = this.hostConfigurations;
            synchronized (map) {
                HostConfiguration hostConfiguration = this.hostConfigurations.get(lookup);
                if (hostConfiguration == null) {
                    Protocol protocol;
                    hostConfiguration = new HostConfiguration();
                    if ("https".equalsIgnoreCase(scheme)) {
                        this.secureSocketFactory = this.keyManagers == null ? new SecureInterruptableSocketFactory(this.certificateValidator) : new SecureInterruptableSocketFactory(this.keyManagers, this.certificateValidator);
                        SecureInterruptableSocketFactory socketFactory = this.secureSocketFactory;
                        protocol = new Protocol("https", (ProtocolSocketFactory)socketFactory, 443);
                        _tracer.debug("Created HTTPS Protocol object", new Object[0]);
                    } else {
                        protocol = new Protocol("http", (ProtocolSocketFactory)new InterruptableSocketFactory(), 80);
                        _tracer.debug("Created HTTP Protocol object", new Object[0]);
                    }
                    hostConfiguration.setHost(hostname, port, protocol);
                    this.updateHostConfigProxy(hostConfiguration);
                    this.hostConfigurations.put(lookup, hostConfiguration);
                }
                HostConfiguration hostConfiguration2 = hostConfiguration;
                return hostConfiguration2;
            }
        }
        finally {
            _tracer.leave("buildHostConfiguration", new Object[0]);
        }
    }

    public synchronized void loadPrefs() {
    }

    public void setCredentials(String userid, String password) {
        super.setCredentials(userid, password);
        _tracer.enter("setCredentials", new Object[0]);
        try {
            if (this.keyManagers != null) {
                this.keyManagers = null;
                this.closeConnections();
            }
            this.ensureInitialized();
            TransportAuthUtil.setCredentials((HttpClient)this.httpClient, (AuthScope)this.authScope, (String)userid, (String)password);
        }
        finally {
            _tracer.leave("setCredentials", new Object[0]);
        }
    }

    public void setCredentials(KeyManager[] keyManagers) {
        _tracer.enter("setCredentials(keyManagers)", new Object[0]);
        try {
            this.closeConnections();
            this.keyManagers = keyManagers;
            this.ensureInitialized();
        }
        finally {
            _tracer.leave("setCredentials(keyManagers)", new Object[0]);
        }
    }

    @Deprecated
    public String[] getHttpCredentials() {
        _tracer.enter("getHttpCredentials", new Object[0]);
        try {
            String[] result = new String[2];
            this.ensureInitialized();
            UsernamePasswordCredentials storedCredentials = (UsernamePasswordCredentials)this.httpClient.getState().getCredentials(this.getAuthScope());
            if (storedCredentials == null) {
                String[] stringArray = result;
                return stringArray;
            }
            result[0] = storedCredentials.getUserName();
            result[1] = storedCredentials.getPassword();
            if (result[0] == null) {
                result[0] = "";
            }
            if (result[1] == null) {
                result[1] = "";
            }
            String[] stringArray = result;
            return stringArray;
        }
        finally {
            _tracer.leave("getHttpCredentials", new Object[0]);
        }
    }

    private static Credentials buildProxyCredentials(String userName, String password) {
        _tracer.enter("buildProxyCredentials", new Object[0]);
        try {
            UsernamePasswordCredentials credentials = null;
            if (System.getProperty(OS_NAME_PROP).toUpperCase().startsWith(OS_WINDOWS)) {
                String hostName;
                String domainName = "";
                String[] s = userName.split(BACK_SLASH_REGEXP);
                if (s.length == 2) {
                    domainName = s[0];
                    userName = s[1];
                }
                if ((hostName = System.getenv(COMPUTER_NAME_EV)) == null) {
                    hostName = "";
                }
                credentials = new NTCredentials(userName, password, hostName, domainName);
                _tracer.debug("Using NTCredentials", new Object[0]);
            } else {
                credentials = new UsernamePasswordCredentials(userName, password);
                _tracer.debug("Using UsernamePasswordCredentials", new Object[0]);
            }
            UsernamePasswordCredentials usernamePasswordCredentials = credentials;
            return usernamePasswordCredentials;
        }
        finally {
            _tracer.leave("buildProxyCredentials", new Object[0]);
        }
    }

    void updateHostConfigProxy(HostConfiguration hostConfig) {
        _tracer.enter("updateHostConfigProxy", new Object[0]);
        try {
            if (hostConfig == null) {
                _tracer.trace("updateHostConfigProxy - config == null", new Object[0]);
                return;
            }
            if (this.proxyHost == null) {
                _tracer.debug("Clearing proxy info", new Object[0]);
                hostConfig.setProxyHost(null);
            } else {
                _tracer.debug("Setting proxy info", new Object[0]);
                hostConfig.setProxy(this.proxyHost, this.proxyPort);
            }
        }
        finally {
            _tracer.leave("updateHostConfigProxy", new Object[0]);
        }
    }

    void updateProxyCredentials(HttpState state) {
        _tracer.enter("updateProxyCredentials", new Object[0]);
        try {
            if (state == null) {
                _tracer.trace("updateProxyCredentials - state == null", new Object[0]);
                return;
            }
            if (this.proxyHost == null || this.proxyPort < 1 || this.proxyUserName == null) {
                state.clearProxyCredentials();
                _tracer.debug("Cleared proxy credentials on httpclient connection", new Object[0]);
            } else {
                Credentials credentials = RemoteTeamServer.buildProxyCredentials(this.proxyUserName, this.proxyPassword);
                state.setProxyCredentials(this.proxyAuthScope, credentials);
                _tracer.debug("Set proxy credentials on httpclient connection", new Object[0]);
            }
        }
        finally {
            _tracer.leave("updateProxyCredentials", new Object[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setProxy() {
        _tracer.enter("setProxy", new Object[0]);
        try {
            Map<HostConfigurationLookup, HostConfiguration> map = this.hostConfigurations;
            synchronized (map) {
                for (Map.Entry<HostConfigurationLookup, HostConfiguration> entrySet : this.hostConfigurations.entrySet()) {
                    HostConfiguration hostConfig = entrySet.getValue();
                    this.updateHostConfigProxy(hostConfig);
                }
            }
            if (this.httpClient != null) {
                this.updateProxyCredentials(this.httpClient.getState());
            }
        }
        finally {
            _tracer.leave("setProxy", new Object[0]);
        }
    }

    public void setProxy(String host, int port, String userName, String password) {
        _tracer.enter("setProxy() - host: %s - port: %d - userName: %s - password: %s", new Object[]{host, port, userName, password});
        try {
            this.proxyHost = host;
            this.proxyPort = port;
            this.proxyUserName = userName;
            this.proxyPassword = password;
            this.proxyAuthScope = host == null || port < 1 || userName == null ? null : new AuthScope(host, port);
            this.setProxy();
        }
        finally {
            _tracer.leave("setProxy()", new Object[0]);
        }
    }

    public void setConfiguration(TeamServerConfiguration configuration) {
        super.setConfiguration(configuration);
        _tracer.enter("setConfiguration", new Object[0]);
        try {
            this.ensureInitialized();
            HttpConnectionManagerParams connectionManagerParams = this.connectionManager.getParams();
            connectionManagerParams.setConnectionTimeout(configuration.getSocketTimeout());
            connectionManagerParams.setSoTimeout(configuration.getSocketTimeout());
            this.connectionManager.setParams(connectionManagerParams);
        }
        finally {
            _tracer.leave("setConfiguration", new Object[0]);
        }
    }

    public ITeamService createTeamService(Class<?> serviceClass, Object implementation, String version, List<ComponentConfiguration> componentConfigurations) {
        if (serviceClass == null) {
            throw new IllegalArgumentException("serviceClass must not be null");
        }
        if (implementation != null) {
            throw new IllegalArgumentException(NLS.bind((String)"{0} implementation must be null", serviceClass, (Object[])new Object[0]));
        }
        _tracer.enter("createTeamService", new Object[0]);
        try {
            ClassLoader serviceClassLoader = serviceClass.getClassLoader();
            if (ITeamRestService.class.isAssignableFrom(serviceClass)) {
                _tracer.debug("creating RemoteTeamRestService from %s", new Object[]{serviceClass.getName()});
                RemoteTeamRestService remoteTeamRestService = new RemoteTeamRestService(this, serviceClass, serviceClassLoader, version);
                return remoteTeamRestService;
            }
            _tracer.debug("creating RemoteTeamService from %s", new Object[]{serviceClass.getName()});
            RemoteTeamService remoteTeamService = new RemoteTeamService(this, serviceClass, serviceClassLoader, version, componentConfigurations);
            return remoteTeamService;
        }
        finally {
            _tracer.leave("createTeamService", new Object[0]);
        }
    }

    protected Object buildServiceImplementation(Class<?> serviceClass) {
        return null;
    }

    public boolean isLocal() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void closeConnections(boolean savePrefs) {
        _tracer.enter("closeConnections", new Object[0]);
        try {
            if (this.connectionManager != null) {
                final MultiThreadedHttpConnectionManager tempConnectionManager = this.connectionManager;
                this.connectionManager = null;
                Job job = new Job(Messages.getClientString(NLS_REMOTE_TEAM_SERVER_CLOSING_CONNECTIONS)){

                    protected IStatus run(IProgressMonitor arg0) {
                        tempConnectionManager.closeIdleConnections(1L);
                        tempConnectionManager.deleteClosedConnections();
                        tempConnectionManager.shutdown();
                        return Status.OK_STATUS;
                    }
                };
                _tracer.debug("creating job to close HttpConnectionManager", new Object[0]);
                job.setRule(RepositoryJobSchedulingRule.getWriteAccessRule(this.getRepositoryURL()));
                job.schedule();
            }
            Map<HostConfigurationLookup, HostConfiguration> map = this.hostConfigurations;
            synchronized (map) {
                this.hostConfigurations.clear();
            }
            this.httpClient = null;
        }
        finally {
            _tracer.leave("closeConnections", new Object[0]);
        }
    }

    public synchronized void closeConnections() {
        this.closeConnections(this.loadSessionState);
    }

    public synchronized HttpClient getHttpClient() {
        this.ensureInitialized();
        return this.httpClient;
    }

    public String getRepositoryPath() {
        return this.repoPath;
    }

    public AuthScope getAuthScope() {
        return this.authScope;
    }

    public AuthScope getProxyAuthScope() {
        return this.proxyAuthScope;
    }

    public X509Certificate[] getServerCertificatePath() {
        SecureInterruptableSocketFactory factory = this.secureSocketFactory;
        if (factory == null) {
            return null;
        }
        return factory.getLastKnownServerCertificatePath();
    }

    public void setOAuthHandler(IOAuthHandler handler) {
        _tracer.enter("setOAuthHandler - handler:%s", new Object[]{handler});
        try {
            this.oauthHandler = handler;
        }
        finally {
            _tracer.leave("setOAuthHandler", new Object[0]);
        }
    }

    public IOAuthHandler getOAuthHandler() {
        return this.oauthHandler;
    }

    private static final class HostConfigurationLookup {
        private final String scheme;
        private final String hostname;
        private final int port;

        public HostConfigurationLookup(String scheme, String hostname, int port) {
            if (scheme == null || scheme.trim().length() == 0) {
                throw new IllegalArgumentException("scheme must not be null or empty");
            }
            if (hostname == null || hostname.trim().length() == 0) {
                throw new IllegalArgumentException("hostname must not be null or empty");
            }
            this.scheme = scheme.trim();
            this.hostname = hostname.trim();
            if (port == -1) {
                _tracer.debug("Normalizing port -1 for scheme %s", new Object[]{scheme});
                if (this.scheme.toLowerCase(Locale.ENGLISH).equals("http")) {
                    this.port = 80;
                } else if (this.scheme.toLowerCase(Locale.ENGLISH).equals("https")) {
                    this.port = 443;
                } else {
                    _tracer.debug("Unrecognized scheme %s - retaining port %d", new Object[]{scheme, port});
                    this.port = port;
                }
            } else {
                this.port = port;
            }
        }

        public int hashCode() {
            int result = 1;
            result = 31 * result + this.hostname.toLowerCase(Locale.ENGLISH).hashCode();
            result = 31 * result + this.port;
            result = 31 * result + this.scheme.toLowerCase(Locale.ENGLISH).hashCode();
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            HostConfigurationLookup other = (HostConfigurationLookup)obj;
            if (!this.hostname.toLowerCase(Locale.ENGLISH).equals(other.hostname.toLowerCase(Locale.ENGLISH))) {
                return false;
            }
            if (this.port != other.port) {
                return false;
            }
            return this.scheme.toLowerCase(Locale.ENGLISH).equals(other.scheme.toLowerCase(Locale.ENGLISH));
        }
    }
}

