/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.repository.client.internal;

import com.ibm.team.repository.client.ICertificateHandler;
import com.ibm.team.repository.common.util.ExtensionReader;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;

public class CertificateHandlerExtensionReader
extends ExtensionReader {
    public static CertificateHandlerExtensionReader INSTANCE = new CertificateHandlerExtensionReader();
    private static final String EXTENSIONPOINT_ID = "certificateHandler";
    protected static Log log = LogFactory.getLog(CertificateHandlerExtensionReader.class);
    private final List<Descriptor> handlers = new ArrayList<Descriptor>();

    private CertificateHandlerExtensionReader() {
        super("com.ibm.team.repository.client", EXTENSIONPOINT_ID);
        this.earlyStart();
    }

    protected boolean handleExtensionAdded(IConfigurationElement element) {
        if (element.getName().equals("handler")) {
            Descriptor descriptor = new Descriptor(element);
            this.handlers.add(descriptor);
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean handleExtensionRemoved(IConfigurationElement element) {
        String key = Descriptor.getHandlerClassName(element);
        Descriptor value = null;
        List<Descriptor> list = this.handlers;
        synchronized (list) {
            int size = this.handlers.size();
            int index = 0;
            boolean found = false;
            while (index < size) {
                Descriptor descriptor = this.handlers.get(index);
                String handlerClassName = descriptor.getHandlerClassName();
                found = handlerClassName.equals(key);
                if (found) break;
                ++index;
            }
            if (found) {
                value = this.handlers.remove(index);
            }
        }
        boolean valid = value != null;
        return valid;
    }

    public Descriptor[] getHandlers() {
        return this.handlers.toArray(new Descriptor[this.handlers.size()]);
    }

    public ICertificateHandler getHighestPriorityHandler() {
        int highestPriority = 0;
        ICertificateHandler highestHandler = null;
        Descriptor[] descriptorArray = this.getHandlers();
        int n = descriptorArray.length;
        int n2 = 0;
        while (n2 < n) {
            int priority;
            Descriptor descriptor = descriptorArray[n2];
            ICertificateHandler handler = descriptor.getHandler();
            if (handler != null && (priority = descriptor.getPriority()) != 0 && (highestPriority == 0 || highestPriority > priority)) {
                highestPriority = priority;
                highestHandler = handler;
            }
            ++n2;
        }
        return highestHandler;
    }

    public static class Descriptor {
        private IConfigurationElement element = null;
        private ICertificateHandler handler;
        private int priority = 0;
        public static final String HANDLER = "handler";
        public static final String CLASS = "class";
        public static final String PRIORITY = "priority";

        private static String getHandlerClassName(IConfigurationElement element) {
            String value = element.getAttribute(CLASS);
            return value;
        }

        public Descriptor(IConfigurationElement element) {
            this.element = element;
        }

        public IConfigurationElement getElement() {
            return this.element;
        }

        public ICertificateHandler getHandler() {
            if (this.handler == null) {
                try {
                    this.handler = (ICertificateHandler)this.element.createExecutableExtension(CLASS);
                }
                catch (CoreException e) {
                    this.handler = null;
                    log.error((Object)e.getMessage(), (Throwable)e);
                }
            }
            return this.handler;
        }

        private String getHandlerClassName() {
            IConfigurationElement el = this.getElement();
            String value = el.getAttribute(CLASS);
            return value;
        }

        public int getPriority() {
            if (this.priority == 0) {
                String number = this.element.getAttribute(PRIORITY);
                try {
                    this.priority = Integer.parseInt(number);
                    if (this.priority < 0) {
                        this.priority = 0;
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    this.priority = 0;
                }
            }
            return this.priority;
        }
    }
}

