/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.fulltext.common;

import com.ibm.team.fulltext.common.TokenizerTypes;
import com.ibm.team.fulltext.common.internal.StandardTokenTypes;
import com.ibm.team.fulltext.common.internal.analysis.ArtifactAttributeImpl;
import java.util.EnumSet;
import org.apache.lucene.analysis.Token;
import org.apache.lucene.util.AttributeImpl;
import org.eclipse.core.runtime.Assert;

public class ArtifactToken
extends Token {
    private final EnumSet<TokenizerTypes> fTokenizers;
    private final Token fCreatedFrom;

    public ArtifactToken(String text, int start, int end, String type) {
        this(text, start, end, type, ArtifactAttributeImpl.DEFAULT_TOKENIZER, null);
    }

    public ArtifactToken(String text, int start, int end, String type, Token createdFrom) {
        this(text, start, end, type, ArtifactAttributeImpl.DEFAULT_TOKENIZER, createdFrom);
    }

    public ArtifactToken(String text, int start, int end, String type, EnumSet<TokenizerTypes> tokenizers) {
        this(text, start, end, type, tokenizers, null);
    }

    public ArtifactToken(String text, int start, int end, String type, EnumSet<TokenizerTypes> tokenizers, Token createdFrom) {
        super(text, start, end, type != null ? type : StandardTokenTypes.WORD.getId());
        Assert.isNotNull((Object)text, (String)"The text of the token must not be null!");
        Assert.isNotNull(tokenizers);
        this.fTokenizers = tokenizers;
        this.fCreatedFrom = createdFrom;
    }

    public Token getCreatedFrom() {
        return this.fCreatedFrom;
    }

    public boolean applies(TokenizerTypes tokenizer) {
        return this.fTokenizers.contains((Object)tokenizer);
    }

    public ArtifactToken clone(String text, int start, int end) {
        return new ArtifactToken(text, start, end, this.type(), this.fTokenizers);
    }

    public void copyTo(AttributeImpl target) {
        super.copyTo(target);
        if (target instanceof ArtifactAttributeImpl) {
            ((ArtifactAttributeImpl)target).setTokenizers((EnumSet<TokenizerTypes>)this.fTokenizers.clone());
            Token cloneCreatedFrom = this.fCreatedFrom == null ? null : (Token)this.fCreatedFrom.clone();
            ((ArtifactAttributeImpl)target).setCreatedFrom(cloneCreatedFrom);
        }
    }
}

