/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.fulltext.common.internal.analysis;

import com.ibm.team.fulltext.common.internal.analysis.CamelCaseFilter;
import com.ibm.team.fulltext.common.internal.analysis.ChineseTokenizerWorkaroundFilter;
import com.ibm.team.fulltext.common.internal.analysis.LowerCaseFilter;
import com.ibm.team.fulltext.common.internal.analysis.NonAlphaNumSplitFilter;
import com.ibm.team.fulltext.common.internal.analysis.PorterStemFilter;
import com.ibm.team.fulltext.common.internal.analysis.SplitTokenFilter;
import com.ibm.team.fulltext.common.internal.analysis.StopFilter;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Locale;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.WhitespaceTokenizer;
import org.apache.lucene.analysis.cn.smart.SmartChineseAnalyzer;
import org.apache.lucene.analysis.ja.JapaneseAnalyzer;
import org.apache.lucene.analysis.ja.JapaneseTokenizer;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;
import org.apache.lucene.analysis.tokenattributes.TypeAttribute;
import org.apache.lucene.util.Version;

public class WordSpliter {
    public static Language languageFrom(String language) {
        if (Locale.UK.getLanguage().equals(language)) {
            return Language.ENGLISH;
        }
        if (Locale.JAPANESE.getLanguage().equals(language)) {
            return Language.JAPANESE;
        }
        if (Locale.CHINESE.getLanguage().equals(language)) {
            return Language.CHINESE;
        }
        return Language.UNKNOWN;
    }

    public static TokenStream newSimpleWordSpliter(Reader reader, Options options) {
        switch (options.language) {
            case CHINESE: {
                return WordSpliter.chineseTokenizer(reader);
            }
            case JAPANESE: {
                return WordSpliter.japaneseTokenizer(reader);
            }
        }
        return new WhitespaceTokenizer(Version.LUCENE_36, reader);
    }

    public static TokenStream newWordSpliter(TokenStream input, Options options) {
        switch (options.language) {
            case CHINESE: {
                return WordSpliter.chineseTokenizer(input);
            }
            case JAPANESE: {
                return WordSpliter.japaneseTokenizer(input);
            }
        }
        return WordSpliter.defaultTokenizer(input, options);
    }

    public static TokenStream defaultTokenizer(TokenStream input, Options options) {
        NonAlphaNumSplitFilter splitFilter = new NonAlphaNumSplitFilter(input, options.wildcardAware);
        SplitTokenFilter camelCaseFilter = options.useCamelCase ? new CamelCaseFilter((TokenStream)splitFilter, options.expandCamelCaseTokens) : splitFilter;
        LowerCaseFilter lowerCaseFilter = new LowerCaseFilter((TokenStream)camelCaseFilter);
        StopFilter stopFilter = new StopFilter((TokenStream)lowerCaseFilter);
        if (options.englishPorterStem) {
            return new PorterStemFilter((TokenStream)stopFilter);
        }
        return stopFilter;
    }

    private static TokenStream japaneseTokenizer(TokenStream input) {
        return WordSpliter.japaneseTokenizer(new TokenStreamReader(input));
    }

    private static TokenStream japaneseTokenizer(Reader reader) {
        JapaneseAnalyzer analyzer = new JapaneseAnalyzer(Version.LUCENE_36, null, JapaneseTokenizer.Mode.SEARCH, JapaneseAnalyzer.getDefaultStopSet(), Collections.EMPTY_SET);
        return analyzer.tokenStream(null, reader);
    }

    private static TokenStream chineseTokenizer(TokenStream input) {
        return WordSpliter.chineseTokenizer(new TokenStreamReader(input));
    }

    private static TokenStream chineseTokenizer(Reader reader) {
        SmartChineseAnalyzer analyzer = new SmartChineseAnalyzer(Version.LUCENE_36);
        TokenStream stream = analyzer.tokenStream(null, reader);
        return new ChineseTokenizerWorkaroundFilter(stream);
    }

    public static enum Language {
        CHINESE,
        ENGLISH,
        JAPANESE,
        UNKNOWN;

    }

    public static class Options {
        boolean wildcardAware;
        boolean useCamelCase;
        boolean expandCamelCaseTokens;
        boolean englishPorterStem;
        Language language = Language.UNKNOWN;

        public void setWildcardAware(boolean wildcardAware) {
            this.wildcardAware = wildcardAware;
        }

        public void setUseCamelCase(boolean useCamelCase) {
            this.useCamelCase = useCamelCase;
        }

        public void setExpandCamelCaseTokens(boolean expandCamelCaseTokens) {
            this.expandCamelCaseTokens = expandCamelCaseTokens;
        }

        public void setEnglishPorterStem(boolean englishPorterStem) {
            this.englishPorterStem = englishPorterStem;
        }

        public void setLanguage(Language language) {
            this.language = language;
        }

        public void setLanguage(String language) {
            this.language = WordSpliter.languageFrom(language);
        }
    }

    private static class TokenStreamReader
    extends Reader {
        TokenStream input;
        int tokenIndex = -1;
        CharTermAttribute termAtt;
        TypeAttribute typeAtt;
        ArrayList<String> types;

        public TokenStreamReader(TokenStream input) {
            this.input = input;
            this.termAtt = (CharTermAttribute)input.getAttribute(CharTermAttribute.class);
            this.typeAtt = (TypeAttribute)input.getAttribute(TypeAttribute.class);
            this.types = new ArrayList();
        }

        @Override
        public int read() throws IOException {
            return this.nextChar();
        }

        @Override
        public int read(char[] cbuf, int off, int len) throws IOException {
            int read = 0;
            int i = off;
            while (i < len) {
                int c = this.nextChar();
                if (c == -1) {
                    if (read != 0) break;
                    return -1;
                }
                cbuf[off + i] = (char)c;
                ++read;
                ++i;
            }
            return read;
        }

        private int nextChar() throws IOException {
            if (this.tokenIndex == -1) {
                if (!this.input.incrementToken()) {
                    return -1;
                }
                this.types.add(this.typeAtt.type());
            } else if (this.tokenIndex == this.termAtt.length() - 1) {
                this.tokenIndex = -1;
                return 32;
            }
            return this.termAtt.charAt(++this.tokenIndex);
        }

        @Override
        public void close() throws IOException {
            this.input.close();
        }
    }
}

