/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.fulltext.jdt.internal;

import java.io.IOException;
import java.io.Reader;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.tokenattributes.PositionIncrementAttribute;
import org.apache.lucene.analysis.tokenattributes.TermAttribute;
import org.apache.lucene.analysis.tokenattributes.TypeAttribute;

public class StackTraceGroup {
    private static final int MAX_STACKTRACE_ENTRIES = 10;
    private static final int MAX_STACKTRACE_DISTANCE = 2;
    private Set<String> fRelevantStackTraces;

    public static StackTraceGroup createStackTraceGroup(Analyzer analyzer, String field, Reader contentReader) throws IOException {
        StackTraceGroup group = new StackTraceGroup();
        TokenStream stream = analyzer.tokenStream(field, contentReader);
        int position = 0;
        int lastPosition = 0;
        int counter = 0;
        PositionIncrementAttribute positionIncrementAtt = (PositionIncrementAttribute)stream.getAttribute(PositionIncrementAttribute.class);
        TypeAttribute typeAtt = (TypeAttribute)stream.getAttribute(TypeAttribute.class);
        TermAttribute termAtt = (TermAttribute)stream.getAttribute(TermAttribute.class);
        while (stream.incrementToken()) {
            position += positionIncrementAtt.getPositionIncrement();
            if (!"<com.ibm.team.fulltext.jdt.METHOD_REFERENCE>".equals(typeAtt.type()) && !"<com.ibm.team.fulltext.jdt.UNQUALIFIED_METHOD_REFERENCE>".equals(typeAtt.type())) continue;
            if (position - lastPosition > 2) {
                counter = 0;
            }
            if (counter < 10) {
                group.add(termAtt.term());
                ++counter;
            }
            lastPosition = position;
        }
        return group;
    }

    private void add(String stackTrace) {
        if (this.fRelevantStackTraces == null) {
            this.fRelevantStackTraces = new HashSet<String>();
        }
        this.fRelevantStackTraces.add(stackTrace);
    }

    public Collection<String> getRelevantStackTraceEntries() {
        return this.fRelevantStackTraces;
    }
}

