/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.repository.client.internal;

import com.ibm.team.repository.client.IContributorManager;
import com.ibm.team.repository.client.ISharedItemChangeEvent;
import com.ibm.team.repository.client.ISharedItemChangeListener;
import com.ibm.team.repository.client.internal.ContributorIdentityCache;
import com.ibm.team.repository.client.internal.ItemManager;
import com.ibm.team.repository.client.internal.TeamPlatformObject;
import com.ibm.team.repository.client.internal.TeamRepository;
import com.ibm.team.repository.client.internal.nls.Messages;
import com.ibm.team.repository.client.internal.util.ClientUtil;
import com.ibm.team.repository.client.util.IClientLibraryContext;
import com.ibm.team.repository.common.IContributor;
import com.ibm.team.repository.common.IContributorDetails;
import com.ibm.team.repository.common.IContributorDetailsHandle;
import com.ibm.team.repository.common.IContributorHandle;
import com.ibm.team.repository.common.IContributorIdentity;
import com.ibm.team.repository.common.IContributorRecord;
import com.ibm.team.repository.common.IContributorRecordHandle;
import com.ibm.team.repository.common.IContributorUserId;
import com.ibm.team.repository.common.IItem;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.ItemNotFoundException;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.common.model.Auditable;
import com.ibm.team.repository.common.model.query.BaseContributorQueryModel;
import com.ibm.team.repository.common.query.IItemQuery;
import com.ibm.team.repository.common.query.IItemQueryPage;
import com.ibm.team.repository.common.query.ast.IQueryModel;
import com.ibm.team.repository.common.service.IContributorService;
import com.ibm.team.repository.common.util.NLS;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;

public class ContributorManager
extends TeamPlatformObject
implements IContributorManager {
    private final IContributorService contributorService;
    private static final IItemQuery ALL_CONTRIBUTORS_QUERY = ContributorManager.createAllContributorsQuery();
    private static final Object[] EMPTY_QUERY_ARGUMENTS = new Object[0];
    private static final int QUERY_PAGE_SIZE = 100;
    private final ContributorIdentityCache contributorIdentityCache = new ContributorIdentityCache();

    private static IItemQuery createAllContributorsQuery() {
        BaseContributorQueryModel.ContributorQueryModel contributorQueryModel = BaseContributorQueryModel.ContributorQueryModel.ROOT;
        IItemQuery allContributorsQuery = (IItemQuery)IItemQuery.FACTORY.newInstance((IQueryModel)contributorQueryModel);
        return allContributorsQuery;
    }

    public ContributorManager(TeamRepository repository) {
        super(repository);
        this.contributorService = (IContributorService)repository.getServiceInterface(IContributorService.class);
        if (this.contributorService == null) {
            throw new IllegalArgumentException("Unable to initialize contributor service");
        }
        ((ItemManager)repository.itemManager()).addInternalItemChangeListener(new ISharedItemChangeListener(){

            @Override
            public void itemsChanged(List events) {
                for (Object o : events) {
                    ISharedItemChangeEvent evt = (ISharedItemChangeEvent)o;
                    IItem item = evt.getSharedItem();
                    if (item.getItemType() != IContributorRecord.ITEM_TYPE) continue;
                    if (evt.getAfterState() == null) {
                        ContributorManager.this.contributorIdentityCache.removeContributorRecord(item.getItemId());
                        continue;
                    }
                    ContributorManager.this.contributorIdentityCache.update((IContributorRecord)item);
                }
            }
        });
    }

    @Override
    public IContributor saveContributor(final IContributor contributorWorkingCopy, IProgressMonitor monitor) throws TeamRepositoryException {
        if (contributorWorkingCopy == null) {
            throw new IllegalArgumentException("The contributor is null");
        }
        if (!contributorWorkingCopy.isWorkingCopy()) {
            throw new IllegalArgumentException("The contributor is not a working copy");
        }
        return this.callCancelableService(new IClientLibraryContext.IServiceRunnable<IContributor>(){

            @Override
            public IContributor run(IProgressMonitor mon) throws TeamRepositoryException {
                SubMonitor progress = SubMonitor.convert((IProgressMonitor)mon, (int)100);
                try {
                    IContributor contributor = ContributorManager.this.contributorService.saveContributor(contributorWorkingCopy);
                    progress.worked(80);
                    ClientUtil.fixWorkingCopy((Auditable)contributorWorkingCopy, contributor.getStateId());
                    ClientUtil.makeImmutable(ContributorManager.this.teamRepository(), (IItemHandle)contributorWorkingCopy);
                    IContributor result = (IContributor)ContributorManager.this.teamRepository().itemManager().applyItemUpdates(Collections.singletonList(contributor)).get(0);
                    IContributorIdentity id = IContributorIdentity.FACTORY.create(result.getItemId());
                    ContributorManager.this.fetchContributorRecordByIdentityInternal(id, 1, (IProgressMonitor)progress.newChild(20));
                    IContributor iContributor = result;
                    return iContributor;
                }
                finally {
                    progress.done();
                }
            }
        }, monitor);
    }

    @Override
    public void deleteContributor(final IContributorHandle contributorHandle, IProgressMonitor monitor) throws TeamRepositoryException {
        if (contributorHandle == null) {
            throw new IllegalArgumentException("The contributor handle is null");
        }
        this.callCancelableService(new IClientLibraryContext.IServiceRunnable<Object>(){

            @Override
            public Object run(IProgressMonitor mon) throws TeamRepositoryException {
                SubMonitor progress = SubMonitor.convert((IProgressMonitor)mon, (int)100);
                try {
                    IContributorDetailsHandle detailsHandle;
                    IContributorHandle createdHandle = contributorHandle;
                    if (contributorHandle instanceof IContributor) {
                        createdHandle = (IContributorHandle)IContributor.ITEM_TYPE.createItemHandle(contributorHandle.getItemId(), contributorHandle.getStateId());
                    }
                    IContributor contributor = (IContributor)ContributorManager.this.teamRepository().itemManager().getSharedItemIfKnown((IItemHandle)createdHandle);
                    IContributorIdentity id = IContributorIdentity.FACTORY.create(createdHandle.getItemId());
                    IContributorRecord r = ContributorManager.this.fetchContributorRecordByIdentityInternal(id, 1, (IProgressMonitor)progress.newChild(10));
                    ContributorManager.this.contributorService.deleteContributor(createdHandle);
                    progress.worked(80);
                    ArrayList<Object> toDelete = new ArrayList<Object>(2);
                    toDelete.add(createdHandle);
                    if (contributor != null && contributor.isPropertySet(IContributor.DETAILS_PROPERTY) && (detailsHandle = contributor.getDetails()) != null) {
                        toDelete.add(detailsHandle);
                    }
                    ContributorManager.this.teamRepository().itemManager().applyItemDeletes(toDelete);
                    ContributorManager.this.teamRepository().itemManager().fetchCompleteItems(Collections.singletonList(r), 1, (IProgressMonitor)progress.newChild(10));
                }
                finally {
                    progress.done();
                }
                return null;
            }
        }, monitor);
    }

    @Override
    public List fetchAllContributors(IProgressMonitor monitor) throws TeamRepositoryException {
        return this.callCancelableService(new IClientLibraryContext.IServiceRunnable<List>(){

            @Override
            public List run(IProgressMonitor mon) throws TeamRepositoryException {
                try {
                    mon = ClientUtil.beginMonitor(mon, 100);
                    ArrayList contributors = new ArrayList();
                    IItemQueryPage page = ContributorManager.this.getQueryService().queryItems(ALL_CONTRIBUTORS_QUERY, EMPTY_QUERY_ARGUMENTS, 100);
                    contributors.addAll(ContributorManager.this.teamRepository().itemManager().fetchCompleteItems(page.getItemHandles(), 0, null));
                    mon.worked(10);
                    SubProgressMonitor subMonitor = new SubProgressMonitor(mon, 90);
                    int size = page.getSize();
                    subMonitor.beginTask(null, size * 100);
                    while (page.hasNext()) {
                        page = (IItemQueryPage)ContributorManager.this.getQueryService().fetchPage(page.getToken(), page.getNextStartPosition(), page.getSize());
                        subMonitor.worked(50);
                        contributors.addAll(ContributorManager.this.teamRepository().itemManager().fetchCompleteItems(page.getItemHandles(), 0, (IProgressMonitor)new SubProgressMonitor((IProgressMonitor)subMonitor, 50)));
                    }
                    List list = Collections.unmodifiableList(contributors);
                    return list;
                }
                finally {
                    mon.done();
                }
            }
        }, monitor);
    }

    @Override
    public IContributor fetchContributorByUserId(final String userId, IProgressMonitor monitor) throws TeamRepositoryException {
        if (userId == null) {
            throw new IllegalArgumentException("The userId is null");
        }
        return this.callCancelableService(new IClientLibraryContext.IServiceRunnable<IContributor>(){

            @Override
            public IContributor run(IProgressMonitor mon) throws TeamRepositoryException {
                mon = ClientUtil.beginMonitor(mon, 100);
                try {
                    IContributorHandle contributor = ContributorManager.this.contributorService.fetchContributorByUserId(userId);
                    mon.worked(50);
                    if (contributor == null) {
                        String message = NLS.bind((String)Messages.getServerString("ContributorManager.0"), (Object)userId, (Object[])new Object[0]);
                        throw new ItemNotFoundException(message);
                    }
                    IContributor iContributor = (IContributor)ContributorManager.this.teamRepository().itemManager().fetchCompleteItem((IItemHandle)contributor, 0, (IProgressMonitor)new SubProgressMonitor(mon, 50));
                    return iContributor;
                }
                finally {
                    mon.done();
                }
            }
        }, monitor);
    }

    @Override
    public IContributorDetails setContributorDetails(final IContributorHandle contributorHandle, final IContributorDetails detailsWorkingCopy, IProgressMonitor monitor) throws TeamRepositoryException {
        if (contributorHandle == null) {
            throw new IllegalArgumentException("The contributor handle is null");
        }
        if (detailsWorkingCopy == null) {
            throw new IllegalArgumentException("The contributor details are null");
        }
        if (!detailsWorkingCopy.isWorkingCopy()) {
            throw new IllegalArgumentException("The contributor details are not a working copy");
        }
        return this.callCancelableService(new IClientLibraryContext.IServiceRunnable<IContributorDetails>(){

            @Override
            public IContributorDetails run(IProgressMonitor mon) throws TeamRepositoryException {
                SubMonitor progress = SubMonitor.convert((IProgressMonitor)mon, (int)100);
                try {
                    IContributorDetails details = ContributorManager.this.contributorService.setContributorDetails(contributorHandle, detailsWorkingCopy);
                    progress.worked(50);
                    ClientUtil.fixWorkingCopy((Auditable)detailsWorkingCopy, details.getStateId());
                    ClientUtil.makeImmutable(ContributorManager.this.teamRepository(), (IItemHandle)detailsWorkingCopy);
                    details = (IContributorDetails)ContributorManager.this.teamRepository().itemManager().applyItemUpdates(Collections.singletonList(details)).get(0);
                    IContributor contributor = (IContributor)ContributorManager.this.teamRepository().itemManager().getSharedItemIfKnown((IItemHandle)contributorHandle);
                    if (contributor != null && contributor.isPropertySet(IContributor.DETAILS_PROPERTY)) {
                        ContributorManager.this.teamRepository().itemManager().refreshSharedItems(Collections.singletonList(contributor), (IProgressMonitor)progress.newChild(25));
                    }
                    progress.setWorkRemaining(25);
                    IContributorIdentity id = IContributorIdentity.FACTORY.create(contributorHandle.getItemId());
                    ContributorManager.this.fetchContributorRecordByIdentityInternal(id, 1, (IProgressMonitor)progress.newChild(25));
                    IContributorDetails iContributorDetails = details;
                    return iContributorDetails;
                }
                finally {
                    progress.done();
                }
            }
        }, monitor);
    }

    private IContributorRecord fetchContributorRecordByIdentityInternal(IContributorIdentity identity, int flags, IProgressMonitor monitor) throws TeamRepositoryException {
        IContributorRecord r;
        boolean useCache;
        boolean bl = useCache = (flags & 3) == 0;
        if (useCache && (r = this.contributorIdentityCache.get(identity.getId())) != null) {
            return r;
        }
        return this.doFetchContributorByIdentityInternal(identity, flags, monitor);
    }

    private IContributorRecord doFetchContributorByIdentityInternal(IContributorIdentity identity, int flags, IProgressMonitor monitor) throws TeamRepositoryException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        try {
            IContributorRecord contributor;
            IContributorRecordHandle crh = this.contributorService.fetchContributorRecordByIdentity(identity);
            progress.worked(50);
            if (crh == null) {
                return null;
            }
            IContributorRecord iContributorRecord = contributor = (IContributorRecord)this.teamRepository().itemManager().fetchCompleteItem((IItemHandle)crh, flags, (IProgressMonitor)progress.newChild(50));
            return iContributorRecord;
        }
        finally {
            progress.done();
        }
    }

    public ArrayList<IContributorRecord> fetchContributorRecordsByIdentities(Collection<IContributorIdentity> identities, final int flags, IProgressMonitor monitor) throws TeamRepositoryException {
        if (identities == null) {
            throw new IllegalArgumentException("The identities list is null");
        }
        final HashSet<UUID> toFetch = new HashSet<UUID>();
        for (IContributorIdentity id : identities) {
            if (id == null) {
                throw new IllegalArgumentException("An identity is null");
            }
            UUID ident = id.getId();
            if (ident == null) {
                throw new IllegalArgumentException("An identity is null");
            }
            toFetch.add(ident);
        }
        boolean useCache = (flags & 3) == 0;
        final HashMap<UUID, IContributorRecord> fetched = new HashMap<UUID, IContributorRecord>();
        if (useCache) {
            Iterator it = toFetch.iterator();
            while (it.hasNext()) {
                IContributorRecord r;
                UUID uUID = (UUID)it.next();
                if (fetched.containsKey(uUID) || (r = this.contributorIdentityCache.get(uUID)) == null) continue;
                fetched.put(uUID, r);
                it.remove();
            }
        }
        if (!toFetch.isEmpty()) {
            this.callCancelableService(new IClientLibraryContext.IServiceRunnable<IContributorRecord>(){

                @Override
                public IContributorRecord run(IProgressMonitor mon) throws TeamRepositoryException {
                    SubMonitor progress = SubMonitor.convert((IProgressMonitor)mon, (int)100);
                    try {
                        IContributorIdentity[] ids = new IContributorIdentity[toFetch.size()];
                        int i = 0;
                        for (UUID id : toFetch) {
                            ids[i++] = IContributorIdentity.FACTORY.create(id);
                        }
                        IContributorRecordHandle[] crh = ContributorManager.this.contributorService.fetchContributorRecordsByIdentities(ids);
                        progress.worked(50);
                        if (crh == null) {
                            return null;
                        }
                        List contributors = ContributorManager.this.teamRepository().itemManager().fetchCompleteItems(Arrays.asList(crh), flags, (IProgressMonitor)progress.newChild(50));
                        for (IContributorRecord r : contributors) {
                            for (IContributorIdentity id : r.getIdentities()) {
                                fetched.put(id.getId(), r);
                            }
                        }
                    }
                    finally {
                        progress.done();
                    }
                    return null;
                }
            }, monitor);
        }
        ArrayList<IContributorRecord> result = new ArrayList<IContributorRecord>(identities.size());
        for (IContributorIdentity iContributorIdentity : identities) {
            result.add((IContributorRecord)fetched.get(iContributorIdentity.getId()));
        }
        return result;
    }

    @Override
    public IContributorRecord fetchContributorRecordByIdentity(final IContributorIdentity identity, final int flags, IProgressMonitor monitor) throws TeamRepositoryException {
        IContributorRecord r;
        boolean useCache;
        if (identity == null) {
            throw new IllegalArgumentException("The identity is null");
        }
        if (identity.getId() == null) {
            throw new IllegalArgumentException("The identity is null");
        }
        boolean bl = useCache = (flags & 3) == 0;
        if (useCache && (r = this.contributorIdentityCache.get(identity.getId())) != null) {
            return r;
        }
        return this.callCancelableService(new IClientLibraryContext.IServiceRunnable<IContributorRecord>(){

            @Override
            public IContributorRecord run(IProgressMonitor mon) throws TeamRepositoryException {
                return ContributorManager.this.doFetchContributorByIdentityInternal(identity, flags, mon);
            }
        }, monitor);
    }

    @Override
    public IContributorRecord fetchContributorRecordByUserId(final IContributorUserId userId, IProgressMonitor monitor) throws TeamRepositoryException {
        if (userId == null) {
            throw new IllegalArgumentException("The userId is null");
        }
        if (userId.getUserId() == null) {
            throw new IllegalArgumentException("The userId is null");
        }
        return this.callCancelableService(new IClientLibraryContext.IServiceRunnable<IContributorRecord>(){

            @Override
            public IContributorRecord run(IProgressMonitor mon) throws TeamRepositoryException {
                SubMonitor progress = SubMonitor.convert((IProgressMonitor)mon, (int)100);
                try {
                    IContributorRecordHandle contributor = ContributorManager.this.contributorService.fetchContributorRecordByUserId(userId);
                    progress.worked(50);
                    if (contributor == null) {
                        String message = NLS.bind((String)Messages.getServerString("ContributorManager.0"), (Object)userId, (Object[])new Object[0]);
                        throw new ItemNotFoundException(message);
                    }
                    IContributorRecord iContributorRecord = (IContributorRecord)ContributorManager.this.teamRepository().itemManager().fetchCompleteItem((IItemHandle)contributor, 0, (IProgressMonitor)progress.newChild(50));
                    return iContributorRecord;
                }
                finally {
                    progress.done();
                }
            }
        }, monitor);
    }

    @Override
    public IContributorDetails setContributorRecordDetails(final IContributorRecordHandle contributorRecordHandle, final IContributorDetails detailsWorkingCopy, IProgressMonitor monitor) throws TeamRepositoryException {
        if (contributorRecordHandle == null) {
            throw new IllegalArgumentException("The contributor record handle is null");
        }
        if (detailsWorkingCopy == null) {
            throw new IllegalArgumentException("The contributor details are null");
        }
        if (!detailsWorkingCopy.isWorkingCopy()) {
            throw new IllegalArgumentException("The contributor details are not a working copy");
        }
        return this.callCancelableService(new IClientLibraryContext.IServiceRunnable<IContributorDetails>(){

            @Override
            public IContributorDetails run(IProgressMonitor mon) throws TeamRepositoryException {
                SubMonitor progress = SubMonitor.convert((IProgressMonitor)mon, (int)100);
                try {
                    IItemHandle h;
                    IContributorIdentity id;
                    IContributorDetails details = ContributorManager.this.contributorService.setContributorRecordDetails(contributorRecordHandle, detailsWorkingCopy);
                    progress.worked(50);
                    ClientUtil.fixWorkingCopy((Auditable)detailsWorkingCopy, details.getStateId());
                    ClientUtil.makeImmutable(ContributorManager.this.teamRepository(), (IItemHandle)detailsWorkingCopy);
                    details = (IContributorDetails)ContributorManager.this.teamRepository().itemManager().applyItemUpdates(Collections.singletonList(details)).get(0);
                    ArrayList<Object> toFetch = new ArrayList<Object>();
                    toFetch.add(contributorRecordHandle);
                    HashSet<UUID> fetched = new HashSet<UUID>();
                    IContributorRecord contributorRecord = (IContributorRecord)ContributorManager.this.teamRepository().itemManager().getSharedItemIfKnown((IItemHandle)contributorRecordHandle);
                    if (contributorRecord != null) {
                        for (Object o : contributorRecord.getIdentities()) {
                            id = (IContributorIdentity)o;
                            h = IContributor.ITEM_TYPE.createItemHandle(id.getId(), null);
                            if (ContributorManager.this.teamRepository().itemManager().getSharedItemIfKnown(h) != null) {
                                toFetch.add(h);
                            }
                            fetched.add(id.getId());
                        }
                    }
                    if ((contributorRecord = (IContributorRecord)ContributorManager.this.teamRepository().itemManager().fetchCompleteItems(toFetch, 1, (IProgressMonitor)progress.newChild(25)).get(0)) != null) {
                        toFetch.clear();
                        for (Object o : contributorRecord.getIdentities()) {
                            id = (IContributorIdentity)o;
                            if (fetched.contains(id.getId())) continue;
                            h = IContributor.ITEM_TYPE.createItemHandle(id.getId(), null);
                            if (ContributorManager.this.teamRepository().itemManager().getSharedItemIfKnown(h) == null) continue;
                            toFetch.add(h);
                        }
                        if (!toFetch.isEmpty()) {
                            ContributorManager.this.teamRepository().itemManager().fetchCompleteItems(toFetch, 1, (IProgressMonitor)progress.newChild(25));
                        }
                    }
                    IContributorDetails iContributorDetails = details;
                    return iContributorDetails;
                }
                finally {
                    progress.done();
                }
            }
        }, monitor);
    }

    @Override
    public List<IContributorRecord> updateContributorRecords(final List<IContributorRecord> contributorRecordsToSave, final List<IContributorRecordHandle> contributorRecordsToDelete, IProgressMonitor monitor) throws TeamRepositoryException {
        if (contributorRecordsToSave != null) {
            for (IContributorRecord iContributorRecord : contributorRecordsToSave) {
                if (iContributorRecord == null) {
                    throw new IllegalArgumentException("The contributor record is null");
                }
                if (iContributorRecord.isWorkingCopy()) continue;
                throw new IllegalArgumentException("The contributor record is not a working copy");
            }
        }
        if (contributorRecordsToDelete != null) {
            for (IContributorRecordHandle iContributorRecordHandle : contributorRecordsToDelete) {
                if (iContributorRecordHandle == null) {
                    throw new IllegalArgumentException("The contributor record handle is null");
                }
                if (iContributorRecordHandle.getStateId() != null) continue;
                throw new IllegalArgumentException("The contributor record handle does not have a state id");
            }
        }
        return this.callCancelableService(new IClientLibraryContext.IServiceRunnable<List<IContributorRecord>>(){

            @Override
            public List<IContributorRecord> run(IProgressMonitor mon) throws TeamRepositoryException {
                SubMonitor progress = SubMonitor.convert((IProgressMonitor)mon, (int)100);
                try {
                    ArrayList allAffected = new ArrayList();
                    HashSet<UUID> possiblyAffectedIdentities = new HashSet<UUID>();
                    if (contributorRecordsToSave != null) {
                        allAffected.addAll(contributorRecordsToSave);
                        for (IContributorRecord r : contributorRecordsToSave) {
                            for (Iterator o : r.getIdentities()) {
                                IContributorIdentity id = (IContributorIdentity)o;
                                possiblyAffectedIdentities.add(id.getId());
                            }
                        }
                    }
                    if (contributorRecordsToDelete != null) {
                        allAffected.addAll(contributorRecordsToDelete);
                    }
                    List fetched = ContributorManager.this.teamRepository().itemManager().fetchCompleteItems(allAffected, 0, (IProgressMonitor)progress.newChild(10));
                    for (IContributorRecord r : fetched) {
                        if (r == null) continue;
                        for (Object o : r.getIdentities()) {
                            IContributorIdentity id = (IContributorIdentity)o;
                            possiblyAffectedIdentities.add(id.getId());
                        }
                    }
                    IContributorRecord[] toSave = contributorRecordsToSave == null ? (IContributorRecord[])null : contributorRecordsToSave.toArray(new IContributorRecord[contributorRecordsToSave.size()]);
                    IContributorRecordHandle[] toDelete = contributorRecordsToDelete == null ? (IContributorRecordHandle[])null : contributorRecordsToDelete.toArray(new IContributorRecordHandle[contributorRecordsToDelete.size()]);
                    IContributorRecord[] updates = ContributorManager.this.contributorService.updateContributorRecords(toSave, toDelete);
                    progress.worked(80);
                    if (toSave != null) {
                        int i = 0;
                        while (i < toSave.length) {
                            ClientUtil.fixWorkingCopy((Auditable)toSave[i], updates[i].getStateId());
                            ClientUtil.makeImmutable(ContributorManager.this.teamRepository(), (IItemHandle)toSave[i]);
                            ++i;
                        }
                    }
                    List<IContributorRecord> updatesList = updates != null ? Arrays.asList(updates) : Collections.EMPTY_LIST;
                    List deletesList = contributorRecordsToDelete != null ? contributorRecordsToDelete : Collections.EMPTY_LIST;
                    ContributorManager.this.teamRepository().itemManager().applyItemUpdatesAndDeletes(updatesList, deletesList);
                    if (!possiblyAffectedIdentities.isEmpty()) {
                        ArrayList<IItemHandle> toFetch = new ArrayList<IItemHandle>(possiblyAffectedIdentities.size());
                        for (UUID id : possiblyAffectedIdentities) {
                            toFetch.add(IContributor.ITEM_TYPE.createItemHandle(id, null));
                        }
                        ContributorManager.this.teamRepository().itemManager().fetchCompleteItems(toFetch, 1, (IProgressMonitor)progress.newChild(10));
                    }
                    List<IContributorRecord> list = updatesList;
                    return list;
                }
                finally {
                    progress.done();
                }
            }
        }, monitor);
    }
}

