/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.repository.client.internal;

import com.ibm.team.repository.client.internal.ProgressHandlingContentManagerSession;
import java.io.IOException;
import java.io.InputStream;
import org.eclipse.core.runtime.OperationCanceledException;

public class ProgressTrackingInputStream
extends InputStream {
    final InputStream wrapped;
    final ProgressHandlingContentManagerSession owner;
    boolean closed = false;

    public ProgressTrackingInputStream(InputStream wrapped, ProgressHandlingContentManagerSession owner) {
        this.wrapped = wrapped;
        this.owner = owner;
    }

    @Override
    public int available() throws IOException {
        return this.wrapped.available();
    }

    @Override
    public void close() throws IOException {
        if (!this.closed) {
            this.wrapped.close();
            this.owner.logTransferCompleted();
            this.closed = true;
        }
    }

    @Override
    public void mark(int i) {
        this.handleCancelation();
        this.wrapped.mark(i);
    }

    @Override
    public boolean markSupported() {
        this.handleCancelation();
        return this.wrapped.markSupported();
    }

    @Override
    public int read() throws IOException {
        this.handleCancelation();
        int r = this.wrapped.read();
        if (r != -1) {
            this.owner.logTransferredBytes(1L);
        }
        return r;
    }

    @Override
    public int read(byte[] b) throws IOException {
        this.handleCancelation();
        int r = this.wrapped.read(b);
        if (r != -1) {
            this.owner.logTransferredBytes(r);
        }
        return r;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        this.handleCancelation();
        int r = this.wrapped.read(b, off, len);
        if (r != -1) {
            this.owner.logTransferredBytes(r);
        }
        return r;
    }

    @Override
    public void reset() throws IOException {
        this.handleCancelation();
        this.wrapped.reset();
    }

    @Override
    public long skip(long i) throws IOException {
        this.handleCancelation();
        long r = this.wrapped.skip(i);
        this.owner.logTransferredBytes(r);
        return r;
    }

    private void handleCancelation() {
        if (this.owner.isCanceled()) {
            throw new OperationCanceledException();
        }
    }
}

