/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.air.i18n;

import com.urbancode.commons.util.IO;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.ResourceBundle;
import org.apache.commons.lang.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TranslateUtil {
    private static TranslateUtil instance = null;
    private static final ThreadLocal<Locale> localeBinding = new ThreadLocal();
    private static final String IS_PSEUDO_TRANSLATION = "pseudoTranslation";
    private static final String RPX_LOCALE = "rpx_RPX";
    private static Locale DEFAULT_LOCALE = Locale.US;
    private List<Locale> supportedLocales;
    private Map<Locale, List<ResourceBundle>> bundlesByLocale;
    private String emptyValueOverride;
    private boolean checkDefaultLocale;
    private boolean isPseudoTranslation;

    public static String i18n(String key, Object ... arguments) {
        return TranslateUtil.getInstance().getValue(key, arguments);
    }

    public static String i18n(String key, List<Object> arguments) {
        return TranslateUtil.getInstance().getValue(key, arguments.toArray());
    }

    public static TranslateUtil getInstance() {
        if (instance == null) {
            instance = new TranslateUtil(new ArrayList<Locale>());
        }
        return instance;
    }

    public static void init(List<Locale> supportedLocales, boolean checkDefaultLocale, String emptyValueOverride) {
        instance = new TranslateUtil(supportedLocales, checkDefaultLocale, emptyValueOverride);
    }

    public static void init(List<Locale> supportedLocales) {
        instance = new TranslateUtil(supportedLocales);
    }

    public static void setDefaultLocale(Locale defaultLocale) {
        DEFAULT_LOCALE = defaultLocale;
    }

    public static Locale getDefaultLocale() {
        return DEFAULT_LOCALE;
    }

    public static Locale getLocaleForRequestHeader(String acceptLanguageHeader) {
        Locale result = TranslateUtil.getDefaultLocale();
        double fallbackLocalePriority = 0.0;
        if (!StringUtils.isEmpty((String)acceptLanguageHeader)) {
            block2: for (String acceptLanguage : acceptLanguageHeader.split(",")) {
                double currentLocalePriority = 1.0;
                String acceptLocaleString = acceptLanguage.trim();
                if (acceptLanguage.contains(";") && acceptLanguage.contains("=")) {
                    acceptLocaleString = acceptLanguage.split(";")[0].trim();
                    try {
                        String priorityString = acceptLanguage.split(";")[1].split("=")[1];
                        currentLocalePriority = Double.valueOf(priorityString.trim());
                    }
                    catch (NumberFormatException e) {
                        e.printStackTrace();
                    }
                }
                acceptLocaleString = acceptLocaleString.toLowerCase().replace('-', '_');
                if (!(currentLocalePriority > fallbackLocalePriority)) continue;
                for (Locale supportedLocale : TranslateUtil.getInstance().supportedLocales) {
                    String supportedLocaleString = supportedLocale.toString().toLowerCase();
                    if (!supportedLocaleString.startsWith(acceptLocaleString)) continue;
                    result = supportedLocale;
                    fallbackLocalePriority = currentLocalePriority;
                    if (!StringUtils.equalsIgnoreCase((String)supportedLocaleString, (String)acceptLocaleString)) continue;
                    continue block2;
                }
            }
        }
        return result;
    }

    public TranslateUtil(List<Locale> supportedLocales, boolean checkDefaultLocale, String emptyValueOverride) {
        this(supportedLocales);
        this.checkDefaultLocale = checkDefaultLocale;
        this.emptyValueOverride = emptyValueOverride;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private TranslateUtil(List<Locale> supportedLocales) {
        InputStream in;
        block5: {
            this.supportedLocales = new ArrayList<Locale>();
            this.bundlesByLocale = new HashMap<Locale, List<ResourceBundle>>();
            this.emptyValueOverride = null;
            this.checkDefaultLocale = false;
            this.isPseudoTranslation = false;
            this.supportedLocales.addAll(supportedLocales);
            for (Locale locale : supportedLocales) {
                this.bundlesByLocale.put(locale, new ArrayList());
            }
            in = null;
            try {
                ClassLoader cl = Thread.currentThread().getContextClassLoader();
                in = cl.getResourceAsStream("installed.properties");
                if (in == null) break block5;
                Properties props = new Properties();
                props.load(in);
                this.isPseudoTranslation = Boolean.parseBoolean((String)props.get(IS_PSEUDO_TRANSLATION));
            }
            catch (IOException iOException) {
                IO.close(in);
                catch (Throwable throwable) {
                    IO.close(in);
                    throw throwable;
                }
            }
        }
        IO.close((InputStream)in);
    }

    public void loadBundle(String bundleName) {
        for (Locale locale : this.supportedLocales) {
            ResourceBundle localeBundle = ResourceBundle.getBundle(bundleName, locale);
            this.bundlesByLocale.get(locale).add(localeBundle);
        }
    }

    public void setCurrentLocale(Locale locale) {
        if (locale == null) {
            localeBinding.remove();
        } else {
            localeBinding.set(locale);
        }
    }

    public Locale getCurrentLocale() {
        Locale result = localeBinding.get();
        if (result == null || !this.supportedLocales.contains(result)) {
            result = DEFAULT_LOCALE;
        }
        return result;
    }

    public String getEmptyValueOverride() {
        return this.emptyValueOverride;
    }

    public List<ResourceBundle> getResourceBundlesForLocale(Locale locale) {
        return this.bundlesByLocale.get(locale);
    }

    public String getValue(String key, Object ... arguments) {
        Locale locale = this.getCurrentLocale();
        String result = this.getTranslationFromLocale(key, locale);
        if (result == null) {
            result = this.getTranslationFromLocale(key.replaceAll("(\\s)+", "$1"), locale);
        }
        if (result == null && this.checkDefaultLocale) {
            result = this.getTranslationFromLocale(key, TranslateUtil.getDefaultLocale());
        }
        if (result == null) {
            result = this.emptyValueOverride != null ? this.emptyValueOverride : key;
        }
        result = this.substituteWildcards(result, arguments);
        return result;
    }

    private String getTranslationFromLocale(String key, Locale locale) {
        String result = null;
        if (this.bundlesByLocale.containsKey(locale)) {
            for (ResourceBundle bundle : this.bundlesByLocale.get(locale)) {
                String bundleResult;
                if (!bundle.containsKey(key) || StringUtils.isEmpty((String)(bundleResult = bundle.getString(key)))) continue;
                try {
                    if (this.isPseudoTranslation || locale.toString().equals(RPX_LOCALE)) {
                        result = bundleResult;
                        break;
                    }
                    result = new String(bundleResult.getBytes("ISO-8859-1"), "UTF-8");
                    break;
                }
                catch (UnsupportedEncodingException e) {
                    throw new RuntimeException("Could not convert string to UTF", e);
                }
            }
        }
        return result;
    }

    public String substituteWildcards(String result, Object ... arguments) {
        int scanIndex = 0;
        int argCount = 0;
        int tokenlength = 1;
        boolean hasToken = false;
        int argNum = argCount;
        while (scanIndex > -1) {
            if ((scanIndex = result.indexOf("%", scanIndex)) <= -1) continue;
            if (scanIndex != result.length() - 1) {
                if (result.charAt(scanIndex + 1) == 's') {
                    tokenlength = 2;
                    argNum = ++argCount;
                    hasToken = true;
                } else {
                    tokenlength = 1;
                    while (result.length() > scanIndex + tokenlength && Character.isDigit(result.charAt(scanIndex + tokenlength))) {
                        ++tokenlength;
                    }
                    if (tokenlength > 1) {
                        ++argCount;
                        argNum = Integer.parseInt(result.substring(scanIndex + 1, scanIndex + tokenlength));
                        hasToken = true;
                    }
                }
            }
            if (hasToken) {
                Object tokenValObject;
                hasToken = false;
                String tokenValue = result.substring(scanIndex, scanIndex + tokenlength);
                if (arguments.length >= argNum && (tokenValObject = arguments[argNum - 1]) != null) {
                    tokenValue = tokenValObject.toString();
                }
                String resultBeforeToken = result.substring(0, scanIndex);
                String resultAfterToken = result.substring(scanIndex + tokenlength);
                result = resultBeforeToken + tokenValue + resultAfterToken;
                scanIndex += tokenValue.length();
                continue;
            }
            ++scanIndex;
        }
        return result;
    }
}

