/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.repository.common.internal.marshal.impl;

import com.ibm.team.repository.common.BacklevelClientException;
import com.ibm.team.repository.common.BacklevelClientRuntimeException;
import com.ibm.team.repository.common.IItem;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.PermissionDeniedException;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.internal.marshal.MarshalFactory;
import com.ibm.team.repository.common.internal.marshal.Marshaller;
import com.ibm.team.repository.common.internal.marshal.MarshallerType;
import com.ibm.team.repository.common.internal.marshal.MarshallingException;
import com.ibm.team.repository.common.internal.marshal.MarshallingExceptionReasonCode;
import com.ibm.team.repository.common.internal.marshal.impl.EObjectJSONMarshaller;
import com.ibm.team.repository.common.internal.marshal.impl.EObjectMarshaller;
import com.ibm.team.repository.common.internal.marshal.util.MarshallerUtil;
import com.ibm.team.repository.common.internal.util.IComponentElementDescriptor;
import com.ibm.team.repository.common.internal.util.ItemUtil;
import com.ibm.team.repository.common.model.ItemHandle;
import com.ibm.team.repository.common.serialize.internal.nls.Messages;
import com.ibm.team.repository.common.transport.HttpUtil;
import com.ibm.team.repository.common.transport.internal.services.DataArg;
import com.ibm.team.repository.common.transport.internal.services.DataArgType;
import com.ibm.team.repository.common.transport.internal.services.NullDataArg;
import com.ibm.team.repository.common.transport.internal.services.Request;
import com.ibm.team.repository.common.transport.internal.services.Response;
import com.ibm.team.repository.common.transport.internal.services.ServicesFactory;
import com.ibm.team.repository.common.util.NLS;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Writer;
import java.lang.reflect.Array;
import java.nio.charset.Charset;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.xmlsoap.schemas.soap.envelope.Body;
import org.xmlsoap.schemas.soap.envelope.Envelope;
import org.xmlsoap.schemas.soap.envelope.EnvelopeFactory;
import org.xmlsoap.schemas.soap.envelope.Fault;

public class WebServicesMarshaller
extends EObjectMarshaller {
    private static final Class ITEM_CLASS = IItem.class;
    private static final Class ITEM_HANDLE_CLASS = IItemHandle.class;
    public static final WebServicesMarshaller INSTANCE = new WebServicesMarshaller();
    public static final String WEB_SERVICVES_MARSHALLER_REGISTRATION_NAME = "Web Services";
    public static final int MARSHAL_AS_XML = 0;
    public static final int MARSHAL_AS_JSON = 1;
    private static final String EXCEPTION_WHILE_MARSHALING_EXCEPTION_MSG = "WebServicesMarshaller.ExceptionWhileMarshalingException";
    private static final String TYPE_UNKNOWN_TO_CLIENT_MSG = "WebServicesMarshaller.TypeUnknownToClient";

    private WebServicesMarshaller() {
        this.setSupportedType(WebServicesMarshaller.class);
        this.setMarshallerType(MarshallerType.WEB_SERVICES_LITERAL);
    }

    @Override
    public String getRegistrationName() {
        return WEB_SERVICVES_MARSHALLER_REGISTRATION_NAME;
    }

    @Override
    public boolean canMarshal(Class type) {
        return type == this.supportedType;
    }

    protected void writeXMLHeader(OutputStream outputStream) {
    }

    public Request demarshalInputStreamToServiceRequest(InputStream inputStream) throws MarshallingException {
        return this.demarshalInputStreamToServiceRequest(inputStream, HttpUtil.CharsetEncoding.UTF8.toCharset());
    }

    public Request demarshalInputStreamToServiceRequest(InputStream inputStream, Charset charset) throws MarshallingException {
        if (charset == null) {
            throw new IllegalArgumentException("charset must not be null");
        }
        Envelope envelope = (Envelope)this.demarshalInputStreamToObject(inputStream, charset);
        if (envelope != null) {
            return envelope.getBody().getRequest();
        }
        return null;
    }

    public Response demarshalInputStreamToServiceResponse(InputStream inputStream) throws MarshallingException {
        return this.demarshalInputStreamToServiceResponse(inputStream, HttpUtil.CharsetEncoding.UTF8.toCharset());
    }

    public Response demarshalInputStreamToServiceResponse(InputStream inputStream, Charset charset) throws MarshallingException {
        if (charset == null) {
            throw new IllegalArgumentException("charset must not be null");
        }
        Envelope envelope = (Envelope)this.demarshalInputStreamToObject(inputStream, charset);
        if (envelope != null) {
            return envelope.getBody().getResponse();
        }
        return null;
    }

    public Envelope marshalServiceRequest(String methodName, String interfaceName, Class[] parameterTypes, Object[] parameters, int marshalType, OutputStream outputStream, Charset charset) throws MarshallingException {
        if (parameterTypes.length != parameters.length) {
            throw new IllegalArgumentException("types and objects are not the same length");
        }
        Request request = ServicesFactory.eINSTANCE.createRequest();
        if (methodName != null) {
            request.setMethod(methodName);
        }
        if (interfaceName != null) {
            request.setInterface(interfaceName);
        }
        request.setMethod(methodName);
        int i = 0;
        while (i < parameterTypes.length) {
            Object parameter = parameters[i];
            parameter = this.handleizeIfRequired(parameter, parameterTypes[i]);
            Marshaller marshaller = MarshalFactory.eINSTANCE.getMarshaller(parameterTypes[i]);
            if (marshaller == null) {
                marshaller = MarshalFactory.eINSTANCE.getMarshaller(MarshallerType.EOBJECT_LITERAL);
            }
            DataArg dataArg = marshaller.marshalObjectToDataArg(parameter);
            request.getParameters().add((Object)dataArg);
            ++i;
        }
        Envelope envelope = EnvelopeFactory.eINSTANCE.createEnvelope();
        Body body = EnvelopeFactory.eINSTANCE.createBody();
        body.setRequest(request);
        envelope.setBody(body);
        this.marshalObjectToOutputStream(envelope, outputStream, marshalType, charset);
        return envelope;
    }

    @Deprecated
    public Envelope marshalServiceRequest(String methodName, String interfaceName, Class[] parameterTypes, Object[] parameters, int marshalType, OutputStream outputStream) throws MarshallingException {
        return this.marshalServiceRequest(methodName, interfaceName, parameterTypes, parameters, marshalType, outputStream, HttpUtil.CharsetEncoding.UTF8.toCharset());
    }

    public Envelope marshalServiceResponse(String methodName, String interfaceName, Class type, Object object, int marshalType, OutputStream outputStream, Charset charset) throws MarshallingException {
        return this.marshalServiceResponse(methodName, interfaceName, type, object, marshalType, outputStream, charset, null, false);
    }

    public Envelope marshalServiceResponse(String methodName, String interfaceName, Class type, Object object, int marshalType, OutputStream outputStream, Charset charset, Map<String, String> clientConfig, boolean canThrowTRE) throws MarshallingException {
        Response response = ServicesFactory.eINSTANCE.createResponse();
        if (methodName != null) {
            response.setMethod(methodName);
        }
        if (interfaceName != null) {
            response.setInterface(interfaceName);
        }
        NullDataArg dataArg = null;
        if (object != null) {
            Marshaller marshaller = MarshalFactory.eINSTANCE.getMarshaller(type);
            if (marshaller == null) {
                marshaller = MarshalFactory.eINSTANCE.getMarshaller(MarshallerType.EOBJECT_LITERAL);
            }
            dataArg = marshaller.marshalObjectToDataArg(object);
            response.setReturnValue((DataArg)dataArg);
        } else {
            dataArg = ServicesFactory.eINSTANCE.createNullDataArg();
            dataArg.setType(DataArgType.NULL_LITERAL);
            response.setReturnValue((DataArg)dataArg);
        }
        Body body = EnvelopeFactory.eINSTANCE.createBody();
        body.setResponse(response);
        Envelope envelope = EnvelopeFactory.eINSTANCE.createEnvelope();
        envelope.setBody(body);
        try {
            this.marshalObjectToOutputStream(envelope, outputStream, marshalType, charset, clientConfig);
        }
        catch (OlderClientMarshallingException marshallingException) {
            Object ex = canThrowTRE ? new BacklevelClientException(marshallingException.getMessage(), marshallingException.getUnknownClassName(), marshallingException.getRequiredClientVersion()) : new BacklevelClientRuntimeException(marshallingException.getMessage(), marshallingException.getUnknownClassName(), marshallingException.getRequiredClientVersion());
            return this.marshalFaultServiceResponse(methodName, interfaceName, (Throwable)ex, marshalType, outputStream, charset, clientConfig);
        }
        return envelope;
    }

    @Deprecated
    public Envelope marshalServiceResponse(String methodName, String interfaceName, Class type, Object object, int marshalType, OutputStream outputStream) throws MarshallingException {
        return this.marshalServiceResponse(methodName, interfaceName, type, object, marshalType, outputStream, HttpUtil.CharsetEncoding.UTF8.toCharset());
    }

    public Envelope marshalFaultServiceResponse(String methodName, String interfaceName, Throwable exception, int marshalType, OutputStream outputStream, Charset charset) {
        return this.marshalFaultServiceResponse(methodName, interfaceName, exception, marshalType, outputStream, charset, null);
    }

    public Envelope marshalFaultServiceResponse(String methodName, String interfaceName, Throwable exception, int marshalType, OutputStream outputStream, Charset charset, Map<String, String> clientConfig) {
        Response response = ServicesFactory.eINSTANCE.createResponse();
        if (methodName != null) {
            response.setMethod(methodName);
        }
        if (interfaceName != null) {
            response.setInterface(interfaceName);
        }
        Fault fault = EnvelopeFactory.eINSTANCE.createFault();
        fault.setFaultstring(MarshallerUtil.encodeExceptions(exception));
        this.populateExtraDataInfo(fault, exception);
        Body body = EnvelopeFactory.eINSTANCE.createBody();
        body.setResponse(response);
        body.setFault(fault);
        Envelope envelope = EnvelopeFactory.eINSTANCE.createEnvelope();
        envelope.setBody(body);
        try {
            this.marshalObjectToOutputStream(envelope, outputStream, marshalType, charset, clientConfig);
        }
        catch (OlderClientMarshallingException marshallingException) {
            String unknownClassName = marshallingException.getUnknownClassName();
            if (unknownClassName.contains("BacklevelClientException") || unknownClassName.contains("BacklevelClientRuntimeException")) {
                return envelope;
            }
            String pattern = Messages.getClientString(EXCEPTION_WHILE_MARSHALING_EXCEPTION_MSG);
            String message = NLS.bind((String)pattern, (Object)exception.getMessage(), (Object[])new Object[]{marshallingException.getMessage()});
            Object ex = exception instanceof TeamRepositoryException ? new BacklevelClientException(message, unknownClassName, marshallingException.getRequiredClientVersion()) : new BacklevelClientRuntimeException(message, unknownClassName, marshallingException.getRequiredClientVersion());
            return this.marshalFaultServiceResponse(methodName, interfaceName, (Throwable)ex, marshalType, outputStream, charset, clientConfig);
        }
        catch (MarshallingException marshallingException) {}
        return envelope;
    }

    @Override
    protected void marshalSingleValuedReference(EObject object, EReference reference, Writer writer, Map nsUriToNsPrefixMap, Map<String, String> clientConfig, int depth) throws MarshallingException {
        EObject objectToMarshal = (EObject)object.eGet((EStructuralFeature)reference);
        this.checkForTypeUnknownToClient(objectToMarshal, clientConfig);
        super.marshalSingleValuedReference(object, reference, writer, nsUriToNsPrefixMap, clientConfig, depth);
    }

    @Override
    protected void marshalMultiValuedReference(EObject object, EReference reference, Writer writer, Map nsUriToNsPrefixMap, Map<String, String> clientConfig, int depth) throws MarshallingException {
        List objectsToMarshal = (List)object.eGet((EStructuralFeature)reference);
        if (objectsToMarshal != null) {
            for (EObject objectToMarshal : objectsToMarshal) {
                this.checkForTypeUnknownToClient(objectToMarshal, clientConfig);
            }
        }
        super.marshalMultiValuedReference(object, reference, writer, nsUriToNsPrefixMap, clientConfig, depth);
    }

    private void checkForTypeUnknownToClient(EObject objectToMarshal, Map<String, String> clientConfig) throws MarshallingException {
        String requiredVersion;
        if (objectToMarshal != null && (requiredVersion = this.requiredClientUpgradeVersion(objectToMarshal.eClass(), clientConfig)) != null) {
            String msgPattern = Messages.getClientString(TYPE_UNKNOWN_TO_CLIENT_MSG);
            String msg = NLS.bind((String)msgPattern, (Object)requiredVersion, (Object[])new Object[0]);
            throw new OlderClientMarshallingException(msg, objectToMarshal.eClass().getName(), requiredVersion);
        }
    }

    private String requiredClientUpgradeVersion(EClass eClass, Map<String, String> clientConfig) {
        String nsURI = eClass.getEPackage().getNsURI();
        IComponentElementDescriptor desc = this.getComponentDescriptor(nsURI);
        String clientVersion = this.getClientVersionForComponentIfDifferent(desc, clientConfig);
        if (clientVersion == null) {
            return null;
        }
        return desc.getModelElementDescriptor(nsURI).requiredClientUpgradeVersion(eClass.getInstanceClassName(), clientVersion);
    }

    private void populateExtraDataInfo(Fault fault, Throwable throwable) {
        TeamRepositoryException tre;
        Object exceptionData;
        PermissionDeniedException pde;
        Object processReportData;
        if (throwable instanceof PermissionDeniedException && (processReportData = (pde = (PermissionDeniedException)throwable).getProcessReportData()) != null && processReportData instanceof EObject) {
            fault.getExtraData().put((Object)"processReportData", (Object)((EObject)processReportData));
        }
        if (throwable instanceof TeamRepositoryException && (exceptionData = (tre = (TeamRepositoryException)throwable).getData()) != null && exceptionData instanceof EObject) {
            fault.getExtraData().put((Object)"exceptionData", (Object)((EObject)exceptionData));
        }
    }

    private void marshalObjectToOutputStream(Envelope envelope, OutputStream outputStream, int marshalType, Charset charset) throws MarshallingException {
        this.marshalObjectToOutputStream(envelope, outputStream, marshalType, charset, null);
    }

    private void marshalObjectToOutputStream(Envelope envelope, OutputStream outputStream, int marshalType, Charset charset, Map<String, String> clientConfig) throws MarshallingException {
        switch (marshalType) {
            case 0: {
                this.marshalObjectToOutputStream((Object)envelope, outputStream, charset, clientConfig);
                break;
            }
            case 1: {
                EObjectJSONMarshaller eObjectJSONMarshaller = (EObjectJSONMarshaller)MarshalFactory.eINSTANCE.getMarshaller(MarshallerType.JSON_LITERAL);
                eObjectJSONMarshaller.marshalObjectToOutputStream(envelope, outputStream, charset);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unexpected value for marshalType: " + marshalType);
            }
        }
    }

    public Object[] getRequestParameters(Request request, Class[] parameterTypes) {
        return this.getMethodParameters((List)request.getParameters(), parameterTypes);
    }

    public Object getResponseReturnValue(Response response, Class parameterType) {
        return this.getReturnValue(response.getReturnValue(), parameterType);
    }

    public Object demarshalInputStreamToReturnValue(InputStream stream, Charset charset, Class type, int marshalType) throws MarshallingException {
        switch (marshalType) {
            case 1: {
                EObjectJSONMarshaller eObjectJSONMarshaller = (EObjectJSONMarshaller)MarshalFactory.eINSTANCE.getMarshaller(MarshallerType.JSON_LITERAL);
                Object ret = eObjectJSONMarshaller.demarshalInputStreamToObject(stream, charset);
                if (!(ret instanceof Envelope)) {
                    throw new MarshallingException(MarshallingExceptionReasonCode.CANNOT_DEMARSHAL_LITERAL, "Missing envelope");
                }
                Envelope envelope = (Envelope)ret;
                Body body = envelope.getBody();
                if (body == null) {
                    throw new MarshallingException(MarshallingExceptionReasonCode.CANNOT_DEMARSHAL_LITERAL, "Missing envelope body");
                }
                Response response = body.getResponse();
                if (response == null) {
                    throw new MarshallingException(MarshallingExceptionReasonCode.CANNOT_DEMARSHAL_LITERAL, "Missing body response");
                }
                return this.getResponseReturnValue(response, type);
            }
        }
        throw new IllegalArgumentException("Only know how to handle JSON");
    }

    private Object[] getMethodParameters(List dataArgParameters, Class[] parameterTypes) {
        Object[] parameters = new Object[parameterTypes.length];
        int i = 0;
        while (i < dataArgParameters.size()) {
            DataArg dataArg = (DataArg)dataArgParameters.get(i);
            parameters[i] = this.getMethodParameter(dataArg, parameterTypes[i]);
            ++i;
        }
        return parameters;
    }

    private Object getMethodParameter(DataArg dataArg, Class parameterType) {
        if (dataArg.getType().equals(DataArgType.NULL_LITERAL)) {
            return null;
        }
        Marshaller marshaller = MarshalFactory.eINSTANCE.getMarshaller(parameterType);
        if (marshaller == null) {
            marshaller = MarshalFactory.eINSTANCE.getMarshaller(MarshallerType.EOBJECT_LITERAL);
        }
        return marshaller.demarshalDataArgToObject(dataArg, parameterType);
    }

    private Object getReturnValue(DataArg dataArg, Class parameterType) {
        if (dataArg.getType().equals(DataArgType.NULL_LITERAL)) {
            return null;
        }
        Marshaller marshaller = MarshalFactory.eINSTANCE.getMarshaller(parameterType);
        if (marshaller == null) {
            marshaller = MarshalFactory.eINSTANCE.getMarshaller(MarshallerType.EOBJECT_LITERAL);
        }
        return marshaller.demarshalDataArgToObject(dataArg, parameterType);
    }

    private Object handleizeIfRequired(Object parameter, Class parameterType) {
        if (parameter == null) {
            return null;
        }
        if (parameterType.isArray()) {
            return this.handleizeArrayIfRequired(parameter, parameterType);
        }
        if (!ITEM_HANDLE_CLASS.isAssignableFrom(parameterType)) {
            return parameter;
        }
        if (ITEM_CLASS.isAssignableFrom(parameterType)) {
            return parameter;
        }
        ItemHandle itemHandle = (ItemHandle)parameter;
        if (!itemHandle.hasFullState()) {
            return parameter;
        }
        return ItemUtil.newItemHandle((ItemHandle)itemHandle, (boolean)true);
    }

    private Object handleizeArrayIfRequired(Object parameter, Class parameterType) {
        if (!ITEM_HANDLE_CLASS.isAssignableFrom(parameterType = parameterType.getComponentType())) {
            return parameter;
        }
        if (ITEM_CLASS.isAssignableFrom(parameterType)) {
            return parameter;
        }
        int length = Array.getLength(parameter);
        if (length == 0) {
            return parameter;
        }
        Object result = Array.newInstance(parameterType, length);
        int i = 0;
        while (i < length) {
            Object object = Array.get(parameter, i);
            object = this.handleizeIfRequired(object, parameterType);
            Array.set(result, i, object);
            ++i;
        }
        return result;
    }

    private static class OlderClientMarshallingException
    extends MarshallingException {
        private static final int OLDER_CLIENT_MARSHALLING_EXCEPTION_REASON = 1001;
        private static final MarshallingExceptionReasonCode INTERNAL_REASON_CODE = new MarshallingExceptionReasonCode(1001, "Internal to WebServicesMarshaller");
        private String unknownClassName;
        private String requiredClientVersion;

        public OlderClientMarshallingException(String message, String unknownClassName, String requiredClientVersion) {
            super(INTERNAL_REASON_CODE, message);
            this.unknownClassName = unknownClassName;
            this.requiredClientVersion = requiredClientVersion;
        }

        public String getUnknownClassName() {
            return this.unknownClassName;
        }

        public String getRequiredClientVersion() {
            return this.requiredClientVersion;
        }
    }
}

