/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.repository.common.serialize.internal;

import com.ibm.team.repository.common.IItem;
import com.ibm.team.repository.common.serialize.ISerializer;
import com.ibm.team.repository.common.serialize.SerializeException;
import com.ibm.team.repository.common.serialize.internal.SerializingWriter;
import com.ibm.team.repository.common.serialize.internal.SerializingWriterVerbose;
import java.io.IOException;
import java.io.Writer;
import org.eclipse.emf.ecore.EObject;

public abstract class Serializer
implements ISerializer {
    private boolean verbose = false;
    private String repoUri;

    protected Serializer() {
    }

    @Override
    public boolean isVerbose() {
        return this.verbose;
    }

    @Override
    public void setVerbose(boolean value) {
        this.verbose = value;
    }

    @Override
    public void setRepoUri(String uri) {
        this.repoUri = uri;
    }

    @Override
    public String getRepoUri() {
        return this.repoUri;
    }

    @Override
    public void serialize(Writer writer, EObject eObject) throws SerializeException {
        if (eObject == null) {
            throw new IllegalArgumentException("object to serialize must not be null");
        }
        SerializingWriter sWriter = this.isVerbose() ? new SerializingWriterVerbose(writer) : new SerializingWriter(writer);
        Class expectedType = eObject.eClass().getInstanceClass();
        this.serializeEObject(sWriter, eObject, expectedType);
        try {
            sWriter.flush();
        }
        catch (IOException e) {
            throw SerializeException.from(e);
        }
    }

    public boolean shouldMorphItemToHandle(EObject eObject, Class expectedType) {
        if (eObject == null) {
            return false;
        }
        if (!(eObject instanceof IItem)) {
            return false;
        }
        return !IItem.class.isAssignableFrom(expectedType);
    }

    public EObject morphItemToHandle(EObject item) {
        if (item == null) {
            return null;
        }
        return (EObject)((IItem)item).getItemHandle();
    }

    public Class getExpectedType(EObject eObject) {
        if (eObject == null) {
            return null;
        }
        return eObject.eClass().getInstanceClass();
    }

    protected abstract void serializeEObject(SerializingWriter var1, EObject var2, Class var3) throws SerializeException;
}

