/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.repository.common.internal.validation;

import com.ibm.team.repository.common.IHelper;
import com.ibm.team.repository.common.IItem;
import com.ibm.team.repository.common.IItemType;
import com.ibm.team.repository.common.IType;
import com.ibm.team.repository.common.internal.validation.IValidationMessages;
import com.ibm.team.repository.common.model.Helper;
import com.ibm.team.repository.common.util.NLS;
import com.ibm.team.repository.common.validation.IPropertyConstraintErrorStatus;
import java.util.Stack;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;

public class ValidationContext {
    private static final String PLUGIN_ID = "com.ibm.team.repository.common";
    private MultiStatus result;
    private final Stack<EStructuralFeature> currentFeaturePath;
    private EStructuralFeature currentFeature;
    private final Stack<EObject> currentEObjectPath;
    private EObject currentEObject;
    private final IItem root;

    public ValidationContext(IItem root) {
        this.root = root;
        this.currentEObject = (EObject)root;
        this.currentEObjectPath = new Stack();
        this.currentEObjectPath.push(this.currentEObject);
        this.currentFeaturePath = new Stack();
    }

    public void appendStatus(IPropertyConstraintErrorStatus next) {
        if (this.result == null) {
            String message = NLS.bind(IValidationMessages.VALIDATION_ERRORS_FOR_ITEM, this.root.getItemType().getName(), this.root.getItemId());
            this.result = new MultiStatus(PLUGIN_ID, -1, message, null);
        }
        this.result.add((IStatus)next);
    }

    public void pushFeature(EStructuralFeature feature) {
        this.currentFeature = feature;
        this.currentFeaturePath.push(feature);
    }

    public void popFeature() {
        this.currentFeaturePath.pop();
        this.currentFeature = this.currentFeaturePath.isEmpty() ? null : this.currentFeaturePath.peek();
    }

    public void pushEObject(EObject eObject) {
        this.currentEObject = eObject;
        this.currentEObjectPath.push(eObject);
    }

    public void popEObject() {
        this.currentEObjectPath.pop();
        this.currentEObject = this.currentEObjectPath.isEmpty() ? null : this.currentEObjectPath.peek();
    }

    public EStructuralFeature getCurrentFeature() {
        return this.currentFeature;
    }

    public String[] computeFeaturePath() {
        String[] result = new String[this.currentFeaturePath.size()];
        int index = 0;
        for (EStructuralFeature feature : this.currentFeaturePath) {
            result[index] = feature.getName();
            ++index;
        }
        return result;
    }

    public String computeFeaturePathLabel() {
        StringBuffer path = new StringBuffer();
        boolean first = true;
        for (EStructuralFeature feature : this.currentFeaturePath) {
            if (!first) {
                path.append('.');
            } else {
                first = false;
            }
            path.append(feature.getName());
        }
        return path.toString();
    }

    public IStatus getResult() {
        return this.result;
    }

    public EObject getCurrentEObject() {
        return this.currentEObject;
    }

    public IItem getRoot() {
        return this.root;
    }

    public IItemType getRootType() {
        if (this.root != null) {
            return this.root.getItemType();
        }
        return null;
    }

    public IType getCurrentType() {
        if (this.currentEObject instanceof IItem) {
            return ((IItem)this.currentEObject).getItemType();
        }
        return ((IHelper)this.currentEObject).getHelperType();
    }

    public boolean isCurrentHelperType() {
        return this.currentEObject instanceof Helper;
    }
}

