/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.ast.tools;

import java.util.List;
import org.codehaus.groovy.ast.ClassHelper;
import org.codehaus.groovy.ast.ClassNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WideningCategories {
    public static boolean isIntCategory(ClassNode type) {
        return type == ClassHelper.byte_TYPE || type == ClassHelper.char_TYPE || type == ClassHelper.int_TYPE || type == ClassHelper.short_TYPE;
    }

    public static boolean isLongCategory(ClassNode type) {
        return type == ClassHelper.long_TYPE || WideningCategories.isIntCategory(type);
    }

    public static boolean isBigIntCategory(ClassNode type) {
        return type == ClassHelper.BigInteger_TYPE || WideningCategories.isLongCategory(type);
    }

    public static boolean isBigDecCategory(ClassNode type) {
        return type == ClassHelper.BigDecimal_TYPE || WideningCategories.isBigIntCategory(type);
    }

    public static boolean isDoubleCategory(ClassNode type) {
        return type == ClassHelper.float_TYPE || type == ClassHelper.double_TYPE || WideningCategories.isBigDecCategory(type);
    }

    public static boolean isNumberCategory(ClassNode type) {
        return WideningCategories.isBigDecCategory(type) || type.isDerivedFrom(ClassHelper.Number_TYPE);
    }

    public static ClassNode firstCommonSuperType(ClassNode a, ClassNode b) {
        if (a == null || b == null) {
            return ClassHelper.OBJECT_TYPE;
        }
        if (a == b || a.equals(b)) {
            return a;
        }
        if (ClassHelper.isPrimitiveType(a) && !ClassHelper.isPrimitiveType(b)) {
            if (ClassHelper.isNumberType(a) && ClassHelper.isNumberType(b)) {
                return WideningCategories.firstCommonSuperType(ClassHelper.getWrapper(a), b);
            }
            return ClassHelper.OBJECT_TYPE;
        }
        if (ClassHelper.isPrimitiveType(b) && !ClassHelper.isPrimitiveType(a)) {
            if (ClassHelper.isNumberType(b) && ClassHelper.isNumberType(a)) {
                return WideningCategories.firstCommonSuperType(ClassHelper.getWrapper(b), a);
            }
            return ClassHelper.OBJECT_TYPE;
        }
        if (ClassHelper.isPrimitiveType(a) && ClassHelper.isPrimitiveType(b)) {
            return WideningCategories.firstCommonSuperType(ClassHelper.getWrapper(a), ClassHelper.getWrapper(b));
        }
        ClassNode superA = a.getSuperClass();
        ClassNode superB = b.getSuperClass();
        if (a == superB || a.equals(superB)) {
            return superB;
        }
        if (b == superA || b.equals(superA)) {
            return superA;
        }
        return WideningCategories.firstCommonSuperType(superA, superB);
    }

    public static ClassNode firstCommonSuperType(List<ClassNode> nodes) {
        if (nodes.size() == 1) {
            return nodes.get(0);
        }
        return WideningCategories.firstCommonSuperType(nodes.get(0), WideningCategories.firstCommonSuperType(nodes.subList(1, nodes.size())));
    }
}

