/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.process.internal.client;

import com.ibm.team.process.common.IProcessArea;
import com.ibm.team.process.common.IProjectArea;
import com.ibm.team.process.common.IRole2;
import com.ibm.team.process.internal.common.ProcessModelUtilities;
import com.ibm.team.process.internal.common.advice.AdvicePackage;
import com.ibm.team.process.internal.common.advice.ConfigurationSource;
import com.ibm.team.process.internal.common.advice.PermissionSource;
import com.ibm.team.process.internal.common.model.AbstractElement;
import com.ibm.team.process.internal.common.model.settings.OperationBehaviorConfiguration;
import com.ibm.team.process.internal.common.model.settings.OperationPermissionsConfiguration;
import com.ibm.team.process.internal.common.model.settings.PermissionActionElement;
import com.ibm.team.process.internal.common.model.settings.ProcessConfigurationElement;
import com.ibm.team.process.internal.common.rest.representations.runtime.BehaviorRepresentation;
import com.ibm.team.process.internal.common.rest.representations.runtime.ConfigurationSourceRepresentation;
import com.ibm.team.process.internal.common.rest.representations.runtime.PermissionRepresentation;
import com.ibm.team.process.internal.common.rest.representations.runtime.RuntimeOperationReportRepresentation;
import com.ibm.team.process.internal.common.rest.representations.runtime.RuntimeRoleRepresentation;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IItem;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;

public class RepresentationConversionUtil {
    public static OperationBehaviorConfiguration createBehaviorConfiguration(RuntimeOperationReportRepresentation operationReport, String operationId, boolean isProjectOperation, ITeamRepository repo, IProgressMonitor monitor) throws TeamRepositoryException {
        String behaviorElementName = isProjectOperation ? "project-operation" : "operation";
        return RepresentationConversionUtil.createBehaviorConfiguration(operationReport, operationId, behaviorElementName, repo, monitor);
    }

    public static OperationBehaviorConfiguration createBehaviorConfiguration(RuntimeOperationReportRepresentation operationReport, String operationId, String elementName, ITeamRepository repo, IProgressMonitor monitor) throws TeamRepositoryException {
        BehaviorRepresentation behaviorRepresentation = operationReport.behavior;
        if (behaviorRepresentation != null) {
            ConfigurationSource configurationSource;
            BehaviorRepresentation.FollowupActionRepresentation[] followupActions;
            OperationBehaviorConfiguration configuration = new OperationBehaviorConfiguration(null, "http://com.ibm.team.process", elementName, null);
            configuration.modifyAttribute("id", operationId);
            configuration.modifyAttribute("final", Boolean.toString(behaviorRepresentation.isFinal));
            BehaviorRepresentation.PreconditionRepresentation[] preconditions = behaviorRepresentation.preconditions;
            if (preconditions != null) {
                ProcessConfigurationElement preconditionsElement = new ProcessConfigurationElement(null, "http://com.ibm.team.process", "preconditions", null);
                int i = 0;
                while (i < preconditions.length) {
                    BehaviorRepresentation.PreconditionRepresentation preconditionRepresentation = preconditions[i];
                    ProcessModelUtilities.createConfigurationElement((String)preconditionRepresentation.configurationXML, (AbstractElement)preconditionsElement);
                    ++i;
                }
                configuration.addChildElement((AbstractElement)preconditionsElement);
            }
            if ((followupActions = behaviorRepresentation.followupActions) != null) {
                ProcessConfigurationElement followupActionsElement = new ProcessConfigurationElement(null, "http://com.ibm.team.process", "followup-actions", null);
                int i = 0;
                while (i < followupActions.length) {
                    BehaviorRepresentation.FollowupActionRepresentation followupActionRepresentation = followupActions[i];
                    ProcessModelUtilities.createConfigurationElement((String)followupActionRepresentation.configurationXML, (AbstractElement)followupActionsElement);
                    ++i;
                }
                configuration.addChildElement((AbstractElement)followupActionsElement);
            }
            if ((configurationSource = RepresentationConversionUtil.createConfigurationSource(behaviorRepresentation.behaviorSource, repo, monitor)) != null) {
                configuration = (OperationBehaviorConfiguration)configuration.createCopyWithSource(configurationSource);
                return configuration;
            }
        }
        return null;
    }

    public static OperationPermissionsConfiguration createPermissionConfiguration(PermissionRepresentation permissionRepresentation, String operationId, boolean isProjectOperation, ITeamRepository repo, IProgressMonitor monitor) throws TeamRepositoryException {
        String elementName = isProjectOperation ? "project-operation" : "operation";
        OperationPermissionsConfiguration configuration = new OperationPermissionsConfiguration(null, "http://com.ibm.team.process", elementName, null);
        configuration.modifyAttribute("id", operationId);
        configuration.modifyAttribute("final", Boolean.toString(permissionRepresentation.isFinal));
        PermissionRepresentation.Action[] permittedActions = permissionRepresentation.permittedActions;
        if (permittedActions != null) {
            IPath[] actionPaths = new IPath[permittedActions.length];
            int i = 0;
            while (i < actionPaths.length) {
                actionPaths[i] = new Path(permittedActions[i].actionId);
                ++i;
            }
            RepresentationConversionUtil.populateActions(configuration, actionPaths);
        }
        PermissionSource permissionSource = RepresentationConversionUtil.createPermissionSource(permissionRepresentation.permissionSource, permittedActions, repo, monitor);
        configuration = (OperationPermissionsConfiguration)configuration.createCopyWithSource((ConfigurationSource)permissionSource);
        return configuration;
    }

    private static void populateActions(OperationPermissionsConfiguration configuration, IPath[] actionPaths) {
        int i = 0;
        while (i < actionPaths.length) {
            OperationPermissionsConfiguration parent = configuration;
            String[] segments = actionPaths[i].segments();
            int j = 0;
            while (j < segments.length) {
                String actionId = segments[j];
                PermissionActionElement action = parent.getAction(actionId);
                if (action == null) {
                    action = new PermissionActionElement((AbstractElement)parent, "http://com.ibm.team.process", "action", null);
                    action.setId(actionId);
                    ((AbstractElement)parent).addChildElement((AbstractElement)action);
                }
                parent = action;
                ++j;
            }
            ++i;
        }
    }

    private static PermissionSource createPermissionSource(ConfigurationSourceRepresentation sourceRepresentation, PermissionRepresentation.Action[] permittedActions, ITeamRepository repo, IProgressMonitor monitor) throws TeamRepositoryException {
        if (sourceRepresentation != null) {
            PermissionSource permissionSource = AdvicePackage.eINSTANCE.getAdviceFactory().createPermissionSource();
            RepresentationConversionUtil.populateConfigurationSource((ConfigurationSource)permissionSource, sourceRepresentation, repo, monitor);
            String[] actions = new String[permittedActions.length];
            int i = 0;
            while (i < actions.length) {
                actions[i] = permittedActions[i].actionId;
                ++i;
            }
            permissionSource.setPermittedActions(actions);
            return permissionSource;
        }
        return null;
    }

    private static ConfigurationSource createConfigurationSource(ConfigurationSourceRepresentation representation, ITeamRepository repo, IProgressMonitor monitor) throws TeamRepositoryException {
        if (representation != null) {
            ConfigurationSource configurationSource = AdvicePackage.eINSTANCE.getAdviceFactory().createConfigurationSource();
            RepresentationConversionUtil.populateConfigurationSource(configurationSource, representation, repo, monitor);
            return configurationSource;
        }
        return null;
    }

    private static void populateConfigurationSource(ConfigurationSource configurationSource, ConfigurationSourceRepresentation representation, ITeamRepository repo, IProgressMonitor monitor) throws TeamRepositoryException {
        configurationSource.setAreaIsTeamArea(representation.isTeamArea);
        configurationSource.setContentKey(representation.contentKey);
        configurationSource.setContentUuid(representation.contentUuid);
        configurationSource.setFinal(representation.isFinal);
        configurationSource.setRoleId(representation.roleId);
        String sourceAreaItemUuid = representation.sourceAreaItemUuid;
        configurationSource.setSourceAreaItemUuid(sourceAreaItemUuid);
        if (sourceAreaItemUuid != null) {
            IItemHandle handle = IProjectArea.ITEM_TYPE.createItemHandle(UUID.valueOf((String)sourceAreaItemUuid), null);
            IItem sourceArea = repo.itemManager().fetchCompleteItem(handle, 0, monitor);
            if (sourceArea instanceof IProcessArea) {
                configurationSource.setSourceArea((IProcessArea)sourceArea);
            }
        }
    }

    public static IRole2 createRoleFromRepresentation(final RuntimeRoleRepresentation assignment) {
        IRole2 role = new IRole2(){

            public String getId() {
                return assignment.id;
            }

            public String getDescription() {
                return assignment.description;
            }

            public int getCardinality() {
                return Integer.parseInt(assignment.cardinality);
            }

            public String getRoleName() {
                return assignment.name;
            }

            public String getRoleLabel() {
                String label = this.getRoleName();
                if (label == null || label.trim().length() == 0) {
                    label = this.getId();
                }
                return label;
            }
        };
        return role;
    }
}

