/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.common.expression;

import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.util.NLS;
import com.ibm.team.workitem.common.expression.AttributeExpression;
import com.ibm.team.workitem.common.expression.Expression;
import com.ibm.team.workitem.common.expression.ExpressionVisitor;
import com.ibm.team.workitem.common.expression.Messages;
import com.ibm.team.workitem.common.expression.ProgressExpressionVisitor;
import com.ibm.team.workitem.common.expression.SelectClause;
import com.ibm.team.workitem.common.expression.SerializationException;
import com.ibm.team.workitem.common.expression.SimilarityExpression;
import com.ibm.team.workitem.common.expression.SortCriteria;
import com.ibm.team.workitem.common.expression.Term;
import com.ibm.team.workitem.common.expression.VariableAttributeExpression;
import com.ibm.team.workitem.common.expression.WorkItemExpression;
import com.ibm.team.workitem.common.internal.expression.IPersistableElement;
import com.ibm.team.workitem.common.internal.expression.ISerializationContext;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;

public class Statement
extends Expression {
    private Expression fConditions;
    private SelectClause fSelectClause;
    private List<SortCriteria> fSortCriteria = new ArrayList<SortCriteria>();

    public Statement() {
    }

    public Statement(SelectClause selectClause, Expression conditions, SortCriteria[] sortCriteria) {
        this(selectClause, conditions, sortCriteria == null ? Collections.emptyList() : Arrays.asList(sortCriteria));
    }

    public Statement(SelectClause selectClause, Expression conditions, List<SortCriteria> sortCriteria) {
        this.fSelectClause = selectClause;
        this.setConditions(conditions);
        this.fSortCriteria.addAll(sortCriteria);
    }

    public Statement(SelectClause selectClause, Expression conditions) {
        this(selectClause, conditions, Collections.emptyList());
    }

    public Expression getConditions() {
        return this.fConditions;
    }

    public SelectClause getSelectClause() {
        return this.fSelectClause;
    }

    public boolean hasSortCriteria() {
        return !this.fSortCriteria.isEmpty();
    }

    public List<SortCriteria> getSortCriteria() {
        return Collections.unmodifiableList(this.fSortCriteria);
    }

    public void setConditions(Expression conditions) {
        Assert.isTrue((!(conditions instanceof Statement) ? 1 : 0) != 0);
        this.fConditions = conditions;
    }

    @Override
    public void accept(ExpressionVisitor visitor) {
        if (visitor.visit(this)) {
            if (this.getSelectClause() != null) {
                this.getSelectClause().accept(visitor);
            }
            if (this.getConditions() != null) {
                this.getConditions().accept(visitor);
            }
            for (SortCriteria sc : this.getSortCriteria()) {
                sc.accept(visitor);
            }
        }
    }

    @Override
    public void accept(ProgressExpressionVisitor visitor, IProgressMonitor monitor) throws TeamRepositoryException {
        if (visitor.visit(this, monitor)) {
            if (this.getSelectClause() != null) {
                this.getSelectClause().accept(visitor, monitor);
            }
            if (this.getConditions() != null) {
                this.getConditions().accept(visitor, monitor);
            }
            for (SortCriteria sc : this.getSortCriteria()) {
                sc.accept(visitor, monitor);
            }
        }
    }

    @Override
    public void init(IPersistableElement query, ISerializationContext context) throws SerializationException {
        this.fSelectClause = new SelectClause();
        this.fSelectClause.init(query, context);
        if (query.hasChild("where")) {
            Expression conditions = null;
            IPersistableElement[] children = query.getChild("where").getChildren();
            if (children.length != 1) {
                String error = NLS.bind((String)Messages.getString("Statement.PATTERN_ONE_CHILD_ONLY"), (Object)"<where>", (Object[])new Object[]{children.length});
                throw new SerializationException(error);
            }
            String name = children[0].getName();
            if ("condition".equals(children[0].getName())) {
                conditions = children[0].hasChild("variable") ? new VariableAttributeExpression() : new AttributeExpression();
            } else if ("and".equals(name) || "or".equals(name)) {
                conditions = new Term();
            } else if ("similarContent".equals(name)) {
                conditions = new SimilarityExpression();
            } else if ("similarItem".equals(name)) {
                conditions = new WorkItemExpression();
            }
            if (conditions == null) {
                String error = NLS.bind((String)Messages.getString("Statement.PATTERN_NO_KNOWN_CHILD"), (Object)"<where>", (Object[])new Object[0]);
                throw new SerializationException(error);
            }
            this.setConditions(conditions);
            ((Expression)conditions).init(children[0], context);
        }
        if (query.hasChild("orderBy")) {
            IPersistableElement[] orderByElements = query.getChildren("orderBy");
            int i = 0;
            while (i < orderByElements.length) {
                SortCriteria sc = new SortCriteria();
                sc.init(orderByElements[i], context);
                this.fSortCriteria.add(sc);
                ++i;
            }
        }
    }

    @Override
    public void saveState(IPersistableElement query) throws SerializationException {
        if (this.fSelectClause != null) {
            this.fSelectClause.saveState(query);
        }
        if (this.fConditions != null) {
            IPersistableElement where = query.createChild("where");
            this.fConditions.saveState(where);
        }
        for (SortCriteria sc : this.fSortCriteria) {
            sc.saveState(query);
        }
    }

    @Override
    public Expression copy() {
        Statement result = new Statement();
        result.fConditions = this.fConditions;
        result.fSelectClause = this.fSelectClause;
        result.fSortCriteria = this.fSortCriteria;
        return result;
    }
}

