/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.common.expression;

import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.json.JSONArray;
import com.ibm.team.repository.common.json.JSONObject;
import com.ibm.team.repository.common.util.NLS;
import com.ibm.team.workitem.common.expression.AttributeExpression;
import com.ibm.team.workitem.common.expression.Expression;
import com.ibm.team.workitem.common.expression.ExpressionVisitor;
import com.ibm.team.workitem.common.expression.IQueryableAttribute;
import com.ibm.team.workitem.common.expression.Messages;
import com.ibm.team.workitem.common.expression.SerializationException;
import com.ibm.team.workitem.common.expression.variables.AbstractAttributeVariable;
import com.ibm.team.workitem.common.expression.variables.AttributeVariableFactory;
import com.ibm.team.workitem.common.expression.variables.IAttributeVariable;
import com.ibm.team.workitem.common.expression.variables.IEvaluationContext;
import com.ibm.team.workitem.common.internal.expression.IAttributeValue;
import com.ibm.team.workitem.common.internal.expression.IPersistableElement;
import com.ibm.team.workitem.common.internal.expression.ISerializationContext;
import com.ibm.team.workitem.common.model.AttributeOperation;
import com.ibm.team.workitem.common.model.IAttribute;
import org.eclipse.core.runtime.IProgressMonitor;

public final class VariableAttributeExpression
extends AttributeExpression {
    public VariableAttributeExpression() {
    }

    public VariableAttributeExpression(IQueryableAttribute attribute, AttributeOperation operation, IAttributeVariable<?> variable) {
        super(attribute, operation, variable);
    }

    @Deprecated
    public VariableAttributeExpression(IAttribute attribute, AttributeOperation operation, IAttributeVariable<?> variable) {
        super(null, attribute, operation, variable);
    }

    @Override
    public Object getResolvedValue(IEvaluationContext context, IProgressMonitor monitor) throws TeamRepositoryException {
        return this.getVariable().evaluate(context, monitor);
    }

    @Override
    public void accept(ExpressionVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    protected IAttributeValue createValueProxy(IPersistableElement condition, ISerializationContext context) throws SerializationException {
        IPersistableElement variableElement = "variable".equals(condition.getName()) ? condition : condition.getChild("variable");
        String variableId = variableElement.getAttribute("type");
        AbstractAttributeVariable variable = (AbstractAttributeVariable)AttributeVariableFactory.getInstance().getVariable(variableId);
        if (variable == null) {
            String error = NLS.bind((String)Messages.getString("VariableAttributeExpression.UNKNOWN_VARIABLE"), (Object)variableId, (Object[])new Object[0]);
            throw new SerializationException(error);
        }
        variable.init(variableElement, context);
        return variable;
    }

    @Override
    protected void saveValueProxy(IPersistableElement condition) throws SerializationException {
        IPersistableElement variableElement = condition.createChild("variable");
        variableElement.setAttribute("type", this.getVariable().getId());
        this.getVariable().saveState(variableElement);
    }

    public IAttributeVariable<?> getVariable() {
        return (IAttributeVariable)super.getValue();
    }

    @Override
    public Expression copy() {
        VariableAttributeExpression result = new VariableAttributeExpression();
        result.fAttribute = this.fAttribute;
        result.fAttributeIdentifier = this.fAttributeIdentifier;
        result.fItemType = this.fItemType;
        result.fOperator = this.fOperator;
        result.fValueProxy = this.fValueProxy;
        return result;
    }

    @Override
    public JSONObject toJson() {
        JSONObject result = super.toJson();
        JSONArray variables = new JSONArray();
        variables.add((Object)this.getVariable().toJson());
        result.put((Object)AttributeExpression.Identifiers.variables.name(), (Object)variables);
        return result;
    }
}

