/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.common.internal;

import com.ibm.team.process.common.IProcessConfigurationElement;
import com.ibm.team.process.common.advice.AdvisableOperation;
import com.ibm.team.process.common.advice.IAdvisorInfo;
import com.ibm.team.process.common.advice.IAdvisorInfoCollector;
import com.ibm.team.process.common.advice.IReportInfo;
import com.ibm.team.process.common.advice.runtime.IOperationAdvisor;
import com.ibm.team.repository.common.IAuditable;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.util.NLS;
import com.ibm.team.workitem.common.IAuditableCommon;
import com.ibm.team.workitem.common.ISaveParameter;
import com.ibm.team.workitem.common.IWorkItemCommon;
import com.ibm.team.workitem.common.internal.Messages;
import com.ibm.team.workitem.common.internal.workflow.WorkflowInfo;
import com.ibm.team.workitem.common.model.IWorkItem;
import com.ibm.team.workitem.common.text.WorkItemTextUtilities;
import java.util.TimeZone;
import org.eclipse.core.runtime.IProgressMonitor;

public class StateBasedModificationAdvisor
implements IOperationAdvisor {
    public static final String ADVISOR_ID = "com.ibm.team.workitem.advisor.stateBasedModification";
    public static final String CHECKS = "checks";
    public static final String OPTIONS = "options";
    public static final String ALLOW_ACTIONS = "allowActions";
    public static final String CHECK = "check";
    public static final String TYPE = "type";
    public static final String STATE = "state";
    public static final String RESOLUTION = "resolution";

    public void run(AdvisableOperation operation, IProcessConfigurationElement advisorConfiguration, IAdvisorInfoCollector collector, IProgressMonitor monitor) throws TeamRepositoryException {
        ISaveParameter saveParameter;
        IAuditable auditable;
        Object data = operation.getOperationData();
        if (data instanceof ISaveParameter && (auditable = (saveParameter = (ISaveParameter)data).getOldState()) instanceof IWorkItem) {
            IAuditableCommon auditableCommon = saveParameter.getSaveOperationParameter().getAuditableCommon();
            IWorkItemCommon workItemCommon = auditableCommon.getPeer(IWorkItemCommon.class);
            IWorkItem workItem = (IWorkItem)auditable;
            TimeZone userTimeZone = saveParameter.getSaveOperationParameter().getUserTimeZone();
            this.checkWorkItem(workItem, workItemCommon, advisorConfiguration, collector, userTimeZone, saveParameter.getWorkflowAction(), monitor);
        }
    }

    private void checkWorkItem(IWorkItem workItem, IWorkItemCommon workItemCommon, IProcessConfigurationElement advisorConfiguration, IAdvisorInfoCollector collector, TimeZone userTimeZone, String actionId, IProgressMonitor monitor) throws TeamRepositoryException {
        IProcessConfigurationElement options = this.getChild(advisorConfiguration, OPTIONS);
        if (options == null || Boolean.TRUE.toString().equals(options.getAttribute(ALLOW_ACTIONS)) && actionId != null) {
            return;
        }
        IProcessConfigurationElement checks = this.getChild(advisorConfiguration, CHECKS);
        if (checks != null) {
            IProcessConfigurationElement[] iProcessConfigurationElementArray = checks.getChildren();
            int n = iProcessConfigurationElementArray.length;
            int n2 = 0;
            while (n2 < n) {
                IProcessConfigurationElement check = iProcessConfigurationElementArray[n2];
                if (this.evaluate(check, workItem)) {
                    IAdvisorInfo info = collector.createProblemInfo(Messages.getString("StateBasedModificationAdvisor.SUMMARY"), this.getDescription(workItem, userTimeZone), ADVISOR_ID);
                    info.setProblemObject((Object)workItem.getItemHandle());
                    collector.addInfo((IReportInfo)info);
                    return;
                }
                ++n2;
            }
        }
    }

    private boolean evaluate(IProcessConfigurationElement check, IWorkItem workItem) {
        String typeId = check.getAttribute(TYPE);
        String stateId = check.getAttribute(STATE);
        String resolutionId = check.getAttribute(RESOLUTION);
        boolean matches = true;
        matches &= workItem.getWorkItemType().equals(typeId);
        if (stateId != null) {
            String realStateId = WorkflowInfo.stripOffPrefix(stateId, 's');
            String workItemState = workItem.getState2() != null ? workItem.getState2().getStringIdentifier() : null;
            matches &= realStateId.equals(workItemState);
        }
        if (resolutionId != null) {
            String realResolutionId = WorkflowInfo.stripOffPrefix(resolutionId, 'r');
            String workItemResolution = workItem.getResolution2() != null ? workItem.getResolution2().getStringIdentifier() : null;
            matches &= realResolutionId.equals(workItemResolution);
        }
        return matches;
    }

    private IProcessConfigurationElement getChild(IProcessConfigurationElement element, String name) {
        IProcessConfigurationElement[] iProcessConfigurationElementArray = element.getChildren();
        int n = iProcessConfigurationElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            IProcessConfigurationElement cfg = iProcessConfigurationElementArray[n2];
            if (cfg.getName().equals(name)) {
                return cfg;
            }
            ++n2;
        }
        return null;
    }

    private String getDescription(IWorkItem workItem, TimeZone userTimeZone) {
        return NLS.bind((String)Messages.getString("StateBasedModificationAdvisor.DESCRIPTION"), (Object)WorkItemTextUtilities.formatWorkItemId(workItem, userTimeZone), (Object[])new Object[0]);
    }
}

