/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.common.internal.attributeValueProviders;

import com.ibm.team.process.common.IProcessConfigurationElement;
import com.ibm.team.process.internal.common.model.AbstractElement;
import com.ibm.team.process.internal.common.model.settings.ProcessConfigurationElement;
import com.ibm.team.workitem.common.internal.attributeValueProviders.Configuration;
import com.ibm.team.workitem.common.internal.attributeValueProviders.IConfiguration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.xml.sax.Attributes;
import org.xml.sax.helpers.AttributesImpl;

public class ValueProviderUtil {
    private static final String INCLUDE_CHILDREN = "includeChildren";
    public static final String MAPPING = "mapping";
    private static final String FALLBACK_2_0_0_2_FILTER_MAP = "filterMap";
    private static final String SOURCE_ATTRIBUTE = "sourceAttribute";
    private static final String SOURCE_ENUM = "sourceEnumeration";
    private static final String DEPENDENT_ENUM = "dependentEnumeration";
    private static final String TRUE = "true";

    public static List<String> getMappedLiterals(IConfiguration configuration, List<String> keys) {
        return ValueProviderUtil.internalGetMappedLiterals(configuration, keys, false, true);
    }

    public static boolean includeChildrenInMapping(IConfiguration configuration) {
        IConfiguration map = ValueProviderUtil.getMap(configuration);
        if (map != null) {
            for (IConfiguration entry : map.getChildren("value")) {
                if (!TRUE.equals(entry.getString(INCLUDE_CHILDREN))) continue;
                return true;
            }
        }
        return false;
    }

    public static String getMappedLiteral(IConfiguration configuration, String key) {
        List<String> literals = ValueProviderUtil.internalGetMappedLiterals(configuration, Collections.singletonList(key), true, false);
        return literals.isEmpty() ? null : literals.get(0);
    }

    public static boolean isIncludeChildren(IConfiguration configuration, String key) {
        IConfiguration map = ValueProviderUtil.getMap(configuration);
        if (map == null) {
            return false;
        }
        IConfiguration value = ValueProviderUtil.getValueElement(map, key);
        if (value == null) {
            return false;
        }
        return TRUE.equals(value.getString(INCLUDE_CHILDREN));
    }

    public static List<String> getLiteralIdentifiers(IConfiguration configuration, String key) {
        IConfiguration map = ValueProviderUtil.getMap(configuration);
        if (map == null) {
            return Collections.emptyList();
        }
        IConfiguration value = ValueProviderUtil.getValueElement(map, key);
        if (value == null) {
            return Collections.emptyList();
        }
        ArrayList<String> identifiers = new ArrayList<String>();
        for (IConfiguration literal : value.getChildren("literal")) {
            String id = literal.getString("id");
            if (id == null || id.length() <= 0) continue;
            identifiers.add(id);
        }
        return identifiers;
    }

    public static String getSourceEnumerationId(IConfiguration configuration) {
        IConfiguration map = ValueProviderUtil.getMap(configuration);
        return map == null ? null : map.getString(SOURCE_ENUM);
    }

    public static String getSourceAttributeId(IConfiguration configuration) {
        String sourceAttributeId;
        IConfiguration map = ValueProviderUtil.getMap(configuration);
        String string = sourceAttributeId = map == null ? null : map.getString(SOURCE_ATTRIBUTE);
        if (sourceAttributeId == null) {
            return ValueProviderUtil.getSourceEnumerationId(configuration);
        }
        return sourceAttributeId;
    }

    public static String getDependentEnumerationId(IConfiguration configuration) {
        IConfiguration map = ValueProviderUtil.getMap(configuration);
        return map == null ? null : map.getString(DEPENDENT_ENUM);
    }

    public static String getFirstSourceEnumerationLiteralId(IConfiguration configuration) {
        List<IConfiguration> literals = ValueProviderUtil.getSourceEnumerationLiterals(configuration);
        return literals.isEmpty() ? null : literals.get(0).getString("content");
    }

    public static String getFirstDependentEnumerationLiteralId(IConfiguration configuration) {
        List<IConfiguration> sourceLiterals = ValueProviderUtil.getSourceEnumerationLiterals(configuration);
        for (IConfiguration sourceLiteral : sourceLiterals) {
            IConfiguration literal = sourceLiteral.getChild("literal");
            if (literal == null) continue;
            return literal.getString("id");
        }
        return null;
    }

    private static <T extends IConfiguration> T getMap(T configuration) {
        IConfiguration map = configuration.getChild(MAPPING);
        if (map == null) {
            map = configuration.getChild(FALLBACK_2_0_0_2_FILTER_MAP);
        }
        return (T)map;
    }

    private static <T extends IConfiguration> T getValueElement(T configuration, String key) {
        for (IConfiguration entry : configuration.getChildren("value")) {
            String content = entry.getString("content");
            if (key != null && key.equals(content)) {
                return (T)entry;
            }
            if (key != null || content != null) continue;
            return (T)entry;
        }
        return null;
    }

    private static <T extends IConfiguration> T getLiteralElement(T configuration, String identifier) {
        for (IConfiguration literal : configuration.getChildren("literal")) {
            String id = literal.getString("id");
            if (identifier == null || !identifier.equals(id)) continue;
            return (T)literal;
        }
        return null;
    }

    private static List<IConfiguration> getSourceEnumerationLiterals(IConfiguration configuration) {
        IConfiguration map = ValueProviderUtil.getMap(configuration);
        if (map == null) {
            return Collections.emptyList();
        }
        return map.getChildren("value");
    }

    private static List<String> internalGetMappedLiterals(IConfiguration configuration, List<String> keys, boolean onlyFirst, boolean withDefault) {
        ArrayList<String> values = new ArrayList<String>();
        IConfiguration map = ValueProviderUtil.getMap(configuration);
        IConfiguration defaultEntry = null;
        if (map != null) {
            for (IConfiguration entry : map.getChildren("value")) {
                String content = entry.getString("content");
                if (content == null) {
                    defaultEntry = entry;
                    continue;
                }
                int i = 0;
                while (i < keys.size()) {
                    String key = keys.get(i);
                    if (key != null && key.equals(content)) {
                        for (IConfiguration literal : entry.getChildren("literal")) {
                            String literalId = literal.getString("id");
                            if (literalId == null) continue;
                            values.add(literalId);
                            if (!onlyFirst) continue;
                            return values;
                        }
                        return values;
                    }
                    ++i;
                }
            }
        }
        if (values.isEmpty() && withDefault && !onlyFirst && defaultEntry != null) {
            for (IConfiguration literal : defaultEntry.getChildren("literal")) {
                String literalId = literal.getString("id");
                if (literalId == null) continue;
                values.add(literalId);
            }
        }
        return values;
    }

    public static void clearMap(Configuration configuration) {
        for (Configuration conf : configuration.internalGetChildren()) {
            if (!MAPPING.equals(conf.getElementName()) && !FALLBACK_2_0_0_2_FILTER_MAP.equals(conf.getElementName())) continue;
            conf.clear();
            break;
        }
    }

    public static void putMapLiteral(Configuration configuration, String key, String literalId) {
        Configuration map = ValueProviderUtil.getOrCreateMap(configuration);
        if (literalId != null) {
            Configuration entry = ValueProviderUtil.getValueElement(map, key);
            if (entry == null) {
                entry = ValueProviderUtil.createConfiguration(map, "value");
                entry.internalGetElement().modifyAttribute("content", key);
            } else {
                entry.internalGetChildren().clear();
            }
            Configuration literal = ValueProviderUtil.createConfiguration(entry, "literal");
            literal.internalGetElement().modifyAttribute("id", literalId);
        } else {
            Configuration entry = ValueProviderUtil.getValueElement(map, key);
            if (entry == null) {
                return;
            }
            Iterator<Configuration> it = map.internalGetChildren().iterator();
            while (it.hasNext()) {
                Configuration conf = it.next();
                if (!"value".equals(conf.getElementName()) || !key.equals(conf.getString("content"))) continue;
                it.remove();
                break;
            }
        }
    }

    public static boolean removeRole(Configuration valueSetProviderConfig, String tagName, String roleId, String optionalTeamAreaPath) {
        List<Configuration> children = valueSetProviderConfig.internalGetChildren();
        Iterator<Configuration> it = children.iterator();
        while (it.hasNext()) {
            Configuration child = it.next();
            if (!child.getElementName().equals(tagName) || !child.getString("role").equals(roleId) || !ValueProviderUtil.nullSafeEquals(child.getString("path"), optionalTeamAreaPath) && (optionalTeamAreaPath != null || !"${current}".equals(child.getString("path")))) continue;
            it.remove();
            return true;
        }
        System.err.println("FALSE " + tagName + " " + roleId + " " + optionalTeamAreaPath);
        return false;
    }

    public static void addRoleForCurrentProjectArea(Configuration valueSetProviderConfig, String roleId) {
        ValueProviderUtil.createConfiguration(valueSetProviderConfig, "projectArea", ValueProviderUtil.createAttributes("role", roleId));
    }

    public static void addRoleForCurrentTeamArea(Configuration valueSetProviderConfig, String roleId) {
        ValueProviderUtil.createConfiguration(valueSetProviderConfig, "teamArea", ValueProviderUtil.createAttributes("role", roleId, "path", "${current}"));
    }

    public static void addRoleForSpecificTeamArea(Configuration valueSetProviderConfig, String roleId, String teamAreaPath) {
        ValueProviderUtil.createConfiguration(valueSetProviderConfig, "teamArea", ValueProviderUtil.createAttributes("role", roleId, "path", teamAreaPath));
    }

    public static void addLiteral(Configuration configuration, String key, String literalId) {
        Configuration literal;
        Configuration map = ValueProviderUtil.getOrCreateMap(configuration);
        Configuration value = ValueProviderUtil.getValueElement(map, key);
        if (value == null) {
            value = ValueProviderUtil.createConfiguration(map, "value");
            if (key != null) {
                value.internalGetElement().modifyAttribute("content", key);
            }
        }
        if ((literal = ValueProviderUtil.getLiteralElement(value, literalId)) == null) {
            literal = ValueProviderUtil.createConfiguration(value, "literal");
            literal.internalGetElement().modifyAttribute("id", literalId);
        }
    }

    public static void setIncludeChildren(Configuration configuration, String key, boolean includeChildren) {
        Configuration map = ValueProviderUtil.getMap(configuration);
        if (map == null) {
            return;
        }
        Configuration value = ValueProviderUtil.getValueElement(map, key);
        if (value == null) {
            return;
        }
        value.setString(INCLUDE_CHILDREN, String.valueOf(includeChildren));
    }

    public static void removeEnumeration(Configuration configuration, String key) {
        Configuration map = ValueProviderUtil.getMap(configuration);
        if (map == null) {
            return;
        }
        Configuration value = ValueProviderUtil.getValueElement(map, key);
        if (value == null) {
            return;
        }
        map.internalGetChildren().remove(value);
    }

    public static void removeLiteral(Configuration configuration, String key, String literalId) {
        Configuration map = ValueProviderUtil.getMap(configuration);
        if (map == null) {
            return;
        }
        Configuration value = ValueProviderUtil.getValueElement(map, key);
        if (value == null) {
            return;
        }
        ValueProviderUtil.removeLiteralElement(value, literalId);
        if (value.getChildren().isEmpty()) {
            map.internalGetChildren().remove(value);
        }
    }

    public static void setSourceEnumerationId(Configuration configuration, String id) {
        Configuration map = ValueProviderUtil.getOrCreateMap(configuration);
        map.setString(SOURCE_ENUM, id);
    }

    public static void setSourceAttributeId(Configuration configuration, String id) {
        Configuration map = ValueProviderUtil.getOrCreateMap(configuration);
        map.setString(SOURCE_ATTRIBUTE, id);
    }

    public static void setDependentEnumerationId(Configuration configuration, String id) {
        Configuration map = ValueProviderUtil.getOrCreateMap(configuration);
        map.setString(DEPENDENT_ENUM, id);
    }

    public static boolean setConfigurationAttribute(Configuration configuration, String key, String value, String ... path) {
        Assert.isNotNull((Object)key);
        Assert.isNotNull((Object)value);
        Configuration cfg = ValueProviderUtil.getOrCreateConfiguration(configuration, path);
        String existing = cfg.getString(key);
        if (!value.equals(existing)) {
            cfg.setString(key, value);
            return true;
        }
        return false;
    }

    public static String getConfigurationAttribute(Configuration configuration, String key, String ... path) {
        Configuration cfg = ValueProviderUtil.getOrCreateConfiguration(configuration, path);
        return cfg.getString(key);
    }

    private static Configuration getOrCreateMap(Configuration configuration) {
        Configuration map = ValueProviderUtil.getMap(configuration);
        if (map == null) {
            map = ValueProviderUtil.createConfiguration(configuration, MAPPING);
        }
        return map;
    }

    private static Attributes createAttributes(String ... nameAndValue) {
        if (nameAndValue.length % 2 != 0) {
            throw new IllegalArgumentException("Names and values must be balanced (multiple of two)");
        }
        AttributesImpl attrs = new AttributesImpl();
        int i = 0;
        while (i < nameAndValue.length) {
            attrs.addAttribute("", "", nameAndValue[i], "", nameAndValue[i + 1]);
            i += 2;
        }
        return attrs;
    }

    private static boolean nullSafeEquals(Object left, Object right) {
        if (left == null && right == null) {
            return true;
        }
        return left != null && left.equals(right);
    }

    private static Configuration getOrCreateConfiguration(Configuration configuration, String ... path) {
        Configuration parent = configuration;
        String[] stringArray = path;
        int n = path.length;
        int n2 = 0;
        while (n2 < n) {
            String segment = stringArray[n2];
            Configuration child = parent.getChild(segment);
            if (child == null) {
                child = ValueProviderUtil.createConfiguration(parent, segment);
            }
            parent = child;
            ++n2;
        }
        return parent;
    }

    private static Configuration createConfiguration(Configuration parent, String name) {
        return ValueProviderUtil.createConfiguration(parent, name, null);
    }

    private static Configuration createConfiguration(Configuration parent, String name, Attributes attrs) {
        Configuration cfg = new Configuration((IProcessConfigurationElement)new ProcessConfigurationElement((AbstractElement)parent.internalGetElement(), null, name, attrs));
        parent.addChild(cfg);
        return cfg;
    }

    private static void removeLiteralElement(Configuration configuration, String identifier) {
        Iterator<Configuration> it = configuration.internalGetChildren().iterator();
        while (it.hasNext()) {
            IConfiguration conf = it.next();
            if (!"literal".equals(conf.getElementName()) || !identifier.equals(conf.getString("id"))) continue;
            it.remove();
            break;
        }
    }
}

