/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.common.internal.template;

import com.ibm.team.links.common.ILink;
import com.ibm.team.links.common.IURIReference;
import com.ibm.team.links.common.factory.IReferenceFactory;
import com.ibm.team.workitem.common.model.IAttribute;
import com.ibm.team.workitem.common.model.Identifier;
import com.ibm.team.workitem.common.template.IWorkItemDescriptor;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class WorkItemDescriptor
implements IWorkItemDescriptor {
    private final Map<Identifier<IAttribute>, Object> fAttributes = new HashMap<Identifier<IAttribute>, Object>();
    private final Map<Identifier<ILink>, Set<IURIReference>> fLinks = new HashMap<Identifier<ILink>, Set<IURIReference>>();
    private final List<IWorkItemDescriptor.IApprovalDescriptor> fApprovals = new ArrayList<IWorkItemDescriptor.IApprovalDescriptor>();
    private final List<IWorkItemDescriptor.IComment> fComments = new ArrayList<IWorkItemDescriptor.IComment>();

    public void addAttribute(Identifier<IAttribute> attributeId, Object value) {
        if (attributeId != null && value != null) {
            this.fAttributes.put(attributeId, value);
        }
    }

    @Override
    public Set<Identifier<IAttribute>> getAttributes() {
        Set<Identifier<IAttribute>> attrs = this.fAttributes.keySet();
        return attrs != null ? new HashSet<Identifier<IAttribute>>(attrs) : Collections.emptySet();
    }

    @Override
    public Object getValue(Identifier<IAttribute> handle) {
        return this.fAttributes.get(handle);
    }

    public void addLink(Identifier<ILink> linkId, String resourceName, String resourceUrl) {
        if (!this.fLinks.containsKey(linkId)) {
            this.fLinks.put(linkId, new HashSet());
        }
        URI resourceUri = URI.create(resourceUrl);
        IURIReference reference = IReferenceFactory.INSTANCE.createReferenceFromURI(resourceUri, resourceName);
        this.fLinks.get(linkId).add(reference);
    }

    @Override
    public Map<Identifier<ILink>, Set<IURIReference>> getLinks() {
        return Collections.unmodifiableMap(this.fLinks);
    }

    public void addApprovalDescriptor(IWorkItemDescriptor.IApprovalDescriptor approval) {
        this.fApprovals.add(approval);
    }

    @Override
    public List<IWorkItemDescriptor.IApprovalDescriptor> getApprovalDescriptors() {
        return Collections.unmodifiableList(this.fApprovals);
    }

    public void addComment(IWorkItemDescriptor.IComment comment) {
        this.fComments.add(comment);
    }

    @Override
    public List<IWorkItemDescriptor.IComment> getComments() {
        return Collections.unmodifiableList(this.fComments);
    }

    @Override
    public int size() {
        return this.fAttributes.size() + this.fLinks.size() + this.fApprovals.size() + (this.fComments.isEmpty() ? 0 : 1);
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.fAttributes == null ? 0 : this.fAttributes.hashCode()) + (this.fLinks == null ? 0 : this.fLinks.hashCode()) + (this.fApprovals == null ? 0 : this.fApprovals.hashCode()) + (this.fComments == null ? 0 : this.fComments.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        WorkItemDescriptor other = (WorkItemDescriptor)obj;
        if (this.fAttributes == null ? other.fAttributes != null : !this.fAttributes.equals(other.fAttributes)) {
            return false;
        }
        if (this.fLinks == null ? other.fLinks != null : !this.fLinks.equals(other.fLinks)) {
            return false;
        }
        if (this.fApprovals == null ? other.fApprovals != null : !this.fApprovals.equals(other.fApprovals)) {
            return false;
        }
        return !(this.fComments == null ? other.fComments != null : !this.fComments.equals(other.fComments));
    }

    public static class Approval
    implements IWorkItemDescriptor.IApproval {
        private final String fApprover;
        private final String fState;

        public Approval(String approver, String state) {
            this.fApprover = approver;
            this.fState = state;
        }

        @Override
        public String getApprover() {
            return this.fApprover;
        }

        @Override
        public String getState() {
            return this.fState;
        }
    }

    public static class ApprovalDescriptor
    implements IWorkItemDescriptor.IApprovalDescriptor {
        private final String fName;
        private final String fType;
        private List<IWorkItemDescriptor.IApproval> fApprovals = new ArrayList<IWorkItemDescriptor.IApproval>();
        private String fDueDate;

        public ApprovalDescriptor(String name, String type) {
            this(name, type, null);
        }

        public ApprovalDescriptor(String name, String type, String dueData) {
            this.fName = name;
            this.fType = type;
            this.fDueDate = dueData;
        }

        public void setApprovals(List<IWorkItemDescriptor.IApproval> approvals) {
            this.fApprovals = approvals;
        }

        @Override
        public List<IWorkItemDescriptor.IApproval> getApprovals() {
            return Collections.unmodifiableList(this.fApprovals);
        }

        public void setDueDate(String date) {
            this.fDueDate = date;
        }

        @Override
        public String getDueDate() {
            return this.fDueDate;
        }

        @Override
        public String getName() {
            return this.fName;
        }

        @Override
        public String getType() {
            return this.fType;
        }
    }

    public static class Comment
    implements IWorkItemDescriptor.IComment {
        private final String fCreator;
        private final String fContent;

        public Comment(String creator, String content) {
            this.fCreator = creator;
            this.fContent = content;
        }

        @Override
        public String getCreator() {
            return this.fCreator;
        }

        @Override
        public String getContent() {
            return this.fContent;
        }
    }
}

