/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.common.internal.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class CollectionUtils {
    public static <T> List<T> removeNulls(List<T> toFilter) {
        boolean hasNulls = false;
        Iterator<T> iter = toFilter.iterator();
        while (iter.hasNext() && !hasNulls) {
            T next = iter.next();
            if (next != null) continue;
            hasNulls = true;
        }
        if (!hasNulls) {
            return toFilter;
        }
        ArrayList<T> result = new ArrayList<T>();
        for (T next : toFilter) {
            if (next == null) continue;
            result.add(next);
        }
        return result;
    }

    public static <T> boolean contains(T[] array, T value) {
        if (value != null) {
            T[] TArray = array;
            int n = array.length;
            int n2 = 0;
            while (n2 < n) {
                T t = TArray[n2];
                if (value.equals(t)) {
                    return true;
                }
                ++n2;
            }
        } else {
            T[] TArray = array;
            int n = array.length;
            int n3 = 0;
            while (n3 < n) {
                T t = TArray[n3];
                if (t == null) {
                    return true;
                }
                ++n3;
            }
        }
        return false;
    }

    public static <T> boolean containsOne(Set<T> collection, T[] values) {
        T[] TArray = values;
        int n = values.length;
        int n2 = 0;
        while (n2 < n) {
            T value = TArray[n2];
            if (collection.contains(value)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static String join(Collection<String> strings, String separator) {
        StringBuffer buffer = new StringBuffer();
        Iterator<String> iterator = strings.iterator();
        while (iterator.hasNext()) {
            buffer.append(iterator.next());
            buffer.append(iterator.hasNext() ? separator : "");
        }
        return buffer.toString();
    }

    public static <E, R> List<R> map(List<E> list, IMapping<E, R> mapping) {
        return CollectionUtils.map(list, mapping, false);
    }

    public static <E, R> List<R> map(List<E> list, IMapping<E, R> mapping, boolean ignoreNull) {
        ArrayList<R> result = new ArrayList<R>();
        Iterator<E> iter = list.iterator();
        while (iter.hasNext()) {
            R value = mapping.map(iter.next());
            if (value == null && ignoreNull) continue;
            result.add(value);
        }
        return result;
    }

    public static class ArrayListMultiMap<K, V>
    implements ListMultiMap<K, V> {
        private final Equalizer<V> fValueEqualizer;
        private final Map<K, List<V>> fMap = new HashMap<K, List<V>>();

        public static <K, V> ArrayListMultiMap<K, V> create() {
            return new ArrayListMultiMap<K, V>();
        }

        public static <K, V> ArrayListMultiMap<K, V> createWithValueEqualizer(Equalizer<V> valueEqualizer) {
            return new ArrayListMultiMap<K, V>(valueEqualizer);
        }

        public ArrayListMultiMap() {
            this(null);
        }

        public ArrayListMultiMap(Equalizer<V> valueEqualizer) {
            this.fValueEqualizer = valueEqualizer;
        }

        @Override
        public void put(K k, V v) {
            List<V> values = this.fMap.get(k);
            if (values == null) {
                values = new ArrayList<V>();
                this.fMap.put(k, values);
            }
            values.add(v);
        }

        @Override
        public void putAll(K k, List<V> v) {
            List<V> values = this.fMap.get(k);
            if (values == null) {
                values = new ArrayList<V>();
                this.fMap.put(k, values);
            }
            values.addAll(v);
        }

        @Override
        public void remove(K k, V v) {
            List<V> values = this.fMap.get(k);
            if (values != null) {
                values.remove(v);
                if (values.isEmpty()) {
                    this.fMap.remove(k);
                }
            }
        }

        @Override
        public void removeAll(K k) {
            this.fMap.remove(k);
        }

        @Override
        public List<V> get(K k) {
            List<V> values = this.fMap.get(k);
            return values == null ? Collections.emptyList() : values;
        }

        @Override
        public boolean isEmpty() {
            return this.fMap.isEmpty();
        }

        @Override
        public int size() {
            return this.fMap.size();
        }

        @Override
        public boolean containsKey(K k) {
            return this.fMap.containsKey(k);
        }

        @Override
        public List<V> values() {
            ArrayList<V> result = new ArrayList<V>();
            Set<K> keySet = this.fMap.keySet();
            for (K k : keySet) {
                result.addAll(this.get(k));
            }
            return result;
        }

        @Override
        public boolean containsValue(K k, V v) {
            List<V> values = this.get(k);
            if (this.fValueEqualizer == null) {
                if (values.contains(v)) {
                    return true;
                }
            } else {
                for (V eachValue : values) {
                    if (!this.fValueEqualizer.areEqual(eachValue, v)) continue;
                    return true;
                }
            }
            return false;
        }

        @Override
        public boolean containsValue(V v) {
            Set<K> keySet = this.fMap.keySet();
            for (K k : keySet) {
                if (!this.containsValue(k, v)) continue;
                return true;
            }
            return false;
        }

        @Override
        public Set<K> keySet() {
            return this.fMap.keySet();
        }

        @Override
        public void putIfAbsent(K k, V v) {
            if (!this.containsValue(k, v)) {
                this.put(k, v);
            }
        }
    }

    public static interface Equalizer<V> {
        public boolean areEqual(V var1, V var2);
    }

    public static interface IMapping<E, R> {
        public R map(E var1);
    }

    public static interface ListMultiMap<K, V> {
        public void put(K var1, V var2);

        public void putIfAbsent(K var1, V var2);

        public void putAll(K var1, List<V> var2);

        public void remove(K var1, V var2);

        public void removeAll(K var1);

        public List<V> get(K var1);

        public boolean isEmpty();

        public int size();

        public boolean containsKey(K var1);

        public boolean containsValue(V var1);

        public boolean containsValue(K var1, V var2);

        public List<V> values();

        public Set<K> keySet();
    }
}

