/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.internal.repository.rcp.streams;

import com.ibm.team.internal.repository.rcp.streams.UnsynchronizedByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class OutputStreamFilterInputStream
extends InputStream {
    private static final String STREAM_IS_CLOSED = "OutputStreamFilterInputStream is closed";
    private InputStream in;
    private UnsynchronizedByteArrayOutputStream buffer;
    private OutputStream out;
    private int posn;
    private byte[] buf;

    public OutputStreamFilterInputStream(InputStream in, OutputStream out, UnsynchronizedByteArrayOutputStream sync) {
        if (in == null) {
            throw new IllegalArgumentException();
        }
        if (out == null) {
            throw new IllegalArgumentException();
        }
        if (sync == null) {
            throw new IllegalArgumentException();
        }
        this.in = in;
        this.buffer = sync;
        this.out = out;
        this.buf = new byte[8192];
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public int read() throws IOException {
        if (this.in != null) ** GOTO lbl12
        throw new IOException("OutputStreamFilterInputStream is closed");
lbl-1000:
        // 1 sources

        {
            if (this.out == null) {
                return -1;
            }
            read = this.in.read();
            if (read == -1) {
                this.out.close();
                this.out = null;
                continue;
            }
            this.out.write(read);
            this.out.flush();
lbl12:
            // 3 sources

            ** while ((size = this.buffer.size()) == 0)
        }
lbl13:
        // 1 sources

        result = this.buffer.getBuffer()[this.posn];
        ++this.posn;
        if (this.posn == size) {
            this.buffer.reset();
            this.posn = 0;
        }
        return result & 255;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        if (b == null) {
            throw new NullPointerException();
        }
        if (off < 0 || off > b.length || len < 0 || off + len > b.length || off + len < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (len == 0) {
            return 0;
        }
        if (this.in != null) ** GOTO lbl18
        throw new IOException("OutputStreamFilterInputStream is closed");
lbl-1000:
        // 1 sources

        {
            if (this.out == null) {
                return -1;
            }
            read = this.in.read(this.buf);
            if (read == -1) {
                this.out.close();
                this.out = null;
                continue;
            }
            this.out.write(this.buf, 0, read);
            this.out.flush();
lbl18:
            // 3 sources

            ** while ((size = this.buffer.size()) == 0)
        }
lbl19:
        // 1 sources

        len = Math.min(len, size - this.posn);
        System.arraycopy(this.buffer.getBuffer(), this.posn, b, off, len);
        this.posn += len;
        if (this.posn == size) {
            this.buffer.reset();
            this.posn = 0;
        }
        return len;
    }

    @Override
    public int available() throws IOException {
        if (this.in == null) {
            throw new IOException(STREAM_IS_CLOSED);
        }
        return this.buffer.size() - this.posn + (this.in.available() > 0 ? 1 : 0);
    }

    @Override
    public boolean markSupported() {
        return false;
    }

    @Override
    public void close() throws IOException {
        if (this.in != null) {
            this.buffer = null;
            this.buf = null;
            if (this.out != null) {
                this.out.close();
                this.out = null;
            }
            this.in.close();
            this.in = null;
        }
    }

    @Override
    public long skip(long n) throws IOException {
        if (this.in == null) {
            throw new IOException(STREAM_IS_CLOSED);
        }
        long skipped = 0L;
        if (n <= 0L) {
            return 0L;
        }
        while (true) {
            int size;
            int len;
            if ((long)(len = (size = this.buffer.size()) - this.posn) >= n) {
                if ((long)len == n) {
                    this.buffer.reset();
                    this.posn = 0;
                } else {
                    this.posn = (int)((long)this.posn + n);
                }
                return skipped += n;
            }
            this.buffer.reset();
            this.posn = 0;
            skipped += (long)len;
            n -= (long)len;
            if (this.out == null) {
                return skipped;
            }
            int read = this.in.read(this.buf);
            if (read == -1) {
                this.out.close();
                this.out = null;
                continue;
            }
            this.out.write(this.buf, 0, read);
            this.out.flush();
        }
    }
}

