/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.internal.repository.rcp.util;

import java.util.Arrays;

public class StringCoder {
    static final char[] digits = new char[]{'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '-', '_'};
    static final int[] inverse_map = new int[128];

    static {
        Arrays.fill(inverse_map, -1);
        int i = digits.length;
        while (i != 0) {
            StringCoder.inverse_map[StringCoder.digits[--i]] = i;
        }
    }

    public static String encode(byte[] data) {
        int j;
        if (data == null) {
            throw new IllegalArgumentException();
        }
        int sourceChunks = data.length / 3;
        int len = (data.length * 4 + 2) / 3;
        char[] result = new char[len];
        int dataIndex = 0;
        int resultIndex = 0;
        int allBits = 0;
        int i = 0;
        while (i < sourceChunks) {
            allBits = 0;
            j = 3;
            while (j != 0) {
                allBits = allBits << 8 | data[dataIndex++] & 0xFF;
                --j;
            }
            j = resultIndex + 3;
            while (j >= resultIndex) {
                result[j] = digits[allBits & 0x3F];
                allBits >>>= 6;
                --j;
            }
            resultIndex += 4;
            ++i;
        }
        int extraBytes = data.length - dataIndex;
        switch (extraBytes) {
            case 1: {
                allBits = data[dataIndex++];
                allBits <<= 4;
                j = resultIndex + 1;
                while (j >= resultIndex) {
                    result[j] = digits[allBits & 0x3F];
                    allBits >>>= 6;
                    --j;
                }
                break;
            }
            case 2: {
                allBits = data[dataIndex++];
                allBits = allBits << 8 | data[dataIndex++] & 0xFF;
                allBits <<= 2;
                j = resultIndex + 2;
                while (j >= resultIndex) {
                    result[j] = digits[allBits & 0x3F];
                    allBits >>>= 6;
                    --j;
                }
                break;
            }
        }
        return new String(result);
    }

    public static boolean isValidCode(String code) {
        if (code == null) {
            throw new IllegalArgumentException();
        }
        char[] chars = code.toCharArray();
        int max = inverse_map.length;
        int len = chars.length;
        int extra_chars = len % 4;
        int checked_chars = 0;
        switch (extra_chars) {
            case 0: {
                break;
            }
            case 1: {
                return false;
            }
            case 2: {
                char c = chars[len - 1];
                if (c >= max) {
                    return false;
                }
                int inverse_value = inverse_map[c];
                if ((inverse_value & 0xF) != 0) {
                    return false;
                }
                checked_chars = 1;
                break;
            }
            case 3: {
                char c = chars[len - 1];
                if (c >= max) {
                    return false;
                }
                int inverse_value = inverse_map[c];
                if ((inverse_value & 3) != 0) {
                    return false;
                }
                checked_chars = 1;
            }
        }
        int i = len - checked_chars;
        while (i != 0) {
            char c;
            if ((c = chars[--i]) >= max) {
                return false;
            }
            if (inverse_map[c] != -1) continue;
            return false;
        }
        return true;
    }

    public static byte[] decode(String code) {
        byte[] result;
        if (code == null) {
            throw new IllegalArgumentException();
        }
        char[] chars = code.toCharArray();
        int MAX_VALUE = inverse_map.length;
        int len = chars.length;
        int extra_chars = len % 4;
        int decoded_len = (len - extra_chars) / 4 * 3;
        switch (extra_chars) {
            case 0: {
                result = new byte[decoded_len];
                break;
            }
            case 1: {
                throw new IllegalArgumentException();
            }
            case 2: {
                ++decoded_len;
                char c1 = chars[len - 2];
                char c2 = chars[len - 1];
                if (c1 >= MAX_VALUE || c2 >= MAX_VALUE) {
                    throw new IllegalArgumentException();
                }
                int v1 = inverse_map[c1];
                int v2 = inverse_map[c2];
                if (v1 == -1) {
                    throw new IllegalArgumentException();
                }
                int inverse_value = v1 << 6 | v2;
                if ((inverse_value & 0xF) != 0) {
                    throw new IllegalArgumentException();
                }
                result = new byte[decoded_len];
                result[decoded_len - 1] = (byte)(inverse_value >>= 4);
                break;
            }
            case 3: {
                decoded_len += 2;
                char c1 = chars[len - 3];
                char c2 = chars[len - 2];
                char c3 = chars[len - 1];
                if (c1 >= MAX_VALUE || c2 >= MAX_VALUE || c3 >= MAX_VALUE) {
                    throw new IllegalArgumentException();
                }
                int v1 = inverse_map[c1];
                int v2 = inverse_map[c2];
                int v3 = inverse_map[c3];
                if (v1 == -1 || v2 == -1) {
                    throw new IllegalArgumentException();
                }
                int inverse_value = v1 << 12 | v2 << 6 | v3;
                if ((inverse_value & 3) != 0) {
                    throw new IllegalArgumentException();
                }
                result = new byte[decoded_len];
                result[decoded_len - 1] = (byte)(inverse_value >>= 2);
                result[decoded_len - 2] = (byte)(inverse_value >>= 8);
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        int top = len - extra_chars;
        int j = -4;
        int i = 0;
        while (i < top) {
            int inverse_value = 0;
            int k = 4;
            while (k != 0) {
                char c = chars[i];
                ++i;
                if (c >= MAX_VALUE) {
                    throw new IllegalArgumentException();
                }
                int v = inverse_map[c];
                if (v == -1) {
                    throw new IllegalArgumentException();
                }
                inverse_value = inverse_value << 6 | v;
                --k;
            }
            j += 6;
            k = 3;
            while (k != 0) {
                result[j] = (byte)inverse_value;
                inverse_value >>= 8;
                --j;
                --k;
            }
        }
        return result;
    }
}

