/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.process.internal.common.util;

import com.ibm.team.process.common.IBehaviorConfiguration;
import com.ibm.team.process.common.IDevelopmentLine;
import com.ibm.team.process.common.IIterationConfiguration;
import com.ibm.team.process.common.IIterationType;
import com.ibm.team.process.common.IProcessArea;
import com.ibm.team.process.common.IProcessAreaHandle;
import com.ibm.team.process.common.IProcessAttachment;
import com.ibm.team.process.common.IProcessAttachmentHandle;
import com.ibm.team.process.common.IProcessConfigurationData;
import com.ibm.team.process.common.IProcessContainer;
import com.ibm.team.process.common.IProcessContainerHandle;
import com.ibm.team.process.common.IProjectArea;
import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.process.common.IRole;
import com.ibm.team.process.common.IRole2;
import com.ibm.team.process.common.ISimpleMap;
import com.ibm.team.process.common.ITeamArea;
import com.ibm.team.process.common.ITeamAreaHandle;
import com.ibm.team.process.common.ITeamAreaHierarchy;
import com.ibm.team.process.common.advice.AdvisableOperation;
import com.ibm.team.process.common.advice.IAdvisorDeclaration;
import com.ibm.team.process.common.advice.IOperationReport;
import com.ibm.team.process.common.advice.IParticipantDeclaration;
import com.ibm.team.process.common.advice.ProjectOperation;
import com.ibm.team.process.internal.common.CurrentIterationInfo;
import com.ibm.team.process.internal.common.IProcessProviderCacheItemHandle;
import com.ibm.team.process.internal.common.ItemHandleAwareHashMap;
import com.ibm.team.process.internal.common.ItemHandleAwareHashSet;
import com.ibm.team.process.internal.common.ProjectArea;
import com.ibm.team.process.internal.common.advice.AdvicePackage;
import com.ibm.team.process.internal.common.advice.ConfigurationSource;
import com.ibm.team.process.internal.common.advice.PermissionSource;
import com.ibm.team.process.internal.common.advice.runtime.IDynamicActionProviderInitializer;
import com.ibm.team.process.internal.common.advice.runtime.ILicenseChecker;
import com.ibm.team.process.internal.common.advice.runtime.OperationAdviceManager;
import com.ibm.team.process.internal.common.enterprise.IProcessProvider;
import com.ibm.team.process.internal.common.model.ElementBuilderDirectives;
import com.ibm.team.process.internal.common.model.ModelGenerator;
import com.ibm.team.process.internal.common.model.customization.IterationTypeConfiguration;
import com.ibm.team.process.internal.common.model.customization.TeamCustomizationModel;
import com.ibm.team.process.internal.common.model.settings.BehaviorElement;
import com.ibm.team.process.internal.common.model.settings.BehaviorRoleElement;
import com.ibm.team.process.internal.common.model.settings.ChangeEventConfiguration;
import com.ibm.team.process.internal.common.model.settings.IterationConfiguration;
import com.ibm.team.process.internal.common.model.settings.OperationBehaviorConfiguration;
import com.ibm.team.process.internal.common.model.settings.OperationConfiguration;
import com.ibm.team.process.internal.common.model.settings.OperationPermissionsConfiguration;
import com.ibm.team.process.internal.common.model.settings.PermissionActionElement;
import com.ibm.team.process.internal.common.model.settings.PermissionsElement;
import com.ibm.team.process.internal.common.model.settings.PermissionsRoleElement;
import com.ibm.team.process.internal.common.model.settings.ProcessConfiguration;
import com.ibm.team.process.internal.common.model.specification.ConfigurationDataDeltaElement;
import com.ibm.team.process.internal.common.model.specification.ConfigurationDataElement;
import com.ibm.team.process.internal.common.model.specification.DataElement;
import com.ibm.team.process.internal.common.model.specification.DevelopmentLineConfiguration;
import com.ibm.team.process.internal.common.model.specification.InitializationElement;
import com.ibm.team.process.internal.common.model.specification.ProcessSpecificationModel;
import com.ibm.team.process.internal.common.model.specification.ProjectConfigurationElement;
import com.ibm.team.process.internal.common.model.specification.TeamConfigurationElement;
import com.ibm.team.process.internal.common.util.Messages;
import com.ibm.team.process.internal.common.util.ProcessAttachmentFilePathComparator;
import com.ibm.team.process.internal.common.util.ProcessDelta;
import com.ibm.team.process.internal.common.util.ProcessModelCache;
import com.ibm.team.repository.common.IContent;
import com.ibm.team.repository.common.IContributorHandle;
import com.ibm.team.repository.common.IItem;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.LicenseNotGrantedException;
import com.ibm.team.repository.common.TeamRepositoryException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;

public abstract class AbstractProcess {
    public static final String ID_ENFORCE_PROCESS_PERMISSIONS = "com.ibm.team.process.enforceProcessPermissions";
    private static final int PERMISSIONS_TYPE = 0;
    private static final int BEHAVIOR_TYPE = 1;
    private static final int CHANGE_EVENT_TYPE = 2;
    protected IProjectArea fProjectArea;
    protected static final HashSet fgInitializingThreads = new HashSet();
    private ProcessModelCache fModelCache;
    public static final IRole fgDefaultRole = new IRole2(){

        @Override
        public String getId() {
            return "default";
        }

        @Override
        public String getDescription() {
            return Messages.getCommonString("AbstractProcess.0");
        }

        @Override
        public int getCardinality() {
            return 0;
        }

        @Override
        public String getRoleName() {
            return Messages.getCommonString("AbstractProcess.13");
        }

        @Override
        public String getRoleLabel() {
            String label = this.getRoleName();
            if (label != null && label.trim().length() > 0) {
                return label;
            }
            return this.getId();
        }

        public boolean equals(Object other) {
            if (other instanceof IRole) {
                return this.getId().equals(((IRole)other).getId());
            }
            return false;
        }

        public int hashCode() {
            return this.getId().hashCode();
        }
    };

    protected AbstractProcess(IProjectArea projectArea, ProcessModelCache modelCache) {
        this.fProjectArea = projectArea;
        this.fModelCache = modelCache;
    }

    protected abstract String createStringFromContent(IContent var1, IProgressMonitor var2) throws TeamRepositoryException;

    protected abstract IContributorHandle getContributor();

    protected abstract CurrentIterationInfo[] getCurrentIterationInfos(IDevelopmentLine var1, IProgressMonitor var2) throws TeamRepositoryException;

    protected abstract IItem fetchCompleteItem(IItemHandle var1, IProgressMonitor var2) throws TeamRepositoryException;

    protected abstract IDevelopmentLine getDevelopmentLine(IProcessArea var1, IProgressMonitor var2) throws TeamRepositoryException;

    protected abstract OperationAdviceManager getOperationAdviceManager();

    protected abstract ILicenseChecker getLicenseChecker();

    protected abstract IProcessAttachment doGetProcessAttachment(IProcessContainer var1, String var2, IProgressMonitor var3) throws TeamRepositoryException;

    protected abstract IItem[] fetchCompleteItems(IItemHandle[] var1, IProgressMonitor var2) throws TeamRepositoryException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IOperationReport executeInitializer(ProjectOperation initializer, IProgressMonitor monitor) throws TeamRepositoryException {
        HashSet hashSet;
        IOperationReport iOperationReport;
        monitor = this.getProgressMonitor(monitor);
        this.assertSameProjectArea(initializer.getProcessArea());
        monitor.beginTask("", 1000);
        try {
            OperationBehaviorConfiguration behavior = this.getInitializationBehaviorConfiguration(initializer.getOperationIdentifier(), (IProgressMonitor)new SubProgressMonitor(monitor, 50));
            ItemHandleAwareHashMap permissions = new ItemHandleAwareHashMap();
            HashSet hashSet2 = fgInitializingThreads;
            synchronized (hashSet2) {
                fgInitializingThreads.add(Thread.currentThread());
            }
            iOperationReport = this.getOperationAdviceManager().advise(initializer, 1, permissions, behavior, null, this.getLicenseChecker(), this.getDynamicActionInitializer(), (IProgressMonitor)new SubProgressMonitor(monitor, 950));
            hashSet = fgInitializingThreads;
        }
        catch (Throwable throwable) {
            HashSet hashSet3 = fgInitializingThreads;
            synchronized (hashSet3) {
                fgInitializingThreads.remove(Thread.currentThread());
            }
            monitor.done();
            throw throwable;
        }
        synchronized (hashSet) {
            fgInitializingThreads.remove(Thread.currentThread());
        }
        monitor.done();
        return iOperationReport;
    }

    public IOperationReport advise(AdvisableOperation operation, IProgressMonitor monitor) throws TeamRepositoryException {
        return this.doAdvise(operation, 0, null, monitor);
    }

    public IOperationReport adviseAndExecute(AdvisableOperation operation, IProgressMonitor monitor) throws TeamRepositoryException {
        return this.doAdvise(operation, 1, null, monitor);
    }

    protected IOperationReport doAdvise(AdvisableOperation operation, int mode, IOperationReport oldReport, IProgressMonitor monitor) throws TeamRepositoryException {
        monitor = this.getProgressMonitor(monitor);
        this.assertSameProjectArea(operation.getProcessArea());
        monitor.beginTask("", 1000);
        try {
            IDevelopmentLine line = this.getOperationDevelopmentLine(operation.getProcessArea(), operation.getDevelopmentLine(), (IProgressMonitor)new SubProgressMonitor(monitor, 25));
            operation.setDevelopmentLine(line);
            ISimpleMap permissions = this.getPermissionsMap(operation, (IProgressMonitor)new SubProgressMonitor(monitor, 25));
            OperationBehaviorConfiguration behavior = this.getBehaviorConfiguration(operation, (IProgressMonitor)new SubProgressMonitor(monitor, 25));
            IOperationReport iOperationReport = this.getOperationAdviceManager().advise(operation, mode, permissions, behavior, oldReport, this.getLicenseChecker(), this.getDynamicActionInitializer(), (IProgressMonitor)new SubProgressMonitor(monitor, 925));
            return iOperationReport;
        }
        finally {
            monitor.done();
        }
    }

    protected abstract IDynamicActionProviderInitializer getDynamicActionInitializer();

    public IAdvisorDeclaration[] getAdvisorDeclarations(IBehaviorConfiguration configuration) {
        if (configuration instanceof OperationBehaviorConfiguration) {
            return this.getOperationAdviceManager().getAdvisorDeclarations((OperationBehaviorConfiguration)configuration);
        }
        return new IAdvisorDeclaration[0];
    }

    public IAdvisorDeclaration[] getAdvisorDeclarations(IProcessArea processArea, String operationId, IProgressMonitor monitor) throws TeamRepositoryException {
        monitor = this.getProgressMonitor(monitor);
        monitor.beginTask("", 1000);
        try {
            IDevelopmentLine line = this.getDevelopmentLine(processArea, (IProgressMonitor)new SubProgressMonitor(monitor, 100));
            OperationBehaviorConfiguration behaviorConfiguration = this.getBehaviorConfiguration(processArea, line, operationId, (IProgressMonitor)new SubProgressMonitor(monitor, 900));
            IAdvisorDeclaration[] iAdvisorDeclarationArray = this.getAdvisorDeclarations(behaviorConfiguration);
            return iAdvisorDeclarationArray;
        }
        finally {
            monitor.done();
        }
    }

    public IAdvisorDeclaration[] getAdvisorDeclarations(String projectOperationId, IProgressMonitor monitor) throws TeamRepositoryException {
        OperationBehaviorConfiguration behaviorConfiguration = this.getStaticBehaviorConfiguration(this.fProjectArea, projectOperationId, monitor);
        return this.getAdvisorDeclarations(behaviorConfiguration);
    }

    public IParticipantDeclaration[] getParticipantDeclarations(IBehaviorConfiguration configuration) {
        if (configuration instanceof OperationBehaviorConfiguration) {
            return this.getOperationAdviceManager().getParticipantDeclarations((OperationBehaviorConfiguration)configuration);
        }
        return new IParticipantDeclaration[0];
    }

    public IParticipantDeclaration[] getParticipantDeclarations(IProcessArea processArea, String operationId, IProgressMonitor monitor) throws TeamRepositoryException {
        monitor = this.getProgressMonitor(monitor);
        monitor.beginTask("", 1000);
        try {
            IDevelopmentLine line = this.getDevelopmentLine(processArea, (IProgressMonitor)new SubProgressMonitor(monitor, 100));
            OperationBehaviorConfiguration behaviorConfiguration = this.getBehaviorConfiguration(processArea, line, operationId, (IProgressMonitor)new SubProgressMonitor(monitor, 900));
            IParticipantDeclaration[] iParticipantDeclarationArray = this.getParticipantDeclarations(behaviorConfiguration);
            return iParticipantDeclarationArray;
        }
        finally {
            monitor.done();
        }
    }

    public boolean[] getPermittedActions(IProcessArea processArea, String operationId, String[] actions, IProgressMonitor monitor) throws TeamRepositoryException {
        monitor = this.getProgressMonitor(monitor);
        List<String> actionList = Arrays.asList(actions);
        IDevelopmentLine line = this.getDevelopmentLine(processArea, (IProgressMonitor)new SubProgressMonitor(monitor, 100));
        boolean[] permitted = new boolean[actions.length];
        HashSet permittedActions = new HashSet();
        OperationPermissionsConfiguration[] permissionConfigs = this.getPermissionConfigurations(processArea, line, operationId, actions, (IProgressMonitor)new SubProgressMonitor(monitor, 900));
        if (permissionConfigs != null) {
            int i = 0;
            while (i < permissionConfigs.length && permittedActions.size() < actions.length) {
                OperationPermissionsConfiguration config = permissionConfigs[i];
                permittedActions.addAll(this.getPermittedActions(actionList, config));
                ++i;
            }
            i = 0;
            while (i < actions.length) {
                permitted[i] = permittedActions.contains(actions[i]);
                ++i;
            }
        }
        return permitted;
    }

    public boolean[] getPermittedActions(String projectOperationId, String[] actions, IProgressMonitor monitor) throws TeamRepositoryException {
        monitor = this.getProgressMonitor(monitor);
        List<String> actionList = Arrays.asList(actions);
        boolean[] permitted = new boolean[actions.length];
        HashSet permittedActions = new HashSet();
        OperationPermissionsConfiguration[] permissionConfigs = this.getStaticPermissionConfigurations(this.fProjectArea, projectOperationId, actions, monitor);
        if (permissionConfigs != null) {
            int i = 0;
            while (i < permissionConfigs.length && permittedActions.size() < actions.length) {
                OperationPermissionsConfiguration config = permissionConfigs[i];
                permittedActions.addAll(this.getPermittedActions(actionList, config));
                ++i;
            }
            i = 0;
            while (i < actions.length) {
                permitted[i] = permittedActions.contains(actions[i]);
                ++i;
            }
        }
        return permitted;
    }

    protected ISimpleMap getPermissionsMap(AdvisableOperation operation, IProgressMonitor monitor) throws TeamRepositoryException {
        monitor = this.getProgressMonitor(monitor);
        monitor.beginTask("", 1000);
        try {
            ItemHandleAwareHashMap permissions = new ItemHandleAwareHashMap();
            IProcessArea primaryArea = operation.getProcessArea();
            String operationId = operation.getOperationIdentifier();
            OperationPermissionsConfiguration[] permissionConfigs = operation instanceof ProjectOperation ? this.getStaticPermissionConfigurations((IProjectArea)operation.getProcessArea(), operation.getOperationIdentifier(), operation.getActions(), (IProgressMonitor)new SubProgressMonitor(monitor, 500)) : this.getPermissionConfigurations(primaryArea, operation.getDevelopmentLine(), operationId, operation.getActions(), (IProgressMonitor)new SubProgressMonitor(monitor, 250));
            if (permissionConfigs != null) {
                permissions.put(primaryArea, permissionConfigs);
            }
            IProcessArea[] secondaryAreas = operation.getSecondaryProcessAreas();
            SubProgressMonitor secondaryMonitor = new SubProgressMonitor(monitor, 500);
            secondaryMonitor.beginTask("", 1000 * secondaryAreas.length);
            int i = 0;
            while (i < secondaryAreas.length) {
                IProcessArea secondaryArea = secondaryAreas[i];
                this.assertSameProjectArea(secondaryArea);
                String[] secondaryActions = operation.getSecondaryActions(secondaryArea);
                IDevelopmentLine secondaryLine = this.getOperationDevelopmentLine(secondaryArea, operation.getSecondaryDevelopmentLine(secondaryArea), (IProgressMonitor)new SubProgressMonitor((IProgressMonitor)secondaryMonitor, 250));
                permissionConfigs = this.getPermissionConfigurations(secondaryArea, secondaryLine, operationId, secondaryActions, (IProgressMonitor)new SubProgressMonitor((IProgressMonitor)secondaryMonitor, 750));
                if (permissionConfigs != null) {
                    permissions.put(secondaryArea, permissionConfigs);
                }
                ++i;
            }
            ItemHandleAwareHashMap itemHandleAwareHashMap = permissions;
            return itemHandleAwareHashMap;
        }
        finally {
            monitor.done();
        }
    }

    public IProcessConfigurationData getProjectConfigurationData(String configPointId, IProgressMonitor monitor) throws TeamRepositoryException {
        monitor = this.getProgressMonitor(monitor);
        monitor.beginTask("", 1000);
        try {
            this.fProjectArea = (IProjectArea)this.fetchCompleteItem((IItemHandle)this.getProjectArea(), (IProgressMonitor)new SubProgressMonitor(monitor, 200));
            IProcessProvider processProvider = this.getProcessProvider(this.fProjectArea, (IProgressMonitor)new SubProgressMonitor(monitor, 200));
            ConfigurationDataElement providerData = null;
            ConfigurationDataDeltaElement providerDelta = null;
            if (processProvider != null) {
                providerData = this.getProjectConfigurationData(processProvider, configPointId, (IProgressMonitor)new SubProgressMonitor(monitor, 100));
                providerDelta = this.getProjectConfigurationDataDelta(processProvider, configPointId, (IProgressMonitor)new SubProgressMonitor(monitor, 100));
            } else {
                monitor.worked(200);
            }
            ConfigurationDataElement consumerData = this.getProjectConfigurationData(this.fProjectArea, configPointId, (IProgressMonitor)new SubProgressMonitor(monitor, 200));
            ConfigurationDataDeltaElement consumerDelta = this.getProjectConfigurationDataDelta(this.fProjectArea, configPointId, (IProgressMonitor)new SubProgressMonitor(monitor, 200));
            this.startLoggingDeltaConfigMerge(consumerDelta);
            ConfigurationDataElement effectiveConfigurationData = ProcessDelta.computeEffectiveConfigurationData(providerData, providerDelta, consumerData, consumerDelta);
            this.finishLoggingDeltaConfigMerge(consumerDelta);
            ConfigurationDataElement configurationDataElement = effectiveConfigurationData;
            return configurationDataElement;
        }
        finally {
            monitor.done();
        }
    }

    protected void startLoggingDeltaConfigMerge(ConfigurationDataDeltaElement consumerDelta) {
    }

    protected void finishLoggingDeltaConfigMerge(ConfigurationDataDeltaElement consumerDelta) {
    }

    protected ConfigurationDataDeltaElement getProjectConfigurationDataDelta(IProcessContainer processContainer, String configPointId, IProgressMonitor monitor) throws TeamRepositoryException {
        DataElement data;
        ProcessSpecificationModel model;
        ProjectConfigurationElement projectConfiguration;
        IContent content = (IContent)processContainer.getProcessData().get("com.ibm.team.internal.process.40.compiled.xml");
        if (content != null && (projectConfiguration = (model = this.getSpecificationModel(processContainer, content, null, null, monitor)).getProjectConfiguration()) != null && (data = projectConfiguration.getData()) != null) {
            ConfigurationDataDeltaElement[] configurations = data.getConfigurationDataDeltas();
            int i = 0;
            while (i < configurations.length) {
                ConfigurationDataDeltaElement delta = configurations[i];
                if (configPointId.equals(delta.getConfigurationDataId())) {
                    return delta;
                }
                ++i;
            }
        }
        return null;
    }

    protected ConfigurationDataElement getProjectConfigurationData(IProcessContainer processContainer, String configPointId, IProgressMonitor monitor) throws TeamRepositoryException {
        DataElement data;
        ProcessSpecificationModel model;
        ProjectConfigurationElement projectConfiguration;
        IContent content = (IContent)processContainer.getProcessData().get("com.ibm.team.internal.process.40.compiled.xml");
        if (content != null && (projectConfiguration = (model = this.getSpecificationModel(processContainer, content, null, null, monitor)).getProjectConfiguration()) != null && (data = projectConfiguration.getData()) != null) {
            ConfigurationDataElement[] configurations = data.getConfigurationData();
            int i = 0;
            while (i < configurations.length) {
                ConfigurationDataElement configuration = configurations[i];
                if (configuration.getId().equals(configPointId)) {
                    return configuration;
                }
                ++i;
            }
        }
        return null;
    }

    protected ProcessSpecificationModel getSpecificationModel(IProcessContainer processContainer, IContent content, final IDevelopmentLine line, final CurrentIterationInfo[] currentIterationInfos, IProgressMonitor monitor) throws TeamRepositoryException {
        ProcessSpecificationModel model = (ProcessSpecificationModel)this.fModelCache.get(processContainer, content, line, currentIterationInfos);
        if (model == null) {
            Exception exception;
            model = new ProcessSpecificationModel(){

                @Override
                protected ModelGenerator createModelGenerator() {
                    ModelGenerator generator = super.createModelGenerator();
                    generator.setDirective(ElementBuilderDirectives.DEVELOPMENT_LINE, line);
                    generator.setDirective(ElementBuilderDirectives.ITERATION_PATH_INFOS, currentIterationInfos);
                    return generator;
                }
            };
            if (content != null && (exception = model.initialize(this.createStringFromContent(content, monitor))) != null) {
                throw new IllegalArgumentException(exception.getMessage());
            }
            this.fModelCache.put(processContainer, content, line, currentIterationInfos, model);
        }
        return model;
    }

    protected TeamCustomizationModel getCustomizationModel(ITeamArea teamArea, IContent content, final IDevelopmentLine line, final CurrentIterationInfo[] currentIterationInfos, IProgressMonitor monitor) throws TeamRepositoryException {
        TeamCustomizationModel model = (TeamCustomizationModel)this.fModelCache.get(teamArea, content, line, currentIterationInfos);
        if (model == null) {
            Exception exception;
            model = new TeamCustomizationModel(){

                @Override
                protected ModelGenerator createModelGenerator() {
                    ModelGenerator generator = super.createModelGenerator();
                    generator.setDirective(ElementBuilderDirectives.DEVELOPMENT_LINE, line);
                    generator.setDirective(ElementBuilderDirectives.ITERATION_PATH_INFOS, currentIterationInfos);
                    return generator;
                }
            };
            if (content != null && (exception = model.initialize(this.createStringFromContent(content, monitor))) != null) {
                throw new IllegalArgumentException(exception.getMessage());
            }
            this.fModelCache.put(teamArea, content, line, currentIterationInfos, model);
        }
        return model;
    }

    public OperationBehaviorConfiguration getStaticBehaviorConfiguration(IProjectArea projectArea, String operationIdentifier, IProgressMonitor monitor) throws TeamRepositoryException {
        ProcessSpecificationModel model;
        ProjectConfigurationElement projectConfiguration;
        ProcessSpecificationModel model2;
        ProjectConfigurationElement projectConfiguration2;
        IContent content;
        this.assertSameProjectArea(projectArea);
        monitor = this.getProgressMonitor(monitor);
        monitor.beginTask(Messages.getCommonString("AbstractProcess.1"), 1000);
        projectArea = (IProjectArea)this.fetchCompleteItem((IItemHandle)projectArea, (IProgressMonitor)new SubProgressMonitor(monitor, 100));
        IRole2[] roles = this.getContributorRoles(this.getContributor(), projectArea, (IProgressMonitor)new SubProgressMonitor(monitor, 300));
        OperationBehaviorConfiguration operation = null;
        IProcessProvider processProvider = this.getProcessProvider(projectArea, (IProgressMonitor)new SubProgressMonitor(monitor, 100));
        if (processProvider != null && (content = (IContent)processProvider.getProcessData().get("com.ibm.team.internal.process.40.compiled.xml")) != null && (projectConfiguration2 = (model2 = this.getSpecificationModel(processProvider, content, null, null, (IProgressMonitor)new SubProgressMonitor(monitor, 300))).getProjectConfiguration()) != null) {
            int i = 0;
            while (i < roles.length) {
                IRole2 role = roles[i];
                String roleId = role.getId();
                operation = this.getBehaviorOperation(projectConfiguration2.getBehavior(), roleId, operationIdentifier);
                if (operation != null) {
                    ConfigurationSource source = AdvicePackage.eINSTANCE.getAdviceFactory().createConfigurationSource();
                    if (processProvider instanceof IProcessArea) {
                        source.setSourceArea((IProcessArea)((Object)processProvider));
                    }
                    source.setSourceAreaItemUuid(processProvider.getItemId().getUuidValue());
                    source.setContentKey("com.ibm.team.internal.process.40.compiled.xml");
                    if (role instanceof IRole2) {
                        source.setRoleId(role.getRoleLabel());
                    } else {
                        source.setRoleId(roleId);
                    }
                    source.setContentUuid(content.getContentId().getUuidValue());
                    operation = (OperationBehaviorConfiguration)operation.createCopyWithSource(source);
                    if (operation.isFinal()) {
                        return operation;
                    }
                }
                ++i;
            }
        }
        OperationBehaviorConfiguration projectAreaOperation = null;
        IContent content2 = (IContent)projectArea.getProcessData().get("com.ibm.team.internal.process.40.compiled.xml");
        if (content2 != null && (projectConfiguration = (model = this.getSpecificationModel(projectArea, content2, null, null, (IProgressMonitor)new SubProgressMonitor(monitor, 200))).getProjectConfiguration()) != null) {
            int i = 0;
            while (i < roles.length) {
                IRole2 role = roles[i];
                String roleId = role.getId();
                projectAreaOperation = this.getBehaviorOperation(projectConfiguration.getBehavior(), roleId, operationIdentifier);
                if (projectAreaOperation != null) {
                    operation = projectAreaOperation;
                    ConfigurationSource source = AdvicePackage.eINSTANCE.getAdviceFactory().createConfigurationSource();
                    source.setSourceArea(projectArea);
                    source.setSourceAreaItemUuid(projectArea.getItemId().getUuidValue());
                    source.setContentKey("com.ibm.team.internal.process.40.compiled.xml");
                    if (role instanceof IRole2) {
                        source.setRoleId(role.getRoleLabel());
                    } else {
                        source.setRoleId(roleId);
                    }
                    source.setContentUuid(content2.getContentId().getUuidValue());
                    operation = (OperationBehaviorConfiguration)operation.createCopyWithSource(source);
                    return operation;
                }
                ++i;
            }
        }
        return operation;
    }

    protected ChangeEventConfiguration getStaticChangeEventConfiguration(IProjectArea projectArea, String eventId, IProgressMonitor monitor) throws TeamRepositoryException {
        ChangeEventConfiguration projectAreaConfiguration;
        ProcessSpecificationModel model;
        ProjectConfigurationElement projectConfiguration;
        ProcessSpecificationModel model2;
        ProjectConfigurationElement projectConfiguration2;
        IContent content;
        this.assertSameProjectArea(projectArea);
        monitor = this.getProgressMonitor(monitor);
        monitor.beginTask(Messages.getCommonString("AbstractProcess.2"), 1000);
        ChangeEventConfiguration configuration = null;
        projectArea = (IProjectArea)this.fetchCompleteItem((IItemHandle)projectArea, (IProgressMonitor)new SubProgressMonitor(monitor, 200));
        IProcessProvider processProvider = this.getProcessProvider(projectArea, (IProgressMonitor)new SubProgressMonitor(monitor, 200));
        if (processProvider != null && (content = (IContent)processProvider.getProcessData().get("com.ibm.team.internal.process.40.compiled.xml")) != null && (projectConfiguration2 = (model2 = this.getSpecificationModel(processProvider, content, null, null, (IProgressMonitor)new SubProgressMonitor(monitor, 300))).getProjectConfiguration()) != null && (configuration = this.getChangeEvent(projectConfiguration2.getBehavior(), eventId)) != null && configuration.isFinal()) {
            return configuration;
        }
        IContent content2 = (IContent)projectArea.getProcessData().get("com.ibm.team.internal.process.40.compiled.xml");
        if (content2 != null && (projectConfiguration = (model = this.getSpecificationModel(projectArea, content2, null, null, (IProgressMonitor)new SubProgressMonitor(monitor, 300))).getProjectConfiguration()) != null && (projectAreaConfiguration = this.getChangeEvent(projectConfiguration.getBehavior(), eventId)) != null) {
            return projectAreaConfiguration;
        }
        return configuration;
    }

    /*
     * Unable to fully structure code
     */
    public OperationPermissionsConfiguration[] getStaticPermissionConfigurations(IProjectArea projectArea, String operationIdentifier, String[] actions, IProgressMonitor monitor) throws TeamRepositoryException {
        this.assertSameProjectArea(projectArea);
        monitor = this.getProgressMonitor(monitor);
        monitor.beginTask(Messages.getCommonString("AbstractProcess.3"), 1000);
        remainingActions = new ArrayList<String>();
        i = 0;
        while (i < actions.length) {
            remainingActions.add(actions[i]);
            ++i;
        }
        permissionConfigurations = new ArrayList<ProcessConfiguration>();
        roleConfigurations = new ArrayList<ProcessConfiguration>();
        try {
            if (!this.shouldCheckPermissions((IProgressMonitor)new SubProgressMonitor(monitor, 10))) {
                var21_9 = this.createAnyPermissions();
                return var21_9;
            }
            projectArea = (IProjectArea)this.fetchCompleteItem((IItemHandle)projectArea, (IProgressMonitor)new SubProgressMonitor(monitor, 190));
            roles = this.getContributorRoles(this.getContributor(), projectArea, (IProgressMonitor)new SubProgressMonitor(monitor, 400));
            operation = null;
            i = 0;
            while (i < roles.length) {
                role = roles[i];
                roleId = role.getId();
                processProvider = this.getProcessProvider(projectArea, (IProgressMonitor)new SubProgressMonitor(monitor, 100));
                if (processProvider == null || (content = (IContent)processProvider.getProcessData().get("com.ibm.team.internal.process.40.compiled.xml")) == null || (projectConfiguration = (model = this.getSpecificationModel(projectArea, content, null, null, (IProgressMonitor)new SubProgressMonitor(monitor, 150))).getProjectConfiguration()) == null || (operation = this.getPermissionOperation(projectConfiguration.getPermissions(), roleId, operationIdentifier)) == null) ** GOTO lbl-1000
                source = AdvicePackage.eINSTANCE.getAdviceFactory().createPermissionSource();
                source.setSourceArea(null);
                source.setSourceAreaItemUuid(processProvider.getItemId().getUuidValue());
                source.setContentKey("com.ibm.team.internal.process.40.compiled.xml");
                if (role instanceof IRole2) {
                    source.setRoleId(role.getRoleLabel());
                } else {
                    source.setRoleId(roleId);
                }
                source.setContentUuid(content.getContentId().getUuidValue());
                operation = (OperationPermissionsConfiguration)operation.createCopyWithSource(source);
                if (operation.isFinal()) {
                    roleConfigurations.add(operation);
                    permitted = this.getPermittedActions(remainingActions, (OperationPermissionsConfiguration)operation);
                    if (permitted.size() > 0) {
                        remainingActions.removeAll(permitted);
                        source.setPermittedActions(permitted.toArray(new String[permitted.size()]));
                        permissionConfigurations.add(operation);
                    }
                    if (remainingActions.size() == 0) {
                        var21_10 = permissionConfigurations.toArray(new OperationPermissionsConfiguration[permissionConfigurations.size()]);
                        return var21_10;
                    }
                } else lbl-1000:
                // 2 sources

                {
                    areaProjectConfiguration = null;
                    projectAreaOperation = null;
                    content = (IContent)projectArea.getProcessData().get("com.ibm.team.internal.process.40.compiled.xml");
                    if (content != null) {
                        model = this.getSpecificationModel(projectArea, content, null, null, (IProgressMonitor)new SubProgressMonitor(monitor, 150));
                        areaProjectConfiguration = model.getProjectConfiguration();
                    }
                    if (areaProjectConfiguration != null && (projectAreaOperation = this.getPermissionOperation(areaProjectConfiguration.getPermissions(), roleId, operationIdentifier)) != null) {
                        operation = projectAreaOperation;
                        source = AdvicePackage.eINSTANCE.getAdviceFactory().createPermissionSource();
                        source.setSourceArea(projectArea);
                        source.setSourceAreaItemUuid(projectArea.getItemId().getUuidValue());
                        source.setContentKey("com.ibm.team.internal.process.40.compiled.xml");
                        if (role instanceof IRole2) {
                            source.setRoleId(role.getRoleLabel());
                        } else {
                            source.setRoleId(roleId);
                        }
                        source.setContentUuid(content.getContentId().getUuidValue());
                        operation = (OperationPermissionsConfiguration)operation.createCopyWithSource(source);
                        roleConfigurations.add(operation);
                        permitted = this.getPermittedActions(remainingActions, (OperationPermissionsConfiguration)operation);
                        if (permitted.size() > 0) {
                            remainingActions.removeAll(permitted);
                            source.setPermittedActions(permitted.toArray(new String[permitted.size()]));
                            permissionConfigurations.add(operation);
                        }
                        if (remainingActions.size() == 0) {
                            var21_11 = permissionConfigurations.toArray(new OperationPermissionsConfiguration[permissionConfigurations.size()]);
                            return var21_11;
                        }
                    }
                    if (operation != null) {
                        if (!operation.isFinal()) {
                            roleConfigurations.add(operation);
                        }
                        if ((permitted = this.getPermittedActions(remainingActions, (OperationPermissionsConfiguration)operation)).size() > 0) {
                            ((PermissionSource)operation.getSource()).setPermittedActions(permitted.toArray(new String[permitted.size()]));
                            remainingActions.removeAll(permitted);
                            permissionConfigurations.add(operation);
                        }
                        if (remainingActions.size() == 0) {
                            var21_12 = permissionConfigurations.toArray(new OperationPermissionsConfiguration[permissionConfigurations.size()]);
                            return var21_12;
                        }
                    }
                }
                ++i;
            }
        }
        finally {
            monitor.done();
        }
        if (remainingActions.size() == 0) {
            return permissionConfigurations.toArray(new OperationPermissionsConfiguration[permissionConfigurations.size()]);
        }
        return roleConfigurations.toArray(new OperationPermissionsConfiguration[roleConfigurations.size()]);
    }

    protected OperationBehaviorConfiguration getBehaviorConfiguration(AdvisableOperation operation, IProgressMonitor monitor) throws TeamRepositoryException {
        if (operation instanceof ProjectOperation) {
            return this.getStaticBehaviorConfiguration((IProjectArea)operation.getProcessArea(), operation.getOperationIdentifier(), monitor);
        }
        return this.getBehaviorConfiguration(operation.getProcessArea(), operation.getDevelopmentLine(), operation.getOperationIdentifier(), monitor);
    }

    public OperationBehaviorConfiguration getBehaviorConfiguration(IProcessArea startingArea, IDevelopmentLine developmentLine, String operationId, IProgressMonitor monitor) throws TeamRepositoryException {
        return (OperationBehaviorConfiguration)this.getBehaviorOrEventConfiguration(startingArea, developmentLine, operationId, 1, monitor);
    }

    protected ChangeEventConfiguration getChangeEventConfiguration(IProcessArea startingArea, IDevelopmentLine developmentLine, String eventId) throws TeamRepositoryException {
        return (ChangeEventConfiguration)this.getBehaviorOrEventConfiguration(startingArea, developmentLine, eventId, 2, null);
    }

    public ProcessConfiguration getBehaviorOrEventConfiguration(IProcessArea startingArea, IDevelopmentLine line, String configurationId, int configurationType, IProgressMonitor monitor) throws TeamRepositoryException {
        this.assertSameProjectArea(startingArea);
        if (configurationType == 0) {
            throw new IllegalArgumentException(Messages.getCommonString("AbstractProcess.4"));
        }
        monitor = this.getProgressMonitor(monitor);
        monitor.beginTask(Messages.getCommonString("AbstractProcess.5"), 1000);
        try {
            CurrentIterationInfo[] currentIterationInfos = null;
            if (line != null) {
                currentIterationInfos = this.getCurrentIterationInfos(line, (IProgressMonitor)new SubProgressMonitor(monitor, 10));
            }
            IRole2[] roles = this.getContributorRoles(this.getContributor(), startingArea, (IProgressMonitor)new SubProgressMonitor(monitor, 10));
            this.fProjectArea = (IProjectArea)this.fetchCompleteItem((IItemHandle)this.getProjectArea(), (IProgressMonitor)new SubProgressMonitor(monitor, 10));
            SubProgressMonitor rolesMonitor = new SubProgressMonitor(monitor, 950);
            rolesMonitor.beginTask("", 1000 * roles.length);
            int i = 0;
            while (i < roles.length) {
                IRole2 role = roles[i];
                ProcessConfiguration configuration = null;
                IProcessProvider processProvider = this.getProcessProvider(this.fProjectArea, (IProgressMonitor)new SubProgressMonitor((IProgressMonitor)rolesMonitor, 10));
                if (processProvider != null) {
                    IContent content = (IContent)processProvider.getProcessData().get("com.ibm.team.internal.process.40.compiled.xml");
                    if (content != null) {
                        configuration = this.getCurrentProcessConfiguration(processProvider, content, line, currentIterationInfos, (IRole)role, configurationId, startingArea, "com.ibm.team.internal.process.40.compiled.xml", configurationType, (IProgressMonitor)new SubProgressMonitor((IProgressMonitor)rolesMonitor, 100));
                    }
                    if (configuration != null && configuration.isFinal()) {
                        ProcessConfiguration processConfiguration = configuration;
                        return processConfiguration;
                    }
                    ProcessConfiguration lowerConfig = null;
                    content = (IContent)processProvider.getProcessData().get("com.ibm.team.internal.process.settings.xml");
                    if (content != null) {
                        lowerConfig = this.getCurrentProcessConfiguration(processProvider, content, line, currentIterationInfos, (IRole)role, configurationId, startingArea, "com.ibm.team.internal.process.settings.xml", configurationType, (IProgressMonitor)new SubProgressMonitor((IProgressMonitor)rolesMonitor, 100));
                    }
                    if (lowerConfig != null && (configuration = lowerConfig).isFinal()) {
                        ProcessConfiguration processConfiguration = configuration;
                        return processConfiguration;
                    }
                }
                ProcessConfiguration lowerConfig = null;
                IContent content = (IContent)this.fProjectArea.getProcessData().get("com.ibm.team.internal.process.40.compiled.xml");
                if (content != null) {
                    lowerConfig = this.getCurrentProcessConfiguration(this.fProjectArea, content, line, currentIterationInfos, (IRole)role, configurationId, startingArea, "com.ibm.team.internal.process.40.compiled.xml", configurationType, (IProgressMonitor)new SubProgressMonitor((IProgressMonitor)rolesMonitor, 100));
                }
                if (lowerConfig != null && (configuration = lowerConfig).isFinal()) {
                    ProcessConfiguration processConfiguration = configuration;
                    return processConfiguration;
                }
                content = (IContent)this.fProjectArea.getProcessData().get("com.ibm.team.internal.process.settings.xml");
                if (content != null) {
                    lowerConfig = this.getCurrentProcessConfiguration(this.fProjectArea, content, line, currentIterationInfos, (IRole)role, configurationId, startingArea, "com.ibm.team.internal.process.settings.xml", configurationType, (IProgressMonitor)new SubProgressMonitor((IProgressMonitor)rolesMonitor, 100));
                }
                if (lowerConfig != null && (configuration = lowerConfig).isFinal()) {
                    ProcessConfiguration processConfiguration = configuration;
                    return processConfiguration;
                }
                List teamAreaHandles = this.computeTeamAreaPath(startingArea);
                int numAreas = teamAreaHandles.size();
                SubProgressMonitor hierarchyMonitor = new SubProgressMonitor((IProgressMonitor)rolesMonitor, 700);
                hierarchyMonitor.beginTask("", 1000 * numAreas);
                int j = numAreas - 1;
                while (j >= 0) {
                    ITeamAreaHandle teamAreaHandle = (ITeamAreaHandle)teamAreaHandles.get(j);
                    ITeamArea teamArea = (ITeamArea)this.fetchCompleteItem((IItemHandle)teamAreaHandle, (IProgressMonitor)new SubProgressMonitor((IProgressMonitor)hierarchyMonitor, 500));
                    content = (IContent)teamArea.getProcessData().get("com.ibm.team.internal.process.settings.xml");
                    if (content != null) {
                        lowerConfig = this.getCurrentProcessConfiguration(teamArea, content, line, currentIterationInfos, (IRole)role, configurationId, startingArea, "com.ibm.team.internal.process.settings.xml", configurationType, (IProgressMonitor)new SubProgressMonitor((IProgressMonitor)hierarchyMonitor, 500));
                    }
                    if (lowerConfig != null && (configuration = lowerConfig).isFinal()) {
                        ProcessConfiguration processConfiguration = configuration;
                        return processConfiguration;
                    }
                    --j;
                }
                hierarchyMonitor.done();
                if (configuration != null) {
                    ProcessConfiguration processConfiguration = configuration;
                    return processConfiguration;
                }
                ++i;
            }
        }
        finally {
            monitor.done();
        }
        return null;
    }

    /*
     * Unable to fully structure code
     */
    public OperationPermissionsConfiguration[] getPermissionConfigurations(IProcessArea startingArea, IDevelopmentLine line, String configurationId, String[] actions, IProgressMonitor monitor) throws TeamRepositoryException {
        this.assertSameProjectArea(startingArea);
        monitor = this.getProgressMonitor(monitor);
        monitor.beginTask(Messages.getCommonString("AbstractProcess.7"), 1000);
        remainingActions = new ArrayList<String>();
        i = 0;
        while (i < actions.length) {
            remainingActions.add(actions[i]);
            ++i;
        }
        permissionConfigurations = new ArrayList<ProcessConfiguration>();
        roleConfigurations = new ArrayList<ProcessConfiguration>();
        try {
            if (!this.shouldCheckPermissions((IProgressMonitor)new SubProgressMonitor(monitor, 10))) {
                var25_10 = this.createAnyPermissions();
                return var25_10;
            }
            currentIterationInfos = null;
            if (line != null) {
                currentIterationInfos = this.getCurrentIterationInfos(line, (IProgressMonitor)new SubProgressMonitor(monitor, 10));
            }
            roles = this.getContributorRoles(this.getContributor(), startingArea, (IProgressMonitor)new SubProgressMonitor(monitor, 10));
            this.fProjectArea = (IProjectArea)this.fetchCompleteItem((IItemHandle)this.getProjectArea(), (IProgressMonitor)new SubProgressMonitor(monitor, 10));
            rolesMonitor = new SubProgressMonitor(monitor, 960);
            rolesMonitor.beginTask("", 1000 * roles.length);
            i = 0;
            while (i < roles.length) {
                role = roles[i];
                configuration = null;
                processProvider = this.getProcessProvider(this.fProjectArea, (IProgressMonitor)new SubProgressMonitor((IProgressMonitor)rolesMonitor, 10));
                if (processProvider == null) ** GOTO lbl-1000
                content = (IContent)processProvider.getProcessData().get("com.ibm.team.internal.process.40.compiled.xml");
                if (content != null) {
                    configuration = (OperationPermissionsConfiguration)this.getCurrentProcessConfiguration(processProvider, content, line, currentIterationInfos, (IRole)role, configurationId, startingArea, "com.ibm.team.internal.process.40.compiled.xml", 0, (IProgressMonitor)new SubProgressMonitor((IProgressMonitor)rolesMonitor, 100));
                }
                if (configuration != null && configuration.isFinal()) {
                    roleConfigurations.add(configuration);
                    permitted = this.getPermittedActions(remainingActions, (OperationPermissionsConfiguration)configuration);
                    if (permitted.size() > 0) {
                        ((PermissionSource)configuration.getSource()).setPermittedActions(permitted.toArray(new String[permitted.size()]));
                        remainingActions.removeAll(permitted);
                        permissionConfigurations.add(configuration);
                        if (remainingActions.size() == 0) {
                            var25_11 = permissionConfigurations.toArray(new OperationPermissionsConfiguration[permissionConfigurations.size()]);
                            return var25_11;
                        }
                    }
                } else lbl-1000:
                // 2 sources

                {
                    lowerConfig = null;
                    content = (IContent)this.fProjectArea.getProcessData().get("com.ibm.team.internal.process.40.compiled.xml");
                    if (content != null) {
                        lowerConfig = (OperationPermissionsConfiguration)this.getCurrentProcessConfiguration(this.fProjectArea, content, line, currentIterationInfos, (IRole)role, configurationId, startingArea, "com.ibm.team.internal.process.40.compiled.xml", 0, (IProgressMonitor)new SubProgressMonitor((IProgressMonitor)rolesMonitor, 100));
                    }
                    if (lowerConfig != null && (configuration = lowerConfig).isFinal()) {
                        roleConfigurations.add(configuration);
                        permitted = this.getPermittedActions(remainingActions, (OperationPermissionsConfiguration)configuration);
                        if (permitted.size() > 0) {
                            ((PermissionSource)configuration.getSource()).setPermittedActions(permitted.toArray(new String[permitted.size()]));
                            remainingActions.removeAll(permitted);
                            permissionConfigurations.add(configuration);
                            if (remainingActions.size() == 0) {
                                var25_12 = permissionConfigurations.toArray(new OperationPermissionsConfiguration[permissionConfigurations.size()]);
                                return var25_12;
                            }
                        }
                    } else {
                        lowerConfig = null;
                        content = (IContent)this.fProjectArea.getProcessData().get("com.ibm.team.internal.process.settings.xml");
                        if (content != null) {
                            lowerConfig = (OperationPermissionsConfiguration)this.getCurrentProcessConfiguration(this.fProjectArea, content, line, currentIterationInfos, (IRole)role, configurationId, startingArea, "com.ibm.team.internal.process.settings.xml", 0, (IProgressMonitor)new SubProgressMonitor((IProgressMonitor)rolesMonitor, 100));
                        }
                        if (lowerConfig != null && (configuration = lowerConfig).isFinal()) {
                            roleConfigurations.add(configuration);
                            permitted = this.getPermittedActions(remainingActions, (OperationPermissionsConfiguration)configuration);
                            if (permitted.size() > 0) {
                                ((PermissionSource)configuration.getSource()).setPermittedActions(permitted.toArray(new String[permitted.size()]));
                                remainingActions.removeAll(permitted);
                                permissionConfigurations.add(configuration);
                                if (remainingActions.size() == 0) {
                                    var25_13 = permissionConfigurations.toArray(new OperationPermissionsConfiguration[permissionConfigurations.size()]);
                                    return var25_13;
                                }
                            }
                        } else {
                            teamAreaHandles = this.computeTeamAreaPath(startingArea);
                            numAreas = teamAreaHandles.size();
                            hierarchyMonitor = new SubProgressMonitor((IProgressMonitor)rolesMonitor, 600);
                            hierarchyMonitor.beginTask("", 1000 * numAreas);
                            j = numAreas - 1;
                            while (j >= 0) {
                                teamAreaHandle = (ITeamAreaHandle)teamAreaHandles.get(j);
                                teamArea = (ITeamArea)this.fetchCompleteItem((IItemHandle)teamAreaHandle, (IProgressMonitor)new SubProgressMonitor((IProgressMonitor)hierarchyMonitor, 500));
                                content = (IContent)teamArea.getProcessData().get("com.ibm.team.internal.process.settings.xml");
                                if (content != null) {
                                    lowerConfig = (OperationPermissionsConfiguration)this.getCurrentProcessConfiguration(teamArea, content, line, currentIterationInfos, (IRole)role, configurationId, startingArea, "com.ibm.team.internal.process.settings.xml", 0, (IProgressMonitor)new SubProgressMonitor((IProgressMonitor)hierarchyMonitor, 500));
                                }
                                if (lowerConfig != null && (configuration = lowerConfig).isFinal()) {
                                    roleConfigurations.add(configuration);
                                    break;
                                }
                                --j;
                            }
                            hierarchyMonitor.done();
                            if (configuration != null) {
                                if (!configuration.isFinal()) {
                                    roleConfigurations.add(configuration);
                                }
                                if ((permitted = this.getPermittedActions(remainingActions, (OperationPermissionsConfiguration)configuration)).size() > 0) {
                                    ((PermissionSource)configuration.getSource()).setPermittedActions(permitted.toArray(new String[permitted.size()]));
                                    remainingActions.removeAll(permitted);
                                    permissionConfigurations.add(configuration);
                                    if (remainingActions.size() == 0) {
                                        var25_14 = permissionConfigurations.toArray(new OperationPermissionsConfiguration[permissionConfigurations.size()]);
                                        return var25_14;
                                    }
                                }
                            }
                        }
                    }
                }
                ++i;
            }
        }
        finally {
            monitor.done();
        }
        if (remainingActions.size() == 0) {
            return permissionConfigurations.toArray(new OperationPermissionsConfiguration[permissionConfigurations.size()]);
        }
        return roleConfigurations.toArray(new OperationPermissionsConfiguration[roleConfigurations.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean shouldCheckPermissions(IProgressMonitor monitor) throws TeamRepositoryException {
        try {
            this.getLicenseChecker().assertLicense(ID_ENFORCE_PROCESS_PERMISSIONS, monitor);
        }
        catch (LicenseNotGrantedException licenseNotGrantedException) {
            return false;
        }
        HashSet hashSet = fgInitializingThreads;
        synchronized (hashSet) {
            block6: {
                if (!fgInitializingThreads.contains(Thread.currentThread())) break block6;
                return false;
            }
        }
        return true;
    }

    private OperationPermissionsConfiguration[] createAnyPermissions() {
        final PermissionActionElement anyAction = new PermissionActionElement(null, null, null, null){

            @Override
            public String getId() {
                return "any";
            }
        };
        OperationPermissionsConfiguration anyConfig = new OperationPermissionsConfiguration(null, null, null, null){

            @Override
            public PermissionActionElement[] getActions() {
                return new PermissionActionElement[]{anyAction};
            }
        };
        return new OperationPermissionsConfiguration[]{anyConfig};
    }

    protected ProcessConfiguration getCurrentProcessConfiguration(ITeamArea teamArea, IContent content, IDevelopmentLine line, CurrentIterationInfo[] currentIterationInfos, IRole role, String configurationId, IProcessArea startingArea, String contentKey, int configurationType, IProgressMonitor monitor) throws TeamRepositoryException {
        TeamCustomizationModel model = this.getCustomizationModel(teamArea, content, line, currentIterationInfos, monitor);
        String roleId = role.getId();
        ProcessConfiguration configuration = null;
        switch (configurationType) {
            case 1: {
                configuration = this.getBehaviorOperation(model.getBehavior(), roleId, configurationId);
                break;
            }
            case 0: {
                configuration = this.getPermissionOperation(model.getPermissions(), roleId, configurationId);
                break;
            }
            case 2: {
                configuration = this.getChangeEvent(model.getBehavior(), configurationId);
                break;
            }
            default: {
                return null;
            }
        }
        IterationTypeConfiguration[] typeConfigurations = model.getIterationTypeConfigurations();
        ProcessConfiguration lowerOperation = this.getCurrentOperationConfiguration(model.getIterationConfigurations(), currentIterationInfos, typeConfigurations, 0, roleId, configurationId, configurationType);
        if (lowerOperation != null) {
            configuration = lowerOperation;
        }
        if (configuration instanceof OperationConfiguration) {
            ConfigurationSource source = configurationType == 0 ? AdvicePackage.eINSTANCE.getAdviceFactory().createPermissionSource() : AdvicePackage.eINSTANCE.getAdviceFactory().createConfigurationSource();
            source.setSourceArea(teamArea);
            source.setAreaIsTeamArea(true);
            source.setSourceAreaItemUuid(teamArea.getItemId().getUuidValue());
            source.setContentKey(contentKey);
            if (role instanceof IRole2) {
                source.setRoleId(((IRole2)role).getRoleLabel());
            } else {
                source.setRoleId(roleId);
            }
            source.setContentUuid(content.getContentId().getUuidValue());
            source.setFinal(configuration.isFinal());
            configuration = ((OperationConfiguration)configuration).createCopyWithSource(source);
        }
        return configuration;
    }

    protected ProcessConfiguration getCurrentProcessConfiguration(IProcessContainer processContainer, IContent content, IDevelopmentLine line, CurrentIterationInfo[] currentIterationInfos, IRole role, String operationId, IProcessArea startingArea, String contentKey, int configurationType, IProgressMonitor monitor) throws TeamRepositoryException {
        ProcessSpecificationModel model = this.getSpecificationModel(processContainer, content, line, currentIterationInfos, monitor);
        TeamConfigurationElement teamConfiguration = model.getTeamConfiguration();
        if (teamConfiguration == null) {
            return null;
        }
        String roleId = role.getId();
        ProcessConfiguration configuration = null;
        switch (configurationType) {
            case 1: {
                configuration = this.getBehaviorOperation(teamConfiguration.getBehavior(), roleId, operationId);
                break;
            }
            case 0: {
                configuration = this.getPermissionOperation(teamConfiguration.getPermissions(), roleId, operationId);
                break;
            }
            case 2: {
                configuration = this.getChangeEvent(teamConfiguration.getBehavior(), operationId);
                break;
            }
            default: {
                return null;
            }
        }
        if (line != null) {
            IterationTypeConfiguration[] typeConfigurations;
            ProcessConfiguration lowerConfig;
            DevelopmentLineConfiguration matchingLineConfig = null;
            DevelopmentLineConfiguration[] lineConfigs = teamConfiguration.getDevelopmentLineConfigurations();
            String lineId = line.getId();
            int i = 0;
            while (i < lineConfigs.length) {
                DevelopmentLineConfiguration lineConfig = lineConfigs[i];
                if (lineId.equals(lineConfig.getId())) {
                    matchingLineConfig = lineConfig;
                    break;
                }
                ++i;
            }
            if (matchingLineConfig != null) {
                ProcessConfiguration lowerConfig2;
                switch (configurationType) {
                    case 1: {
                        lowerConfig2 = this.getBehaviorOperation(matchingLineConfig.getBehavior(), roleId, operationId);
                        break;
                    }
                    case 0: {
                        lowerConfig2 = this.getPermissionOperation(matchingLineConfig.getPermissions(), roleId, operationId);
                        break;
                    }
                    case 2: {
                        lowerConfig2 = this.getChangeEvent(matchingLineConfig.getBehavior(), operationId);
                        break;
                    }
                    default: {
                        return null;
                    }
                }
                if (lowerConfig2 != null) {
                    configuration = lowerConfig2;
                }
            }
            IIterationConfiguration[] iterationConfigs = null;
            if (matchingLineConfig != null) {
                iterationConfigs = matchingLineConfig.getIterations();
            }
            if ((lowerConfig = this.getCurrentOperationConfiguration(iterationConfigs, currentIterationInfos, typeConfigurations = teamConfiguration.getIterationTypeConfigurations(), 0, roleId, operationId, configurationType)) != null) {
                configuration = lowerConfig;
            }
        }
        if (configuration instanceof OperationConfiguration) {
            ConfigurationSource source = configurationType == 0 ? AdvicePackage.eINSTANCE.getAdviceFactory().createPermissionSource() : AdvicePackage.eINSTANCE.getAdviceFactory().createConfigurationSource();
            if (processContainer instanceof IProcessArea) {
                source.setSourceArea((IProcessArea)processContainer);
            }
            source.setSourceAreaItemUuid(processContainer.getItemId().getUuidValue());
            source.setContentKey(contentKey);
            if (role instanceof IRole2) {
                source.setRoleId(((IRole2)role).getRoleLabel());
            } else {
                source.setRoleId(roleId);
            }
            source.setContentUuid(content.getContentId().getUuidValue());
            source.setFinal(configuration.isFinal());
            configuration = ((OperationConfiguration)configuration).createCopyWithSource(source);
        }
        return configuration;
    }

    private ProcessConfiguration getCurrentOperationConfiguration(IIterationConfiguration[] iterationConfigs, CurrentIterationInfo[] currentIterationInfos, IterationTypeConfiguration[] typeConfigs, int currentDepth, String roleId, String operationId, int configurationType) throws TeamRepositoryException {
        ProcessConfiguration configuration = null;
        if (currentIterationInfos != null && currentDepth < currentIterationInfos.length) {
            ProcessConfiguration lowerConfig;
            CurrentIterationInfo iterationInfo = currentIterationInfos[currentDepth];
            String currentId = iterationInfo.getIteration().getId();
            IterationConfiguration matchingIterationConfig = null;
            if (iterationConfigs != null) {
                int i = 0;
                block10: while (i < iterationConfigs.length) {
                    IterationConfiguration iterationConfig = (IterationConfiguration)iterationConfigs[i];
                    String id = iterationConfig.getId();
                    if (id != null && id.equals(currentId)) {
                        matchingIterationConfig = iterationConfig;
                        switch (configurationType) {
                            case 1: {
                                configuration = this.getBehaviorOperation(matchingIterationConfig.getBehavior(), roleId, operationId);
                                break block10;
                            }
                            case 0: {
                                configuration = this.getPermissionOperation(matchingIterationConfig.getPermissions(), roleId, operationId);
                                break block10;
                            }
                            case 2: {
                                configuration = this.getChangeEvent(matchingIterationConfig.getBehavior(), operationId);
                                break block10;
                            }
                            default: {
                                return null;
                            }
                        }
                    }
                    ++i;
                }
            }
            IIterationType iterationType = iterationInfo.getIterationType();
            if (configuration == null && iterationType != null) {
                int j = 0;
                block11: while (j < typeConfigs.length) {
                    IterationTypeConfiguration typeConfig = typeConfigs[j];
                    String configTypeId = typeConfig.getId();
                    if (configTypeId != null && configTypeId.equals(iterationType.getId())) {
                        switch (configurationType) {
                            case 1: {
                                configuration = this.getBehaviorOperation(typeConfig.getBehavior(), roleId, operationId);
                                break block11;
                            }
                            case 0: {
                                configuration = this.getPermissionOperation(typeConfig.getPermissions(), roleId, operationId);
                                break block11;
                            }
                            case 2: {
                                configuration = this.getChangeEvent(typeConfig.getBehavior(), operationId);
                                break block11;
                            }
                            default: {
                                return null;
                            }
                        }
                    }
                    ++j;
                }
            }
            IIterationConfiguration[] childConfigs = null;
            if (matchingIterationConfig != null) {
                childConfigs = matchingIterationConfig.getChildIterations();
            }
            if ((lowerConfig = this.getCurrentOperationConfiguration(childConfigs, currentIterationInfos, typeConfigs, currentDepth + 1, roleId, operationId, configurationType)) != null) {
                configuration = lowerConfig;
            }
        }
        return configuration;
    }

    private OperationPermissionsConfiguration getPermissionOperation(PermissionsElement permissions, String roleId, String operationId) {
        if (permissions != null) {
            PermissionsRoleElement[] roleElements = permissions.getRoleElements();
            int i = 0;
            while (i < roleElements.length) {
                PermissionsRoleElement roleElement = roleElements[i];
                if (roleElement.getId().equals(roleId)) {
                    OperationPermissionsConfiguration[] operations = roleElement.getOperations();
                    int j = 0;
                    while (j < operations.length) {
                        OperationPermissionsConfiguration operation = operations[j];
                        if (operation.getId().equals(operationId)) {
                            return operation;
                        }
                        ++j;
                    }
                }
                ++i;
            }
        }
        return null;
    }

    private OperationBehaviorConfiguration getBehaviorOperation(BehaviorElement behavior, String roleId, String operationId) {
        if (behavior != null) {
            BehaviorRoleElement[] roleElements = behavior.getRoleElements();
            int i = 0;
            while (i < roleElements.length) {
                BehaviorRoleElement roleElement = roleElements[i];
                if (roleElement.getId().equals(roleId)) {
                    OperationBehaviorConfiguration[] operations = roleElement.getOperations();
                    int j = 0;
                    while (j < operations.length) {
                        OperationBehaviorConfiguration operation = operations[j];
                        if (operation.getId().equals(operationId)) {
                            return operation;
                        }
                        ++j;
                    }
                }
                ++i;
            }
        }
        return null;
    }

    private ChangeEventConfiguration getChangeEvent(BehaviorElement behavior, String eventId) {
        if (behavior != null) {
            ChangeEventConfiguration[] events = behavior.getChangeEventElements();
            int j = 0;
            while (j < events.length) {
                ChangeEventConfiguration event = events[j];
                if (event.getId().equals(eventId)) {
                    return event;
                }
                ++j;
            }
        }
        return null;
    }

    protected List computeTeamAreaPath(IProcessArea processArea) {
        ArrayList<ITeamAreaHandle> teamAreaHandles = new ArrayList<ITeamAreaHandle>();
        if (processArea instanceof ITeamArea) {
            ITeamAreaHierarchy hierarchy = this.fProjectArea.getTeamAreaHierarchy();
            ITeamAreaHandle teamAreaHandle = (ITeamAreaHandle)((Object)processArea);
            while (teamAreaHandle != null) {
                teamAreaHandles.add(teamAreaHandle);
                teamAreaHandle = hierarchy.getParent(teamAreaHandle);
            }
        }
        return teamAreaHandles;
    }

    public OperationBehaviorConfiguration getInitializationBehaviorConfiguration(String configPointId, IProgressMonitor monitor) throws TeamRepositoryException {
        monitor = this.getProgressMonitor(monitor);
        monitor.beginTask("", 1000);
        try {
            InitializationElement initialization;
            ProcessSpecificationModel model;
            ProjectConfigurationElement projectConfiguration;
            this.fProjectArea = (IProjectArea)this.fetchCompleteItem((IItemHandle)this.getProjectArea(), (IProgressMonitor)new SubProgressMonitor(monitor, 200));
            Map processData = this.fProjectArea.getProcessData();
            IContent content = (IContent)processData.get("com.ibm.team.internal.process.40.compiled.xml");
            if (content != null && (projectConfiguration = (model = this.getSpecificationModel(this.fProjectArea, content, null, null, (IProgressMonitor)new SubProgressMonitor(monitor, 800))).getProjectConfiguration()) != null && (initialization = projectConfiguration.getInitialization()) != null) {
                OperationBehaviorConfiguration[] configurations = initialization.getOperations();
                int index = 0;
                while (index < configurations.length) {
                    OperationBehaviorConfiguration configuration = configurations[index];
                    if (configuration.getId().equals(configPointId)) {
                        ConfigurationSource source = AdvicePackage.eINSTANCE.getAdviceFactory().createConfigurationSource();
                        source.setSourceArea(this.fProjectArea);
                        source.setSourceAreaItemUuid(this.fProjectArea.getItemId().getUuidValue());
                        source.setContentKey("com.ibm.team.internal.process.40.compiled.xml");
                        source.setContentUuid(content.getContentId().getUuidValue());
                        OperationBehaviorConfiguration operationBehaviorConfiguration = configuration = (OperationBehaviorConfiguration)configuration.createCopyWithSource(source);
                        return operationBehaviorConfiguration;
                    }
                    ++index;
                }
            }
            return null;
        }
        finally {
            monitor.done();
        }
    }

    public IRole2[] getRoles(IProcessArea startingArea, IProgressMonitor monitor) throws TeamRepositoryException {
        this.assertSameProjectArea(startingArea);
        monitor = this.getProgressMonitor(monitor);
        monitor.beginTask(Messages.getCommonString("AbstractProcess.9"), 1000);
        try {
            ArrayList<IRole> allRoles = new ArrayList<IRole>();
            this.fProjectArea = (IProjectArea)this.fetchCompleteItem((IItemHandle)this.getProjectArea(), (IProgressMonitor)new SubProgressMonitor(monitor, 100));
            SubProgressMonitor hierarchyMonitor = new SubProgressMonitor(monitor, 600);
            hierarchyMonitor.beginTask("", 1000);
            if (startingArea instanceof ITeamArea) {
                ITeamAreaHierarchy hierarchy = this.fProjectArea.getTeamAreaHierarchy();
                ITeamAreaHandle teamAreaHandle = (ITeamAreaHandle)((Object)startingArea);
                while (teamAreaHandle != null) {
                    ITeamArea teamArea = (ITeamArea)this.fetchCompleteItem((IItemHandle)teamAreaHandle, (IProgressMonitor)new SubProgressMonitor((IProgressMonitor)hierarchyMonitor, 50));
                    this.addRoles(allRoles, teamArea, "com.ibm.team.internal.process.settings.xml", (IProgressMonitor)new SubProgressMonitor((IProgressMonitor)hierarchyMonitor, 50));
                    teamAreaHandle = hierarchy.getParent(teamArea);
                }
            }
            hierarchyMonitor.done();
            this.addRoles(allRoles, this.fProjectArea, "com.ibm.team.internal.process.settings.xml", (IProgressMonitor)new SubProgressMonitor(monitor, 100));
            this.addRoles(allRoles, this.fProjectArea, "com.ibm.team.internal.process.40.compiled.xml", (IProgressMonitor)new SubProgressMonitor(monitor, 100));
            IProcessProvider processProvider = this.getProcessProvider(this.fProjectArea, (IProgressMonitor)new SubProgressMonitor(monitor, 50));
            if (processProvider != null) {
                this.addRoles(allRoles, processProvider, "com.ibm.team.internal.process.40.compiled.xml", (IProgressMonitor)new SubProgressMonitor(monitor, 50));
            }
            allRoles.add(fgDefaultRole);
            IRole2[] iRole2Array = allRoles.toArray(new IRole2[allRoles.size()]);
            return iRole2Array;
        }
        finally {
            monitor.done();
        }
    }

    private void addRoles(List allRoles, IProcessContainer processContainer, String contentKey, IProgressMonitor monitor) throws TeamRepositoryException {
        IRole2[] areaRoles = this.getRoles(processContainer, contentKey, monitor);
        int i = 0;
        while (i < areaRoles.length) {
            if (!this.containsRole(allRoles, areaRoles[i])) {
                allRoles.add(areaRoles[i]);
            }
            ++i;
        }
    }

    protected boolean containsRole(List roles, IRole role) {
        for (IRole existing : roles) {
            if (!role.getId().equals(existing.getId())) continue;
            return true;
        }
        return false;
    }

    public IRole2[] getContributorRoles(IContributorHandle contributor, IProcessArea startingArea, IProgressMonitor monitor) throws TeamRepositoryException {
        this.assertSameProjectArea(startingArea);
        monitor = this.getProgressMonitor(monitor);
        monitor.beginTask(Messages.getCommonString("AbstractProcess.10"), 1000);
        IRole[] availableRoles = this.getRoles(startingArea, (IProgressMonitor)new SubProgressMonitor(monitor, 100));
        ArrayList<IRole> assignedRoles = new ArrayList<IRole>();
        this.fProjectArea = (IProjectArea)this.fetchCompleteItem((IItemHandle)this.getProjectArea(), (IProgressMonitor)new SubProgressMonitor(monitor, 100));
        SubProgressMonitor hierarchyMonitor = new SubProgressMonitor(monitor, 600);
        hierarchyMonitor.beginTask("", 1000);
        if (startingArea instanceof ITeamArea) {
            ITeamAreaHierarchy hierarchy = this.fProjectArea.getTeamAreaHierarchy();
            ITeamAreaHandle teamAreaHandle = (ITeamAreaHandle)((Object)startingArea);
            while (teamAreaHandle != null) {
                ITeamArea teamArea = (ITeamArea)this.fetchCompleteItem((IItemHandle)teamAreaHandle, (IProgressMonitor)new SubProgressMonitor((IProgressMonitor)hierarchyMonitor, 50));
                this.addContributorRoles(assignedRoles, teamArea.getRoleAssignments(contributor, availableRoles), (IProgressMonitor)new SubProgressMonitor((IProgressMonitor)hierarchyMonitor, 50));
                teamAreaHandle = hierarchy.getParent(teamArea);
            }
        }
        hierarchyMonitor.done();
        this.addContributorRoles(assignedRoles, this.fProjectArea.getRoleAssignments(contributor, availableRoles), (IProgressMonitor)new SubProgressMonitor(monitor, 100));
        assignedRoles.add(fgDefaultRole);
        return assignedRoles.toArray(new IRole2[assignedRoles.size()]);
    }

    private void addContributorRoles(List allRoles, IRole[] assignedRoles, IProgressMonitor monitor) throws TeamRepositoryException {
        if (assignedRoles != null) {
            int i = 0;
            while (i < assignedRoles.length) {
                if (!this.containsRole(allRoles, assignedRoles[i])) {
                    allRoles.add(assignedRoles[i]);
                }
                ++i;
            }
        }
    }

    protected IRole2[] getRoles(IProcessContainer processContainer, String contentKey, IProgressMonitor monitor) throws TeamRepositoryException {
        IContent content = (IContent)processContainer.getProcessData().get(contentKey);
        if (content != null) {
            if (processContainer instanceof ITeamArea) {
                TeamCustomizationModel model = this.getCustomizationModel((ITeamArea)processContainer, content, null, null, monitor);
                return model.getRoleDefinitions();
            }
            ProcessSpecificationModel model = this.getSpecificationModel(processContainer, content, null, null, monitor);
            return model.getRoleDefinitions();
        }
        return new IRole2[0];
    }

    public IContributorHandle[] getContributorsWithRole(IContributorHandle[] contributors, IProcessAreaHandle areaHandle, String[] roleIds, IProgressMonitor monitor) throws TeamRepositoryException {
        monitor = this.getProgressMonitor(monitor);
        monitor.beginTask("", 1000);
        IProcessArea processArea = (IProcessArea)this.fetchCompleteItem((IItemHandle)areaHandle, (IProgressMonitor)new SubProgressMonitor(monitor, 100));
        int i = 0;
        while (i < roleIds.length) {
            if ("default".equals(roleIds[i])) {
                return contributors;
            }
            ++i;
        }
        ItemHandleAwareHashSet resultSet = new ItemHandleAwareHashSet();
        ItemHandleAwareHashSet contributorsToSearch = new ItemHandleAwareHashSet();
        contributorsToSearch.addAll(Arrays.asList(contributors));
        this.fProjectArea = processArea instanceof IProjectArea ? (IProjectArea)processArea : (IProjectArea)this.fetchCompleteItem((IItemHandle)processArea.getProjectArea(), (IProgressMonitor)new SubProgressMonitor(monitor, 300));
        List teamAreaHandles = this.computeTeamAreaPath(processArea);
        IItem[] teamAreas = this.fetchCompleteItems(teamAreaHandles.toArray(new IItemHandle[teamAreaHandles.size()]), (IProgressMonitor)new SubProgressMonitor(monitor, 600));
        int i2 = 0;
        while (i2 < teamAreas.length) {
            this.addContributorsWithRole(contributorsToSearch, (IProcessArea)teamAreas[i2], roleIds, resultSet);
            ++i2;
        }
        this.addContributorsWithRole(contributorsToSearch, this.fProjectArea, roleIds, resultSet);
        return (IContributorHandle[])resultSet.toArray(new IContributorHandle[resultSet.size()]);
    }

    private void addContributorsWithRole(ItemHandleAwareHashSet contributors, IProcessArea processArea, String[] roleIds, ItemHandleAwareHashSet resultSet) {
        Iterator iter = contributors.iterator();
        block0: while (iter.hasNext()) {
            IContributorHandle contributor = (IContributorHandle)iter.next();
            String[] assignmentIds = processArea.getRoleAssignmentIds(contributor);
            int i = 0;
            while (i < assignmentIds.length) {
                String assigned = assignmentIds[i];
                int j = 0;
                while (j < roleIds.length) {
                    if (assigned.equals(roleIds[j])) {
                        iter.remove();
                        resultSet.add(contributor);
                        continue block0;
                    }
                    ++j;
                }
                ++i;
            }
        }
    }

    private List getPermittedActions(List actions, OperationPermissionsConfiguration configuration) {
        return OperationAdviceManager.getPermittedActions(actions, configuration);
    }

    protected IDevelopmentLine getOperationDevelopmentLine(IProcessArea processArea, IDevelopmentLine operationLine, IProgressMonitor monitor) throws TeamRepositoryException {
        if (processArea instanceof ITeamArea) {
            return this.getDevelopmentLine(processArea, monitor);
        }
        IDevelopmentLine line = this.getDevelopmentLine(processArea, monitor);
        if (line != null) {
            return line;
        }
        return operationLine;
    }

    public IProcessAttachment getProcessAttachment(IProcessArea processArea, String attachmentPath, IProgressMonitor monitor) throws TeamRepositoryException {
        IProcessAttachment attachment;
        monitor = this.getProgressMonitor(monitor);
        monitor.beginTask(Messages.getCommonString("AbstractProcess.6"), 1000);
        try {
            IProcessProvider processProvider;
            attachment = this.doGetProcessAttachment(processArea, attachmentPath, (IProgressMonitor)new SubProgressMonitor(monitor, 500));
            if (attachment == null && processArea instanceof IProjectArea && (processProvider = this.getProcessProvider((IProjectArea)processArea, (IProgressMonitor)new SubProgressMonitor(monitor, 100))) != null) {
                attachment = this.doGetProcessAttachment(processProvider, attachmentPath, (IProgressMonitor)new SubProgressMonitor(monitor, 400));
            }
        }
        finally {
            monitor.done();
        }
        return attachment;
    }

    protected void assertSameProjectArea(IProcessArea processArea) {
        if (processArea == null) {
            throw new IllegalArgumentException(Messages.getCommonString("AbstractProcess.11"));
        }
        IProjectAreaHandle actual = processArea.getProjectArea();
        if (!this.getProjectArea().sameItemId((IItemHandle)actual)) {
            throw new IllegalArgumentException(Messages.getCommonString("AbstractProcess.12"));
        }
    }

    public IProjectArea getProjectArea() {
        return this.fProjectArea;
    }

    protected IProgressMonitor getProgressMonitor(IProgressMonitor monitor) {
        if (monitor == null) {
            return new NullProgressMonitor();
        }
        return monitor;
    }

    public IProcessProvider getProcessProvider(IProjectArea area, IProgressMonitor progressMonitor) throws TeamRepositoryException {
        IProcessProvider provider = null;
        IProgressMonitor monitor = this.getProgressMonitor(progressMonitor);
        monitor.beginTask("Fetching process from provider... ", 1000);
        try {
            IProcessContainerHandle providerHandle = this.getProcessProviderHandle(area, (IProgressMonitor)new SubProgressMonitor(monitor, 500));
            if (providerHandle != null) {
                provider = (IProcessProvider)this.fetchCompleteItem((IItemHandle)providerHandle, (IProgressMonitor)new SubProgressMonitor(monitor, 500));
            }
            IProcessProvider iProcessProvider = provider;
            return iProcessProvider;
        }
        finally {
            monitor.done();
        }
    }

    public IProcessAttachment[] getProcessAttachments(IProcessArea processArea, IProgressMonitor monitor) throws TeamRepositoryException {
        this.assertSameProjectArea(processArea);
        monitor = this.getProgressMonitor(monitor);
        monitor.beginTask(Messages.getCommonString("AbstractProcess.8"), 1000);
        ArrayList<IProcessAttachment> allAttachments = new ArrayList<IProcessAttachment>();
        try {
            IProcessAttachmentHandle[] processAreaAttachmentHandles = processArea.getAttachments();
            IItem[] projectAreaAttachmentItems = this.fetchCompleteItems((IItemHandle[])processAreaAttachmentHandles, (IProgressMonitor)new SubProgressMonitor(monitor, 400));
            ArrayList<IProcessAttachment> processAreaAttachments = new ArrayList<IProcessAttachment>();
            IItem[] iItemArray = projectAreaAttachmentItems;
            int n = projectAreaAttachmentItems.length;
            int n2 = 0;
            while (n2 < n) {
                IItem processAttachmentItem = iItemArray[n2];
                processAreaAttachments.add((IProcessAttachment)processAttachmentItem);
                ++n2;
            }
            IItem[] providerAttachments = this.getProcessProviderAttachmentItems(processArea, (IProgressMonitor)new SubProgressMonitor(monitor, 600));
            if (providerAttachments.length == 0) {
                allAttachments = processAreaAttachments;
            } else {
                ProcessAttachmentFilePathComparator attachmentComparator = new ProcessAttachmentFilePathComparator();
                Collections.sort(processAreaAttachments, attachmentComparator);
                IItem[] iItemArray2 = providerAttachments;
                int n3 = providerAttachments.length;
                int n4 = 0;
                while (n4 < n3) {
                    IItem providerAttachmentItem = iItemArray2[n4];
                    IProcessAttachment attachment = (IProcessAttachment)providerAttachmentItem;
                    int foundIndex = Collections.binarySearch(processAreaAttachments, attachment, attachmentComparator);
                    if (foundIndex < 0) {
                        allAttachments.add(attachment);
                    }
                    ++n4;
                }
                allAttachments.addAll(processAreaAttachments);
            }
        }
        finally {
            monitor.done();
        }
        return allAttachments.toArray(new IProcessAttachment[allAttachments.size()]);
    }

    private IItem[] getProcessProviderAttachmentItems(IProcessArea processArea, IProgressMonitor monitor) throws TeamRepositoryException {
        IProcessAttachmentHandle[] providerAttachmentHandles;
        IProjectArea projectArea;
        IProcessProvider provider;
        if (processArea instanceof IProjectArea && (provider = this.getProcessProvider(projectArea = (IProjectArea)processArea, (IProgressMonitor)new SubProgressMonitor(monitor, 200))) != null && (providerAttachmentHandles = provider.getAttachments()).length > 0) {
            return this.fetchCompleteItems((IItemHandle[])providerAttachmentHandles, (IProgressMonitor)new SubProgressMonitor(monitor, 400));
        }
        return new IItem[0];
    }

    protected IProcessContainerHandle getProcessProviderHandle(IProjectArea area, IProgressMonitor monitor) {
        IProjectAreaHandle providerProjectAreaHandle = ((ProjectArea)area).getProcessProvider();
        if (providerProjectAreaHandle != null) {
            return providerProjectAreaHandle;
        }
        IProcessProviderCacheItemHandle providerHandle = ((ProjectArea)area).getRemoteProcessProvider();
        if (providerHandle != null) {
            return providerHandle;
        }
        return null;
    }
}

