/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.process.internal.common.util;

import com.ibm.team.process.internal.common.util.Messages;
import com.ibm.team.repository.common.FileLocator;
import com.ibm.team.repository.common.TeamRepositoryException;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.osgi.util.NLS;

public class FileUtil {
    public static String createStringFromFile(String filePath, String bundleSymbolicName) throws TeamRepositoryException {
        return FileUtil.createStringFromFile(filePath, bundleSymbolicName, "UTF-8");
    }

    public static String createStringFromFile(String filePath, String bundleSymbolicName, String encoding) throws TeamRepositoryException {
        URL fileURL = FileLocator.find((String)bundleSymbolicName, (IPath)new Path(filePath));
        if (fileURL == null) {
            throw new TeamRepositoryException(NLS.bind((String)Messages.getCommonString("FileUtil.0"), (Object)filePath));
        }
        try {
            int b;
            InputStream stream = fileURL.openStream();
            ByteArrayOutputStream byteStream = new ByteArrayOutputStream();
            while ((b = stream.read()) > -1) {
                byteStream.write(b);
            }
            return new String(byteStream.toByteArray(), encoding);
        }
        catch (UnsupportedEncodingException e) {
            throw new TeamRepositoryException((Throwable)e);
        }
        catch (IOException e) {
            throw new TeamRepositoryException((Throwable)e);
        }
    }
}

