/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client;

import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.filesystem.client.IFileContentManager;
import com.ibm.team.filesystem.client.IFileSystemManager;
import com.ibm.team.filesystem.client.ISharingManager;
import com.ibm.team.filesystem.client.internal.ProxyAuthenticator;
import com.ibm.team.filesystem.client.internal.SharingManager;
import com.ibm.team.filesystem.client.internal.copyfileareas.ICopyFileAreaManager;
import com.ibm.team.repository.client.ITeamRepository;
import java.io.File;
import java.io.IOException;
import java.util.Map;

public class FileSystemCore {
    public static final String HOME_CONFIG_DIRECTORY = ".jazz-scm";
    public static final String SCM_DIRECTORY = "jazz-scm";
    public static final String ID = "com.ibm.team.filesystem.client";
    public static final String WORK_ITEMS_LINKS_REMOVER = "workItemLinksRemover";
    public static final String DAEMON_BUILD_ID_PROPERTY = "scm.daemon.buildId";
    public static final String USER_DIR = String.valueOf(System.getProperty("user.home")) + File.separator + ".jazz-scm";
    private static boolean isShutDown = false;
    private static ProxyAuthenticator headlessAuthenticator;

    public static UserConfigDir getUserConfigDir() throws IOException {
        return FileSystemCore.getUserConfigDir(System.getenv());
    }

    public static UserConfigDir getUserConfigDir(Map<String, String> env) throws IOException {
        String reqPath;
        String toReturn = null;
        boolean isUsingAppData = false;
        String localAppData = env.get("LOCALAPPDATA");
        if (localAppData != null && (localAppData = localAppData.trim()).length() > 0) {
            toReturn = String.valueOf(localAppData) + File.separator + SCM_DIRECTORY;
            isUsingAppData = true;
        }
        if ((reqPath = env.get("SCM_CONFIG_DIRECTORY")) != null && (reqPath = reqPath.trim()).length() > 0) {
            toReturn = reqPath;
            isUsingAppData = false;
        }
        if (toReturn == null) {
            toReturn = String.valueOf(System.getProperty("user.home")) + File.separator + HOME_CONFIG_DIRECTORY;
            isUsingAppData = false;
        }
        File file = new File(toReturn);
        return new UserConfigDir(file.getCanonicalFile(), isUsingAppData);
    }

    public static ISharingManager getSharingManager() {
        return SharingManager.getInstance();
    }

    public static IFileSystemManager getFileSystemManager(ITeamRepository repository) {
        if (repository == null) {
            throw new IllegalArgumentException();
        }
        return (IFileSystemManager)repository.getClientLibrary(IFileSystemManager.class);
    }

    public static IFileContentManager getContentManager(ITeamRepository repo) {
        return FileSystemCore.getFileSystemManager(repo).getContentManager();
    }

    public static void startUp() {
        isShutDown = false;
    }

    public static void shutDown() throws FileSystemException {
        isShutDown = true;
        SharingManager.conditionalShutDown();
        ICopyFileAreaManager.instance.shutdown(null);
    }

    public static boolean isShutDown() {
        return isShutDown;
    }

    private FileSystemCore() {
    }

    public static void enableHeadlessProxies() {
        headlessAuthenticator = new ProxyAuthenticator();
    }

    public static void addProxyData(String url, String proxyHost, int proxyPort, String proxyUserName, String proxyPassword) {
        if (headlessAuthenticator != null) {
            headlessAuthenticator.addProxyData(url, proxyHost, proxyPort, proxyUserName, proxyPassword);
        }
    }

    public static final class UserConfigDir {
        private final boolean isUsingAppData;
        private final File configDirAsFile;

        public UserConfigDir(File canonicalConfigDir, boolean localAppDataSet) {
            this.configDirAsFile = canonicalConfigDir;
            this.isUsingAppData = localAppDataSet;
        }

        public String getConfigDir() {
            return this.configDirAsFile.getAbsolutePath();
        }

        public File getConfigDirAsFile() {
            return this.configDirAsFile;
        }

        public boolean isUsingLocalAppData() {
            return this.isUsingAppData;
        }
    }
}

