/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal;

import com.ibm.team.filesystem.client.internal.SymLinkHelper;
import org.eclipse.core.runtime.CoreException;

class WindowsNativeSymLinkHelper
extends SymLinkHelper {
    private final boolean supportsSymlinks = WindowsNativeSymLinkHelper.nativeSupportsSymlinks();

    static SymLinkHelper newInstance() {
        try {
            System.loadLibrary("winfsnatives");
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            return null;
        }
        return new WindowsNativeSymLinkHelper();
    }

    private WindowsNativeSymLinkHelper() {
    }

    private static native void createLink(String var0, String var1, int var2) throws CoreException;

    private static native boolean nativeSupportsSymlinks();

    private static native String getRealPath(String var0) throws CoreException;

    @Override
    public void createSymlink(String path, String targetPath) throws CoreException {
        WindowsNativeSymLinkHelper.createLink(targetPath, path, 0);
    }

    @Override
    public void createSymlink(String path, String targetPath, boolean isDirectory) throws CoreException {
        WindowsNativeSymLinkHelper.createLink(targetPath, path, isDirectory ? 1 : 0);
    }

    @Override
    public String getResolvedPath(String path) throws CoreException {
        return WindowsNativeSymLinkHelper.getRealPath(path);
    }

    @Override
    public boolean supportsSymLinks() {
        return this.supportsSymlinks;
    }

    @Override
    public boolean hasEmbeddedTargetType() {
        return true;
    }

    @Override
    public String normalizeSymlinkTarget(String targetPath) throws CoreException {
        return targetPath;
    }
}

