/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal.calm;

import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.client.util.IClientLibraryContext;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.transport.HttpUtil;
import com.ibm.team.repository.transport.client.AuthenticationException;
import com.ibm.team.repository.transport.client.ITeamRawRestServiceClient;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Map;
import org.apache.http.HeaderElement;
import org.apache.http.NameValuePair;
import org.apache.http.message.BasicHeaderValueParser;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;

public class RESTClient {
    private final IClientLibraryContext fClientContext;

    public RESTClient(IClientLibraryContext context) {
        Assert.isNotNull((Object)context);
        this.fClientContext = context;
    }

    public IClientLibraryContext getClientContext() {
        return this.fClientContext;
    }

    public ITeamRawRestServiceClient.IRawRestClientConnection.Response performGET(final URI resourceUri, final Map<String, String> headers, String errorMessage, IProgressMonitor monitor) throws TeamRepositoryException {
        final ITeamRawRestServiceClient rawRestServiceClient = this.fClientContext.teamRepository().getRawRestServiceClient();
        IClientLibraryContext.IServiceRunnable<ITeamRawRestServiceClient.IRawRestClientConnection.Response> block = new IClientLibraryContext.IServiceRunnable<ITeamRawRestServiceClient.IRawRestClientConnection.Response>(){

            public ITeamRawRestServiceClient.IRawRestClientConnection.Response run(IProgressMonitor monitor) throws TeamRepositoryException {
                try {
                    ITeamRawRestServiceClient.IRawRestClientConnection connection = rawRestServiceClient.getConnection(resourceUri);
                    for (Map.Entry header : headers.entrySet()) {
                        connection.addRequestHeader((String)header.getKey(), (String)header.getValue());
                    }
                    return connection.doGet();
                }
                catch (URISyntaxException ex) {
                    throw new TeamRepositoryException(ex.getLocalizedMessage(), (Throwable)ex);
                }
            }
        };
        try {
            ITeamRawRestServiceClient.IRawRestClientConnection.Response response = (ITeamRawRestServiceClient.IRawRestClientConnection.Response)this.fClientContext.callCancelableService((IClientLibraryContext.IServiceRunnable)block, monitor);
            if (response.getStatusCode() != 200) {
                if (errorMessage == null) {
                    throw new TeamRepositoryException(response.getResponseHeader("Warning"));
                }
                throw new TeamRepositoryException(errorMessage);
            }
            return response;
        }
        catch (AuthenticationException ex) {
            ITeamRepository repository = this.fClientContext.teamRepository();
            if (!repository.loggedIn()) {
                repository.login(monitor);
            }
            throw new TeamRepositoryException(ex.getLocalizedMessage(), (Throwable)ex);
        }
    }

    public ITeamRawRestServiceClient.IRawRestClientConnection.Response performPOST(URI uri, Map<String, String> headers, String content, String errorMessage, IProgressMonitor monitor) throws TeamRepositoryException {
        return this.performPOSTorPUT(true, uri, headers, content, errorMessage, monitor);
    }

    public ITeamRawRestServiceClient.IRawRestClientConnection.Response performPUT(URI uri, Map<String, String> headers, String content, String errorMessage, IProgressMonitor monitor) throws TeamRepositoryException {
        return this.performPOSTorPUT(false, uri, headers, content, errorMessage, monitor);
    }

    private ITeamRawRestServiceClient.IRawRestClientConnection.Response performPOSTorPUT(final boolean isPOST, final URI uri, final Map<String, String> headers, final String content, String errorMessage, IProgressMonitor monitor) throws TeamRepositoryException {
        final ITeamRawRestServiceClient rawRestServiceClient = this.fClientContext.teamRepository().getRawRestServiceClient();
        IClientLibraryContext.IServiceRunnable<ITeamRawRestServiceClient.IRawRestClientConnection.Response> block = new IClientLibraryContext.IServiceRunnable<ITeamRawRestServiceClient.IRawRestClientConnection.Response>(){

            public ITeamRawRestServiceClient.IRawRestClientConnection.Response run(IProgressMonitor monitor) throws TeamRepositoryException {
                try {
                    ITeamRawRestServiceClient.IRawRestClientConnection connection = rawRestServiceClient.getConnection(uri);
                    for (Map.Entry header : headers.entrySet()) {
                        connection.addRequestHeader((String)header.getKey(), (String)header.getValue());
                    }
                    String encoding = HttpUtil.CharsetEncoding.UTF8.name();
                    byte[] bytes = content.getBytes(encoding);
                    if (isPOST) {
                        return connection.doPost((InputStream)new ByteArrayInputStream(bytes), (long)bytes.length, encoding);
                    }
                    return connection.doPut((InputStream)new ByteArrayInputStream(bytes), (long)bytes.length, encoding);
                }
                catch (URISyntaxException ex) {
                    throw new TeamRepositoryException(ex.getMessage(), (Throwable)ex);
                }
                catch (UnsupportedEncodingException ex) {
                    throw new TeamRepositoryException(ex.getMessage(), (Throwable)ex);
                }
            }
        };
        ITeamRawRestServiceClient.IRawRestClientConnection.Response response = (ITeamRawRestServiceClient.IRawRestClientConnection.Response)this.fClientContext.callCancelableService((IClientLibraryContext.IServiceRunnable)block, monitor);
        if (response.getStatusCode() != 200 && response.getStatusCode() != 201) {
            if (errorMessage == null) {
                throw new TeamRepositoryException(response.getResponseHeader("Warning"));
            }
            throw new TeamRepositoryException(errorMessage);
        }
        return response;
    }

    public String readResponse(ITeamRawRestServiceClient.IRawRestClientConnection.Response response) throws TeamRepositoryException {
        try {
            ByteArrayOutputStream buffer = new ByteArrayOutputStream(8192);
            InputStream stream = response.getResponseStream();
            byte[] bytes = new byte[8192];
            try {
                int ch = stream.read(bytes);
                while (ch != -1) {
                    buffer.write(bytes, 0, ch);
                    ch = stream.read(bytes);
                }
            }
            finally {
                if (stream != null) {
                    stream.close();
                }
            }
            return buffer.toString(this.getEncoding(response, "UTF-8"));
        }
        catch (IOException ex) {
            throw new TeamRepositoryException(ex.getMessage(), (Throwable)ex);
        }
    }

    private String getEncoding(ITeamRawRestServiceClient.IRawRestClientConnection.Response response, String defaultCharset) {
        NameValuePair param;
        HeaderElement[] values;
        String contentTypeHeader = response.getResponseHeader("Content-Type");
        if (contentTypeHeader != null && (values = BasicHeaderValueParser.parseElements((String)contentTypeHeader, null)).length > 0 && (param = values[0].getParameterByName("charset")) != null) {
            return param.getValue();
        }
        return defaultCharset;
    }
}

