/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal.magic;

import com.ibm.team.filesystem.client.FileSystemCore;
import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.filesystem.client.IContentExaminer;
import com.ibm.team.filesystem.client.IContentProperties;
import com.ibm.team.filesystem.client.IShareable;
import com.ibm.team.filesystem.client.ResourceType;
import com.ibm.team.filesystem.client.internal.Shareable;
import com.ibm.team.filesystem.client.internal.api.content.MagicContentExaminer;
import com.ibm.team.filesystem.client.internal.api.content.SniffContentExaminer;
import com.ibm.team.filesystem.client.internal.magic.ContentProperties;
import com.ibm.team.filesystem.common.FileLineDelimiter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;

public class LocalContentExaminer
extends MagicContentExaminer
implements IContentExaminer {
    private static volatile LocalContentExaminer instance = new LocalContentExaminer();
    private SniffContentExaminer sniffContentExaminer = new SniffContentExaminer();

    public static IContentExaminer getInstance() {
        return instance;
    }

    public LocalContentExaminer(String pathToUserHome) {
        super(pathToUserHome);
    }

    public LocalContentExaminer() {
        this(FileSystemCore.USER_DIR);
    }

    public IContentProperties examine(String name, MagicContentExaminer.IStreamSource data, IProgressMonitor progress) throws FileSystemException {
        SubMonitor mon = SubMonitor.convert((IProgressMonitor)progress, (int)10);
        IContentProperties contentProperties = this.getMagicProperties(name, (IProgressMonitor)mon.newChild(5));
        String encoding = this.getEncoding(name, data, (IProgressMonitor)mon.newChild(5));
        if (encoding == null) {
            encoding = System.getProperty("file.encoding");
        }
        return new ContentProperties(encoding, contentProperties.getMimeType(), contentProperties.getLineDelimiter());
    }

    @Override
    public IContentProperties examine(final IShareable shareable, IProgressMonitor mon) throws FileSystemException {
        return this.examine(shareable.getLocalPath().getName(), new MagicContentExaminer.IStreamSource(){

            @Override
            public InputStream getStream() throws FileSystemException {
                return ((Shareable)shareable).getFileStorage().getContents(null);
            }
        }, mon);
    }

    @Override
    public IContentProperties findStoredProperties(IShareable shareable, IProgressMonitor mon) throws FileSystemException {
        String encoding;
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)mon, (int)100);
        final File file = (File)shareable.getAdapter(File.class);
        final ResourceType type = shareable.getResourceType((IProgressMonitor)progress.newChild(1));
        if (file == null || type == null) {
            return ContentProperties.UNKNOWN;
        }
        String mimeType = shareable.getContentType((IProgressMonitor)progress.newChild(25));
        FileLineDelimiter lineDelimiter = shareable.getLineDelimiter((IProgressMonitor)progress.newChild(25));
        if (mimeType == null || lineDelimiter == null) {
            IContentProperties props = this.examine(shareable, (IProgressMonitor)progress.newChild(50));
            if (mimeType == null) {
                mimeType = props.getMimeType();
            }
            if (lineDelimiter == null) {
                lineDelimiter = props.getLineDelimiter();
            }
            encoding = props.getEncoding();
        } else {
            MagicContentExaminer.IStreamSource data = new MagicContentExaminer.IStreamSource(){

                @Override
                public InputStream getStream() throws FileSystemException {
                    block3: {
                        try {
                            if (file != null && type == ResourceType.FILE && file.canRead()) break block3;
                            return null;
                        }
                        catch (FileNotFoundException fileNotFoundException) {
                            return null;
                        }
                    }
                    return new FileInputStream(file);
                }
            };
            encoding = this.getEncoding(shareable.getLocalPath().getName(), data, (IProgressMonitor)progress.newChild(50));
        }
        if (encoding == null) {
            encoding = System.getProperty("file.encoding");
        }
        return new ContentProperties(encoding, mimeType, lineDelimiter);
    }

    @Override
    public String getEncoding(IShareable shareable, IProgressMonitor progress) throws FileSystemException {
        SubMonitor mon = SubMonitor.convert((IProgressMonitor)progress, (int)10);
        final File file = (File)shareable.getAdapter(File.class);
        final ResourceType type = shareable.getResourceType((IProgressMonitor)mon);
        String encoding = null;
        MagicContentExaminer.IStreamSource data = new MagicContentExaminer.IStreamSource(){

            @Override
            public InputStream getStream() throws FileSystemException {
                block3: {
                    try {
                        if (file != null && type == ResourceType.FILE && file.canRead()) break block3;
                        return null;
                    }
                    catch (FileNotFoundException fileNotFoundException) {
                        return null;
                    }
                }
                return new FileInputStream(file);
            }
        };
        encoding = this.getEncoding(shareable.getLocalPath().getName(), data, (IProgressMonitor)mon.newChild(10));
        if (encoding == null) {
            encoding = System.getProperty("file.encoding");
        }
        return encoding;
    }

    private String getEncoding(String name, MagicContentExaminer.IStreamSource data, IProgressMonitor mon) throws FileSystemException {
        String encoding = null;
        if (data != null) {
            encoding = this.sniffContentExaminer.sniffEncoding(data);
        }
        if (encoding == null) {
            encoding = this.getMagicEncoding(name, mon);
        }
        return encoding;
    }

    public void makeDefault() {
        instance = this;
    }
}

