/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal.rest.util;

import com.ibm.team.filesystem.client.ILocalChange;
import com.ibm.team.filesystem.client.IOperationFactory;
import com.ibm.team.filesystem.client.IShareable;
import com.ibm.team.filesystem.client.internal.rest.CommonUtil;
import com.ibm.team.filesystem.client.internal.rest.util.CommitUtil;
import com.ibm.team.filesystem.client.internal.rest.util.CoreUtil;
import com.ibm.team.filesystem.client.internal.rest.util.RefreshUtil;
import com.ibm.team.filesystem.client.internal.rest.util.SandboxUpdateDilemmaUtil;
import com.ibm.team.filesystem.client.internal.rest.util.UpdateDilemmaUtil;
import com.ibm.team.filesystem.client.internal.rest.util.VerifyOutOfSyncUtil;
import com.ibm.team.filesystem.client.internal.rest.util.WorkspaceUpdateUtil;
import com.ibm.team.filesystem.client.internal.utils.ConfigurationFacade;
import com.ibm.team.filesystem.client.operations.BackupDilemmaHandler;
import com.ibm.team.filesystem.client.operations.CommitDilemmaHandler;
import com.ibm.team.filesystem.client.operations.DiscardDilemmaHandler;
import com.ibm.team.filesystem.client.operations.ICheckinOptions;
import com.ibm.team.filesystem.client.operations.IDiscardOperation;
import com.ibm.team.filesystem.client.operations.IResumeOperation;
import com.ibm.team.filesystem.client.operations.ISuspendOperation;
import com.ibm.team.filesystem.client.operations.OutOfSyncDilemmaHandler;
import com.ibm.team.filesystem.client.operations.ResumeDilemmaHandler;
import com.ibm.team.filesystem.client.operations.SuspendDilemmaHandler;
import com.ibm.team.filesystem.client.rest.parameters.ParmsDiscardChangeSets;
import com.ibm.team.filesystem.client.rest.parameters.ParmsRemoveSuspendedChangeSets;
import com.ibm.team.filesystem.client.rest.parameters.ParmsResumeChangeSets;
import com.ibm.team.filesystem.client.rest.parameters.ParmsSuspendChangeSets;
import com.ibm.team.filesystem.common.internal.rest.client.changeset.DiscardResultDTO;
import com.ibm.team.filesystem.common.internal.rest.client.changeset.FilesystemRestClientDTOchangesetFactory;
import com.ibm.team.filesystem.common.internal.rest.client.changeset.GapChangeSetsDTO;
import com.ibm.team.filesystem.common.internal.rest.client.changeset.ProblemChangeSetsDTO;
import com.ibm.team.filesystem.common.internal.rest.client.changeset.ResumeResultDTO;
import com.ibm.team.filesystem.common.internal.rest.client.changeset.SuspendResultDTO;
import com.ibm.team.filesystem.common.internal.rest.client.core.ConfigurationWithUncheckedInChangesDTO;
import com.ibm.team.filesystem.common.internal.rest.client.core.FilesystemRestClientDTOcoreFactory;
import com.ibm.team.filesystem.common.internal.rest.client.dilemma.CommitDilemmaDTO;
import com.ibm.team.filesystem.common.internal.rest.client.dilemma.SandboxUpdateDilemmaDTO;
import com.ibm.team.filesystem.common.internal.rest.client.dilemma.UpdateDilemmaDTO;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.common.IChangeSet;
import com.ibm.team.scm.common.IChangeSetHandle;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubMonitor;

public class SuspendResumeDiscardChangeSetUtil {
    public static final ResumeResultDTO resume(ParmsResumeChangeSets parms, IProgressMonitor progress) throws TeamRepositoryException {
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress, (int)100);
        parms.validate("postResume", new Object[0]);
        IWorkspaceConnection wc = parms.workspace.getWorkspaceConnection((IProgressMonitor)monitor.newChild(5));
        List<IChangeSetHandle> changeSets = parms.getChangeSets();
        ResumeResultDTO result = FilesystemRestClientDTOchangesetFactory.eINSTANCE.createResumeResultDTO();
        ResumeDilemmaHandler dilemmaHandler = SuspendResumeDiscardChangeSetUtil.getResumeDilemmaHandler(parms, result.getOutOfSyncShares(), result.getConfigurationsWithUncheckedInChanges(), result.getCommitDilemma(), result.getSandboxUpdateDilemma(), result.getUpdateDilemma(), result.getActiveChangeSetsOverlap(), result.getGap(), result.getChangeSetsBlockedByPortInProgress(), (IProgressMonitor)monitor.newChild(5));
        IResumeOperation op = IOperationFactory.instance.getResumeOperation(dilemmaHandler);
        op.resume(wc, changeSets);
        RefreshUtil.configureRefresh(parms.preoperationRefresh, op);
        CommitUtil.configureCommit(parms.pendingChangesDilemmaHandler, (ICheckinOptions)op);
        try {
            op.run((IProgressMonitor)monitor.newChild(80));
        }
        catch (OperationCanceledException operationCanceledException) {
            result.setCancelled(true);
        }
        return result;
    }

    private static ResumeDilemmaHandler getResumeDilemmaHandler(ParmsResumeChangeSets parms, List outOfSyncShares, final List<ConfigurationWithUncheckedInChangesDTO> configurationsWithUncheckedInChanges, CommitDilemmaDTO commitDilemma, SandboxUpdateDilemmaDTO sandboxUpdateDilemma, UpdateDilemmaDTO updateDilemma, final List<ProblemChangeSetsDTO> activeChangeSetsOverlapEncountered, final List<GapChangeSetsDTO> gapEncountered, final List<ProblemChangeSetsDTO> changeSetsBlockedByPortInProgress, IProgressMonitor progress) throws TeamRepositoryException {
        int activeChangeSetsOverlapInstruction;
        int portInProgressInstruction;
        int gapInstruction;
        final SandboxUpdateDilemmaUtil sandboxUpdateDilemmaUtil = new SandboxUpdateDilemmaUtil(parms.sandboxUpdateDilemmaHandler, sandboxUpdateDilemma);
        final UpdateDilemmaUtil updateDilemmaUtil = new UpdateDilemmaUtil(parms.updateDilemmaHandler, updateDilemma);
        final OutOfSyncDilemmaHandler outOfSyncDilemmaHandler = VerifyOutOfSyncUtil.getOutOfSyncDilemmaHandler(parms.outOfSyncInstructions, outOfSyncShares, parms.sandboxUpdateDilemmaHandler, sandboxUpdateDilemma, progress);
        final CommitDilemmaHandler commitDilemmaHandler = CommitUtil.getCommitDilemmaHandler(parms.pendingChangesDilemmaHandler, commitDilemma, parms.sandboxUpdateDilemmaHandler, sandboxUpdateDilemma, parms.updateDilemmaHandler, updateDilemma, outOfSyncDilemmaHandler);
        final int uncheckedInChangesInstruction = CommitUtil.getUncheckedInChangesInstruction(parms.pendingChangesDilemmaHandler);
        if (parms.resumeDilemmaHandler == null) {
            gapInstruction = 2;
            portInProgressInstruction = 2;
            activeChangeSetsOverlapInstruction = 2;
        } else {
            gapInstruction = WorkspaceUpdateUtil.getInstruction(parms.resumeDilemmaHandler.gapDirection, true, "gapDirection");
            portInProgressInstruction = WorkspaceUpdateUtil.getInstruction(parms.resumeDilemmaHandler.portInProgressDirection, true, "portInProgressDirection");
            activeChangeSetsOverlapInstruction = WorkspaceUpdateUtil.getInstruction(parms.resumeDilemmaHandler.activeChangeSetsOverlapDirection, true, "activeChangeSetsOverlapDirection");
        }
        ResumeDilemmaHandler dilemmaHandler = new ResumeDilemmaHandler(){

            @Override
            public int uncheckedInChanges(Map<ConfigurationFacade, Collection<ILocalChange>> configurationToChangesMap) {
                if (configurationsWithUncheckedInChanges != null) {
                    for (Map.Entry<ConfigurationFacade, Collection<ILocalChange>> entry : configurationToChangesMap.entrySet()) {
                        ConfigurationWithUncheckedInChangesDTO uncheckedInChanges = FilesystemRestClientDTOcoreFactory.eINSTANCE.createConfigurationWithUncheckedInChangesDTO();
                        uncheckedInChanges.setConfiguration(CoreUtil.translateConfigurationDescriptor(entry.getKey()));
                        uncheckedInChanges.setChangeCount(entry.getValue().size());
                        configurationsWithUncheckedInChanges.add(uncheckedInChanges);
                    }
                }
                return uncheckedInChangesInstruction;
            }

            @Override
            public OutOfSyncDilemmaHandler getOutOfSyncDilemmaHandler() {
                return outOfSyncDilemmaHandler;
            }

            @Override
            public CommitDilemmaHandler getCommitDilemmaHandler() {
                return commitDilemmaHandler;
            }

            @Override
            public BackupDilemmaHandler getBackupDilemmaHandler() {
                return sandboxUpdateDilemmaUtil.getBackupDilemmaHandler();
            }

            @Override
            public int deletedContent(Collection<IShareable> contentDeleted) {
                return sandboxUpdateDilemmaUtil.deletedContent(contentDeleted);
            }

            @Override
            public int inaccessibleForUpdate(Collection<IShareable> shareables) {
                return updateDilemmaUtil.inaccessibleForUpdate(shareables);
            }

            @Override
            public int siblingSharesToAdd(Collection<IShareable> shareables) {
                return updateDilemmaUtil.siblingSharesToAdd(shareables);
            }

            @Override
            public int activeChangeSetsOverlap(IWorkspaceConnection workspace, Collection<? extends IChangeSetHandle> activeChangeSets) {
                if (activeChangeSetsOverlapEncountered != null) {
                    activeChangeSetsOverlapEncountered.add(CoreUtil.translateProblemChangeSetsDTO(workspace, activeChangeSets));
                }
                return activeChangeSetsOverlapInstruction;
            }

            @Override
            public int gap(IWorkspaceConnection workspace, List<IChangeSetHandle> changeSetsWithGap) {
                if (gapEncountered != null) {
                    gapEncountered.add(CoreUtil.translateGapProblemChangeSetsDTO(workspace, changeSetsWithGap, true));
                }
                return gapInstruction;
            }

            @Override
            public int portInProgress(IWorkspaceConnection workspaceConnection, List<IChangeSetHandle> changeSets) {
                if (changeSetsBlockedByPortInProgress != null) {
                    changeSetsBlockedByPortInProgress.add(CoreUtil.translateProblemChangeSetsDTO(workspaceConnection, changeSets));
                }
                return portInProgressInstruction;
            }
        };
        return dilemmaHandler;
    }

    public static final SuspendResultDTO suspend(ParmsSuspendChangeSets parms, IProgressMonitor progress) throws TeamRepositoryException {
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress, (int)100);
        IWorkspaceConnection wc = parms.workspace.getWorkspaceConnection((IProgressMonitor)monitor.newChild(5));
        List<IChangeSetHandle> changeSets = parms.getChangeSets();
        SuspendResultDTO result = FilesystemRestClientDTOchangesetFactory.eINSTANCE.createSuspendResultDTO();
        SuspendDilemmaHandler dilemmaHandler = SuspendResumeDiscardChangeSetUtil.getSuspendDilemmaHandler(parms, result.getOutOfSyncShares(), result.getConfigurationsWithUncheckedInChanges(), result.getCommitDilemma(), result.getSandboxUpdateDilemma(), result.getUpdateDilemma(), (IProgressMonitor)monitor.newChild(5));
        ISuspendOperation op = IOperationFactory.instance.getSuspendOperation(dilemmaHandler);
        op.suspend(wc, changeSets);
        RefreshUtil.configureRefresh(parms.preoperationRefresh, op);
        CommitUtil.configureCommit(parms.pendingChangesDilemmaHandler, (ICheckinOptions)op);
        try {
            op.run((IProgressMonitor)monitor.newChild(90));
        }
        catch (OperationCanceledException operationCanceledException) {
            result.setCancelled(true);
        }
        return result;
    }

    public static SuspendDilemmaHandler getSuspendDilemmaHandler(ParmsSuspendChangeSets parms, List outOfSyncShares, final List<ConfigurationWithUncheckedInChangesDTO> configurationsWithUncheckedInChanges, CommitDilemmaDTO commitDilemma, SandboxUpdateDilemmaDTO sandboxUpdateDilemma, UpdateDilemmaDTO updateDilemma, IProgressMonitor progress) throws TeamRepositoryException {
        final SandboxUpdateDilemmaUtil sandboxUpdateDilemmaUtil = new SandboxUpdateDilemmaUtil(parms.sandboxUpdateDilemmaHandler, sandboxUpdateDilemma);
        final UpdateDilemmaUtil updateDilemmaUtil = new UpdateDilemmaUtil(parms.updateDilemmaHandler, updateDilemma);
        final OutOfSyncDilemmaHandler outOfSyncDilemmaHandler = VerifyOutOfSyncUtil.getOutOfSyncDilemmaHandler(parms.outOfSyncInstructions, outOfSyncShares, parms.sandboxUpdateDilemmaHandler, sandboxUpdateDilemma, progress);
        final CommitDilemmaHandler commitDilemmaHandler = CommitUtil.getCommitDilemmaHandler(parms.pendingChangesDilemmaHandler, commitDilemma, parms.sandboxUpdateDilemmaHandler, sandboxUpdateDilemma, parms.updateDilemmaHandler, updateDilemma, outOfSyncDilemmaHandler);
        final int uncheckedInChangesInstruction = CommitUtil.getUncheckedInChangesInstruction(parms.pendingChangesDilemmaHandler);
        SuspendDilemmaHandler dilemmaHandler = new SuspendDilemmaHandler(){

            @Override
            public int uncheckedInChanges(Map<ConfigurationFacade, Collection<ILocalChange>> configurationToChangesMap) {
                if (configurationsWithUncheckedInChanges != null) {
                    for (Map.Entry<ConfigurationFacade, Collection<ILocalChange>> entry : configurationToChangesMap.entrySet()) {
                        ConfigurationWithUncheckedInChangesDTO uncheckedInChanges = FilesystemRestClientDTOcoreFactory.eINSTANCE.createConfigurationWithUncheckedInChangesDTO();
                        uncheckedInChanges.setConfiguration(CoreUtil.translateConfigurationDescriptor(entry.getKey()));
                        uncheckedInChanges.setChangeCount(entry.getValue().size());
                        configurationsWithUncheckedInChanges.add(uncheckedInChanges);
                    }
                }
                return uncheckedInChangesInstruction;
            }

            @Override
            public OutOfSyncDilemmaHandler getOutOfSyncDilemmaHandler() {
                return outOfSyncDilemmaHandler;
            }

            @Override
            public CommitDilemmaHandler getCommitDilemmaHandler() {
                return commitDilemmaHandler;
            }

            @Override
            public BackupDilemmaHandler getBackupDilemmaHandler() {
                return sandboxUpdateDilemmaUtil.getBackupDilemmaHandler();
            }

            @Override
            public int deletedContent(Collection<IShareable> contentDeleted) {
                return sandboxUpdateDilemmaUtil.deletedContent(contentDeleted);
            }

            @Override
            public int inaccessibleForUpdate(Collection<IShareable> shareables) {
                return updateDilemmaUtil.inaccessibleForUpdate(shareables);
            }

            @Override
            public int siblingSharesToAdd(Collection<IShareable> shareables) {
                return updateDilemmaUtil.siblingSharesToAdd(shareables);
            }
        };
        return dilemmaHandler;
    }

    public static final DiscardResultDTO discard(ParmsDiscardChangeSets parms, IProgressMonitor progress) throws TeamRepositoryException {
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress, (int)100);
        IWorkspaceConnection wc = parms.workspace.getWorkspaceConnection((IProgressMonitor)monitor.newChild(5));
        List<IChangeSetHandle> changeSets = parms.getChangeSets();
        DiscardResultDTO result = FilesystemRestClientDTOchangesetFactory.eINSTANCE.createDiscardResultDTO();
        DiscardDilemmaHandler dilemmaHandler = SuspendResumeDiscardChangeSetUtil.getDiscardDilemmaHandler(parms, result.getOutOfSyncShares(), result.getConfigurationsWithUncheckedInChanges(), result.getCommitDilemma(), result.getSandboxUpdateDilemma(), result.getUpdateDilemma(), (IProgressMonitor)monitor.newChild(5));
        IDiscardOperation op = IOperationFactory.instance.getDiscardOperation(dilemmaHandler);
        op.setRemoveWorkItemLinks(parms.removeWorkItemLinks);
        op.discard(wc, changeSets);
        RefreshUtil.configureRefresh(parms.preoperationRefresh, op);
        CommitUtil.configureCommit(parms.pendingChangesDilemmaHandler, (ICheckinOptions)op);
        try {
            op.run((IProgressMonitor)monitor.newChild(90));
        }
        catch (OperationCanceledException operationCanceledException) {
            result.setCancelled(true);
        }
        return result;
    }

    private static DiscardDilemmaHandler getDiscardDilemmaHandler(ParmsDiscardChangeSets parms, List outOfSyncShares, final List<ConfigurationWithUncheckedInChangesDTO> configurationsWithUncheckedInChanges, CommitDilemmaDTO commitDilemma, SandboxUpdateDilemmaDTO sandboxUpdateDilemma, UpdateDilemmaDTO updateDilemma, IProgressMonitor progress) throws TeamRepositoryException {
        final SandboxUpdateDilemmaUtil sandboxUpdateDilemmaUtil = new SandboxUpdateDilemmaUtil(parms.sandboxUpdateDilemmaHandler, sandboxUpdateDilemma);
        final UpdateDilemmaUtil updateDilemmaUtil = new UpdateDilemmaUtil(parms.updateDilemmaHandler, updateDilemma);
        final OutOfSyncDilemmaHandler outOfSyncDilemmaHandler = VerifyOutOfSyncUtil.getOutOfSyncDilemmaHandler(parms.outOfSyncInstructions, outOfSyncShares, parms.sandboxUpdateDilemmaHandler, sandboxUpdateDilemma, progress);
        final CommitDilemmaHandler commitDilemmaHandler = CommitUtil.getCommitDilemmaHandler(parms.pendingChangesDilemmaHandler, commitDilemma, parms.sandboxUpdateDilemmaHandler, sandboxUpdateDilemma, parms.updateDilemmaHandler, updateDilemma, outOfSyncDilemmaHandler);
        final int uncheckedInChangesInstruction = CommitUtil.getUncheckedInChangesInstruction(parms.pendingChangesDilemmaHandler);
        DiscardDilemmaHandler dilemmaHandler = new DiscardDilemmaHandler(){

            @Override
            public int uncheckedInChanges(Map<ConfigurationFacade, Collection<ILocalChange>> configurationToChangesMap) {
                if (configurationsWithUncheckedInChanges != null) {
                    for (Map.Entry<ConfigurationFacade, Collection<ILocalChange>> entry : configurationToChangesMap.entrySet()) {
                        ConfigurationWithUncheckedInChangesDTO uncheckedInChanges = FilesystemRestClientDTOcoreFactory.eINSTANCE.createConfigurationWithUncheckedInChangesDTO();
                        uncheckedInChanges.setConfiguration(CoreUtil.translateConfigurationDescriptor(entry.getKey()));
                        uncheckedInChanges.setChangeCount(entry.getValue().size());
                        configurationsWithUncheckedInChanges.add(uncheckedInChanges);
                    }
                }
                return uncheckedInChangesInstruction;
            }

            @Override
            public OutOfSyncDilemmaHandler getOutOfSyncDilemmaHandler() {
                return outOfSyncDilemmaHandler;
            }

            @Override
            public CommitDilemmaHandler getCommitDilemmaHandler() {
                return commitDilemmaHandler;
            }

            @Override
            public BackupDilemmaHandler getBackupDilemmaHandler() {
                return sandboxUpdateDilemmaUtil.getBackupDilemmaHandler();
            }

            @Override
            public int deletedContent(Collection<IShareable> contentDeleted) {
                return sandboxUpdateDilemmaUtil.deletedContent(contentDeleted);
            }

            @Override
            public int inaccessibleForUpdate(Collection<IShareable> shareables) {
                return updateDilemmaUtil.inaccessibleForUpdate(shareables);
            }

            @Override
            public int siblingSharesToAdd(Collection<IShareable> shareables) {
                return updateDilemmaUtil.siblingSharesToAdd(shareables);
            }
        };
        return dilemmaHandler;
    }

    public static final void removeSuspended(ParmsRemoveSuspendedChangeSets parms, IProgressMonitor progress) throws TeamRepositoryException {
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress, (int)100);
        parms.validate("postRemoveSuspendedChangeSets", new Object[0]);
        IWorkspaceConnection wc = parms.workspace.getWorkspaceConnection((IProgressMonitor)monitor.newChild(10));
        List<? extends IItemHandle> changeSets = CommonUtil.createHandles(IChangeSet.ITEM_TYPE, parms.workspace.repositoryUrl, parms.changeSetItemIds);
        wc.removeSuspended(changeSets, (IProgressMonitor)monitor.newChild(80));
    }
}

