/*
 * Decompiled with CFR 0.152.
 */
package net.oauth;

import java.io.IOException;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.oauth.OAuth;
import net.oauth.OAuthAccessor;
import net.oauth.OAuthException;
import net.oauth.OAuthMessage;
import net.oauth.OAuthProblemException;
import net.oauth.OAuthValidator;
import net.oauth.signature.OAuthSignatureMethod;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleOAuthValidator
implements OAuthValidator {
    public static final long DEFAULT_TIMESTAMP_WINDOW = 300000L;
    public static final Set<String> SINGLE_PARAMETERS = SimpleOAuthValidator.constructSingleParameters();
    protected final double minVersion = 1.0;
    protected final double maxVersion;
    protected final long timestampWindow;

    private static Set<String> constructSingleParameters() {
        HashSet<String> s = new HashSet<String>();
        for (String p : new String[]{"oauth_consumer_key", "oauth_token", "oauth_token_secret", "oauth_callback", "oauth_signature_method", "oauth_signature", "oauth_timestamp", "oauth_nonce", "oauth_version"}) {
            s.add(p);
        }
        return Collections.unmodifiableSet(s);
    }

    public SimpleOAuthValidator() {
        this(300000L, Double.parseDouble("1.0"));
    }

    public SimpleOAuthValidator(long timestampWindowMsec, double maxVersion) {
        this.timestampWindow = timestampWindowMsec;
        this.maxVersion = maxVersion;
    }

    @Override
    public void validateMessage(OAuthMessage message, OAuthAccessor accessor) throws OAuthException, IOException, URISyntaxException {
        this.checkSingleParameters(message);
        this.validateVersion(message);
        this.validateTimestampAndNonce(message);
        this.validateSignature(message, accessor);
    }

    protected void checkSingleParameters(OAuthMessage message) throws IOException, OAuthException {
        boolean repeated = false;
        HashMap<String, ArrayList<String>> nameToValues = new HashMap<String, ArrayList<String>>();
        for (Map.Entry<String, String> parameter : message.getParameters()) {
            String name = parameter.getKey();
            if (!SINGLE_PARAMETERS.contains(name)) continue;
            ArrayList<String> values = (ArrayList<String>)nameToValues.get(name);
            if (values == null) {
                values = new ArrayList<String>();
                nameToValues.put(name, values);
            } else {
                repeated = true;
            }
            values.add(parameter.getValue());
        }
        if (repeated) {
            ArrayList<OAuth.Parameter> rejected = new ArrayList<OAuth.Parameter>();
            for (Map.Entry p : nameToValues.entrySet()) {
                String name = (String)p.getKey();
                Collection values = (Collection)p.getValue();
                if (values.size() <= 1) continue;
                for (String value : values) {
                    rejected.add(new OAuth.Parameter(name, value));
                }
            }
            OAuthProblemException problem = new OAuthProblemException("parameter_rejected");
            problem.setParameter("oauth_parameters_rejected", OAuth.formEncode(rejected));
            throw problem;
        }
    }

    protected void validateVersion(OAuthMessage message) throws OAuthException, IOException {
        double version2;
        String versionString = message.getParameter("oauth_version");
        if (versionString != null && ((version2 = Double.parseDouble(versionString)) < 1.0 || this.maxVersion < version2)) {
            OAuthProblemException problem = new OAuthProblemException("version_rejected");
            problem.setParameter("oauth_acceptable_versions", "1.0-" + this.maxVersion);
            throw problem;
        }
    }

    protected void validateTimestampAndNonce(OAuthMessage message) throws IOException, OAuthProblemException {
        message.requireParameters("oauth_timestamp", "oauth_nonce");
        long timestamp = Long.parseLong(message.getParameter("oauth_timestamp")) * 1000L;
        long now = this.currentTimeMsec();
        long min = now - this.timestampWindow;
        long max = now + this.timestampWindow;
        if (timestamp < min || max < timestamp) {
            OAuthProblemException problem = new OAuthProblemException("timestamp_refused");
            problem.setParameter("oauth_acceptable_timestamps", min + "-" + max);
            throw problem;
        }
    }

    protected void validateSignature(OAuthMessage message, OAuthAccessor accessor) throws OAuthException, IOException, URISyntaxException {
        message.requireParameters("oauth_consumer_key", "oauth_signature_method", "oauth_signature");
        OAuthSignatureMethod.newSigner(message, accessor).validate(message);
    }

    protected long currentTimeMsec() {
        return System.currentTimeMillis();
    }
}

