/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wink.server.internal.handlers;

import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.core.Response;
import org.apache.wink.common.http.HttpStatus;
import org.apache.wink.common.internal.utils.HeaderUtils;
import org.apache.wink.common.model.wadl.Application;
import org.apache.wink.common.model.wadl.WADLGenerator;
import org.apache.wink.server.handlers.HandlersChain;
import org.apache.wink.server.handlers.MessageContext;
import org.apache.wink.server.handlers.RequestHandler;
import org.apache.wink.server.internal.handlers.SearchResult;
import org.apache.wink.server.internal.registry.ResourceRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OptionsMethodWADLHandler
implements RequestHandler {
    private static final Logger logger = LoggerFactory.getLogger(OptionsMethodWADLHandler.class);

    public void handleRequest(MessageContext context, HandlersChain chain) throws Throwable {
        chain.doChain(context);
        SearchResult searchResult = context.getAttribute(SearchResult.class);
        if (searchResult.isError() && searchResult.getError().getResponse().getStatus() == HttpStatus.METHOD_NOT_ALLOWED.getCode() && context.getHttpMethod().equalsIgnoreCase("OPTIONS")) {
            ResourceRegistry resourceRegistry = context.getAttribute(ResourceRegistry.class);
            HashSet c = new HashSet();
            Class<?> resourceClass = searchResult.getResource().getResourceClass();
            c.add(resourceClass);
            logger.trace("Found the resource classes {}", c);
            Application app = new WADLHandlerWADLGenerator().generate(context.getUriInfo().getBaseUri().toString(), c);
            if (context.getUriInfo().getMatchedResources().size() > 1) {
                app.getResources().get(0).getResource().get(0).setPath(context.getUriInfo().getMatchedURIs().get(0));
            }
            Set<String> httpMethods = resourceRegistry.getOptions(searchResult.getResource());
            logger.trace("Invoking OPTIONS request handled by runtime with {} resource and {} HTTP methods", searchResult.getResource(), httpMethods);
            if (httpMethods.size() > 0) {
                String allowHeader = HeaderUtils.buildOptionsHeader(httpMethods);
                context.getAttribute(HttpServletResponse.class).addHeader("Allow", allowHeader);
                context.getAttribute(SearchResult.class).setError(null);
                context.setResponseStatusCode(Response.Status.OK.getStatusCode());
                context.setResponseEntity(Response.ok(app).type("application/vnd.sun.wadl+xml").build());
            }
        }
    }

    public void init(Properties props) {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class WADLHandlerWADLGenerator
    extends WADLGenerator {
        private WADLHandlerWADLGenerator() {
        }

        @Override
        protected boolean isResource(Class<?> cls) {
            return true;
        }
    }
}

