/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wink.server.internal.log;

import java.io.IOException;
import java.util.Properties;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.MultivaluedMap;
import org.apache.wink.server.handlers.HandlersChain;
import org.apache.wink.server.handlers.MessageContext;
import org.apache.wink.server.handlers.RequestHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Requests
implements RequestHandler {
    private static final Logger logger = LoggerFactory.getLogger(Requests.class);
    private static final int BREAK_POINT = Integer.valueOf(System.getProperty(Requests.class.getName() + ".breakPoint", "4096"));
    private static final boolean IS_LOGGED_AS_BYTES = Boolean.valueOf(System.getProperty(Requests.class.getName() + ".logAsBytes", "false"));
    private static final int BUFFER_SIZE = Integer.valueOf(System.getProperty(Requests.class.getName() + ".bufferSize", "8192"));

    public void init(Properties props) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleRequest(MessageContext context, HandlersChain chain) throws Throwable {
        logger.trace("handleRequest({}, {}) entry", context, (Object)chain);
        try {
            if (logger.isDebugEnabled()) {
                this.logStartRequest(context);
            }
            chain.doChain(context);
        }
        finally {
            if (logger.isDebugEnabled()) {
                this.logFinishRequest(context);
            }
        }
        logger.trace("handleRequest({}, {}) exit", context, (Object)chain);
    }

    void logStartRequest(MessageContext context) {
        logger.trace("logStartRequest() entry");
        try {
            if (!logger.isDebugEnabled()) {
                logger.trace("logStartRequest() exit");
                return;
            }
            HttpServletRequestWrapper request = context.getAttribute(HttpServletRequestWrapper.class);
            if (request == null) {
                logger.debug("Could not find the HTTP Servlet Request to wrap.");
                logger.trace("logStartRequest() exit");
                return;
            }
            logger.debug("Request URI is " + context.getUriInfo().getRequestUri().toASCIIString());
            HttpHeaders headers = context.getHttpHeaders();
            MultivaluedMap<String, String> headersMap = headers.getRequestHeaders();
            String headersString = "{";
            for (String key : headersMap.keySet()) {
                headersString = headersString + key + "=" + headersMap.get(key) + ",";
            }
            if (headersString.length() > 1) {
                headersString = headersString.substring(0, headersString.length() - 1);
            }
            headersString = headersString + "}";
            logger.debug("HTTP Headers are " + headersString);
            RequestWrapper wrapper = new RequestWrapper((HttpServletRequest)request);
            context.setAttribute(RequestWrapper.class, wrapper);
            context.setAttribute(HttpServletRequest.class, wrapper);
            context.setAttribute(HttpServletRequestWrapper.class, wrapper);
        }
        catch (Exception e) {
            logger.trace("Could not log the start of the request", e);
        }
        logger.trace("logStartRequest() exit");
    }

    void logFinishRequest(MessageContext context) {
        logger.trace("logFinishRequest() entry");
        try {
            if (!logger.isDebugEnabled()) {
                logger.trace("logFinishRequest() exit");
                return;
            }
            RequestWrapper requestWrapper = context.getAttribute(RequestWrapper.class);
            if (requestWrapper == null) {
                logger.debug("Did not find the RequestWrapper so will not log the request entity.");
                logger.trace("logStartRequest() exit");
                return;
            }
            LoggedServletInputStream loggedInputStream = requestWrapper.getLoggedInputStream();
            if (loggedInputStream == null || loggedInputStream.getLoggedByteBufferLength() == 0) {
                logger.debug("The request entity was not read from the HttpServletRequest.getInputStream().");
                return;
            }
            byte[] buffer = loggedInputStream.getLoggedByteBuffer();
            int bufferLength = loggedInputStream.getLoggedByteBufferLength();
            if (IS_LOGGED_AS_BYTES) {
                logger.debug("The request entity as bytes:");
                StringBuffer sb = new StringBuffer();
                int outputCount = 0;
                for (int count = 0; count < bufferLength; ++count) {
                    sb.append(String.format("%#04x ", buffer[count]));
                    sb.append(" ");
                    if (++outputCount <= BREAK_POINT) continue;
                    logger.debug("{}", sb);
                    sb = new StringBuffer();
                    outputCount = 0;
                }
                if (outputCount > 0) {
                    logger.debug("{}", sb);
                    sb = new StringBuffer();
                }
            } else {
                int length;
                logger.debug("The request entity as a String in the default encoding:");
                for (int offset = 0; offset < bufferLength; offset += length) {
                    length = bufferLength - offset;
                    if (length > BREAK_POINT) {
                        length = BREAK_POINT;
                    }
                    String str = new String(buffer, offset, length);
                    logger.debug("{}", (Object)str);
                }
            }
            context.setAttribute(RequestWrapper.class, null);
        }
        catch (Exception e) {
            logger.debug("Could not log the finishing of the request", e);
        }
        logger.trace("logFinishRequest() exit");
    }

    public static class LoggedServletInputStream
    extends ServletInputStream {
        private final ServletInputStream originalRequest;
        private final byte[] requestBuffer;
        private int offset = 0;

        public LoggedServletInputStream(ServletInputStream originalRequest, int bufferSize) {
            this.originalRequest = originalRequest;
            this.requestBuffer = new byte[bufferSize];
        }

        public int available() throws IOException {
            return this.originalRequest.available();
        }

        public void close() throws IOException {
            this.originalRequest.close();
        }

        public void mark(int readlimit) {
            this.originalRequest.mark(readlimit);
        }

        public boolean markSupported() {
            return this.originalRequest.markSupported();
        }

        public int read() throws IOException {
            int value = this.originalRequest.read();
            if (value < 0) {
                return value;
            }
            if (this.offset < this.requestBuffer.length - 1) {
                this.requestBuffer[this.offset] = (byte)value;
                ++this.offset;
            }
            return value;
        }

        public int read(byte[] b) throws IOException {
            int value = this.originalRequest.read(b);
            if (value < 0) {
                return value;
            }
            int diff = value;
            if (this.offset + value > this.requestBuffer.length) {
                diff = this.requestBuffer.length - this.offset;
            }
            if (diff > 0) {
                System.arraycopy(b, 0, this.requestBuffer, this.offset, diff);
                this.offset += diff;
            }
            return value;
        }

        public int read(byte[] b, int off, int len) throws IOException {
            int value = this.originalRequest.read(b, off, len);
            if (value < 0) {
                return value;
            }
            int diff = value;
            if (this.offset + value > this.requestBuffer.length) {
                diff = this.requestBuffer.length - this.offset;
            }
            if (diff > 0) {
                System.arraycopy(b, off, this.requestBuffer, this.offset, diff);
                this.offset += diff;
            }
            return value;
        }

        public int readLine(byte[] b, int off, int len) throws IOException {
            int value = this.originalRequest.readLine(b, off, len);
            if (value < 0) {
                return value;
            }
            int diff = value;
            if (this.offset + value > this.requestBuffer.length) {
                diff = this.requestBuffer.length - this.offset;
            }
            if (diff > 0) {
                System.arraycopy(b, off, this.requestBuffer, this.offset, diff);
                this.offset += diff;
            }
            return value;
        }

        public void reset() throws IOException {
            this.originalRequest.reset();
        }

        public long skip(long n) throws IOException {
            return this.originalRequest.skip(n);
        }

        public byte[] getLoggedByteBuffer() {
            return this.requestBuffer;
        }

        public int getLoggedByteBufferLength() {
            return this.offset;
        }
    }

    public static class RequestWrapper
    extends HttpServletRequestWrapper {
        private final HttpServletRequest request;
        private LoggedServletInputStream inputStreamLogger = null;
        private ServletInputStream originalStream;
        private boolean hasStreamBeenRetrievedBefore = false;

        public RequestWrapper(HttpServletRequest request) {
            super(request);
            this.request = request;
        }

        public ServletInputStream getInputStream() throws IOException {
            if (this.inputStreamLogger != null) {
                return this.inputStreamLogger;
            }
            if (!this.hasStreamBeenRetrievedBefore) {
                this.originalStream = this.request.getInputStream();
            }
            if (this.originalStream == null) {
                logger.debug("The web container did not return a stream from HttpServletRequest.getInputStream()");
                return null;
            }
            this.inputStreamLogger = new LoggedServletInputStream(this.originalStream, BUFFER_SIZE);
            return this.inputStreamLogger;
        }

        public LoggedServletInputStream getLoggedInputStream() {
            return this.inputStreamLogger;
        }
    }
}

