/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.scm.common.internal.util;

import com.ibm.team.repository.common.IItemType;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.common.internal.util.ItemUtil;
import com.ibm.team.repository.common.model.ItemType;
import com.ibm.team.repository.common.validation.IPropertyConstraintErrorStatus;
import com.ibm.team.repository.common.validation.PropertyConstraintException;
import com.ibm.team.scm.common.IVersionable;
import com.ibm.team.scm.common.IVersionableHandle;
import com.ibm.team.scm.common.internal.VersionableHandle;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;

public class SCMItemUtil {
    public static IVersionableHandle createVersionableHandle(EClass eClass, UUID itemId, UUID optionalStateId) {
        EObject object = eClass.getEPackage().getEFactoryInstance().create(eClass);
        if (object instanceof VersionableHandle) {
            VersionableHandle handle = (VersionableHandle)object;
            handle.setItemId(itemId);
            handle.setStateId(optionalStateId);
            return handle;
        }
        return null;
    }

    public static IVersionableHandle createVersionableHandle(ItemType itemType, UUID itemId, UUID optionalStateId) {
        EClass eClass = ItemUtil.getHandleEClass((ItemType)itemType);
        return SCMItemUtil.createVersionableHandle(eClass, itemId, optionalStateId);
    }

    public static VersionableHandle newVersionableHandle(IVersionableHandle versionableHandle, boolean includeStateId) {
        ItemType type = (ItemType)versionableHandle.getItemType();
        UUID itemId = versionableHandle.getItemId();
        UUID optionalStateId = includeStateId ? versionableHandle.getStateId() : null;
        VersionableHandle newVersionableHandle = (VersionableHandle)SCMItemUtil.createVersionableHandle(type, itemId, optionalStateId);
        newVersionableHandle.setOrigin(versionableHandle.getOrigin());
        return newVersionableHandle;
    }

    public static PropertyConstraintException buildConstraintException(IVersionable item, IStatus status) {
        if (item == null) {
            throw new IllegalArgumentException();
        }
        if (status == null) {
            throw new IllegalArgumentException();
        }
        StringBuffer message = new StringBuffer();
        MultiStatus multi = (MultiStatus)status;
        IStatus[] iStatusArray = multi.getChildren();
        int n = iStatusArray.length;
        int n2 = 0;
        while (n2 < n) {
            IStatus s = iStatusArray[n2];
            IPropertyConstraintErrorStatus specific = (IPropertyConstraintErrorStatus)s;
            IItemType type = specific.getRootType();
            message.append("ItemType " + type.getName() + " : property ");
            String[] propertyPath = specific.getPropertyPath();
            int i = 0;
            while (i < propertyPath.length) {
                String pathElem = propertyPath[i];
                message.append(pathElem);
                if (i != 0) {
                    message.append("\\");
                }
                ++i;
            }
            switch (specific.getCode()) {
                case -2: {
                    message.append(" cannot be null.");
                    break;
                }
                case -4: {
                    message.append(" cannot be an empty string.");
                    break;
                }
                case -3: {
                    message.append(" exceeds model specified string size.");
                }
            }
            ++n2;
        }
        message.append("\n");
        PropertyConstraintException e = new PropertyConstraintException(message.toString());
        e.setData((Object)item);
        return e;
    }
}

