/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.urelease.plugin.rtc.plain.api;

import com.ibm.team.links.common.IReference;
import com.ibm.team.process.client.IProcessClientService;
import com.ibm.team.process.client.IProcessItemService;
import com.ibm.team.process.common.IDevelopmentLine;
import com.ibm.team.process.common.IDevelopmentLineHandle;
import com.ibm.team.process.common.IIteration;
import com.ibm.team.process.common.IIterationHandle;
import com.ibm.team.process.common.IProjectArea;
import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.repository.client.IItemManager;
import com.ibm.team.repository.client.ILoginHandler2;
import com.ibm.team.repository.client.ILoginInfo2;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.client.TeamPlatform;
import com.ibm.team.repository.client.login.UsernameAndPasswordLoginInfo;
import com.ibm.team.repository.common.IAuditable;
import com.ibm.team.repository.common.IAuditableHandle;
import com.ibm.team.repository.common.IContributor;
import com.ibm.team.repository.common.IContributorHandle;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.Location;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.workitem.client.IAuditableClient;
import com.ibm.team.workitem.client.IQueryClient;
import com.ibm.team.workitem.client.IWorkItemClient;
import com.ibm.team.workitem.common.IAuditableCommon;
import com.ibm.team.workitem.common.IWorkItemCommon;
import com.ibm.team.workitem.common.model.IAttribute;
import com.ibm.team.workitem.common.model.IAttributeHandle;
import com.ibm.team.workitem.common.model.ICategory;
import com.ibm.team.workitem.common.model.IEnumeration;
import com.ibm.team.workitem.common.model.ILiteral;
import com.ibm.team.workitem.common.model.ISeverity;
import com.ibm.team.workitem.common.model.IWorkItem;
import com.ibm.team.workitem.common.model.IWorkItemHandle;
import com.ibm.team.workitem.common.model.IWorkItemReferences;
import com.ibm.team.workitem.common.model.IWorkItemType;
import com.ibm.team.workitem.common.model.Identifier;
import com.ibm.team.workitem.common.model.ItemProfile;
import com.ibm.team.workitem.common.model.WorkItemEndPoints;
import com.ibm.team.workitem.common.query.IQueryDescriptor;
import com.ibm.team.workitem.common.query.IQueryResult;
import com.ibm.team.workitem.common.query.IResolvedResult;
import com.ibm.team.workitem.common.query.IResult;
import com.ibm.team.workitem.common.workflow.ICombinedWorkflowInfos;
import com.ibm.team.workitem.common.workflow.IWorkflowInfo;
import com.urbancode.urelease.plugin.rtc.plain.api.models.RTCCustomAttribute;
import com.urbancode.urelease.plugin.rtc.plain.api.models.RTCItem;
import com.urbancode.urelease.plugin.rtc.plain.api.models.RTCWorkItem;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RTCClientHelper {
    private static Logger LOGGER = Logger.getLogger(RTCClientHelper.class);
    private String login;
    private String password;
    private String serverUrl;
    private IProgressMonitor progressMonitor = new NullProgressMonitor();
    private ITeamRepository repo;
    private IProjectArea rtcProjectArea;

    public void login(String userLogin, String userPassword, String rtcServerUrl) {
        this.login = userLogin;
        this.password = userPassword;
        this.serverUrl = rtcServerUrl;
        TeamPlatform.startup();
        try {
            this.repo = TeamPlatform.getTeamRepositoryService().getTeamRepository(this.serverUrl);
            this.repo.registerLoginHandler(new ILoginHandler2(){

                public ILoginInfo2 challenge(ITeamRepository repo) {
                    return new UsernameAndPasswordLoginInfo(RTCClientHelper.this.login, RTCClientHelper.this.password);
                }
            });
            this.repo.login(this.progressMonitor);
        }
        catch (TeamRepositoryException e) {
            System.out.println("Error: " + e.getMessage());
        }
    }

    public void logout() {
        this.repo.logout();
        if (TeamPlatform.isStarted()) {
            TeamPlatform.shutdown();
        }
    }

    public List<RTCItem> getAllProjectAreasSorted() throws TeamRepositoryException {
        ArrayList<RTCItem> projects = new ArrayList<RTCItem>();
        List<IProjectArea> unsortedProjectAreas = this.getAllProjectAreas();
        for (IProjectArea project : unsortedProjectAreas) {
            projects.add(new RTCItem(project.getItemId().getUuidValue(), project.getName()));
        }
        Collections.sort(projects);
        return projects;
    }

    public List<IProjectArea> getAllProjectAreas() throws TeamRepositoryException {
        List projectAreas = null;
        IProcessItemService itemService = (IProcessItemService)this.repo.getClientLibrary(IProcessItemService.class);
        projectAreas = itemService.findAllProjectAreas(null, this.progressMonitor);
        return projectAreas;
    }

    public List<RTCItem> getAllQueriesSorted(IProjectArea project) throws TeamRepositoryException {
        ArrayList<RTCItem> queries = new ArrayList<RTCItem>();
        List<IQueryDescriptor> unsortedQueries = this.getAllQueries(project);
        for (IQueryDescriptor query : unsortedQueries) {
            queries.add(new RTCItem(query.getItemId().getUuidValue(), query.getName()));
        }
        Collections.sort(queries);
        return queries;
    }

    public List<IQueryDescriptor> getAllQueries(IProjectArea project) throws TeamRepositoryException {
        List queries = null;
        ITeamRepository teamRepository = (ITeamRepository)project.getOrigin();
        IWorkItemClient workItemClient = (IWorkItemClient)teamRepository.getClientLibrary(IWorkItemClient.class);
        IQueryClient queryClient = workItemClient.getQueryClient();
        IContributor loggedIn = teamRepository.loggedInContributor();
        queries = queryClient.findPersonalQueries(project.getProjectArea(), (IContributorHandle)loggedIn, "com.ibm.team.workitem.workItemType", IQueryDescriptor.FULL_PROFILE, this.progressMonitor);
        return queries;
    }

    public List<IQueryDescriptor> getAllSharedQueries(IProjectArea project) throws TeamRepositoryException {
        List queries = null;
        ITeamRepository teamRepository = (ITeamRepository)project.getOrigin();
        IWorkItemClient workItemClient = (IWorkItemClient)teamRepository.getClientLibrary(IWorkItemClient.class);
        IQueryClient queryClient = workItemClient.getQueryClient();
        ArrayList<IProjectArea> sharingTargets = new ArrayList<IProjectArea>();
        sharingTargets.add(project);
        queries = queryClient.findSharedQueries(project.getProjectArea(), sharingTargets, "com.ibm.team.workitem.workItemType", IQueryDescriptor.FULL_PROFILE, this.progressMonitor);
        return queries;
    }

    public IProjectArea getProjectAreaByName(String projectAreaName) throws TeamRepositoryException {
        IProjectArea projectArea = null;
        IProcessClientService processClient = (IProcessClientService)this.repo.getClientLibrary(IProcessClientService.class);
        URI uri = URI.create(projectAreaName.replaceAll(" ", "%20"));
        projectArea = (IProjectArea)processClient.findProcessArea(uri, null, null);
        return projectArea;
    }

    public IQueryDescriptor findPersonalQuery(IProjectArea projectArea, String queryName) throws TeamRepositoryException {
        ITeamRepository teamRepository = (ITeamRepository)projectArea.getOrigin();
        IWorkItemClient workItemClient = (IWorkItemClient)teamRepository.getClientLibrary(IWorkItemClient.class);
        IQueryClient queryClient = workItemClient.getQueryClient();
        IContributor loggedIn = teamRepository.loggedInContributor();
        IQueryDescriptor queryToRun = null;
        List queries = queryClient.findPersonalQueries(projectArea.getProjectArea(), (IContributorHandle)loggedIn, "com.ibm.team.workitem.workItemType", IQueryDescriptor.FULL_PROFILE, this.progressMonitor);
        for (IQueryDescriptor iQueryDescriptor : queries) {
            if (!iQueryDescriptor.getName().equals(queryName)) continue;
            queryToRun = iQueryDescriptor;
            break;
        }
        return queryToRun;
    }

    public IQueryDescriptor findSharedQuery(IProjectArea projectArea, String queryName) throws TeamRepositoryException {
        ITeamRepository teamRepository = (ITeamRepository)projectArea.getOrigin();
        IWorkItemClient workItemClient = (IWorkItemClient)teamRepository.getClientLibrary(IWorkItemClient.class);
        IQueryClient queryClient = workItemClient.getQueryClient();
        IQueryDescriptor queryToRun = null;
        ArrayList<IProjectArea> sharingTargets = new ArrayList<IProjectArea>();
        sharingTargets.add(projectArea);
        List queries = queryClient.findSharedQueries(projectArea.getProjectArea(), sharingTargets, "com.ibm.team.workitem.workItemType", IQueryDescriptor.FULL_PROFILE, this.progressMonitor);
        for (IQueryDescriptor iQueryDescriptor : queries) {
            if (!iQueryDescriptor.getName().equals(queryName)) continue;
            queryToRun = iQueryDescriptor;
            break;
        }
        return queryToRun;
    }

    public IQueryResult<IResolvedResult<IWorkItem>> resolveQueryResult(IQueryDescriptor query, ItemProfile<IWorkItem> profile) {
        IWorkItemClient workItemClient = (IWorkItemClient)this.repo.getClientLibrary(IWorkItemClient.class);
        IQueryClient queryClient = workItemClient.getQueryClient();
        ItemProfile<IWorkItem> loadProfile = profile;
        IQueryResult resolvedResults = queryClient.getResolvedQueryResults(query, loadProfile);
        return resolvedResults;
    }

    public IQueryResult<IResult> unResolvedResults(IQueryDescriptor query) throws TeamRepositoryException {
        IWorkItemClient workItemClient = (IWorkItemClient)this.repo.getClientLibrary(IWorkItemClient.class);
        IQueryClient queryClient = workItemClient.getQueryClient();
        IQueryResult unresolvedResults = queryClient.getQueryResults(query);
        return unresolvedResults;
    }

    public void processResolvedResults(IProjectArea projectArea, IQueryResult<IResolvedResult<IWorkItem>> resolvedResults, IProgressMonitor monitor) throws TeamRepositoryException {
        long processed = 0L;
        while (resolvedResults.hasNext(monitor)) {
            IResolvedResult result = (IResolvedResult)resolvedResults.next(monitor);
            IWorkItem workItem = (IWorkItem)result.getItem();
            System.out.println(processed + ": " + workItem.getHTMLSummary());
            ++processed;
        }
        LOGGER.debug((Object)("Processed results: " + processed));
    }

    public void processUnresolvedResults(IProjectArea projectArea, IQueryResult<IResult> results, ItemProfile<IWorkItem> profile) throws TeamRepositoryException {
        ITeamRepository teamRepository = (ITeamRepository)projectArea.getOrigin();
        IAuditableCommon auditableCommon = (IAuditableCommon)teamRepository.getClientLibrary(IAuditableCommon.class);
        long processed = 0L;
        while (results.hasNext(this.progressMonitor)) {
            IResult result = (IResult)results.next(this.progressMonitor);
            IWorkItem workItem = (IWorkItem)auditableCommon.resolveAuditable((IAuditableHandle)result.getItem(), profile, this.progressMonitor);
            System.out.println(processed + ": " + workItem.getHTMLSummary());
            ++processed;
        }
        LOGGER.debug((Object)("Processed results: " + processed));
    }

    public List<RTCWorkItem> getWorkAllItemsFromQuery(IProjectArea projectArea, String queryName, List<String> urlsExistingItem, Date lastExecution) throws TeamRepositoryException {
        ArrayList<RTCWorkItem> items = new ArrayList();
        IQueryDescriptor query = this.findPersonalQuery(projectArea, queryName);
        IQueryResult<IResult> resultCount = this.unResolvedResults(query);
        int resultCountTotal = resultCount.getResultSize(null).getTotal();
        System.out.println("Query Size=>" + resultCount.getResultSize(null).getTotal());
        System.out.println("Max Available=>" + resultCount.getResultSize(null).getTotalAvailable());
        IQueryResult<IResult> results = this.unResolvedResults(query);
        if (resultCountTotal > 1000) {
            System.out.println("Changing limit to " + resultCountTotal);
            results.setLimit(resultCountTotal);
        }
        items = this.processCustomedUnresolvedResults(projectArea, results, urlsExistingItem, lastExecution);
        return items;
    }

    public List<RTCWorkItem> getWorkAllItemsFromQueryWithCustomAttributes(IProjectArea projectArea, String queryName, List<String> urlsExistingItem, Date lastExecution) throws TeamRepositoryException {
        ArrayList<RTCWorkItem> items = new ArrayList();
        IQueryDescriptor query = this.findPersonalQuery(projectArea, queryName);
        IQueryResult<IResult> resultCount = this.unResolvedResults(query);
        int resultCountTotal = resultCount.getResultSize(null).getTotal();
        System.out.println("Query Size=>" + resultCount.getResultSize(null).getTotal());
        System.out.println("Max Available=>" + resultCount.getResultSize(null).getTotalAvailable());
        IQueryResult<IResult> results = this.unResolvedResults(query);
        if (resultCountTotal > 1000) {
            System.out.println("Changing limit to " + resultCountTotal);
            results.setLimit(resultCountTotal);
        }
        items = this.processUnresolvedResultsWithCustomAttributes(projectArea, results, urlsExistingItem, lastExecution);
        return items;
    }

    public Map<String, String> getWorkItemToParentMap(IProjectArea projectArea, String queryName) throws TeamRepositoryException {
        HashMap<String, String> workItemToParentIds = new HashMap();
        IQueryDescriptor query = this.findPersonalQuery(projectArea, queryName);
        IQueryResult<IResult> results = this.unResolvedResults(query);
        workItemToParentIds = this.getWorkItemParentMap(projectArea, results);
        return workItemToParentIds;
    }

    public Map<String, String> getWorkItemParentMap(IProjectArea projectArea, IQueryResult<IResult> results) throws TeamRepositoryException {
        HashMap<String, String> workItemToParentIds = new HashMap<String, String>();
        ITeamRepository teamRepository = (ITeamRepository)projectArea.getOrigin();
        IAuditableCommon auditableCommon = (IAuditableCommon)teamRepository.getClientLibrary(IAuditableCommon.class);
        long processed = 0L;
        while (results.hasNext(this.progressMonitor)) {
            IResult result = (IResult)results.next(this.progressMonitor);
            IWorkItem workItem = (IWorkItem)auditableCommon.resolveAuditable((IAuditableHandle)result.getItem(), IWorkItem.SMALL_PROFILE, this.progressMonitor);
            String parent = this.getWorkItemParent(workItem);
            if (parent != null) {
                workItemToParentIds.put(workItem.getId() + "", parent);
            }
            ++processed;
        }
        return workItemToParentIds;
    }

    public List<RTCWorkItem> processCustomedUnresolvedResults(IProjectArea projectArea, IQueryResult<IResult> results, List<String> existingItems, Date lastUpdate) throws TeamRepositoryException {
        ArrayList<RTCWorkItem> items = new ArrayList<RTCWorkItem>();
        ITeamRepository teamRepository = (ITeamRepository)projectArea.getOrigin();
        IAuditableCommon auditableCommon = (IAuditableCommon)teamRepository.getClientLibrary(IAuditableCommon.class);
        long processed = 0L;
        while (results.hasNext(this.progressMonitor)) {
            IResult result = (IResult)results.next(this.progressMonitor);
            ItemProfile customProfile = IWorkItem.SMALL_PROFILE.createExtension(Arrays.asList(IWorkItem.SEVERITY_PROPERTY, IWorkItem.STATE_PROPERTY, IWorkItem.TARGET_PROPERTY, IWorkItem.CATEGORY_PROPERTY));
            IWorkItem workItem = (IWorkItem)auditableCommon.resolveAuditable((IAuditableHandle)result.getItem(), customProfile, this.progressMonitor);
            String target = this.getTarget(workItem);
            if (lastUpdate == null || workItem.modified().getTime() > lastUpdate.getTime() || !existingItems.contains(target)) {
                String parent;
                IWorkItemType type;
                ICategory category;
                String status;
                RTCWorkItem rtcWorkItem = new RTCWorkItem(workItem.getId() + "", workItem.getHTMLSummary().toString(), workItem.modified());
                String severity = this.getSeverity(projectArea, workItem);
                if (severity != null) {
                    rtcWorkItem.setSeverity(severity);
                }
                if ((status = this.getState(workItem)) != null) {
                    rtcWorkItem.setStatus(status);
                }
                rtcWorkItem.setTarget(target);
                IIteration iteration = this.getIteration(workItem);
                if (iteration != null) {
                    rtcWorkItem.setPlannedFor(iteration.getName());
                    rtcWorkItem.setIterationId(iteration.getItemId().getUuidValue());
                }
                if (workItem.getCategory() != null && (category = this.getCategory(workItem)) != null) {
                    rtcWorkItem.setFiledAgainst(category.getName());
                    rtcWorkItem.setCategoryId(category.getItemId().getUuidValue());
                }
                if ((type = this.getType(projectArea, workItem)) != null) {
                    rtcWorkItem.setType(type.getDisplayName());
                }
                if ((parent = this.getWorkItemParent(workItem)) != null) {
                    rtcWorkItem.setParentId(parent);
                    IWorkItem parentItem = this.getWorkItemById(Integer.parseInt(parent));
                    String parentTarget = this.getTarget(parentItem);
                    rtcWorkItem.setParentTarget(parentTarget);
                }
                items.add(rtcWorkItem);
            }
            ++processed;
        }
        return items;
    }

    public String getWorkItemParent(IWorkItem item) throws TeamRepositoryException {
        String parent = null;
        IWorkItemCommon common = (IWorkItemCommon)this.repo.getClientLibrary(IWorkItemCommon.class);
        IWorkItemReferences workitemReferences = common.resolveWorkItemReferences((IWorkItemHandle)item, null);
        List references = workitemReferences.getReferences(WorkItemEndPoints.PARENT_WORK_ITEM);
        for (IReference reference : references) {
            if (!reference.isItemReference() || reference.getComment() == null || reference.getComment().isEmpty() || !reference.getComment().contains(":")) continue;
            parent = reference.getComment().substring(0, reference.getComment().indexOf(":"));
        }
        return parent;
    }

    public IWorkItem getWorkItemById(int id) throws TeamRepositoryException {
        IWorkItemClient workItemClient = (IWorkItemClient)this.repo.getClientLibrary(IWorkItemClient.class);
        IWorkItem item = workItemClient.findWorkItemById(id, IWorkItem.SMALL_PROFILE, this.progressMonitor);
        return item;
    }

    public String getTarget(IWorkItem item) throws TeamRepositoryException {
        Location location = Location.itemLocation((IItemHandle)item, (String)this.serverUrl);
        return location.toAbsoluteUri().toString();
    }

    public IIteration getIteration(IWorkItem item) throws TeamRepositoryException {
        IIteration iteration = null;
        if (item.getTarget() != null) {
            IAuditableCommon auditableCommon = (IAuditableCommon)this.repo.getClientLibrary(IAuditableCommon.class);
            IAuditable anAuditable = auditableCommon.resolveAuditable((IAuditableHandle)item.getTarget(), ItemProfile.ITERATION_DEFAULT, null);
            iteration = (IIteration)anAuditable;
        }
        return iteration;
    }

    public String getState(IWorkItem item) throws TeamRepositoryException {
        String status = null;
        IWorkItemClient workItemClient = (IWorkItemClient)this.repo.getClientLibrary(IWorkItemClient.class);
        IWorkflowInfo info = workItemClient.findWorkflowInfo(item, this.progressMonitor);
        status = info.getStateName(item.getState2());
        return status;
    }

    public String getSeverity(IProjectArea project, IWorkItem item) throws TeamRepositoryException {
        String severity = null;
        IWorkItemClient workItemClient = (IWorkItemClient)this.repo.getClientLibrary(IWorkItemClient.class);
        IAttribute severityAttribute = workItemClient.findAttribute((IProjectAreaHandle)project, IWorkItem.SEVERITY_PROPERTY, this.progressMonitor);
        IEnumeration severityEnum = workItemClient.resolveEnumeration((IAttributeHandle)severityAttribute, this.progressMonitor);
        ISeverity resolvedSeverity = (ISeverity)severityEnum.findEnumerationLiteral(item.getSeverity());
        severity = resolvedSeverity.getName();
        return severity;
    }

    public ICategory getCategory(IWorkItem item) throws TeamRepositoryException {
        IItemManager itm = this.repo.itemManager();
        ICategory category = (ICategory)itm.fetchCompleteItem((IItemHandle)item.getCategory(), 0, this.progressMonitor);
        return category;
    }

    public IWorkItemType getType(IProjectArea project, IWorkItem item) throws TeamRepositoryException {
        IWorkItemClient workItemClient = (IWorkItemClient)this.repo.getClientLibrary(IWorkItemClient.class);
        IWorkItemType type = workItemClient.findWorkItemType((IProjectAreaHandle)project, item.getWorkItemType(), this.progressMonitor);
        return type;
    }

    public List<RTCItem> getAllStatusesSorted(IProjectArea project) throws TeamRepositoryException {
        ArrayList<RTCItem> statuses = new ArrayList<RTCItem>();
        IWorkflowInfo[] workflowInfos = null;
        IWorkItemCommon workItemCommon = (IWorkItemCommon)this.repo.getClientLibrary(IWorkItemCommon.class);
        ICombinedWorkflowInfos combinedWorkflowInfos = workItemCommon.findCombinedWorkflowInfos((IProjectAreaHandle)project, this.progressMonitor);
        for (IWorkflowInfo workflowInfo : workflowInfos = combinedWorkflowInfos.getWorkflowInfos()) {
            Identifier[] states;
            for (Identifier state : states = workflowInfo.getAllStateIds()) {
                String name;
                String id = workflowInfo.getIdentifier();
                if (statuses.contains(new RTCItem(id, name = workflowInfo.getStateName(state)))) continue;
                statuses.add(new RTCItem(id, name));
            }
        }
        Collections.sort(statuses);
        return statuses;
    }

    public String getCustomAttributes(IWorkItem item, String attr) throws TeamRepositoryException {
        String value = null;
        List custAttributeHandles = item.getCustomAttributes();
        for (IAttributeHandle iAttributeHandle : custAttributeHandles) {
            IAttribute iAttribute = (IAttribute)this.repo.itemManager().fetchCompleteItem((IItemHandle)iAttributeHandle, 0, this.progressMonitor);
            Object custom = item.getValue(iAttribute);
            if (!iAttribute.getDisplayName().equals(attr) || !(custom instanceof String)) continue;
            value = (String)custom;
        }
        return value;
    }

    public void getWorkItemStatuses(IWorkflowInfo workflow) {
        Identifier[] states;
        for (Identifier state : states = workflow.getAllStateIds()) {
            String name = workflow.getStateName(state);
            LOGGER.debug((Object)("--->Status: " + name));
        }
    }

    public IWorkflowInfo[] getWorkAllWorkFlow(IProjectArea project) throws TeamRepositoryException {
        IWorkflowInfo[] workflowInfos = null;
        IWorkItemCommon workItemCommon = (IWorkItemCommon)this.repo.getClientLibrary(IWorkItemCommon.class);
        ICombinedWorkflowInfos combinedWorkflowInfos = workItemCommon.findCombinedWorkflowInfos((IProjectAreaHandle)project, this.progressMonitor);
        for (IWorkflowInfo workflowInfo : workflowInfos = combinedWorkflowInfos.getWorkflowInfos()) {
            LOGGER.debug((Object)workflowInfo.getName());
            this.getWorkItemStatuses(workflowInfo);
        }
        return workflowInfos;
    }

    public List<RTCItem> getAllWorkItemTypesSorted(IProjectArea project) throws TeamRepositoryException {
        IWorkItemClient workItemClient = (IWorkItemClient)this.repo.getClientLibrary(IWorkItemClient.class);
        ArrayList<RTCItem> types = new ArrayList<RTCItem>();
        List iWorkItemType = workItemClient.findWorkItemTypes((IProjectAreaHandle)project, null);
        for (IWorkItemType type : iWorkItemType) {
            types.add(new RTCItem(type.getDisplayName(), type.getDisplayName()));
        }
        Collections.sort(types);
        return types;
    }

    public String getSeverity(IWorkItem item) throws TeamRepositoryException {
        String severity = null;
        IWorkItemClient workItemClient = (IWorkItemClient)this.repo.getClientLibrary(IWorkItemClient.class);
        IAttribute severityAttribute = workItemClient.findAttribute((IProjectAreaHandle)this.rtcProjectArea, IWorkItem.SEVERITY_PROPERTY, this.progressMonitor);
        IEnumeration severityEnum = workItemClient.resolveEnumeration((IAttributeHandle)severityAttribute, this.progressMonitor);
        ISeverity resolvedSeverity = (ISeverity)severityEnum.findEnumerationLiteral(item.getSeverity());
        severity = resolvedSeverity.getName();
        return severity;
    }

    public List<ICategory> getWorkItemCategories(IProjectArea project) throws TeamRepositoryException {
        List categories = null;
        IWorkItemClient workItemClient = (IWorkItemClient)this.repo.getClientLibrary(IWorkItemClient.class);
        categories = workItemClient.findCategories((IProjectAreaHandle)project, ICategory.FULL_PROFILE, null);
        return categories;
    }

    public List<ISeverity> getWorkItemSeverities(IProjectArea project) throws TeamRepositoryException {
        List severities = null;
        IWorkItemClient workItemClient = (IWorkItemClient)this.repo.getClientLibrary(IWorkItemClient.class);
        severities = workItemClient.findSeverities((IProjectAreaHandle)project, this.progressMonitor);
        return severities;
    }

    public List<IIteration> getPlannedForList(IProjectArea project) throws TeamRepositoryException {
        ArrayList<Object> list = new ArrayList();
        ArrayList listall = new ArrayList();
        IDevelopmentLineHandle[] developmentHandles = project.getDevelopmentLines();
        IDevelopmentLine line22 = null;
        if (developmentHandles != null) {
            List developmentLines = null;
            developmentLines = this.repo.itemManager().fetchCompleteItems(Arrays.asList(developmentHandles), 0, null);
            for (IDevelopmentLine line22 : developmentLines) {
                IIterationHandle[] iIterationHandleArray = line22.getIterations();
                list = this.getPlannedForRecursive(iIterationHandleArray);
                if (list == null) continue;
                listall.add(list);
            }
        }
        ArrayList<IIteration> data = new ArrayList<IIteration>();
        for (ArrayList arrayList : listall) {
            if (arrayList == null) continue;
            for (IIteration s : arrayList) {
                if (s.getItemId().getUuidValue() == null) continue;
                data.add(s);
            }
        }
        return data;
    }

    private ArrayList<IIteration> getPlannedForRecursive(IIterationHandle[] iterationHandles) throws TeamRepositoryException {
        ArrayList<IIteration> interations = new ArrayList<IIteration>();
        if (iterationHandles != null) {
            List iterationlines = null;
            iterationlines = this.repo.itemManager().fetchCompleteItems(Arrays.asList(iterationHandles), 0, null);
            IIteration iteration2 = null;
            for (IIteration iteration2 : iterationlines) {
                if (iteration2.getName() != null && !iteration2.isArchived()) {
                    interations.add(iteration2);
                }
                ArrayList<IIteration> templist = null;
                if (iteration2.getChildren() != null) {
                    templist = this.getPlannedForRecursive(iteration2.getChildren());
                }
                if (templist == null) continue;
                for (IIteration s : templist) {
                    if (s == null) continue;
                    interations.add(s);
                }
            }
        }
        return interations;
    }

    public List<RTCItem> getAllCustomAttributesSorted(IProjectArea project) throws TeamRepositoryException {
        ArrayList<RTCItem> items = new ArrayList<RTCItem>();
        items.add(new RTCItem("category", "Filed Against"));
        items.add(new RTCItem("target", "Planned For"));
        IWorkItemCommon workItemCommon = (IWorkItemCommon)this.repo.getClientLibrary(IWorkItemCommon.class);
        for (IAttribute iAttribute : workItemCommon.findAttributes((IProjectAreaHandle)project, null)) {
            if (iAttribute.isBuiltIn()) continue;
            items.add(new RTCItem(iAttribute.getIdentifier(), iAttribute.getDisplayName()));
        }
        Collections.sort(items);
        return items;
    }

    public RTCCustomAttribute getCustomAttribute(IWorkItem item, String attr) throws TeamRepositoryException {
        RTCCustomAttribute attribute = null;
        List custAttributeHandles = item.getCustomAttributes();
        for (IAttributeHandle iAttributeHandle : custAttributeHandles) {
            Object custom;
            IAttribute iAttribute = (IAttribute)this.repo.itemManager().fetchCompleteItem((IItemHandle)iAttributeHandle, 0, this.progressMonitor);
            if (!item.hasAttribute(iAttribute) || !iAttribute.getDisplayName().equals(attr) || (custom = item.getValue(iAttribute)) == null) continue;
            if (custom instanceof String) {
                String value = (String)custom;
                if (value == null || value.isEmpty()) continue;
                attribute = new RTCCustomAttribute(iAttribute.getDisplayName(), value, "String");
                continue;
            }
            if (custom instanceof Identifier) {
                Identifier literalID = (Identifier)custom;
                ILiteral literal = this.getLiteralbyID((Identifier<ILiteral>)literalID, (IAttributeHandle)iAttribute);
                String displayValue = literal.getName();
                attribute = new RTCCustomAttribute(iAttribute.getDisplayName(), displayValue, "Literal");
                continue;
            }
            if (!(custom instanceof IContributorHandle)) continue;
            IContributorHandle contributorHandle = (IContributorHandle)custom;
            IContributor contributor = (IContributor)this.repo.itemManager().fetchCompleteItem((IItemHandle)contributorHandle, 0, null);
            String name = contributor.getName();
            attribute = new RTCCustomAttribute(iAttribute.getDisplayName(), name, "Contributor");
        }
        return attribute;
    }

    public List<RTCCustomAttribute> getAllCustomAttributes(IWorkItem item) throws TeamRepositoryException {
        ArrayList<RTCCustomAttribute> attributes = new ArrayList<RTCCustomAttribute>();
        IAuditableClient client = (IAuditableClient)this.repo.getClientLibrary(IAuditableClient.class);
        List custAttributeHandles = item.getCustomAttributes();
        for (IAttributeHandle iAttributeHandle : custAttributeHandles) {
            String name;
            IAttribute iAttribute = (IAttribute)this.repo.itemManager().fetchCompleteItem((IItemHandle)iAttributeHandle, 0, this.progressMonitor);
            if (iAttribute == null) continue;
            boolean isUnassigned = false;
            Object custom = item.getValue(iAttribute);
            if (custom == null || iAttribute.getDisplayName() == null) continue;
            if (custom instanceof String) {
                String value = (String)custom;
                if (value == null || value.isEmpty()) continue;
                attributes.add(new RTCCustomAttribute(iAttribute.getDisplayName(), value, "String"));
                continue;
            }
            if (custom instanceof Identifier) {
                Identifier literalID = (Identifier)custom;
                ILiteral literal = this.getLiteralbyID((Identifier<ILiteral>)literalID, (IAttributeHandle)iAttribute);
                if (literal == null) continue;
                String displayValue = literal.getName();
                Identifier nullAttributeIdentifier = (Identifier)iAttribute.getNullValue((IAuditableCommon)client, this.progressMonitor);
                ILiteral nullLiteral = this.getLiteralbyID((Identifier<ILiteral>)nullAttributeIdentifier, (IAttributeHandle)iAttribute);
                if (literal == nullLiteral) {
                    isUnassigned = true;
                }
                if (displayValue == null) continue;
                attributes.add(new RTCCustomAttribute(iAttribute.getDisplayName(), displayValue, "Literal", isUnassigned));
                continue;
            }
            if (!(custom instanceof IContributorHandle)) continue;
            IContributorHandle contributorHandle = (IContributorHandle)custom;
            IContributor contributor = (IContributor)this.repo.itemManager().fetchCompleteItem((IItemHandle)contributorHandle, 0, null);
            if (contributor == null || (name = contributor.getName()) == null) continue;
            attributes.add(new RTCCustomAttribute(iAttribute.getDisplayName(), name, "Contributor"));
        }
        return attributes;
    }

    private ILiteral getLiteralbyID(Identifier<ILiteral> findLliteralID, IAttributeHandle iAttribute) throws TeamRepositoryException {
        IWorkItemClient workItemClient = (IWorkItemClient)this.repo.getClientLibrary(IWorkItemClient.class);
        IEnumeration enumeration = workItemClient.resolveEnumeration(iAttribute, null);
        List literals = enumeration.getEnumerationLiterals();
        for (ILiteral iLiteral : literals) {
            if (!iLiteral.getIdentifier2().equals(findLliteralID)) continue;
            return iLiteral;
        }
        return null;
    }

    public List<RTCWorkItem> processUnresolvedResultsWithCustomAttributes(IProjectArea projectArea, IQueryResult<IResult> results, List<String> existingItems, Date lastUpdate) throws TeamRepositoryException {
        ArrayList<RTCWorkItem> items = new ArrayList<RTCWorkItem>();
        ITeamRepository teamRepository = (ITeamRepository)projectArea.getOrigin();
        IAuditableCommon auditableCommon = (IAuditableCommon)teamRepository.getClientLibrary(IAuditableCommon.class);
        long processed = 0L;
        while (results.hasNext(this.progressMonitor)) {
            IResult result = (IResult)results.next(this.progressMonitor);
            ArrayList<String> extensions = new ArrayList<String>();
            extensions.addAll(IWorkItem.CUSTOM_ATTRIBUTE_PROPERTIES);
            extensions.add(IWorkItem.SEVERITY_PROPERTY);
            extensions.add(IWorkItem.STATE_PROPERTY);
            extensions.add(IWorkItem.CATEGORY_PROPERTY);
            extensions.add(IWorkItem.TARGET_PROPERTY);
            ItemProfile customProfile = IWorkItem.SMALL_PROFILE.createExtension(extensions);
            IWorkItem workItem = (IWorkItem)auditableCommon.resolveAuditable((IAuditableHandle)result.getItem(), customProfile, this.progressMonitor);
            String target = this.getTarget(workItem);
            if (lastUpdate == null || workItem.modified().getTime() > lastUpdate.getTime() || !existingItems.contains(target)) {
                String parent;
                IWorkItemType type;
                ICategory category;
                String status;
                RTCWorkItem rtcWorkItem = new RTCWorkItem(workItem.getId() + "", workItem.getHTMLSummary().toString(), workItem.modified());
                String severity = this.getSeverity(projectArea, workItem);
                if (severity != null) {
                    rtcWorkItem.setSeverity(severity);
                }
                if ((status = this.getState(workItem)) != null) {
                    rtcWorkItem.setStatus(status);
                }
                rtcWorkItem.setTarget(target);
                IIteration iteration = this.getIteration(workItem);
                if (iteration != null) {
                    rtcWorkItem.setPlannedFor(iteration.getName());
                    rtcWorkItem.setIterationId(iteration.getItemId().getUuidValue());
                }
                if (workItem.getCategory() != null && (category = this.getCategory(workItem)) != null) {
                    rtcWorkItem.setFiledAgainst(category.getName());
                    rtcWorkItem.setCategoryId(category.getItemId().getUuidValue());
                }
                if ((type = this.getType(projectArea, workItem)) != null) {
                    rtcWorkItem.setType(type.getDisplayName());
                }
                if ((parent = this.getWorkItemParent(workItem)) != null) {
                    rtcWorkItem.setParentId(parent);
                    IWorkItem parentItem = this.getWorkItemById(Integer.parseInt(parent));
                    String parentTarget = this.getTarget(parentItem);
                    rtcWorkItem.setParentTarget(parentTarget);
                }
                List<RTCCustomAttribute> attributes = this.getAllCustomAttributes(workItem);
                rtcWorkItem.setCustomAttributes(attributes);
                items.add(rtcWorkItem);
            }
            ++processed;
        }
        return items;
    }
}

