/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.air.property.prop_def.parser;

import com.urbancode.air.i18n.TranslatableException;
import com.urbancode.air.property.prop_def.PropDef;
import com.urbancode.air.property.prop_def.PropDefAllowedValue;
import com.urbancode.air.property.prop_def.http.HttpPropInfo;
import com.urbancode.air.property.prop_def.scripted.ScriptedPropInfo;
import com.urbancode.commons.util.StringUtil;
import com.urbancode.commons.util.logging.LogUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.log4j.Logger;
import org.codehaus.jettison.json.JSONArray;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JsonParser {
    static final Logger log = Logger.getLogger(JsonParser.class);
    private static final String JSON_SPLIT_REGEX = "(?<!\\\\)\\.";
    private static final String JSON_CLEAN_REGEX = "\\\\\\.";

    public static List<PropDefAllowedValue> parseJson(String rawData, HttpPropInfo info) throws Exception {
        return JsonParser.parseJson(rawData, info.getPropDef(), info.getBasePath(), info.getValuePath(), info.getLabelPath());
    }

    public static List<PropDefAllowedValue> parseJson(String rawData, ScriptedPropInfo info) throws Exception {
        return JsonParser.parseJson(rawData, info.getPropDef(), info.getBasePath(), info.getValuePath(), info.getLabelPath());
    }

    public static List<PropDefAllowedValue> parseJson(String rawData, PropDef propDef, String basePath, String valuePath, String labelPath) throws Exception {
        JSONArray base;
        ArrayList<PropDefAllowedValue> result = new ArrayList<PropDefAllowedValue>();
        if (!StringUtil.isEmpty((String)basePath)) {
            JSONObject json;
            try {
                json = new JSONObject(rawData);
            }
            catch (JSONException e) {
                if (e.getMessage().length() > 500) {
                    throw new JSONException(e.getMessage().substring(0, 500) + "...");
                }
                throw e;
            }
            LogUtil.logDebug((Logger)log, (Object)("Getting base array with JSON path: " + basePath));
            base = JsonParser.getBaseArray(json, JsonParser.splitJSONPath(basePath));
            if (LogUtil.isTraceEnabled((Logger)log)) {
                LogUtil.logTrace((Logger)log, (Object)base.toString());
            }
        } else {
            LogUtil.logDebug((Logger)log, (Object)"No base path found. Using raw data as base JSON array.");
            base = new JSONArray(rawData);
        }
        LogUtil.logDebug((Logger)log, (Object)("Parsing JSON objects with JSON paths: " + valuePath + ", " + labelPath));
        for (int i = 0; i < base.length(); ++i) {
            String value;
            String label = null;
            if (!StringUtil.isEmpty((String)valuePath)) {
                JSONObject json = base.getJSONObject(i);
                try {
                    value = JsonParser.getStringFromJSON(json, JsonParser.splitJSONPath(valuePath));
                }
                catch (JSONException e) {
                    throw new TranslatableException("Unable to find property names using JSON path %s", new Object[]{valuePath});
                }
                label = !StringUtil.isEmpty((String)labelPath) ? JsonParser.getStringFromJSON(json, JsonParser.splitJSONPath(labelPath)) : value;
            } else {
                label = value = base.getString(i);
            }
            LogUtil.logTrace((Logger)log, (Object)("Value, Label: " + value + ", " + label));
            PropDefAllowedValue allowedValue = new PropDefAllowedValue(propDef, value, label);
            result.add(allowedValue);
        }
        return result;
    }

    private static List<String> splitJSONPath(String path) {
        String[] array = path.split(JSON_SPLIT_REGEX);
        for (int i = 0; i < array.length; ++i) {
            array[i] = array[i].replaceAll(JSON_CLEAN_REGEX, ".");
        }
        return new ArrayList<String>(Arrays.asList(array));
    }

    private static String getStringFromJSON(JSONObject json, List<String> pathParts) throws JSONException {
        String result;
        if (pathParts.size() > 1) {
            JSONObject child = json.getJSONObject(pathParts.remove(0));
            result = JsonParser.getStringFromJSON(child, pathParts);
        } else {
            result = json.getString(pathParts.remove(0));
        }
        return result;
    }

    private static JSONArray getBaseArray(JSONObject json, List<String> pathParts) throws JSONException {
        JSONArray result;
        if (pathParts.size() > 1) {
            JSONObject child = json.getJSONObject(pathParts.remove(0));
            result = JsonParser.getBaseArray(child, pathParts);
        } else {
            result = json.getJSONArray(pathParts.remove(0));
        }
        return result;
    }
}

