/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wink.common.internal.application;

import java.util.LinkedHashSet;
import java.util.Set;
import javax.ws.rs.Path;
import javax.ws.rs.ext.Provider;
import org.apache.wink.common.DynamicResource;
import org.apache.wink.common.internal.i18n.Messages;
import org.apache.wink.common.internal.registry.metadata.ProviderMetadataCollector;
import org.apache.wink.common.internal.registry.metadata.ResourceMetadataCollector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ApplicationValidator {
    private final Set<Class<?>> singletonClasses = new LinkedHashSet();
    private static final Logger logger = LoggerFactory.getLogger(ApplicationValidator.class);

    public boolean isValidResource(Class<?> cls) {
        return ApplicationValidator.isValidClass(cls) && (ResourceMetadataCollector.isStaticResource(cls) && this.classUnique(cls) || ResourceMetadataCollector.isDynamicResource(cls));
    }

    public boolean isValidProvider(Class<?> cls) {
        return ApplicationValidator.isValidClass(cls) && ProviderMetadataCollector.isProvider(cls) && this.classUnique(cls);
    }

    private boolean classUnique(Class<? extends Object> cls) {
        if (!this.singletonClasses.add(cls)) {
            if (logger.isWarnEnabled()) {
                logger.warn(Messages.getMessage("classAlreadyAdded", cls.getName()));
            }
            return false;
        }
        return true;
    }

    private static boolean isValidClass(Class<?> cls) {
        boolean valid;
        int counter = 0;
        if (ResourceMetadataCollector.isStaticResource(cls)) {
            ++counter;
        }
        if (ProviderMetadataCollector.isProvider(cls)) {
            ++counter;
        }
        if (ResourceMetadataCollector.isDynamicResource(cls)) {
            ++counter;
        }
        boolean bl = valid = counter <= 1;
        if (!valid && logger.isWarnEnabled()) {
            logger.warn(Messages.getMessage("classNotValid", cls.getName(), Path.class.getName(), DynamicResource.class.getName(), Provider.class.getName()));
        }
        return valid;
    }
}

