/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wink.server.internal.contexts;

import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.EntityTag;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Request;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.Variant;
import javax.ws.rs.ext.RuntimeDelegate;
import org.apache.wink.common.internal.http.AcceptCharset;
import org.apache.wink.common.internal.http.AcceptEncoding;
import org.apache.wink.common.internal.http.AcceptLanguage;
import org.apache.wink.common.internal.http.EntityTagMatchHeader;
import org.apache.wink.common.utils.ProviderUtils;
import org.apache.wink.server.handlers.MessageContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RequestImpl
implements Request {
    private static final Logger logger = LoggerFactory.getLogger(RequestImpl.class);
    private MessageContext msgContext;
    private static final RuntimeDelegate delegate = RuntimeDelegate.getInstance();
    private static final RuntimeDelegate.HeaderDelegate<EntityTagMatchHeader> ifMatchHeaderDelegate = delegate.createHeaderDelegate(EntityTagMatchHeader.class);
    private static final RuntimeDelegate.HeaderDelegate<Date> dateHeaderDelegate = delegate.createHeaderDelegate(Date.class);

    public RequestImpl(MessageContext msgContext) {
        this.msgContext = msgContext;
    }

    private String getHeaderValue(String header) {
        List<String> headers = this.msgContext.getHttpHeaders().getRequestHeader(header);
        if (headers != null && headers.size() > 0 && headers.get(0) != null) {
            return headers.get(0);
        }
        return null;
    }

    @Override
    public Response.ResponseBuilder evaluatePreconditions() {
        logger.trace("evaluatePreconditions() called");
        String ifMatch = this.getHeaderValue("If-Match");
        if (ifMatch != null) {
            try {
                EntityTagMatchHeader ifMatchHeader = null;
                ifMatchHeader = ifMatchHeaderDelegate.fromString(ifMatch);
                logger.trace("ifMatchHeaderDelegate returned {}", ifMatchHeader);
            }
            catch (IllegalArgumentException e) {
                throw new WebApplicationException((Throwable)e, Response.Status.BAD_REQUEST);
            }
            Response.ResponseBuilder responseBuilder = delegate.createResponseBuilder();
            responseBuilder.status(412);
            logger.trace("evaluatePreconditions() returning built response because there was no match due to no entity tag");
            return responseBuilder;
        }
        return null;
    }

    @Override
    public Response.ResponseBuilder evaluatePreconditions(EntityTag tag) {
        logger.trace("evaluatePreconditions({}) called", tag);
        String ifMatch = this.getHeaderValue("If-Match");
        if (ifMatch != null) {
            return this.evaluateIfMatch(tag, ifMatch);
        }
        String ifNoneMatch = this.getHeaderValue("If-None-Match");
        if (ifNoneMatch != null) {
            return this.evaluateIfNoneMatch(tag, ifNoneMatch);
        }
        return null;
    }

    private Response.ResponseBuilder evaluateIfMatch(EntityTag tag, String headerValue) {
        logger.trace("evaluateIfMatch({}, {}) called", tag, (Object)headerValue);
        EntityTagMatchHeader ifMatchHeader = null;
        try {
            ifMatchHeader = ifMatchHeaderDelegate.fromString(headerValue);
            logger.trace("ifMatchHeaderDelegate returned {}", ifMatchHeader);
        }
        catch (IllegalArgumentException e) {
            throw new WebApplicationException((Throwable)e, Response.Status.BAD_REQUEST);
        }
        if (!ifMatchHeader.isMatch(tag)) {
            Response.ResponseBuilder responseBuilder = delegate.createResponseBuilder();
            responseBuilder.status(412).tag(tag);
            logger.trace("evaluateIfMatch returning built response because there was no match");
            return responseBuilder;
        }
        logger.trace("evaluateIfMatch returning null because there was a match");
        return null;
    }

    private Response.ResponseBuilder evaluateIfNoneMatch(EntityTag tag, String headerValue) {
        logger.trace("evaluateIfNoneMatch({}, {}) called", tag, (Object)headerValue);
        EntityTagMatchHeader ifNoneMatchHeader = null;
        try {
            ifNoneMatchHeader = ifMatchHeaderDelegate.fromString(headerValue);
            logger.trace("ifMatchHeaderDelegate returned {}", ifNoneMatchHeader);
        }
        catch (IllegalArgumentException e) {
            throw new WebApplicationException((Throwable)e, Response.Status.BAD_REQUEST);
        }
        if (ifNoneMatchHeader.isMatch(tag)) {
            Response.ResponseBuilder responseBuilder = delegate.createResponseBuilder();
            String method = this.getMethod();
            if (method.equalsIgnoreCase("GET") || method.equalsIgnoreCase("HEAD")) {
                logger.trace("evaluateIfNoneMatch returning 304 Not Modified because the {} method matched", (Object)method);
                responseBuilder.status(304).tag(tag);
            } else {
                logger.trace("evaluateIfNoneMatch returning 412 Precondition Failed because the {} method matched", (Object)method);
                responseBuilder.status(412).tag(tag);
            }
            return responseBuilder;
        }
        logger.trace("evaluateIfNoneMatch returning null because there was no match");
        return null;
    }

    @Override
    public Response.ResponseBuilder evaluatePreconditions(Date lastModified) {
        String ifModifiedSince;
        if (logger.isTraceEnabled()) {
            logger.trace("evaluatePreconditions({}) called with {} date", lastModified, (Object)lastModified.getTime());
        }
        if ((ifModifiedSince = this.getHeaderValue("If-Modified-Since")) != null) {
            return this.evaluateIfModifiedSince(lastModified, ifModifiedSince);
        }
        String ifUnmodifiedSince = this.getHeaderValue("If-Unmodified-Since");
        if (ifUnmodifiedSince != null) {
            return this.evalueateIfUnmodifiedSince(lastModified, ifUnmodifiedSince);
        }
        return null;
    }

    private Response.ResponseBuilder evalueateIfUnmodifiedSince(Date lastModified, String headerValue) {
        Date date = dateHeaderDelegate.fromString(headerValue);
        if (logger.isTraceEnabled()) {
            logger.trace("evalueateIfUnmodifiedSince({}, {}) got Date {} from header so comparing {} is after {}", new Object[]{lastModified, headerValue, date, lastModified.getTime(), date.getTime()});
        }
        if (lastModified.after(date)) {
            Response.ResponseBuilder responseBuilder = delegate.createResponseBuilder();
            responseBuilder.status(412);
            logger.trace("evalueateIfUnmodifiedSince returning 412 Precondition Failed");
            return responseBuilder;
        }
        logger.trace("evalueateIfUnmodifiedSince returning null");
        return null;
    }

    private Response.ResponseBuilder evaluateIfModifiedSince(Date lastModified, String headerValue) {
        Date date = dateHeaderDelegate.fromString(headerValue);
        if (logger.isTraceEnabled()) {
            logger.trace("evaluateIfModifiedSince({}, {}) got Date {} from header so comparing {} is after {}", new Object[]{lastModified, headerValue, date, lastModified.getTime(), date.getTime()});
        }
        if (lastModified.after(date)) {
            logger.trace("evaluateIfModifiedSince returning null");
            return null;
        }
        Response.ResponseBuilder responseBuilder = delegate.createResponseBuilder();
        responseBuilder.status(304);
        logger.trace("evaluateIfModifiedSince returning 304 Not Modified");
        return responseBuilder;
    }

    @Override
    public Response.ResponseBuilder evaluatePreconditions(Date lastModified, EntityTag tag) {
        String ifMatch;
        if (logger.isTraceEnabled()) {
            logger.trace("evaluatePreconditions({}, {}) called with date {} as a long type", new Object[]{lastModified, tag, lastModified.getTime()});
        }
        if ((ifMatch = this.getHeaderValue("If-Match")) != null) {
            return this.evaluateIfMatch(tag, ifMatch);
        }
        String ifNoneMatch = this.getHeaderValue("If-None-Match");
        String ifModifiedSince = this.getHeaderValue("If-Modified-Since");
        if (ifNoneMatch != null) {
            Response.ResponseBuilder isNoneMatch = this.evaluateIfNoneMatch(tag, ifNoneMatch);
            if (isNoneMatch != null && ifModifiedSince != null && this.evaluateIfModifiedSince(lastModified, ifModifiedSince) == null) {
                return null;
            }
            return isNoneMatch;
        }
        if (ifModifiedSince != null) {
            return this.evaluateIfModifiedSince(lastModified, ifModifiedSince);
        }
        String ifUnmodifiedSince = this.getHeaderValue("If-Unmodified-Since");
        if (ifUnmodifiedSince != null) {
            return this.evalueateIfUnmodifiedSince(lastModified, ifUnmodifiedSince);
        }
        return null;
    }

    @Override
    public String getMethod() {
        return this.msgContext.getHttpMethod();
    }

    @Override
    public Variant selectVariant(List<Variant> variants) throws IllegalArgumentException {
        logger.trace("selectVariant({}) called", variants);
        if (variants == null) {
            throw new IllegalArgumentException();
        }
        if (variants.size() == 0) {
            logger.trace("No variants so returning null");
            return null;
        }
        List<MediaType> acceptableMediaTypes = this.msgContext.getHttpHeaders().getAcceptableMediaTypes();
        List<String> acceptableLanguages = this.msgContext.getHttpHeaders().getRequestHeader("Accept-Language");
        AcceptLanguage languages = null;
        if (acceptableLanguages != null) {
            StringBuilder acceptLanguageTemp = new StringBuilder();
            acceptLanguageTemp.append(acceptableLanguages.get(0));
            for (int c = 1; c < acceptableLanguages.size(); ++c) {
                acceptLanguageTemp.append(",");
                acceptLanguageTemp.append(acceptableLanguages.get(c));
            }
            String acceptLanguage = acceptLanguageTemp.toString();
            languages = AcceptLanguage.valueOf(acceptLanguage);
        }
        List<String> acceptableEncodings = this.msgContext.getHttpHeaders().getRequestHeader("Accept-Encoding");
        AcceptEncoding encodings = null;
        if (acceptableEncodings != null) {
            StringBuilder acceptEncodingsTemp = new StringBuilder();
            acceptEncodingsTemp.append(acceptableEncodings.get(0));
            for (int c = 1; c < acceptableEncodings.size(); ++c) {
                acceptEncodingsTemp.append(",");
                acceptEncodingsTemp.append(acceptableEncodings.get(c));
            }
            String acceptEncodings = acceptEncodingsTemp.toString();
            encodings = AcceptEncoding.valueOf(acceptEncodings);
        }
        List<String> acceptableCharsets = this.msgContext.getHttpHeaders().getRequestHeader("Accept-Charset");
        AcceptCharset charsets = null;
        if (acceptableCharsets != null) {
            StringBuilder acceptCharsetsTemp = new StringBuilder();
            acceptCharsetsTemp.append(acceptableCharsets.get(0));
            for (int c = 1; c < acceptableCharsets.size(); ++c) {
                acceptCharsetsTemp.append(",");
                acceptCharsetsTemp.append(acceptableCharsets.get(c));
            }
            String acceptCharsets = acceptCharsetsTemp.toString();
            charsets = AcceptCharset.valueOf(acceptCharsets);
        }
        VariantQChecked bestVariant = null;
        boolean isIdentityEncodingChecked = false;
        Iterator<Variant> iter = variants.iterator();
        while (iter.hasNext()) {
            double acceptQFactor = -1.0;
            Variant v = iter.next();
            logger.trace("Variant being evaluated is: {}", v);
            MediaType vMediaType = v.getMediaType();
            if (vMediaType != null && acceptableMediaTypes != null) {
                boolean isCompatible = false;
                boolean isAcceptable = true;
                for (MediaType mt : acceptableMediaTypes) {
                    logger.trace("Checking variant media type {} against Accept media type {}", vMediaType, (Object)mt);
                    if (!mt.isCompatible(vMediaType)) continue;
                    Map<String, String> params = mt.getParameters();
                    String q = params.get("q");
                    if (q != null) {
                        try {
                            Double qAsDouble = Double.valueOf(q);
                            if (qAsDouble.equals(0.0)) {
                                isAcceptable = false;
                                logger.trace("Accept Media Type: {} is NOT compatible with q-factor {}", mt, (Object)qAsDouble);
                                break;
                            }
                            acceptQFactor = qAsDouble;
                        }
                        catch (NumberFormatException e) {
                            logger.trace("NumberFormatException during MediaType q-factor evaluation: {}", e);
                        }
                    } else {
                        acceptQFactor = 1.0;
                    }
                    isCompatible = true;
                    logger.trace("Accept Media Type: {} is compatible with q-factor {}", mt, (Object)acceptQFactor);
                }
                if (!isCompatible || !isAcceptable) {
                    logger.trace("Variant {} is not compatible or not acceptable", vMediaType);
                    continue;
                }
            }
            if (bestVariant != null && acceptQFactor < bestVariant.acceptMediaTypeQFactor) {
                logger.trace("Best variant's media type {} q-factor {} is greater than current variant {} q-factor {}", new Object[]{bestVariant.variant, bestVariant.acceptMediaTypeQFactor, vMediaType, acceptQFactor});
                continue;
            }
            double acceptLanguageQFactor = -1.0;
            Locale vLocale = v.getLanguage();
            if (vLocale != null && languages != null) {
                boolean isCompatible = false;
                logger.trace("Checking variant locale {}", vLocale);
                if (languages.getBannedLanguages().contains(vLocale)) {
                    logger.trace("Variant locale {} was in unacceptable languages", vLocale);
                    continue;
                }
                for (AcceptLanguage.ValuedLocale locale : languages.getValuedLocales()) {
                    logger.trace("Checking against Accept-Language locale {} with quality factor {}", locale.locale, (Object)locale.qValue);
                    if (!locale.isWildcard() && !vLocale.equals(locale.locale)) continue;
                    logger.trace("Locale is compatible {}", locale.locale);
                    isCompatible = true;
                    acceptLanguageQFactor = locale.qValue;
                    break;
                }
                if (!isCompatible) {
                    logger.trace("Variant locale is not compatible {}", vLocale);
                    continue;
                }
            }
            if (bestVariant != null && acceptLanguageQFactor < bestVariant.acceptLanguageQFactor) {
                logger.trace("Best variant's language {} q-factor {} is greater than current variant {} q-factor {}", new Object[]{bestVariant.variant, bestVariant.acceptLanguageQFactor, v, acceptLanguageQFactor});
                continue;
            }
            double acceptCharsetQFactor = -1.0;
            String vCharset = ProviderUtils.getCharsetOrNull(v.getMediaType());
            boolean hasCharSet = true;
            if (vCharset == null) {
                hasCharSet = false;
            } else if (vCharset != null && charsets != null) {
                boolean isCompatible = false;
                logger.trace("Checking variant charset: {}", (Object)vCharset);
                if (charsets.getBannedCharsets().contains(vCharset)) {
                    logger.trace("Variant charset {} was in unacceptable charsets", (Object)vCharset);
                    continue;
                }
                for (AcceptCharset.ValuedCharset charset : charsets.getValuedCharsets()) {
                    logger.trace("Checking against Accept-Charset charset {} with quality factor {}", (Object)charset.charset, (Object)charset.qValue);
                    if (!charset.isWildcard() && !vCharset.equalsIgnoreCase(charset.charset)) continue;
                    logger.trace("Charset is compatible with {}", (Object)charset.charset);
                    isCompatible = true;
                    acceptCharsetQFactor = charset.qValue;
                    break;
                }
                if (!isCompatible) {
                    logger.trace("Variant charset is not compatible {}", (Object)vCharset);
                }
            }
            if (bestVariant != null && acceptCharsetQFactor < bestVariant.acceptCharsetQFactor && hasCharSet) {
                logger.trace("Best variant's charset {} q-factor {} is greater than current variant {} q-factor {}", new Object[]{bestVariant.variant, bestVariant.acceptCharsetQFactor, v, acceptCharsetQFactor});
                continue;
            }
            double acceptEncodingQFactor = -1.0;
            String vEncoding = v.getEncoding();
            if (vEncoding != null) {
                logger.trace("Checking variant encoding {}", (Object)vEncoding);
                if (encodings == null) {
                    logger.trace("Accept-Encoding is null");
                    if (!v.getEncoding().equalsIgnoreCase("identity")) {
                        logger.trace("Variant encoding {} does not equal identity so not acceptable", (Object)vEncoding);
                        isIdentityEncodingChecked = true;
                        continue;
                    }
                } else {
                    boolean isAcceptable = true;
                    for (String encoding : encodings.getBannedEncodings()) {
                        logger.trace("Checking against not acceptable encoding: {}", (Object)encoding);
                        if (!encoding.equalsIgnoreCase(vEncoding)) continue;
                        logger.trace("Encoding was not acceptable: {}", (Object)vEncoding);
                        isAcceptable = false;
                        break;
                    }
                    if (!isAcceptable) continue;
                    boolean isCompatible = false;
                    for (AcceptEncoding.ValuedEncoding encoding : encodings.getValuedEncodings()) {
                        logger.trace("Checking against acceptable encoding: {}", (Object)encoding.encoding);
                        if (!encoding.isWildcard() && !encoding.encoding.equalsIgnoreCase(vEncoding)) continue;
                        isCompatible = true;
                        acceptEncodingQFactor = encoding.qValue;
                        logger.trace("Encoding {} was acceptable with q-factor {}", (Object)encoding.encoding, (Object)encoding.qValue);
                        break;
                    }
                    if (!isCompatible) {
                        logger.trace("Variant encoding {} was not compatible", (Object)vEncoding);
                        continue;
                    }
                }
            }
            if (bestVariant != null && acceptEncodingQFactor < bestVariant.acceptEncodingQFactor) {
                logger.trace("Best variant's encoding {} q-factor {} is greater than current variant {} q-factor {}", new Object[]{bestVariant.variant, bestVariant.acceptEncodingQFactor, v, acceptEncodingQFactor});
                continue;
            }
            if (!(bestVariant == null || acceptQFactor > bestVariant.acceptMediaTypeQFactor || acceptLanguageQFactor > bestVariant.acceptLanguageQFactor || acceptEncodingQFactor > bestVariant.acceptEncodingQFactor || hasCharSet && acceptCharsetQFactor > bestVariant.acceptCharsetQFactor) && (!hasCharSet || bestVariant.hasCharset)) continue;
            bestVariant = new VariantQChecked(v, acceptQFactor, acceptLanguageQFactor, acceptEncodingQFactor, acceptCharsetQFactor, hasCharSet);
        }
        if (bestVariant == null) {
            return null;
        }
        StringBuilder varyHeaderValue = new StringBuilder();
        boolean isValueWritten = false;
        if (bestVariant.acceptMediaTypeQFactor > 0.0) {
            varyHeaderValue.append("Accept");
            isValueWritten = true;
        }
        if (bestVariant.acceptLanguageQFactor > 0.0) {
            if (isValueWritten) {
                varyHeaderValue.append(", ");
            }
            varyHeaderValue.append("Accept-Language");
            isValueWritten = true;
        }
        if (isIdentityEncodingChecked || bestVariant.acceptEncodingQFactor > 0.0) {
            if (isValueWritten) {
                varyHeaderValue.append(", ");
            }
            varyHeaderValue.append("Accept-Encoding");
            isValueWritten = true;
        }
        if (bestVariant.acceptCharsetQFactor > 0.0) {
            if (isValueWritten) {
                varyHeaderValue.append(", ");
            }
            varyHeaderValue.append("Accept-Charset");
            isValueWritten = true;
        }
        String varyHeaderValueStr = varyHeaderValue.toString().trim();
        logger.trace("Vary Header value should be set to {}", (Object)varyHeaderValueStr);
        this.msgContext.setAttribute(VaryHeader.class, new VaryHeader(varyHeaderValueStr));
        return bestVariant.variant;
    }

    public static class VaryHeader {
        private final String varyHeaderValue;

        private VaryHeader(String varyHeaderValue) {
            this.varyHeaderValue = varyHeaderValue;
        }

        public String getVaryHeaderValue() {
            return this.varyHeaderValue;
        }
    }

    private static class VariantQChecked {
        final Variant variant;
        final double acceptMediaTypeQFactor;
        final double acceptLanguageQFactor;
        final double acceptEncodingQFactor;
        final double acceptCharsetQFactor;
        final boolean hasCharset;

        public VariantQChecked(Variant v, double acceptMediaType, double acceptLanguage, double acceptEncoding, double acceptCharset, boolean hasCharset) {
            this.variant = v;
            this.acceptMediaTypeQFactor = acceptMediaType;
            this.acceptLanguageQFactor = acceptLanguage;
            this.acceptEncodingQFactor = acceptEncoding;
            this.acceptCharsetQFactor = acceptCharset;
            this.hasCharset = hasCharset;
        }
    }
}

