/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.air.property;

import com.urbancode.air.property.prop_def.PropDef;
import com.urbancode.air.property.prop_def.PropDefAllowedValue;
import com.urbancode.air.property.prop_def.http.HttpPropInfo;
import com.urbancode.air.property.prop_def.scripted.ScriptedPropInfo;
import com.urbancode.air.property.prop_sheet.PropSheet;
import com.urbancode.air.property.prop_sheet.PropSheetFactoryImpl;
import com.urbancode.air.property.prop_sheet.PropSheetFactoryRegistry;
import com.urbancode.air.property.prop_sheet.PropSheetHandle;
import com.urbancode.air.property.prop_sheet.PropSheetLookup;
import com.urbancode.air.property.prop_sheet.PropSheetVCHelper;
import com.urbancode.air.property.prop_sheet_def.PropSheetDef;
import com.urbancode.air.property.prop_sheet_def.PropSheetDefFactoryImpl;
import com.urbancode.air.property.prop_sheet_def.PropSheetDefFactoryRegistry;
import com.urbancode.air.property.prop_sheet_def.PropSheetDefVCHelper;
import com.urbancode.air.property.prop_sheet_group.PropSheetGroup;
import com.urbancode.air.property.prop_sheet_group.PropSheetGroupFactoryImpl;
import com.urbancode.air.property.prop_sheet_group.PropSheetGroupFactoryRegistry;
import com.urbancode.air.property.prop_sheet_group.PropSheetGroupVCHelper;
import com.urbancode.air.property.prop_value.PropValue;
import com.urbancode.air.services.event.EventSender;
import com.urbancode.air.vc.Repository;
import com.urbancode.air.vc.VCHelper;
import com.urbancode.air.vc.VCHelperRegistry;
import com.urbancode.persistence.hibernate.SessionLookup;
import org.hibernate.cfg.Configuration;

public class PropertyConfiguration {
    private static PropertyConfiguration instance = new PropertyConfiguration();
    private EventSender eventSender;
    private Repository repository;
    private SessionLookup sessionLookup;
    private PropSheetLookup propSheetLookup;

    public static PropertyConfiguration getInstance() {
        return instance;
    }

    public static void configurePersistentClasses(Configuration hibernateConfig) {
        hibernateConfig.addAnnotatedClass(PropDef.class);
        hibernateConfig.addAnnotatedClass(PropDefAllowedValue.class);
        hibernateConfig.addAnnotatedClass(PropSheet.class);
        hibernateConfig.addAnnotatedClass(PropSheetDef.class);
        hibernateConfig.addAnnotatedClass(PropSheetGroup.class);
        hibernateConfig.addAnnotatedClass(PropSheetHandle.class);
        hibernateConfig.addAnnotatedClass(PropValue.class);
        hibernateConfig.addAnnotatedClass(HttpPropInfo.class);
        hibernateConfig.addAnnotatedClass(ScriptedPropInfo.class);
    }

    public static void configureVCHelperRegistry(VCHelperRegistry registry) {
        registry.registerHelper((VCHelper)new PropSheetVCHelper());
        registry.registerHelper((VCHelper)new PropSheetDefVCHelper());
        registry.registerHelper((VCHelper)new PropSheetGroupVCHelper());
    }

    public static void configureStandardFactories() {
        PropSheetFactoryRegistry.getInstance().setFactory(new PropSheetFactoryImpl());
        PropSheetDefFactoryRegistry.getInstance().setFactory(new PropSheetDefFactoryImpl());
        PropSheetGroupFactoryRegistry.getInstance().setFactory(new PropSheetGroupFactoryImpl());
    }

    private PropertyConfiguration() {
    }

    public Repository getRepository() {
        return this.repository;
    }

    public void setRepository(Repository repository) {
        this.repository = repository;
    }

    public SessionLookup getSessionLookup() {
        return this.sessionLookup;
    }

    public void setSessionLookup(SessionLookup sessionLookup) {
        this.sessionLookup = sessionLookup;
    }

    public EventSender getEventSender() {
        return this.eventSender;
    }

    public void setEventSender(EventSender eventSender) {
        this.eventSender = eventSender;
    }

    public PropSheetLookup getPropSheetLookup() {
        return this.propSheetLookup;
    }

    public void setPropSheetLookup(PropSheetLookup propSheetLookup) {
        this.propSheetLookup = propSheetLookup;
    }
}

